/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tools.attach.attacher;

import com.ibm.oti.util.Msg;
import com.ibm.tools.attach.attacher.OpenJ9AttachProvider;
import com.ibm.tools.attach.attacher.OpenJ9VirtualMachineDescriptor;
import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.AttachOperationFailedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import com.sun.tools.attach.spi.AttachProvider;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import openj9.internal.tools.attach.target.AttachHandler;
import openj9.internal.tools.attach.target.AttachmentConnection;
import openj9.internal.tools.attach.target.CommonDirectory;
import openj9.internal.tools.attach.target.DiagnosticProperties;
import openj9.internal.tools.attach.target.DiagnosticUtils;
import openj9.internal.tools.attach.target.FileLock;
import openj9.internal.tools.attach.target.IPC;
import openj9.internal.tools.attach.target.Reply;
import openj9.internal.tools.attach.target.Response;
import openj9.internal.tools.attach.target.TargetDirectory;

public final class OpenJ9VirtualMachine
extends VirtualMachine
implements Response {
    private static final int ATTACH_CONNECTED_MESSAGE_LENGTH_LIMIT = 4000;
    private static final int DEFAULT_ATTACH_TIMEOUT = 120000;
    private static final int DEFAULT_COMMAND_TIMEOUT = 0;
    private static int MAXIMUM_ATTACH_TIMEOUT;
    private static int COMMAND_TIMEOUT;
    private static final String INSTRUMENT_LIBRARY = "instrument";
    private OutputStream commandStream;
    private final OpenJ9VirtualMachineDescriptor descriptor;
    private final OpenJ9AttachProvider myProvider;
    private Integer portNumber;
    private InputStream responseStream;
    private boolean targetAttached;
    private String targetId;
    private FileLock[] targetLocks;
    private ServerSocket targetServer;
    private Socket targetSocket;

    OpenJ9VirtualMachine(AttachProvider provider, String id) throws NullPointerException {
        super(provider, id);
        if (null == id || null == provider) {
            throw new NullPointerException(Msg.getString((String)"K0554"));
        }
        this.targetId = id;
        this.myProvider = (OpenJ9AttachProvider)provider;
        this.descriptor = (OpenJ9VirtualMachineDescriptor)this.myProvider.getDescriptor(id);
    }

    void attachTarget() throws IOException, AttachNotSupportedException {
        PrivilegedExceptionAction<Object> action = () -> {
            this.attachTargetImpl();
            return null;
        };
        try {
            AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof AttachNotSupportedException) {
                throw (AttachNotSupportedException)cause;
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    private void attachTargetImpl() throws AttachNotSupportedException, IOException {
        if (null == this.descriptor) {
            throw new AttachNotSupportedException(Msg.getString((String)"K0531", (Object)this.targetId));
        }
        AttachNotSupportedException lastException = null;
        int timeout = 100;
        while (timeout < MAXIMUM_ATTACH_TIMEOUT) {
            lastException = null;
            try {
                this.tryAttachTarget(timeout);
            }
            catch (AttachNotSupportedException e) {
                IPC.logMessage((String)("attachTarget " + this.targetId + " timeout after " + timeout + " ms"));
                lastException = e;
                timeout = timeout * 3 / 2;
            }
            if (null == lastException) break;
            try {
                Thread.sleep(timeout);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (null != lastException) {
            throw lastException;
        }
        IPC.logMessage((String)"OpenJ9VirtualMachine.attachTargetImpl() finished");
    }

    private static String createLoadAgent(String agentName, String options) {
        String optString = null == options ? "" : options;
        String cmdFrame = "ATTACH_LOADAGENT(instrument," + agentName + '=' + optString + ')';
        return cmdFrame;
    }

    private static String createLoadAgentLibrary(String agentName, String options, boolean agentPath) {
        String cmd = agentPath ? "ATTACH_LOADAGENTPATH" : "ATTACH_LOADAGENTLIBRARY";
        String optString = "";
        if (null != options && !options.equals("")) {
            optString = ',' + options;
        }
        String cmdFrame = cmd + '(' + agentName + optString + ')';
        return cmdFrame;
    }

    @Override
    public synchronized void detach() throws IOException {
        AttachmentConnection.streamSend((OutputStream)this.commandStream, (String)"ATTACH_DETACH");
        try {
            AttachmentConnection.streamReceiveString((InputStream)this.responseStream);
        }
        finally {
            IPC.logMessage((String)"VirtualMachine.detach");
            if (null != this.commandStream) {
                this.commandStream.close();
                this.commandStream = null;
            }
            if (null != this.targetSocket) {
                this.targetSocket.close();
                this.targetSocket = null;
            }
            if (null != this.targetServer) {
                this.targetServer.close();
                this.targetServer = null;
            }
        }
        this.targetAttached = false;
    }

    @Override
    public Properties getAgentProperties() throws IOException {
        if (!this.targetAttached) {
            throw new IOException(Msg.getString((String)"K0544"));
        }
        Properties props = this.getTargetProperties(false);
        return props;
    }

    @Override
    public Properties getSystemProperties() throws IOException {
        if (!this.targetAttached) {
            throw new IOException(Msg.getString((String)"K0544"));
        }
        Properties props = this.getTargetProperties(true);
        return props;
    }

    private synchronized Properties getTargetProperties(boolean systemProperties) throws IOException {
        AttachmentConnection.streamSend((OutputStream)this.commandStream, (String)(systemProperties ? "ATTACH_GETSYSTEMPROPERTIES" : "ATTACH_GETAGENTPROPERTIES"));
        return IPC.receiveProperties((InputStream)this.responseStream, (boolean)true);
    }

    @Override
    public synchronized void loadAgent(String agent, String options) throws AgentLoadException, AgentInitializationException, IOException {
        if (!this.targetAttached) {
            throw new IOException(Msg.getString((String)"K0544"));
        }
        AttachmentConnection.streamSend((OutputStream)this.commandStream, (String)OpenJ9VirtualMachine.createLoadAgent(agent, options));
        String response = AttachmentConnection.streamReceiveString((InputStream)this.responseStream);
        OpenJ9VirtualMachine.parseResponse(response);
    }

    @Override
    public synchronized void loadAgentLibrary(String agentLibrary, String options) throws AgentLoadException, AgentInitializationException, IOException {
        if (!this.targetAttached) {
            throw new IOException(Msg.getString((String)"K0544"));
        }
        AttachmentConnection.streamSend((OutputStream)this.commandStream, (String)OpenJ9VirtualMachine.createLoadAgentLibrary(agentLibrary, options, false));
        String response = AttachmentConnection.streamReceiveString((InputStream)this.responseStream);
        OpenJ9VirtualMachine.parseResponse(response);
    }

    @Override
    public synchronized void loadAgentPath(String agentPath, String options) throws AgentLoadException, AgentInitializationException, IOException {
        if (null == agentPath) {
            throw new AgentLoadException(Msg.getString((String)"K0577"));
        }
        if (!this.targetAttached) {
            throw new IOException(Msg.getString((String)"K0544"));
        }
        AttachmentConnection.streamSend((OutputStream)this.commandStream, (String)OpenJ9VirtualMachine.createLoadAgentLibrary(agentPath, options, true));
        String response = AttachmentConnection.streamReceiveString((InputStream)this.responseStream);
        OpenJ9VirtualMachine.parseResponse(response);
    }

    public Properties executeDiagnosticCommand(String diagnosticCommand) throws IOException {
        IPC.logMessage((String)"enter executeDiagnosticCommand ", (String)diagnosticCommand);
        AttachmentConnection.streamSend((OutputStream)this.commandStream, (String)("ATTACH_DIAGNOSTICS:" + diagnosticCommand));
        return IPC.receiveProperties((InputStream)this.responseStream, (boolean)true);
    }

    private void lockAllAttachNotificationSyncFiles(List<VirtualMachineDescriptor> vmds) {
        int vmdIndex = 0;
        this.targetLocks = new FileLock[vmds.size()];
        for (VirtualMachineDescriptor i : vmds) {
            OpenJ9VirtualMachineDescriptor vmd;
            try {
                vmd = (OpenJ9VirtualMachineDescriptor)i;
            }
            catch (ClassCastException e) {
                continue;
            }
            if (!vmd.id().equalsIgnoreCase(AttachHandler.getVmId())) {
                String attachSyncFile = vmd.getAttachSyncFileValue();
                if (null != attachSyncFile) {
                    IPC.logMessage((String)"lockAllAttachNotificationSyncFiles locking targetLocks[", (int)vmdIndex, (String)"] ", (String)attachSyncFile);
                    this.targetLocks[vmdIndex] = new FileLock(attachSyncFile, 438);
                    try {
                        this.targetLocks[vmdIndex].lockFile(true, "OpenJ9VirtualMachine.lockAllAttachNotificationSyncFiles");
                    }
                    catch (IOException e) {
                        this.targetLocks[vmdIndex] = null;
                        IPC.logMessage((String)"lockAllAttachNotificationSyncFiles locking targetLocks[", (int)vmdIndex, (String)"] ", (String)"already locked");
                    }
                }
            } else {
                this.targetLocks[vmdIndex] = null;
            }
            ++vmdIndex;
        }
    }

    private static boolean parseResponse(String response) throws IOException, AgentInitializationException, AgentLoadException, IllegalArgumentException, AttachOperationFailedException {
        if (response.startsWith("ATTACH_ERR")) {
            int responseLength = response.indexOf(0);
            String trimmedResponse = -1 == responseLength ? response : response.substring(0, responseLength);
            if (response.contains("IOException")) {
                throw new IOException(Msg.getString((String)"K0576", (Object)trimmedResponse));
            }
            if (response.contains("AgentInitializationException")) {
                Integer status = OpenJ9VirtualMachine.getStatusValue(trimmedResponse);
                if (null == status) {
                    throw new AgentInitializationException(trimmedResponse);
                }
                throw new AgentInitializationException(trimmedResponse, status);
            }
            if (response.contains("AgentLoadException")) {
                throw new AgentLoadException(trimmedResponse);
            }
            if (response.contains("IOException")) {
                throw new IOException(Msg.getString((String)"K0576", (Object)trimmedResponse));
            }
            if (response.contains("IllegalArgumentException")) {
                throw new IllegalArgumentException(Msg.getString((String)"K05de", (Object)trimmedResponse));
            }
            if (response.contains("AttachOperationFailedException")) {
                throw new AttachOperationFailedException(Msg.getString((String)"k05dc", (Object)trimmedResponse));
            }
            return false;
        }
        return response.startsWith("ATTACH_ACK") || response.startsWith("ATTACH_RESULT=");
    }

    private static Integer getStatusValue(String response) {
        Pattern rvPattern = Pattern.compile("(-?\\d+)\\s*$");
        Matcher rvMatcher = rvPattern.matcher(response);
        Integer ret = null;
        if (rvMatcher.find()) {
            String status = rvMatcher.group(1);
            try {
                ret = Integer.valueOf(status);
            }
            catch (NumberFormatException e) {
                IPC.logMessage((String)"Error parsing response", (String)response);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void tryAttachTarget(int timeout) throws IOException, AttachNotSupportedException {
        Object myIn;
        Reply replyFile = null;
        AttachHandler.waitForAttachApiInitialization();
        IPC.logMessage((String)"VirtualMachineImpl.tryAttachtarget");
        Object object = myIn = AttachHandler.getMainHandler().getIgnoreNotification();
        synchronized (object) {
            int numberOfTargets;
            block37: {
                int thePort;
                List<VirtualMachineDescriptor> vmds;
                block35: {
                    block36: {
                        block33: {
                            block34: {
                                numberOfTargets = 0;
                                try {
                                    CommonDirectory.obtainAttachLock((String)("OpenJ9VirtualMachine.tryAttachTarget(" + timeout + ")"));
                                    IPC.logMessage((String)"OpenJ9VirtualMachine.tryAttachTarget() before listVirtualMachines");
                                    vmds = this.myProvider.listVirtualMachines();
                                    if (null != vmds) break block33;
                                    IPC.logMessage((String)"OpenJ9VirtualMachine.tryAttachTarget() myProvider.listVirtualMachines() returns null");
                                    if (null == replyFile) break block34;
                                }
                                catch (Throwable throwable) {
                                    if (null != replyFile) {
                                        replyFile.deleteReply();
                                    }
                                    if (numberOfTargets > 0) {
                                        this.unlockAllAttachNotificationSyncFiles();
                                        CommonDirectory.cancelNotify((int)numberOfTargets, (boolean)this.descriptor.isGlobalSemaphore());
                                        if (numberOfTargets > 2) {
                                            try {
                                                int delayTime = 50 * (numberOfTargets > 10 ? 10 : numberOfTargets);
                                                IPC.logMessage((String)"attachTarget sleep for ", (int)delayTime);
                                                Thread.sleep(delayTime);
                                            }
                                            catch (InterruptedException e) {
                                                IPC.logMessage((String)"attachTarget sleep interrupted");
                                            }
                                        }
                                    }
                                    CommonDirectory.releaseAttachLock((String)("OpenJ9VirtualMachine.tryAttachTarget(" + timeout + ")"));
                                    throw throwable;
                                }
                                replyFile.deleteReply();
                            }
                            if (numberOfTargets > 0) {
                                this.unlockAllAttachNotificationSyncFiles();
                                CommonDirectory.cancelNotify((int)numberOfTargets, (boolean)this.descriptor.isGlobalSemaphore());
                                if (numberOfTargets > 2) {
                                    try {
                                        int delayTime = 50 * (numberOfTargets > 10 ? 10 : numberOfTargets);
                                        IPC.logMessage((String)"attachTarget sleep for ", (int)delayTime);
                                        Thread.sleep(delayTime);
                                    }
                                    catch (InterruptedException e) {
                                        IPC.logMessage((String)"attachTarget sleep interrupted");
                                    }
                                }
                            }
                            CommonDirectory.releaseAttachLock((String)("OpenJ9VirtualMachine.tryAttachTarget(" + timeout + ")"));
                            return;
                        }
                        IPC.logMessage((String)"OpenJ9VirtualMachine.tryAttachTarget() myProvider.listVirtualMachines() returns");
                        this.targetServer = new ServerSocket(0);
                        thePort = this.targetServer.getLocalPort();
                        if (thePort >= 0) break block35;
                        IPC.logMessage((String)"OpenJ9VirtualMachine.tryAttachTarget() ServerSocket is not bound yet, port: ", (int)thePort);
                        if (null == replyFile) break block36;
                        replyFile.deleteReply();
                    }
                    if (numberOfTargets > 0) {
                        this.unlockAllAttachNotificationSyncFiles();
                        CommonDirectory.cancelNotify((int)numberOfTargets, (boolean)this.descriptor.isGlobalSemaphore());
                        if (numberOfTargets > 2) {
                            try {
                                int delayTime = 50 * (numberOfTargets > 10 ? 10 : numberOfTargets);
                                IPC.logMessage((String)"attachTarget sleep for ", (int)delayTime);
                                Thread.sleep(delayTime);
                            }
                            catch (InterruptedException e) {
                                IPC.logMessage((String)"attachTarget sleep interrupted");
                            }
                        }
                    }
                    CommonDirectory.releaseAttachLock((String)("OpenJ9VirtualMachine.tryAttachTarget(" + timeout + ")"));
                    return;
                }
                this.portNumber = thePort;
                String key = IPC.getRandomString();
                replyFile = new Reply(this.portNumber, key, TargetDirectory.getTargetDirectoryPath((String)this.descriptor.id()), this.descriptor.getUid());
                try {
                    IPC.logMessage((String)"OpenJ9VirtualMachine.tryAttachTarget() before replyFile.writeReply()");
                    replyFile.writeReply();
                }
                catch (IOException e) {
                    AttachNotSupportedException exc = new AttachNotSupportedException(Msg.getString((String)"K0457"));
                    exc.initCause(e);
                    IPC.logMessage((String)"OpenJ9VirtualMachine.tryAttachTarget() Target no longer available.");
                    throw exc;
                }
                if (this.descriptor.id().equals(AttachHandler.getVmId())) {
                    boolean selfAttachAllowed;
                    String allowAttachSelf_Value = AttachHandler.allowAttachSelf;
                    boolean bl = selfAttachAllowed = "".equals(allowAttachSelf_Value) || Boolean.parseBoolean(allowAttachSelf_Value);
                    if (!selfAttachAllowed) {
                        throw new IOException(Msg.getString((String)"K0646"));
                    }
                    if (!AttachHandler.isAttachApiInitialized()) throw new AttachNotSupportedException(Msg.getString((String)"K0558"));
                    AttachHandler.getMainHandler().attachSelf(thePort, key);
                } else {
                    this.lockAllAttachNotificationSyncFiles(vmds);
                    numberOfTargets = CommonDirectory.countTargetDirectories();
                    int status = CommonDirectory.notifyVm((int)numberOfTargets, (boolean)this.descriptor.isGlobalSemaphore(), (String)"OpenJ9VirtualMachine.tryAttachTarget");
                    if (0 != status && 103 != status) {
                        throw new AttachNotSupportedException(Msg.getString((String)"K0532", (int)status));
                    }
                }
                try {
                    IPC.logMessage((String)("attachTarget " + this.targetId + " on port " + this.portNumber));
                    this.targetServer.setSoTimeout(timeout);
                    this.targetSocket = this.targetServer.accept();
                }
                catch (SocketTimeoutException e) {
                    this.targetServer.close();
                    IPC.logMessage((String)("attachTarget SocketTimeoutException on " + this.portNumber + " to " + this.targetId));
                    AttachNotSupportedException exc = new AttachNotSupportedException(Msg.getString((String)"K0539", (Object)this.targetId, (Object)this.portNumber));
                    exc.initCause(e);
                    throw exc;
                }
                this.commandStream = this.targetSocket.getOutputStream();
                this.targetSocket.setSoTimeout(COMMAND_TIMEOUT);
                this.responseStream = this.targetSocket.getInputStream();
                String response = AttachmentConnection.streamReceiveString((InputStream)this.responseStream, (int)4000);
                if (!response.contains(' ' + key + ' ')) {
                    throw new AttachNotSupportedException(Msg.getString((String)"K0533", (Object)response));
                }
                IPC.logMessage((String)"attachTarget connected on ", (String)this.portNumber.toString());
                this.targetAttached = true;
                if (null == replyFile) break block37;
                replyFile.deleteReply();
            }
            if (numberOfTargets > 0) {
                this.unlockAllAttachNotificationSyncFiles();
                CommonDirectory.cancelNotify((int)numberOfTargets, (boolean)this.descriptor.isGlobalSemaphore());
                if (numberOfTargets > 2) {
                    try {
                        int delayTime = 50 * (numberOfTargets > 10 ? 10 : numberOfTargets);
                        IPC.logMessage((String)"attachTarget sleep for ", (int)delayTime);
                        Thread.sleep(delayTime);
                    }
                    catch (InterruptedException e) {
                        IPC.logMessage((String)"attachTarget sleep interrupted");
                    }
                }
            }
            CommonDirectory.releaseAttachLock((String)("OpenJ9VirtualMachine.tryAttachTarget(" + timeout + ")"));
            return;
        }
    }

    private void unlockAllAttachNotificationSyncFiles() {
        if (null != this.targetLocks) {
            for (int i = 0; i < this.targetLocks.length; ++i) {
                IPC.logMessage((String)"unlockAllAttachNotificationSyncFiles unlocking targetLocks[", (int)i, (String)"]");
                if (null == this.targetLocks[i]) continue;
                this.targetLocks[i].unlockFile("OpenJ9VirtualMachine.unlockAllAttachNotificationSyncFiles");
            }
        }
    }

    @Override
    public void startManagementAgent(Properties agentProperties) throws IOException, IllegalArgumentException, AttachOperationFailedException {
        if (!this.targetAttached) {
            throw new IOException(Msg.getString((String)"K0544"));
        }
        if (null == agentProperties) {
            throw new NullPointerException();
        }
        AttachmentConnection.streamSend((OutputStream)this.commandStream, (String)"ATTACH_START_MANAGEMENT_AGENT");
        IPC.sendProperties((Properties)agentProperties, (OutputStream)this.commandStream);
        String response = AttachmentConnection.streamReceiveString((InputStream)this.responseStream);
        try {
            OpenJ9VirtualMachine.parseResponse(response);
        }
        catch (AgentInitializationException | AgentLoadException e) {
            IPC.logMessage((String)("Unexpected exception " + e + " in startManagementAgent"));
        }
    }

    @Override
    public String startLocalManagementAgent() throws IOException {
        String result;
        block6: {
            if (!this.targetAttached) {
                throw new IOException(Msg.getString((String)"K0544"));
            }
            AttachmentConnection.streamSend((OutputStream)this.commandStream, (String)"ATTACH_START_LOCAL_MANAGEMENT_AGENT");
            String response = AttachmentConnection.streamReceiveString((InputStream)this.responseStream);
            result = "";
            try {
                if (!OpenJ9VirtualMachine.parseResponse(response)) {
                    throw new IOException(Msg.getString((String)"k05dd", (Object)response));
                }
                if (response.startsWith("ATTACH_ACK")) {
                    result = response.substring("ATTACH_ACK".length());
                    break block6;
                }
                if (response.startsWith("ATTACH_RESULT=")) {
                    result = response.substring("ATTACH_RESULT=".length());
                    break block6;
                }
                throw new IOException(Msg.getString((String)"k05dd", (Object)response));
            }
            catch (AgentInitializationException | AgentLoadException | IllegalArgumentException e) {
                IPC.logMessage((String)("Unexpected exception " + e + " in startLocalManagementAgent"));
            }
        }
        return result;
    }

    public InputStream heapHisto(Object ... opts) {
        InputStream ret = null;
        PrivilegedExceptionAction<InputStream> action = () -> this.heapHistoImpl(opts);
        try {
            ret = AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new RuntimeException(cause);
        }
        return ret;
    }

    private InputStream heapHistoImpl(Object ... opts) {
        String responseString = null;
        IPC.logMessage((String)"heapHisto called");
        boolean live = true;
        for (Object opt : opts) {
            IPC.logMessage((String)"heapHisto option: ", (String)opt.toString());
            if ("-live".equals(opt)) {
                live = true;
                continue;
            }
            if ("-all".equals(opt)) {
                live = false;
                continue;
            }
            responseString = "unrecognized option: " + opt.toString();
        }
        if (null == responseString) {
            String cmd = DiagnosticUtils.makeHeapHistoCommand((boolean)live);
            try {
                DiagnosticProperties props = new DiagnosticProperties(this.executeDiagnosticCommand(cmd));
                responseString = props.printStringResult();
            }
            catch (IOException e) {
                responseString = "Error executing heapHisto command: " + e.toString();
            }
        }
        IPC.logMessage((String)"heapHisto result: ", responseString);
        return new ByteArrayInputStream(responseString.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public boolean equals(Object comparand) {
        if (!(comparand instanceof VirtualMachine)) {
            return false;
        }
        VirtualMachine otherVM = (VirtualMachine)comparand;
        return this.id().equals(otherVM.id());
    }

    @Override
    public int hashCode() {
        return this.provider().hashCode() + this.id().hashCode();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "@" + this.hashCode() + ";" + this.id();
    }

    static {
        PrivilegedAction<Object> action = () -> {
            MAXIMUM_ATTACH_TIMEOUT = Integer.getInteger("com.ibm.tools.attach.timeout", 120000);
            COMMAND_TIMEOUT = Integer.getInteger("com.ibm.tools.attach.command_timeout", 0);
            return null;
        };
        AccessController.doPrivileged(action);
    }
}

