/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Hash;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.Session;
import com.ibm.crypto.pkcs11impl.provider.SessionManager;
import com.ibm.crypto.pkcs11impl.provider.Signature;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.SignatureException;
import java.security.SignatureSpi;

public final class PKCS11SHA1withDSASingle
extends SignatureSpi {
    private Signature sig;
    private Hash sha;
    private PrivateKey privateKey;
    private PublicKey publicKey;
    private boolean reset = false;
    private SessionManager sessionManager;

    public PKCS11SHA1withDSASingle(Provider provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        this.sig = new Signature(17, provider);
        this.sha = new Hash(544, ((IBMPKCS11Impl)provider).getSessionManager());
        this.sessionManager = ((IBMPKCS11Impl)provider).getSessionManager();
    }

    public PKCS11SHA1withDSASingle() throws NoSuchAlgorithmException, NoSuchProviderException {
        this(Security.getProvider("IBMPKCS11Impl"));
    }

    @Override
    protected void engineSetParameter(String key, Object param) {
    }

    @Override
    protected Object engineGetParameter(String key) {
        return null;
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.privateKey = privateKey;
        if (this.reset) {
            this.sha.engineReset();
        }
        this.reset = false;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.publicKey = publicKey;
        if (this.reset) {
            this.sha.engineReset();
        }
        this.reset = false;
    }

    @Override
    protected void engineUpdate(byte b) {
        byte[] onebyte = new byte[]{b};
        if (this.reset) {
            this.sha.engineReset();
        }
        this.sha.engineUpdate(onebyte, 0, 1);
    }

    @Override
    protected void engineUpdate(byte[] data, int off, int len) {
        if (this.reset) {
            this.sha.engineReset();
        }
        this.sha.engineUpdate(data, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] engineSign() throws SignatureException {
        byte[] digest = this.sha.engineDigest();
        Session session = this.sessionManager.getOpSession();
        try {
            this.sig.engineInitSign(session, this.privateKey);
        }
        catch (Exception ex) {
            this.sessionManager.releaseSession(session);
            throw new PKCS11Exception(ex.getMessage());
        }
        byte[] signature = null;
        try {
            signature = this.sig.engineSign(session, digest, digest.length);
        }
        finally {
            this.sessionManager.releaseSession(session);
        }
        this.reset = true;
        try {
            byte[] r = new byte[20];
            byte[] s = new byte[20];
            System.arraycopy(signature, 0, r, 0, 20);
            System.arraycopy(signature, 20, s, 0, 20);
            DerOutputStream out = new DerOutputStream(100);
            out.putInteger(new BigInteger(1, r));
            out.putInteger(new BigInteger(1, s));
            DerValue result = new DerValue(48, out.toByteArray());
            return result.toByteArray();
        }
        catch (IOException e) {
            throw new SignatureException("error encoding signature");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean engineVerify(byte[] signature) throws SignatureException {
        byte[] signingBytes = new byte[40];
        try {
            DerInputStream in = new DerInputStream(signature);
            DerValue[] integers = in.getSequence(2);
            byte[] rPrime = integers[0].getInteger().toByteArray();
            byte[] sPrime = integers[1].getInteger().toByteArray();
            int length = rPrime.length;
            if (length > 20) {
                System.arraycopy(rPrime, length - 20, signingBytes, 0, 20);
            } else {
                System.arraycopy(rPrime, 0, signingBytes, 20 - length, length);
            }
            length = sPrime.length;
            if (length > 20) {
                System.arraycopy(sPrime, length - 20, signingBytes, 20, 20);
            } else {
                System.arraycopy(sPrime, 0, signingBytes, 40 - length, length);
            }
        }
        catch (IOException e) {
            throw new SignatureException("invalid encoding for signature :" + e);
        }
        byte[] digest = this.sha.engineDigest();
        Session session = null;
        try {
            session = this.sessionManager.getOpSession();
            this.sig.engineInitVerify(session, this.publicKey);
        }
        catch (Exception ex) {
            this.sessionManager.releaseSession(session);
            throw new PKCS11Exception(ex.getMessage());
        }
        this.reset = true;
        try {
            boolean bl = this.sig.engineVerify(session, signingBytes, digest, digest.length);
            return bl;
        }
        finally {
            this.sessionManager.releaseSession(session);
        }
    }
}

