/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.crmf;

import com.ibm.security.cmputil.CMPDerObject;
import com.ibm.security.crmf.CRMF;
import com.ibm.security.crmf.RegInfo;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;

public final class Utf8PairsRegInfo
extends CMPDerObject
implements RegInfo,
Cloneable {
    private static final ObjectIdentifier oid = CRMF.id_regInfo_utf8Pairs_oid;
    private String value;
    private byte[] encodedValue;

    public Utf8PairsRegInfo(String string) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("Utf8PairsRegInfo error, utf8String not specified");
        }
        this.value = string;
        this.setEncodedValue();
    }

    public Utf8PairsRegInfo(byte[] byArray) throws IOException {
        this.decode(byArray);
    }

    public Object clone() {
        try {
            return new Utf8PairsRegInfo(this.encodedValue);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        this.value = derValue.getData().getUTF8String();
        this.setEncodedValue();
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putUTF8String(this.value);
        outputStream.write(derOutputStream.toByteArray());
    }

    public boolean equals(Utf8PairsRegInfo utf8PairsRegInfo) {
        DerValue derValue;
        DerValue derValue2;
        if (utf8PairsRegInfo == this) {
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode((OutputStream)derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            utf8PairsRegInfo.encode((OutputStream)derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        return derValue2.equals(derValue);
    }

    public boolean equals(Object object) {
        if (object instanceof Utf8PairsRegInfo) {
            return this.equals((Utf8PairsRegInfo)object);
        }
        return false;
    }

    public byte[] getEncodedValue() {
        return (byte[])this.encodedValue.clone();
    }

    public String getName() {
        return "Utf8Pairs";
    }

    public ObjectIdentifier getObjectIdentifier() {
        return oid;
    }

    public Object getValue() {
        return this.value;
    }

    private void setEncodedValue() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putUTF8String(this.value);
        this.encodedValue = derOutputStream.toByteArray();
    }

    public String toString() {
        String string = "";
        Object object = this.getValue();
        string = String.valueOf(string) + "Utf8PairsRegInfo:";
        string = String.valueOf(string) + "\r\nvalue: ";
        string = String.valueOf(string) + this.value;
        return string;
    }
}

