/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.crypto.dsig.dom;

import com.ibm.xml.crypto.dsig.dom.AlgorithmFactory;
import com.ibm.xml.crypto.dsig.dom.XMLStructureImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.keyinfo.PGPData;

class PGPDataImpl
extends XMLStructureImpl
implements PGPData {
    List content;
    byte[] keyId;
    byte[] keyPacket;

    PGPDataImpl(AlgorithmFactory f, byte[] keyId, byte[] keyPacket, List content) {
        super(f);
        if (keyId == null && keyPacket == null) {
            throw new NullPointerException("Both of keyId and keyPacket are null.");
        }
        this.keyId = null;
        if (keyId != null) {
            if (!this.afactory.checkPGPKeyId(keyId)) {
                throw new IllegalArgumentException("Invalid PGP key id");
            }
            this.keyId = new byte[keyId.length];
            System.arraycopy(keyId, 0, this.keyId, 0, keyId.length);
        }
        this.keyPacket = null;
        if (keyPacket != null) {
            this.afactory.checkPGPKeyPacket(keyPacket);
            this.keyPacket = new byte[keyPacket.length];
            System.arraycopy(keyPacket, 0, this.keyPacket, 0, keyPacket.length);
        }
        if (content == null || content.size() == 0) {
            this.content = null;
        } else {
            this.content = new ArrayList(content.size());
            for (XMLStructure obj : content) {
                this.content.add(obj);
            }
        }
    }

    @Override
    public byte[] getKeyId() {
        if (this.keyId == null) {
            return null;
        }
        byte[] ret = new byte[this.keyId.length];
        System.arraycopy(this.keyId, 0, ret, 0, ret.length);
        return ret;
    }

    @Override
    public byte[] getKeyPacket() {
        if (this.keyPacket == null) {
            return null;
        }
        byte[] ret = new byte[this.keyPacket.length];
        System.arraycopy(this.keyPacket, 0, ret, 0, ret.length);
        return ret;
    }

    public List getExternalElements() {
        return this.content == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(this.content);
    }
}

