/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.crypto.dsig.dom;

import com.ibm.xml.crypto.dsig.dom.AlgorithmFactory;
import com.ibm.xml.crypto.dsig.dom.AlgorithmMethodImpl;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.spec.DigestMethodParameterSpec;

class DigestMethodImpl
extends AlgorithmMethodImpl
implements DigestMethod {
    DigestMethodImpl(AlgorithmFactory f, String alg, DigestMethodParameterSpec param) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        super(f, alg, param);
        MessageDigest d = this.afactory.getMessageDigest(alg, param);
        this.afactory.releaseMessageDigest(alg, d);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DigestMethod)) {
            return false;
        }
        DigestMethod odm = (DigestMethod)o;
        boolean algorithmEqual = this.getAlgorithm().equals(odm.getAlgorithm());
        AlgorithmParameterSpec params = this.getParameterSpec();
        boolean paramsEqual = params == null ? odm.getParameterSpec() == null : params.equals(odm.getParameterSpec());
        return algorithmEqual && paramsEqual;
    }

    public int hashCode() {
        int result = 17;
        AlgorithmParameterSpec params = this.getParameterSpec();
        if (params != null) {
            result = 31 * result + params.hashCode();
        }
        result = 31 * result + this.getAlgorithm().hashCode();
        return result;
    }
}

