/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.trace.format.api;

import com.ibm.jvm.trace.format.api.ByteStream;
import com.ibm.jvm.trace.format.api.TraceContext;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.nio.ByteOrder;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraceRecord
implements Comparable<TraceRecord> {
    private TraceContext context;
    private String textSummary;
    private BigInteger endTime = BigInteger.ZERO;
    BigInteger wrapTime = BigInteger.ZERO;
    BigInteger writePlatform = BigInteger.ZERO;
    private byte[] endTimeBytes = new byte[8];
    private byte[] wrapTimeBytes = new byte[8];
    BigInteger writeSystem = BigInteger.ZERO;
    long threadID;
    long threadSyn1;
    long threadSyn2;
    int firstEntry;
    int nextEntry;
    String threadName = "";
    private byte[] data;
    boolean lostRecord = false;
    boolean userDiscardedData = false;
    private static final byte[] userDiscardTracePoint = new byte[]{8, 0, 1, 0, 0, 0, 0, 0};
    public static final int TRACERECORD_HEADER_SIZE = 64;
    private static final int GUESSED_MAX_THREAD_NAME = 128;
    RandomAccessFile file;
    long offset;
    List<Integer> debugOffsets = null;

    public TraceRecord(TraceContext context, byte[] data) throws IllegalArgumentException {
        this.context = context;
        this.data = data;
        if (data.length != context.getRecordSize()) {
            throw new IllegalArgumentException();
        }
        if (context.debugLevel > 0) {
            this.debugOffsets = new Vector<Integer>();
        }
        this.parseHeader(data);
    }

    public TraceRecord(TraceContext context, RandomAccessFile file, long offset) throws IOException, IllegalArgumentException {
        this.context = context;
        this.file = file;
        this.offset = offset;
        int required = 192;
        if (context.debugLevel > 0) {
            this.debugOffsets = new Vector<Integer>();
        }
        while (required != 0) {
            byte[] data = new byte[required];
            file.seek(offset);
            if (file.read(data) != data.length) {
                throw new IllegalArgumentException();
            }
            required = this.parseHeader(data);
        }
        if (context.debugStream != null) {
            context.debug(this, 3, this.summary());
        }
    }

    private int parseHeader(byte[] data) throws IllegalArgumentException {
        ByteStream stream = this.context.createByteStream(data);
        stream.peek(this.endTimeBytes);
        this.endTime = stream.getBigInteger(8);
        stream.peek(this.wrapTimeBytes);
        this.wrapTime = stream.getBigInteger(8);
        this.writePlatform = stream.getBigInteger(8);
        this.writeSystem = stream.getBigInteger(8);
        this.threadID = stream.getLong();
        this.threadSyn1 = stream.getLong();
        this.threadSyn2 = stream.getLong();
        this.firstEntry = stream.getInt();
        this.nextEntry = stream.getInt();
        String error = null;
        if (error == null && this.firstEntry < 64) {
            error = "data passed to TraceRecord gives firstEntry[" + this.firstEntry + "] < header size[" + 64 + "]";
        }
        if (error == null && this.nextEntry > this.context.getRecordSize()) {
            error = "data passed to TraceRecord gives nextEntry[" + this.nextEntry + "] > record size[" + this.context.getRecordSize() + "]";
        }
        if (error == null && this.firstEntry > this.nextEntry && this.nextEntry != -1) {
            error = "data passed to TraceRecord gives firstEntry[" + this.firstEntry + "] > nextEntry[" + this.nextEntry + "]";
        }
        if (error != null) {
            this.context.error(this, error);
            throw new IllegalArgumentException(error);
        }
        if (data.length < this.firstEntry) {
            return this.firstEntry;
        }
        this.threadName = stream.getASCIIString(this.firstEntry - 64).intern();
        return 0;
    }

    private int load() {
        if (this.file != null && (this.data == null || this.data.length != this.context.getRecordSize())) {
            this.data = new byte[this.context.getRecordSize()];
            if (this.context.debugStream != null) {
                this.context.debug(this, 3, "Reading in full " + this.data.length + "byte record @" + this.offset);
            }
            int bytesRead = 0;
            try {
                this.file.seek(this.offset);
                bytesRead = this.file.read(this.data);
                if (bytesRead != this.data.length) {
                    this.context.error(this, "couldn't read an entire record from the file");
                    if (bytesRead <= this.nextEntry) {
                        return 0;
                    }
                    byte[] shrunk = new byte[bytesRead];
                    System.arraycopy(this.data, 0, shrunk, 0, bytesRead);
                    this.data = shrunk;
                }
                return bytesRead;
            }
            catch (IOException e) {
                this.context.error(this, "IOException while reading record at offset " + this.offset);
                this.context.error(this, e.getMessage());
                return 0;
            }
        }
        return this.data.length;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int appendToStream(ByteStream stream, boolean newThread) {
        if (this.load() == 0) {
            return 0;
        }
        ++this.context.totalRecords;
        if (this.nextEntry == -1) {
            if (this.context.getTraceType() == 1) {
                stream.setGuardBytes(stream.getGuardBytes() + this.data.length - this.firstEntry);
                stream.add(this.data, this.firstEntry);
                return this.data.length - this.firstEntry;
            }
            this.context.warning(this, "Found \"middle of tracepoint record\" for internal trace record.");
            return 0;
        }
        if (this.nextEntry == this.context.getRecordSize()) {
            --this.nextEntry;
        }
        if (this.context.getTraceType() == 0) {
            byte[] tmp = new byte[this.data.length];
            int pivotIndex = this.nextEntry + 1;
            System.arraycopy(this.data, pivotIndex, tmp, this.firstEntry, this.data.length - pivotIndex);
            System.arraycopy(this.data, this.firstEntry, tmp, this.data.length - pivotIndex + this.firstEntry, pivotIndex - this.firstEntry);
            this.nextEntry = this.data.length - 1;
            this.data = tmp;
        }
        int indexSource = this.nextEntry;
        int indexTarget = this.nextEntry;
        byte entryLengthSource = this.data[indexSource];
        if (entryLengthSource == 0 && this.nextEntry - this.firstEntry > 7 && this.data[this.nextEntry - 1] == 8 && this.data[this.nextEntry - 8] == 0 && this.data[this.nextEntry - 7] == 0 && this.data[this.nextEntry - 6] == 0) {
            --indexTarget;
            --this.nextEntry;
            entryLengthSource = this.data[--indexSource];
            this.context.warning(this, "Fixed up misaligned sequence wrap trace point from defect 147869");
        }
        this.data[indexSource] = 0;
        int leadin = 0;
        int guardBytes = stream.getGuardBytes();
        boolean discard = true;
        byte[] startTimestamp = new byte[8];
        startTimestamp[0] = 8;
        startTimestamp[1] = 0;
        startTimestamp[2] = 0;
        startTimestamp[3] = 0;
        if (this.context.metadata.byteOrder == ByteOrder.LITTLE_ENDIAN) {
            System.arraycopy(this.endTimeBytes, 4, startTimestamp, 4, 4);
        } else {
            System.arraycopy(this.endTimeBytes, 0, startTimestamp, 4, 4);
        }
        while (indexTarget >= this.firstEntry && entryLengthSource != 0) {
            block74: {
                block76: {
                    block75: {
                        block73: {
                            int len;
                            block69: {
                                block72: {
                                    block71: {
                                        len = entryLengthSource & 0xFF;
                                        indexTarget = indexSource - len;
                                        if (len != 4) break block71;
                                        byte[] longTPSize = new byte[4];
                                        if (indexTarget < this.firstEntry) {
                                            byte[] missing;
                                            block68: {
                                                missing = new byte[this.firstEntry - indexTarget];
                                                try {
                                                    int found = stream.truncate(missing);
                                                    guardBytes = stream.getGuardBytes();
                                                    if (found != missing.length) {
                                                        if (this.context.debugStream != null) {
                                                            this.context.debug(this, 4, "discarding spanned long trace point special because we failed retriving " + missing.length + "bytes, got " + found);
                                                        }
                                                        discard = true;
                                                    }
                                                    break block68;
                                                }
                                                catch (IndexOutOfBoundsException e) {
                                                    if (this.context.debugStream != null) {
                                                        this.context.debug(this, 4, "discarding spanned long trace point special because we underflowed trying to get " + missing.length + "bytes");
                                                    }
                                                    discard = true;
                                                }
                                                break;
                                            }
                                            System.arraycopy(missing, 0, longTPSize, 0, missing.length);
                                            System.arraycopy(this.data, this.firstEntry, longTPSize, missing.length, 4 - missing.length);
                                        } else {
                                            longTPSize[0] = this.data[indexSource - 4];
                                            longTPSize[1] = this.data[indexSource - 3];
                                            longTPSize[2] = this.data[indexSource - 2];
                                            longTPSize[3] = this.data[indexSource - 1];
                                        }
                                        byte highBits = longTPSize[3];
                                        byte lowBits = longTPSize[0];
                                        len = (highBits & 0xFF) << 8 | lowBits & 0xFF;
                                        if (longTPSize[1] != 0 || longTPSize[2] != 0) {
                                            if (indexTarget < this.firstEntry) {
                                                this.context.warning(this, "center 2 bytes for spanned long tracepoint special are not null, discarding remaining data");
                                            } else {
                                                this.context.error(this, "center 2 bytes for long tracepoint are not null, discarding remaining data");
                                            }
                                            discard = true;
                                            break;
                                        }
                                        if (this.context.debugStream != null) {
                                            this.context.debug(this, 4, "length for long tracepoint is " + len);
                                        }
                                        if ((indexTarget = indexSource - 4 - len) >= this.firstEntry - 1) {
                                            System.arraycopy(this.data, indexTarget + 1, this.data, indexTarget + 5, len - 1);
                                            System.arraycopy(longTPSize, 0, this.data, indexTarget + 1, longTPSize.length);
                                            break block69;
                                        } else {
                                            int localLen = indexSource - 4 - this.firstEntry;
                                            try {
                                                if (localLen > 0) {
                                                    stream.put(longTPSize, localLen - len + 1);
                                                } else {
                                                    stream.put(longTPSize, 0 - len + 1);
                                                }
                                                guardBytes = stream.getGuardBytes();
                                            }
                                            catch (IndexOutOfBoundsException e) {
                                                if (this.context.debugStream != null) {
                                                    this.context.warning(this, "Unable to insert long trace point special at index " + (localLen - len + 1) + " in the byte stream");
                                                }
                                                discard = true;
                                                break;
                                            }
                                            if (localLen > 0) {
                                                System.arraycopy(this.data, this.firstEntry, this.data, this.firstEntry + 4, localLen);
                                                leadin += 4;
                                                break block69;
                                            } else {
                                                leadin += 4 + localLen;
                                            }
                                        }
                                        break block69;
                                    }
                                    if (len != 8 || this.data[indexTarget + 1] != 0 || this.data[indexTarget + 3] != 0) break block69;
                                    if (this.data[indexTarget + 2] != 0) break block72;
                                    if (indexTarget > this.firstEntry) {
                                        byte[] timestamp = new byte[8];
                                        timestamp[0] = 8;
                                        System.arraycopy(this.data, indexTarget + 1, timestamp, 1, 7);
                                        System.arraycopy(startTimestamp, 1, this.data, indexTarget + 1, 7);
                                        startTimestamp = timestamp;
                                        if (this.context.debugLevel > 0) {
                                            this.debugOffsets.add(indexTarget);
                                        }
                                        break block69;
                                    } else {
                                        int fragmentSize = stream.getGuardBytes();
                                        if (fragmentSize != 0 && fragmentSize != this.firstEntry - indexTarget && this.context.debugStream != null) {
                                            this.context.debug(this, 4, "Sequence wrap trace point spans buffers but doesn't match fragment size from preceeding buffer, discarding both");
                                        }
                                        discard = true;
                                        break;
                                    }
                                }
                                if (indexTarget == this.firstEntry && this.data[indexTarget] == 0 && this.data[indexTarget + 2] == 1) {
                                    discard = true;
                                    this.lostRecord = true;
                                    if (this.context.debugLevel > 0) {
                                        this.debugOffsets.add(indexTarget);
                                    }
                                } else {
                                    this.context.error(this, "Special tracepoint (length is 8) and neither sequence wrap or lost record");
                                }
                            }
                            if (indexTarget <= this.firstEntry) break block73;
                            if (this.context.debugLevel >= 5) {
                                if (len > 12) {
                                    this.context.debug(this, 5, "fixing up tracepoint: " + new String(this.data, indexTarget + 12, Math.min(len - 12, 8)) + ", data[" + indexTarget + "] = " + (entryLengthSource & 0xFF));
                                } else {
                                    this.context.debug(this, 5, "fixing up special tracepoint, length " + len);
                                }
                            }
                            byte entryLengthTarget = this.data[indexTarget];
                            this.data[indexTarget] = entryLengthSource;
                            entryLengthSource = entryLengthTarget;
                            indexSource = indexTarget;
                            if (this.context.debugLevel > 0) {
                                this.debugOffsets.add(indexTarget);
                            }
                            break block74;
                        }
                        if (indexTarget == this.firstEntry && this.data[this.firstEntry] == 0) {
                            if (guardBytes > 0) {
                                discard = true;
                            }
                            this.data[indexTarget] = entryLengthSource;
                            indexSource = indexTarget;
                            if (this.context.debugLevel <= 0) break;
                            this.debugOffsets.add(indexTarget);
                            break;
                        }
                        if (indexTarget != this.firstEntry || this.data[this.firstEntry] == 0) break block75;
                        byte entryLengthTarget = this.data[indexTarget];
                        this.data[indexTarget] = entryLengthSource;
                        entryLengthSource = entryLengthTarget;
                        indexSource = indexTarget;
                        break block74;
                    }
                    if (this.context.getTraceType() != 1) break block76;
                    int negativeOffset = indexTarget - this.firstEntry - leadin;
                    if (this.context.debugStream != null) {
                        this.context.debug(this, 5, "Negative offset for fixup is " + negativeOffset);
                    }
                    if (negativeOffset == -1) {
                        if (guardBytes == 1) {
                            stream.truncate(1);
                            discard = false;
                        } else {
                            discard = true;
                        }
                        this.data[indexTarget] = entryLengthSource;
                        indexSource = indexTarget;
                        if (this.context.debugLevel > 0) {
                            this.debugOffsets.add(indexTarget);
                        }
                        break block74;
                    } else {
                        block70: {
                            if (guardBytes + negativeOffset != 0 || this.userDiscardedData) {
                                discard = true;
                            } else {
                                if (this.context.debugStream != null) {
                                    this.context.debug(this, 5, "Trying to put byte into stream at offset " + negativeOffset + " into " + stream.getGuardBytes() + " guard bytes");
                                }
                                try {
                                    byte b = stream.put(entryLengthSource, negativeOffset);
                                    if (b != 0) {
                                        discard = true;
                                        break block70;
                                    }
                                    if (this.context.debugStream != null) {
                                        this.context.debug(this, 5, "successfully fixed up earlier buffer");
                                    }
                                    discard = false;
                                    if (this.context.debugLevel > 0) {
                                        this.debugOffsets.add(indexTarget);
                                    }
                                }
                                catch (IndexOutOfBoundsException e) {
                                    this.context.error(this, "discarding end of spanned tracepoint for " + this.getIdentifier() + ", missing " + Math.abs(negativeOffset) + " bytes for start, discarding " + (indexSource - this.firstEntry - leadin) + " bytes");
                                    discard = true;
                                }
                            }
                        }
                        if (discard || indexSource <= this.firstEntry) break;
                        stream.add(this.data, this.firstEntry + leadin, indexSource - this.firstEntry - leadin);
                        break;
                    }
                }
                if (this.context.getTraceType() != 0) {
                    this.context.error(this, "Unknown trace type: " + this.context.getTraceType());
                }
                discard = true;
            }
            ++this.context.totalTracePoints;
        }
        if (discard) {
            long expected = Math.abs(indexTarget - this.firstEntry - leadin);
            stream.truncate(guardBytes);
            leadin = indexSource - this.firstEntry;
            if (this.userDiscardedData && !this.lostRecord) {
                stream.add(userDiscardTracePoint);
            } else if (expected != (long)guardBytes) {
                if (this.lostRecord) {
                    this.context.debug(this, 4, "Discarding data depending on contents of lost records");
                } else if (expected == 0L) {
                    this.context.debug(this, 4, "Previous record was likely flushed, discarding trailing data");
                } else if (!newThread) {
                    this.context.warning(this, "Expected " + expected + " of data from previous buffer for thread " + this.getIdentifier() + ", got " + guardBytes + " so discarded both inconsistent pieces");
                }
            }
        }
        if (this.context.debugStream != null) {
            this.context.debug(this, 4, "guarding " + (this.data.length - this.nextEntry) + "bytes");
        }
        stream.setGuardBytes(this.data.length - this.nextEntry);
        stream.add(startTimestamp);
        if (this.context.debugLevel > 0) {
            this.debugOffsets.add(Integer.MIN_VALUE);
        }
        stream.add(this.data, indexSource);
        return this.data.length - (this.firstEntry + leadin);
    }

    public String toString() {
        return this.getIdentifier();
    }

    private String getIdentifier() {
        return (this.threadID + this.threadName).intern();
    }

    public String summary() {
        if (this.textSummary == null) {
            StringBuilder s = new StringBuilder("TraceRecord:" + System.getProperty("line.separator"));
            if (this.file != null) {
                s.append("file offset:    " + this.offset).append(System.getProperty("line.separator"));
            } else {
                s.append("non file data").append(System.getProperty("line.separator"));
            }
            s.append("internal id:    ").append(this.toString()).append(System.getProperty("line.separator"));
            s.append("endTime:        ").append(this.endTime).append(System.getProperty("line.separator"));
            s.append("wrapTime:       ").append(this.wrapTime).append(System.getProperty("line.separator"));
            s.append("writePlatform:  ").append(this.writePlatform).append(System.getProperty("line.separator"));
            s.append("writeSystem:    ").append(this.writeSystem).append(System.getProperty("line.separator"));
            s.append("threadID:       ").append("0x" + Long.toHexString(this.threadID)).append(System.getProperty("line.separator"));
            s.append("threadSyn1:     ").append(this.threadSyn1).append(System.getProperty("line.separator"));
            s.append("threadSyn2:     ").append(this.threadSyn2).append(System.getProperty("line.separator"));
            s.append("firstEntry:     ").append(this.firstEntry).append(System.getProperty("line.separator"));
            s.append("nextEntry:      ").append(this.nextEntry).append(System.getProperty("line.separator"));
            this.textSummary = s.toString();
        }
        return this.textSummary;
    }

    @Override
    public int compareTo(TraceRecord other) {
        return this.wrapTime.compareTo(other.wrapTime);
    }
}

