/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.marshalling.data.events;

import com.ibm.java.diagnostics.healthcenter.marshalling.data.events.ThreadInternalEvent;
import com.ibm.java.diagnostics.healthcenter.marshalling.data.events.ThreadInternalObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ThreadEventHandler
extends Thread {
    List<ThreadInternalEvent> listeners = new ArrayList<ThreadInternalEvent>();
    Queue<ThreadInternalObject> events = new ConcurrentLinkedQueue<ThreadInternalObject>();
    private boolean flushData = false;
    private static int eventQueueSize = 0;
    private static final int maxEventQueueSize = 10000;
    protected volatile boolean run = true;

    public ThreadEventHandler() {
        super("Thread Event Handler");
        this.setDaemon(true);
    }

    public void addThreadEventListener(ThreadInternalEvent threadInternalEvent) {
        this.listeners.add(threadInternalEvent);
    }

    private void triggerThread(ThreadInternalObject threadInternalObject) {
        for (ThreadInternalEvent threadInternalEvent : this.listeners) {
            threadInternalEvent.threadEvent(threadInternalObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(ThreadInternalObject threadInternalObject) {
        Queue<ThreadInternalObject> queue = this.events;
        synchronized (queue) {
            if (eventQueueSize < 10000 && !this.flushData) {
                this.events.add(threadInternalObject);
                ++eventQueueSize;
            } else {
                this.flushData = true;
            }
            this.events.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.run) {
            try {
                if (!this.events.isEmpty()) {
                    if (this.flushData) {
                        while (this.flushData) {
                            this.triggerThread(this.events.poll());
                            --eventQueueSize;
                            if (!this.events.isEmpty()) continue;
                            this.flushData = false;
                        }
                    } else {
                        this.triggerThread(this.events.poll());
                        --eventQueueSize;
                    }
                }
                Queue<ThreadInternalObject> queue = this.events;
                synchronized (queue) {
                    try {
                        if (this.events.isEmpty()) {
                            this.events.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void terminate() {
        this.run = false;
        this.interrupt();
    }
}

