/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.marshalling.data.events;

import com.ibm.java.diagnostics.healthcenter.marshalling.data.events.CpuInternalEvent;
import com.ibm.java.diagnostics.healthcenter.marshalling.data.events.CpuInternalObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class CpuEventHandler
extends Thread {
    List<CpuInternalEvent> listeners = new ArrayList<CpuInternalEvent>();
    Queue<CpuInternalObject> events = new ConcurrentLinkedQueue<CpuInternalObject>();
    private boolean flushData = false;
    private static int eventQueueSize = 0;
    private static final int maxEventQueueSize = 15;
    protected volatile boolean run = true;

    public CpuEventHandler() {
        super("CPU Event Handler");
        this.setDaemon(true);
    }

    public void addCpuEventListener(CpuInternalEvent cpuInternalEvent) {
        this.listeners.add(cpuInternalEvent);
    }

    private void triggerEvent(CpuInternalObject cpuInternalObject) {
        for (CpuInternalEvent cpuInternalEvent : this.listeners) {
            cpuInternalEvent.cpuEvent(cpuInternalObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(CpuInternalObject cpuInternalObject) {
        Queue<CpuInternalObject> queue = this.events;
        synchronized (queue) {
            if (eventQueueSize < 15 && !this.flushData) {
                this.events.add(cpuInternalObject);
                ++eventQueueSize;
            } else {
                this.flushData = true;
            }
            this.events.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.run) {
            try {
                if (!this.events.isEmpty()) {
                    if (this.flushData) {
                        while (this.flushData) {
                            this.triggerEvent(this.events.poll());
                            --eventQueueSize;
                            if (!this.events.isEmpty()) continue;
                            this.flushData = false;
                        }
                    } else {
                        this.triggerEvent(this.events.poll());
                        --eventQueueSize;
                    }
                }
                Queue<CpuInternalObject> queue = this.events;
                synchronized (queue) {
                    try {
                        if (this.events.isEmpty()) {
                            this.events.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void terminate() {
        this.run = false;
        this.interrupt();
    }
}

