/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.jit.postprocessor;

import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.DataPointBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.StructuredStringDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.SubsystemDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TableDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.impl.data.StructuredStringDataImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.data.TableDataImpl;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.extensions.postprocessing.PostProcessor;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.JVMLabels;
import com.ibm.java.diagnostics.healthcenter.jit.JITCompileDataPointImpl;
import com.ibm.java.diagnostics.healthcenter.jit.JITLabels;
import com.ibm.java.diagnostics.healthcenter.jit.Messages;
import com.ibm.java.diagnostics.healthcenter.jit.SharedCacheDataPointImpl;
import com.ibm.java.diagnostics.healthcenter.postprocessor.PostProcessorBase;
import java.text.MessageFormat;
import java.util.logging.Logger;

public class JITPostProcessor
extends PostProcessorBase
implements PostProcessor {
    private static final Logger TRACE = LogFactory.getTrace(JITPostProcessor.class);
    private static final String EMPTY_STRING = "";
    private static final String CLASS_NAME = JITPostProcessor.class.getName();

    @Override
    public void postprocess(DataBuilder dataBuilder, OutputProperties outputProperties) {
        TRACE.entering(CLASS_NAME, "postprocess");
        TableDataImpl tableDataImpl = new TableDataImpl(JITLabels.SUMMARY, new String[]{EMPTY_STRING, EMPTY_STRING});
        SubsystemDataBuilder subsystemDataBuilder = (SubsystemDataBuilder)dataBuilder.getTopLevelData(JVMLabels.JIT);
        if (subsystemDataBuilder != null) {
            subsystemDataBuilder.clearValue();
            subsystemDataBuilder.removeData(JITLabels.RECOMMENDATION_LABEL);
            StructuredStringDataImpl structuredStringDataImpl = new StructuredStringDataImpl(JITLabels.RECOMMENDATION_LABEL);
            this.checkForMethodPrexInvalidatedEvents(subsystemDataBuilder, structuredStringDataImpl);
            this.checkForCompilationFailureEvents(subsystemDataBuilder, structuredStringDataImpl);
            this.checkForCacheFullEvents(subsystemDataBuilder, structuredStringDataImpl);
            this.checkForDataCacheFullEvents(subsystemDataBuilder, structuredStringDataImpl);
            this.checkForIProfilerCapReachedEvents(subsystemDataBuilder, structuredStringDataImpl);
            this.checkForIncompatbleAOTHeaderEvents(subsystemDataBuilder, structuredStringDataImpl);
            this.checkForLowUserVirtualMemoryEvents(subsystemDataBuilder, structuredStringDataImpl);
            this.calculateMethodStats(subsystemDataBuilder, tableDataImpl, structuredStringDataImpl);
            this.populateSCCInfo(subsystemDataBuilder, structuredStringDataImpl);
            subsystemDataBuilder.addData(tableDataImpl);
            this.setHighLevelMessage(subsystemDataBuilder, structuredStringDataImpl);
            subsystemDataBuilder.addData(structuredStringDataImpl);
        }
        TRACE.exiting(CLASS_NAME, "postprocess");
    }

    private void populateSCCInfo(SubsystemDataBuilder subsystemDataBuilder, StructuredStringDataBuilder structuredStringDataBuilder) {
        TwoDimensionalDataBuilder twoDimensionalDataBuilder;
        DataPointBuilder[] dataPointBuilderArray;
        Data data = subsystemDataBuilder.getData(JITLabels.SCC_INFO);
        if (data != null && (dataPointBuilderArray = (twoDimensionalDataBuilder = (TwoDimensionalDataBuilder)data).getDataPoints()).length >= 1) {
            SharedCacheDataPointImpl sharedCacheDataPointImpl = (SharedCacheDataPointImpl)dataPointBuilderArray[dataPointBuilderArray.length - 1];
            if (sharedCacheDataPointImpl.disabledReason.isEnabled()) {
                structuredStringDataBuilder.addInformation(MessageFormat.format(Messages.getString("jit.recommendations.scc.info"), sharedCacheDataPointImpl.cacheName, sharedCacheDataPointImpl.cacheDir, sharedCacheDataPointImpl.cacheSize, sharedCacheDataPointImpl.freeBytes, sharedCacheDataPointImpl.softMaxBytes, sharedCacheDataPointImpl.ROMClassBytes, sharedCacheDataPointImpl.AOTBytes, sharedCacheDataPointImpl.AOTDataBytes, sharedCacheDataPointImpl.JITHintDataBytes, sharedCacheDataPointImpl.JITProfileDataBytes, sharedCacheDataPointImpl.numROMClasses, sharedCacheDataPointImpl.numAOTMethods));
            } else {
                structuredStringDataBuilder.addWarning(MessageFormat.format(Messages.getString("jit.recommendations.scc.disabled"), sharedCacheDataPointImpl.disabledReason.name()));
            }
        }
    }

    private void checkForMethodPrexInvalidatedEvents(SubsystemDataBuilder subsystemDataBuilder, StructuredStringDataBuilder structuredStringDataBuilder) {
        int n;
        Data data = subsystemDataBuilder.getData(JITLabels.METHOD_PREX_INVALIDATED);
        if (data != null && (n = ((TwoDimensionalDataBuilder)data).getDataPoints().length) > 0) {
            structuredStringDataBuilder.addWarning(MessageFormat.format(Messages.getString("jit.recommendations.prex.events"), n));
        }
    }

    private void checkForCompilationFailureEvents(SubsystemDataBuilder subsystemDataBuilder, StructuredStringDataBuilder structuredStringDataBuilder) {
        double d;
        Data data = subsystemDataBuilder.getData(JITLabels.MANY_COMPILATION_FAILURES);
        if (data != null && (d = ((TwoDimensionalDataBuilder)data).getRawTotalY()) > 0.0) {
            structuredStringDataBuilder.addWarning(MessageFormat.format(Messages.getString("jit.recommendations.comp.failures"), d));
        }
    }

    private void checkForCacheFullEvents(SubsystemDataBuilder subsystemDataBuilder, StructuredStringDataBuilder structuredStringDataBuilder) {
        Data data = subsystemDataBuilder.getData(JITLabels.CACHE_FULL);
        if (data != null) {
            structuredStringDataBuilder.addWarning(Messages.getString("jit.recommendations.cache.full"));
        }
    }

    private void checkForDataCacheFullEvents(SubsystemDataBuilder subsystemDataBuilder, StructuredStringDataBuilder structuredStringDataBuilder) {
        Data data = subsystemDataBuilder.getData(JITLabels.DATA_CACHE_FULL);
        if (data != null) {
            structuredStringDataBuilder.addWarning(Messages.getString("jit.recommendations.data.cache.full"));
        }
    }

    private void checkForIProfilerCapReachedEvents(SubsystemDataBuilder subsystemDataBuilder, StructuredStringDataBuilder structuredStringDataBuilder) {
        Data data = subsystemDataBuilder.getData(JITLabels.PROFILER_CAP_REACHED);
        if (data != null) {
            structuredStringDataBuilder.addWarning(Messages.getString("jit.recommendations.profiler.cap.reached"));
        }
    }

    private void checkForIncompatbleAOTHeaderEvents(SubsystemDataBuilder subsystemDataBuilder, StructuredStringDataBuilder structuredStringDataBuilder) {
        Data data = subsystemDataBuilder.getData(JITLabels.INCOMPATIBLE_HEADER);
        if (data != null) {
            structuredStringDataBuilder.addWarning(Messages.getString("jit.recommendations.incompatible.header"));
        }
    }

    private void checkForLowUserVirtualMemoryEvents(SubsystemDataBuilder subsystemDataBuilder, StructuredStringDataBuilder structuredStringDataBuilder) {
        Data data = subsystemDataBuilder.getData(JITLabels.LOW_VIRTUAL_MEMORY);
        if (data != null) {
            structuredStringDataBuilder.addWarning(Messages.getString("jit.recommendations.low.virtual.memory"));
        }
    }

    private void checkForCodeCacheAllocatedEvents(SubsystemDataBuilder subsystemDataBuilder, StructuredStringDataBuilder structuredStringDataBuilder) {
        int n;
        Data data = subsystemDataBuilder.getData(JITLabels.CODE_CACHE_ALLOCATED);
        if (data != null && (n = ((TwoDimensionalDataBuilder)data).getDataPoints().length) > 0) {
            structuredStringDataBuilder.addInformation(MessageFormat.format(Messages.getString("jit.recommendations.cache.allocated.events"), n));
        }
    }

    private void calculateMethodStats(SubsystemDataBuilder subsystemDataBuilder, TableDataBuilder tableDataBuilder, StructuredStringDataBuilder structuredStringDataBuilder) {
        TwoDimensionalDataBuilder twoDimensionalDataBuilder;
        Data data = subsystemDataBuilder.getData(JITLabels.COMPILE_END);
        if (data != null && (twoDimensionalDataBuilder = (TwoDimensionalDataBuilder)data) != null && !twoDimensionalDataBuilder.isEmpty()) {
            DataPointBuilder[] dataPointBuilderArray = twoDimensionalDataBuilder.getDataPoints();
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            block8: for (DataPointBuilder dataPointBuilder : dataPointBuilderArray) {
                switch (((JITCompileDataPointImpl)dataPointBuilder).getHotness()) {
                    case 1: {
                        ++n;
                        continue block8;
                    }
                    case 3: {
                        ++n2;
                        continue block8;
                    }
                    case 2: {
                        ++n3;
                        continue block8;
                    }
                    case 4: {
                        ++n4;
                        continue block8;
                    }
                    case 5: {
                        ++n5;
                        continue block8;
                    }
                    case 0: {
                        ++n6;
                    }
                }
            }
            tableDataBuilder.addRow(new Object[]{"no-opt", n6});
            tableDataBuilder.addRow(new Object[]{"cold", n});
            tableDataBuilder.addRow(new Object[]{"hot", n2});
            tableDataBuilder.addRow(new Object[]{"warm", n3});
            tableDataBuilder.addRow(new Object[]{"very-hot", n4});
            tableDataBuilder.addRow(new Object[]{"scorching", n5});
            int n7 = n + n3 + n4 + n2 + n5 + n6;
            if (n7 > 0) {
                String string = MessageFormat.format(Messages.getString("jit.recommendations.jit.compilations"), n7, n6, n, n3, n2, n4, n5);
                structuredStringDataBuilder.addInformation(string);
            }
        }
    }
}

