/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.impl.marshalling;

import com.ibm.java.diagnostics.common.datamodel.data.Messages;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Logger;

public class DataManager {
    private HashMap<String, Queue<byte[]>> dataQueue = new HashMap();
    private long dataQueueSize = 0L;
    private long dataQueueMax = 0x6400000L;
    private long dataQueueCut = (long)(0.8 * (double)this.dataQueueMax);
    private static boolean cuttingData;
    private static final Logger TRACE;

    public DataManager() {
        cuttingData = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addData(String string, byte[] byArray) {
        HashMap<String, Queue<byte[]>> hashMap = this.dataQueue;
        synchronized (hashMap) {
            if (!cuttingData) {
                this.dataQueueSize += (long)byArray.length;
                if (this.dataQueueSize >= this.dataQueueMax) {
                    cuttingData = true;
                    TRACE.warning(MessageFormat.format(Messages.getString("DataManager.data.cutting.start"), string));
                } else {
                    Queue<byte[]> queue = this.dataQueue.get(string);
                    if (queue == null) {
                        queue = new ConcurrentLinkedQueue<byte[]>();
                        this.dataQueue.put(string, queue);
                    }
                    queue.add(byArray);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getData(String string) {
        byte[] byArray = null;
        HashMap<String, Queue<byte[]>> hashMap = this.dataQueue;
        synchronized (hashMap) {
            Queue<byte[]> queue = null;
            if (this.dataQueue.containsKey(string)) {
                queue = this.dataQueue.get(string);
                byArray = queue.poll();
                if (byArray != null) {
                    this.dataQueueSize -= (long)byArray.length;
                }
                if (cuttingData && this.dataQueueSize <= this.dataQueueCut) {
                    cuttingData = false;
                    TRACE.warning(MessageFormat.format(Messages.getString("DataManager.data.cutting.stop"), string));
                }
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearData() {
        HashMap<String, Queue<byte[]>> hashMap = this.dataQueue;
        synchronized (hashMap) {
            for (String string : this.dataQueue.keySet()) {
                if (!this.dataQueue.containsKey(string)) continue;
                Queue<byte[]> queue = this.dataQueue.get(string);
                int n = 0;
                for (int i = 0; i < queue.size(); ++i) {
                    n += queue.poll().length;
                }
                this.dataQueueSize -= (long)n;
            }
        }
    }

    static {
        TRACE = LogFactory.getTrace(DataManager.class);
    }
}

