/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.gc.parser.j9;

import com.ibm.java.diagnostics.common.datamodel.data.ControllableData;
import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.DataPointBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.StringData;
import com.ibm.java.diagnostics.common.datamodel.data.StringDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.factory.DataFactory;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.JVMLabels;
import com.ibm.java.diagnostics.healthcenter.environment.EnvironmentData;
import com.ibm.java.diagnostics.healthcenter.environment.labels.EnvironmentLabels;
import com.ibm.java.diagnostics.healthcenter.gc.GCDataImpl;
import com.ibm.java.diagnostics.healthcenter.gc.parser.constants.GCLabels;
import com.ibm.java.diagnostics.healthcenter.gc.parser.constants.GCReasons;
import com.ibm.java.diagnostics.healthcenter.gc.parser.constants.GCType;
import com.ibm.java.diagnostics.healthcenter.gc.parser.j9.GCModelUtil;
import com.ibm.java.diagnostics.healthcenter.gc.parser.j9.Messages;
import com.ibm.java.diagnostics.healthcenter.gc.parser.j9.ThreadState;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.MarshallerImpl;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.data.JVMDataImpl;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TraceAxisUtil;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TraceMetaData;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TracePoint;
import com.ibm.java.diagnostics.healthcenter.marshalling.data.events.BalancedInternalObject;
import com.ibm.java.diagnostics.healthcenter.marshalling.data.events.GCInternalObject;
import com.ibm.java.diagnostics.healthcenter.marshalling.data.events.GenconInternalObject;
import com.ibm.java.diagnostics.healthcenter.postprocessor.VMLevelChecker;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class J9MMTraceParser {
    private static final String ZERO = "0";
    private static final Pattern GCPOLICYMATCHER = Pattern.compile("-Xgcpolicy:(.*?)@@@");
    public static final String OPTTHRUPUT = "optthruput";
    public static final String OPTAVGPAUSE = "optavgpause";
    public static final String GENCON = "gencon";
    public static final String BALANCED = "balanced";
    public static final String REALTIME = "metronome";
    private static final String UNKNOWN = "unknown";
    private static final String DOT = ".";
    private static final String EMPTY_STRING = "";
    private static final Logger TRACE = LogFactory.getTrace(J9MMTraceParser.class);
    private static final DataFactory factory = DataFactory.getFactory();
    protected static final int JAVA6SR1_DATE = 20080401;
    protected GCModelUtil util = null;
    private boolean hasAfStartTrace = false;
    protected boolean isSystemGC = false;
    protected boolean isSynchGC = false;
    protected boolean isVMRealtime = false;
    private static final int UNSET = -1;
    private DataBuilder data;
    private long weakReferencesBefore = -1L;
    private long softReferencesBefore = -1L;
    private long phantomReferencesBefore = -1L;
    private long finalReferencesQueued = -1L;
    private long markTime = -1L;
    private long sweepTime = -1L;
    private long compactTime = -1L;
    private long localWeakReferencesCleared = 0L;
    private long localWeakReferencesQueued = -1L;
    private long localSoftReferencesQueued = -1L;
    private long localPhantomReferencesQueued = -1L;
    private long localFinalReferencesQueued = -1L;
    private long gmpIncrementCount = 0L;
    private boolean initialized = false;
    protected boolean isGencon = false;
    private static final String DATE_REG_EX = "\\d\\d\\d\\d[01]\\d[0123]\\d";
    private static final Pattern DATE_REG_EX_COMP = Pattern.compile("\\d\\d\\d\\d[01]\\d[0123]\\d");
    private int currentReason = GCReasons.AF_INT;
    HeapValueHolding concurrentHeapValueCache = null;
    HeapValueHolding sysGcHolding = null;
    private HeapValueHolding oldspaceHolding = null;

    public static boolean canParseThisVersion(String string) {
        if (string == null) {
            return true;
        }
        return string.contains("1.6.0") && J9MMTraceParser.getDate(string) >= 20080401;
    }

    public J9MMTraceParser(DataBuilder dataBuilder, OutputProperties outputProperties, TraceMetaData traceMetaData) {
        this.createJ9MMData(dataBuilder, outputProperties, traceMetaData);
    }

    private synchronized void createJ9MMData(DataBuilder dataBuilder, OutputProperties outputProperties, TraceMetaData traceMetaData) {
        if (!this.initialized) {
            Data data;
            Object object;
            this.initialized = true;
            if (traceMetaData.getVMVersion() != null) {
                object = new VMLevelChecker(traceMetaData.getVMVersion());
                data = (JVMDataImpl)dataBuilder.findRootData();
                if (((VMLevelChecker)object).isVMRealtime() || ((JVMDataImpl)data).isRealtimeVM() || ((JVMDataImpl)data).isSoftRealtimeVM()) {
                    this.isVMRealtime = true;
                } else {
                    String string;
                    Data data2;
                    DataBuilder dataBuilder2 = dataBuilder.getTopLevelData(EnvironmentLabels.ENVIRONMENT_LABEL);
                    if (dataBuilder2 instanceof EnvironmentData && (data2 = dataBuilder2.getData(EnvironmentLabels.COMMAND_LINE)) instanceof StringData && (string = ((StringData)data2).getValue()) != null) {
                        Matcher matcher = GCPOLICYMATCHER.matcher(string);
                        if (matcher.find()) {
                            String string2 = matcher.group(1);
                            if (string2.equals(GENCON)) {
                                // empty if block
                            }
                            this.isGencon = true;
                        } else {
                            String string3;
                            EnvironmentData environmentData = (EnvironmentData)((Object)dataBuilder2);
                            VMLevelChecker vMLevelChecker = environmentData.getVMLevelChecker();
                            if (vMLevelChecker != null && (string3 = vMLevelChecker.getVMVersion()).equals("2.6")) {
                                this.isGencon = true;
                            }
                        }
                    }
                }
            }
            this.data = dataBuilder.getTopLevelData(JVMLabels.GARBAGE_COLLECTION);
            if (!(this.data instanceof GCDataImpl)) {
                if (this.data != null) {
                    dataBuilder.removeData(JVMLabels.GARBAGE_COLLECTION);
                    if (TRACE.isLoggable(Level.FINE)) {
                        TRACE.fine("Internal error: Postprocessed data was not cleared properly - deleting existing data.");
                    }
                }
                this.data = new GCDataImpl();
                object = dataBuilder.getData("gc_subsystem");
                if (object instanceof ControllableData) {
                    data = (ControllableData)object;
                    this.data.setEnabled(data.isEnabled());
                }
                dataBuilder.addData(this.data);
            }
            this.util = new GCModelUtil(this.data, outputProperties, traceMetaData, dataBuilder);
        }
    }

    void handleConcurrentStart(ThreadState threadState, TracePoint tracePoint, TraceMetaData traceMetaData) {
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        this.isSystemGC = false;
        this.util.incrementSequenceNumber(threadState);
        Object[] objectArray = tracePoint.getParameters();
        if (objectArray == null) {
            return;
        }
        this.addBeforeLOAPoints(threadState, d, tracePoint, (Long)objectArray[4], (Long)objectArray[5]);
        this.concurrentHeapValueCache = new HeapValueHolding(d, (Long)objectArray[0], (Long)objectArray[1], (Long)objectArray[2], (Long)objectArray[3]);
        this.util.addNumberDataPoint(threadState, GCLabels.CARDS_CLEANED, d, (Long)objectArray[10]);
        this.currentReason = GCReasons.CON_INT;
    }

    void handleCompactStart(ThreadState threadState, TracePoint tracePoint) {
        Object[] objectArray = tracePoint.getParameters();
        if (objectArray == null) {
            return;
        }
        threadState.compactReasonString = (String)objectArray[0];
    }

    void handleCompactEnd(ThreadState threadState, TracePoint tracePoint, TraceMetaData traceMetaData) {
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        if (threadState.compactReasonString != EMPTY_STRING) {
            Object[] objectArray = tracePoint.getParameters();
            if (objectArray == null) {
                return;
            }
            long l = (Long)objectArray[0];
            this.util.addHeapDataPoint(threadState, GCLabels.AMOUNT_COMPACTED, d, l, threadState.compactReasonString);
        }
        threadState.compactReasonString = EMPTY_STRING;
    }

    void handleClassUnloadingStart(ThreadState threadState, TracePoint tracePoint) {
        threadState.classUnloadingStartTime = tracePoint;
    }

    void handleClassUnloadingEnd(ThreadState threadState, TracePoint tracePoint, TraceMetaData traceMetaData) {
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        Object[] objectArray = tracePoint.getParameters();
        if (objectArray == null) {
            return;
        }
        if (threadState.classUnloadingStartTime != null) {
            double d2 = d - TraceAxisUtil.getTimestampMS(threadState.classUnloadingStartTime, traceMetaData);
            this.util.addNativeTimeDataPoint(threadState, GCLabels.CLASSLOADER_UNLOADING_TIME, d, d2);
            this.util.addNativeTimeDataPoint(threadState, GCLabels.CLASS_UNLOADING_TIME, d, d2);
            threadState.classUnloadingStartTime = null;
        }
        this.util.addNumberDataPoint(threadState, GCLabels.CLASSES_UNLOADED, d, (Long)objectArray[1]);
        this.util.addNumberDataPoint(threadState, GCLabels.CLASSLOADERS_UNLOADED, d, (Long)objectArray[0]);
    }

    void handleExclusiveAccess(ThreadState threadState, TracePoint tracePoint, TraceMetaData traceMetaData) {
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        Object[] objectArray = tracePoint.getParameters();
        if (objectArray == null) {
            return;
        }
        double d2 = this.convertTwoLongsToDouble(objectArray, 0, 1, 3);
        this.util.addTimeDataPoint(threadState, GCLabels.EXCLUSIVE_ACCESS_TIMES, d, d2);
    }

    void startSystemGC(ThreadState threadState, TracePoint tracePoint, TraceMetaData traceMetaData) {
        this.util.incrementSequenceNumber(threadState);
        this.isSystemGC = true;
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        if (tracePoint.getID() == 131) {
            Object[] objectArray = tracePoint.getParameters();
            if (objectArray == null) {
                return;
            }
            this.sysGcHolding = new HeapValueHolding(d, (Long)objectArray[0], (Long)objectArray[1], (Long)objectArray[2], (Long)objectArray[3]);
            this.addBeforeLOAPoints(threadState, d, tracePoint, (Long)objectArray[4], (Long)objectArray[5]);
        }
        this.currentReason = GCReasons.SYS_INT;
    }

    void endSystemGC(ThreadState threadState, TracePoint tracePoint, TraceMetaData traceMetaData) {
        long l;
        Object[] objectArray;
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        if (this.sysGcHolding != null) {
            this.sysGcHolding.process(threadState, this.isGencon);
            this.sysGcHolding = null;
        }
        if ((objectArray = tracePoint.getParameters()) == null) {
            return;
        }
        if (this.isGencon) {
            this.util.addHeapDataPoint(threadState, GCLabels.FREE_TENURED_HEAP_AFTER_ALL_GCS, d, (Long)objectArray[2]);
            this.util.addHeapDataPoint(threadState, GCLabels.TENURED_SIZE_AFTER_ALL_GCS, d, (Long)objectArray[3]);
            l = (Long)objectArray[0];
            this.addAfterAllNurseryPoints(threadState, d, l);
        } else {
            this.util.addHeapDataPoint(threadState, GCLabels.FREE_FLAT_HEAP_AFTER_ALL_GCS, d, (Long)objectArray[2]);
            this.util.addHeapDataPoint(threadState, GCLabels.FLAT_HEAP_SIZE_AFTER_ALL_GCS, d, (Long)objectArray[3]);
        }
        l = (Long)objectArray[3] - (Long)objectArray[2];
        this.util.addHeapDataPoint(threadState, GCLabels.LIVE_FLAT_HEAP_AFTER_GC, d, l);
        threadState.flushStarts();
        threadState.collectionStarted = null;
        this.isSystemGC = false;
    }

    void startSynchGC(ThreadState threadState, TracePoint tracePoint, TraceMetaData traceMetaData) {
        Object[] objectArray = tracePoint.getParameters();
        if (objectArray == null) {
            return;
        }
        if (!this.isSynchGC) {
            this.util.incrementSequenceNumber(threadState);
        }
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        this.isSynchGC = true;
        long l = (Long)objectArray[0];
        switch ((int)l) {
            case 3: {
                this.currentReason = GCReasons.SYNCH_INT;
                break;
            }
            case 4: {
                this.currentReason = GCReasons.SYS_INT;
                break;
            }
        }
    }

    void endSynchGC(ThreadState threadState, TracePoint tracePoint) {
        this.isSynchGC = false;
    }

    void startConcurrentCollection(ThreadState threadState, TracePoint tracePoint, TraceMetaData traceMetaData) {
        Object[] objectArray = tracePoint.getParameters();
        if (objectArray == null) {
            return;
        }
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        this.isSystemGC = false;
        this.util.incrementSequenceNumber(threadState);
        this.util.addNumberDataPoint(threadState, GCLabels.CARDS_CLEANED, d, (Long)objectArray[12]);
        this.util.addNumberDataPoint(threadState, GCLabels.CARDS_TRACED, d, (Long)objectArray[9]);
        if (!this.isGencon) {
            this.util.addHeapDataPoint(threadState, GCLabels.FREE_FLAT_HEAP_BEFORE_GC, d, (Long)objectArray[4]);
        }
        this.currentReason = GCReasons.CON_INT;
    }

    void endConcurrentCollection(ThreadState threadState, TracePoint tracePoint, TraceMetaData traceMetaData) {
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        Object[] objectArray = tracePoint.getParameters();
        if (objectArray == null) {
            return;
        }
        if (this.concurrentHeapValueCache != null) {
            this.concurrentHeapValueCache.process(threadState, this.isGencon);
            this.concurrentHeapValueCache = null;
        }
        if (!this.isGencon) {
            this.util.addHeapDataPoint(threadState, GCLabels.FREE_FLAT_HEAP_AFTER_ALL_GCS, d, (Long)objectArray[2]);
        } else {
            this.addAfterAllNurseryPoints(threadState, d, (Long)objectArray[0]);
            this.util.addHeapDataPoint(threadState, GCLabels.FREE_TENURED_HEAP_AFTER_ALL_GCS, d, (Long)objectArray[2]);
        }
    }

    void handleAfStart(ThreadState threadState, TracePoint tracePoint, TraceMetaData traceMetaData) {
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        this.hasAfStartTrace = true;
        this.util.incrementSequenceNumber(threadState);
        Object[] objectArray = tracePoint.getParameters();
        if (objectArray == null) {
            return;
        }
        this.oldspaceHolding = new HeapValueHolding(d, (Long)objectArray[0], (Long)objectArray[1], (Long)objectArray[2], (Long)objectArray[3]);
        this.addBeforeLOAPoints(threadState, d, tracePoint, (Long)objectArray[4], (Long)objectArray[5]);
        long l = (Long)objectArray[6];
        this.util.addByteDataPoint(threadState, GCLabels.MINIMUM_REQUESTED_BYTES, d, l);
        this.currentReason = GCReasons.AF_INT;
    }

    void handleAfEnd(ThreadState threadState, TracePoint tracePoint, TraceMetaData traceMetaData) {
        long l;
        Object[] objectArray;
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        if (this.oldspaceHolding != null) {
            this.oldspaceHolding.process(threadState, this.isGencon);
            this.oldspaceHolding = null;
        }
        if ((objectArray = tracePoint.getParameters()) == null) {
            return;
        }
        if (this.isGencon) {
            this.util.addHeapDataPoint(threadState, GCLabels.FREE_TENURED_HEAP_AFTER_ALL_GCS, d, (Long)objectArray[2]);
            this.util.addHeapDataPoint(threadState, GCLabels.TENURED_SIZE_AFTER_ALL_GCS, d, (Long)objectArray[3]);
            l = (Long)objectArray[0];
            this.addAfterAllNurseryPoints(threadState, d, l);
        } else {
            this.util.addHeapDataPoint(threadState, GCLabels.FREE_FLAT_HEAP_AFTER_ALL_GCS, d, (Long)objectArray[2]);
            this.util.addHeapDataPoint(threadState, GCLabels.FLAT_HEAP_SIZE_AFTER_ALL_GCS, d, (Long)objectArray[3]);
        }
        l = (Long)objectArray[3] - (Long)objectArray[2];
        this.util.addHeapDataPoint(threadState, GCLabels.LIVE_FLAT_HEAP_AFTER_GC, d, l);
    }

    void handleReferenceCountAtStart(ThreadState threadState, TracePoint tracePoint, TraceMetaData traceMetaData) {
        this.parseReferenceInfo(threadState, tracePoint, 0, 1, 2, false, traceMetaData);
    }

    void handleReferenceCountAtEnd(ThreadState threadState, TracePoint tracePoint, TraceMetaData traceMetaData) {
        this.parseReferenceInfo(threadState, tracePoint, 0, 1, 2, true, traceMetaData);
    }

    void parseReferenceInfo(ThreadState threadState, TracePoint tracePoint, int n, int n2, int n3, boolean bl, TraceMetaData traceMetaData) {
        Object[] objectArray = tracePoint.getParameters();
        if (objectArray == null) {
            return;
        }
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        long l = (Long)objectArray[n];
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = null;
        long l2 = (Long)objectArray[n2];
        TwoDimensionalDataBuilder twoDimensionalDataBuilder2 = null;
        long l3 = (Long)objectArray[n3];
        TwoDimensionalDataBuilder twoDimensionalDataBuilder3 = null;
        if (bl) {
            this.util.addNumberDataPoint(threadState, GCLabels.WEAK_REFERENCES_AFTER, d, l);
            twoDimensionalDataBuilder = this.util.getNumberTwoDimensionalData(GCLabels.SOFT_REFERENCES_CLEARED);
            this.util.addNumberDataPoint(threadState, GCLabels.SOFT_REFERENCES_AFTER, d, l2);
            twoDimensionalDataBuilder2 = this.util.getNumberTwoDimensionalData(GCLabels.SOFT_REFERENCES_CLEARED);
            this.util.addNumberDataPoint(threadState, GCLabels.PHANTOM_REFERENCES_AFTER, d, l3);
            twoDimensionalDataBuilder3 = this.util.getNumberTwoDimensionalData(GCLabels.PHANTOM_REFERENCES_CLEARED);
        } else {
            this.util.addNumberDataPoint(threadState, GCLabels.WEAK_REFERENCES_BEFORE, d, l);
            this.util.addNumberDataPoint(threadState, GCLabels.SOFT_REFERENCES_BEFORE, d, l2);
            this.util.addNumberDataPoint(threadState, GCLabels.PHANTOM_REFERENCES_BEFORE, d, l3);
        }
        if (bl) {
            if (this.weakReferencesBefore != -1L && twoDimensionalDataBuilder != null) {
                this.util.addNumberDataPoint(threadState, GCLabels.WEAK_REFERENCES_CLEARED, d, this.weakReferencesBefore - l);
                this.weakReferencesBefore = -1L;
            }
            if (this.softReferencesBefore != -1L && twoDimensionalDataBuilder2 != null) {
                this.util.addNumberDataPoint(threadState, GCLabels.SOFT_REFERENCES_CLEARED, d, this.softReferencesBefore - l2);
                this.softReferencesBefore = -1L;
            }
            if (this.phantomReferencesBefore != -1L && twoDimensionalDataBuilder3 != null) {
                this.util.addNumberDataPoint(threadState, GCLabels.PHANTOM_REFERENCES_CLEARED, d, this.phantomReferencesBefore - l3);
                this.phantomReferencesBefore = -1L;
            }
        } else {
            this.weakReferencesBefore = l;
            this.softReferencesBefore = l2;
            this.phantomReferencesBefore = l3;
        }
    }

    void startGlobalCollection(ThreadState threadState, TracePoint tracePoint, int n, int n2, int n3, TraceMetaData traceMetaData) {
        Object[] objectArray = tracePoint.getParameters();
        if (objectArray == null) {
            return;
        }
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        threadState.flushStarts();
        threadState.collectionStarted = tracePoint;
        if (!(this.hasAfStartTrace || this.isSynchGC || this.isSystemGC)) {
            this.util.incrementSequenceNumber(threadState);
        }
        if (n >= 0) {
            this.util.addNumberDataPoint(threadState, GCLabels.FINAL_REFERENCES_QUEUED, d, (Long)objectArray[n]);
        }
        long l = (Long)objectArray[n2];
        this.util.addNumberDataPoint(threadState, GCLabels.GC_NUMBER_TUPLE, d, l);
        if (this.isVMRealtime && !this.isSynchGC && !this.isSystemGC) {
            this.currentReason = GCReasons.QUANTUM_INT;
        }
    }

    void endGlobalCollection(ThreadState threadState, TracePoint tracePoint, int n, int n2, int n3, int n4, int n5, int n6, int n7, TraceMetaData traceMetaData) {
        long l;
        long l2;
        long l3;
        this.checkSequenceNumber(threadState);
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        Object[] objectArray = tracePoint.getParameters();
        if (objectArray == null) {
            return;
        }
        long l4 = -1L;
        if (this.finalReferencesQueued != -1L && n >= 0) {
            l3 = (Long)objectArray[n];
            l2 = Math.max(this.finalReferencesQueued, this.localPhantomReferencesQueued);
            l4 = l2 - l3;
            this.util.addNumberDataPoint(threadState, GCLabels.FINAL_REFERENCES_CLEARED, d, l4);
            this.finalReferencesQueued = -1L;
        }
        l3 = (Long)objectArray[n4];
        l2 = (Long)objectArray[n5];
        long l5 = 0L;
        long l6 = 0L;
        if (this.isGencon) {
            this.util.addHeapDataPoint(threadState, GCLabels.FREE_TENURED_HEAP_AFTER_GC, d, l3);
            this.util.addHeapDataPoint(threadState, GCLabels.TENURED_SIZE, d, l2);
            l6 = (Long)objectArray[n2];
            l5 = (Long)objectArray[n3];
            this.addAfterNurseryPoints(threadState, d, l6, l5);
            this.util.addHeapDataPoint(threadState, GCLabels.FREE_FLAT_HEAP_AFTER_GC, d, l3 + l6);
            this.util.addHeapDataPoint(threadState, GCLabels.FLAT_HEAP_SIZE, d, l2 + l5);
            l = l2 - l3;
            this.util.addHeapDataPoint(threadState, GCLabels.LIVE_TENURED_HEAP_AFTER_GC, d, l);
        } else {
            this.util.addHeapDataPoint(threadState, GCLabels.FREE_FLAT_HEAP_AFTER_GC, d, l3);
            this.util.addHeapDataPoint(threadState, GCLabels.FLAT_HEAP_SIZE, d, l2);
            l = l2 - l3;
            this.util.addHeapDataPoint(threadState, GCLabels.LIVE_FLAT_HEAP_AFTER_GC, d, l);
        }
        l = -1L;
        long l7 = -1L;
        if (n6 != -1 && n7 != -2) {
            l = (Long)objectArray[n6];
            l7 = (Long)objectArray[n7];
            this.addAfterLOAPoints(threadState, d, tracePoint, l, l7);
        }
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.util.getNativeTimeTwoDimensionalData(GCLabels.PAUSE_TIMES_WITHOUT_EXCLUSIVE_ACCESS);
        double d2 = 0.0;
        if (threadState.collectionStarted != null) {
            d2 = d - TraceAxisUtil.getTimestampMS(threadState.collectionStarted, traceMetaData);
            this.util.addNativeTimeDataPoint(threadState, GCLabels.PAUSE_TIMES_WITHOUT_EXCLUSIVE_ACCESS, d, d2);
            threadState.flushStarts();
            threadState.collectionStarted = null;
        } else {
            this.handleLostData(d, twoDimensionalDataBuilder);
        }
        if (!this.isVMRealtime) {
            this.util.addScopeDataPoint(threadState, GCLabels.GC_TYPE_RECORD, d, GCType.GLOBAL_INT);
            this.util.addReasonDataPoint(threadState, GCLabels.GC_REASON_RECORD, d, this.currentReason);
            if (this.isGencon) {
                GenconInternalObject genconInternalObject = new GenconInternalObject(l2 + l5, l3 + l6, d2, (long)d);
                genconInternalObject.setReason(GCReasons.intToDisplayName(this.currentReason));
                genconInternalObject.setType(GCType.intToDisplayName(GCType.GLOBAL_INT));
                genconInternalObject.setFreeTenuredSize(l3);
                genconInternalObject.setTenuredSize(l2);
                genconInternalObject.setFreeNurserySize(l6);
                genconInternalObject.setNurserySize(l3);
                genconInternalObject.setFinalReferencesCleared(l4);
                genconInternalObject.setLoaSize(l7);
                genconInternalObject.setLoaFreeSize(l);
                genconInternalObject.setMarkTime(this.markTime);
                genconInternalObject.setSweepTime(this.sweepTime);
                genconInternalObject.setCompactTime(this.compactTime);
                genconInternalObject.setGCMode(GENCON);
                if (this.oldspaceHolding != null) {
                    genconInternalObject.setFreeTenuredSizeBeforeGC(this.oldspaceHolding.oldspaceFree);
                    genconInternalObject.setFreeNurserySizeBeforeGC(this.oldspaceHolding.newspaceFree);
                    genconInternalObject.setFreeHeapBeforeGC(this.oldspaceHolding.oldspaceFree + this.oldspaceHolding.newspaceFree);
                }
                MarshallerImpl.getMarshaller().getGCEventHandler().addEvent(genconInternalObject);
            } else {
                GCInternalObject gCInternalObject = new GCInternalObject(l2 + l5, l3 + l6, d2, (long)d);
                gCInternalObject.setReason(GCReasons.intToDisplayName(this.currentReason));
                gCInternalObject.setGCMode(this.calculateGCMode());
                gCInternalObject.setType(GCType.intToDisplayName(GCType.GLOBAL_INT));
                gCInternalObject.setFinalReferencesCleared(l4);
                gCInternalObject.setLoaSize(l7);
                gCInternalObject.setLoaFreeSize(l);
                gCInternalObject.setMarkTime(this.markTime);
                gCInternalObject.setSweepTime(this.sweepTime);
                gCInternalObject.setCompactTime(this.compactTime);
                if (this.oldspaceHolding != null) {
                    gCInternalObject.setFreeHeapBeforeGC(this.oldspaceHolding.oldspaceFree);
                }
                MarshallerImpl.getMarshaller().getGCEventHandler().addEvent(gCInternalObject);
            }
            this.markTime = -1L;
            this.sweepTime = -1L;
            this.compactTime = -1L;
        }
    }

    private String calculateGCMode() {
        EnvironmentData environmentData;
        VMLevelChecker vMLevelChecker;
        Data data = MarshallerImpl.getMarshaller().getData(null);
        EnvironmentData environmentData2 = ((JVMDataImpl)data).getEnvironmentData();
        String string = null;
        String string2 = null;
        String string3 = UNKNOWN;
        if (environmentData2 != null && (vMLevelChecker = (environmentData = environmentData2).getVMLevelChecker()) != null) {
            string = vMLevelChecker.getVMVersion();
            Data data2 = environmentData2.getData(EnvironmentLabels.COMMAND_LINE);
            if (data2 instanceof StringData) {
                string2 = ((StringData)data2).getValue();
            }
            if (string != null) {
                if (this.isVMRealtime) {
                    string3 = REALTIME;
                } else if (string2 != null) {
                    Matcher matcher = GCPOLICYMATCHER.matcher(string2);
                    if (matcher.find()) {
                        string3 = matcher.group(1);
                    } else if (string.equals("2.4") || string.equals("2.3")) {
                        string3 = OPTTHRUPUT;
                    } else if (string.equals("2.6") || string.equals("2.8")) {
                        string3 = GENCON;
                    }
                }
            }
        }
        return string3;
    }

    void endNewFormatGlobalCollection(ThreadState threadState, TracePoint tracePoint, int n, int n2, TraceMetaData traceMetaData) {
        this.checkSequenceNumber(threadState);
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        Object[] objectArray = tracePoint.getParameters();
        if (objectArray == null) {
            return;
        }
        long l = (Long)objectArray[n];
        long l2 = (Long)objectArray[n2];
        long l3 = l2 - l;
        this.util.addHeapDataPoint(threadState, GCLabels.FREE_FLAT_HEAP_AFTER_GC, d, l);
        this.util.addHeapDataPoint(threadState, GCLabels.FLAT_HEAP_SIZE, d, l2);
        this.util.addHeapDataPoint(threadState, GCLabels.LIVE_FLAT_HEAP_AFTER_GC, d, l3);
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.util.getNativeTimeTwoDimensionalData(GCLabels.PAUSE_TIMES_WITHOUT_EXCLUSIVE_ACCESS);
        double d2 = 0.0;
        if (threadState.collectionStarted != null) {
            d2 = d - TraceAxisUtil.getTimestampMS(threadState.collectionStarted, traceMetaData);
            this.util.addNativeTimeDataPoint(threadState, GCLabels.PAUSE_TIMES_WITHOUT_EXCLUSIVE_ACCESS, d, d2);
            threadState.flushStarts();
            threadState.collectionStarted = null;
        } else {
            this.handleLostData(d, twoDimensionalDataBuilder);
        }
        this.util.addScopeDataPoint(threadState, GCLabels.GC_TYPE_RECORD, d, GCType.GLOBAL_INT);
        this.util.addReasonDataPoint(threadState, GCLabels.GC_REASON_RECORD, d, this.currentReason);
        if (this.isGencon) {
            GenconInternalObject genconInternalObject = new GenconInternalObject(l2, l, d2, (long)d);
            genconInternalObject.setReason(GCReasons.intToDisplayName(this.currentReason));
            genconInternalObject.setGCMode(GENCON);
            genconInternalObject.setType(GCType.intToDisplayName(GCType.GLOBAL_INT));
            genconInternalObject.setMarkTime(this.markTime);
            genconInternalObject.setSweepTime(this.sweepTime);
            genconInternalObject.setCompactTime(this.compactTime);
            if (this.oldspaceHolding != null) {
                genconInternalObject.setFreeTenuredSizeBeforeGC(this.oldspaceHolding.oldspaceFree);
                genconInternalObject.setFreeNurserySizeBeforeGC(this.oldspaceHolding.newspaceFree);
                genconInternalObject.setFreeHeapBeforeGC(this.oldspaceHolding.oldspaceFree + this.oldspaceHolding.newspaceFree);
            }
            MarshallerImpl.getMarshaller().getGCEventHandler().addEvent(genconInternalObject);
        } else {
            GCInternalObject gCInternalObject = new GCInternalObject(l2, l, d2, (long)d);
            gCInternalObject.setReason(GCReasons.intToDisplayName(this.currentReason));
            gCInternalObject.setGCMode(this.calculateGCMode());
            gCInternalObject.setType(GCType.intToDisplayName(GCType.GLOBAL_INT));
            gCInternalObject.setMarkTime(this.markTime);
            gCInternalObject.setSweepTime(this.sweepTime);
            gCInternalObject.setCompactTime(this.compactTime);
            if (this.oldspaceHolding != null) {
                gCInternalObject.setFreeHeapBeforeGC(this.oldspaceHolding.oldspaceFree);
            }
            MarshallerImpl.getMarshaller().getGCEventHandler().addEvent(gCInternalObject);
        }
    }

    void addAfterNurseryPoints(ThreadState threadState, double d, long l, long l2) {
        this.util.addHeapDataPoint(threadState, GCLabels.FREE_NURSERY_HEAP_AFTER_GC, d, l);
        this.util.addHeapDataPoint(threadState, GCLabels.NURSERY_SIZE, d, l2);
        long l3 = l2 - l;
        this.util.addHeapDataPoint(threadState, GCLabels.LIVE_NURSERY_HEAP_AFTER_GC, d, l3);
    }

    void addAfterAllNurseryPoints(ThreadState threadState, double d, long l) {
        this.util.addHeapDataPoint(threadState, GCLabels.FREE_NURSERY_HEAP_AFTER_ALL_GCS, d, l);
    }

    void addAfterLOAPoints(ThreadState threadState, double d, TracePoint tracePoint, Long l, Long l2) {
        this.util.addHeapDataPoint(threadState, GCLabels.FREE_LOA_AFTER_GC, d, l);
        this.util.addHeapDataPoint(threadState, GCLabels.TOTAL_LOA, d, l2);
    }

    void addBeforeLOAPoints(ThreadState threadState, double d, TracePoint tracePoint, Long l, Long l2) {
        this.util.addHeapDataPoint(threadState, GCLabels.FREE_LOA_BEFORE_GC, d, l);
    }

    void completeGlobalCollection(ThreadState threadState, TracePoint tracePoint) {
    }

    void startLocalCollection(ThreadState threadState, TracePoint tracePoint, TraceMetaData traceMetaData) {
        Object[] objectArray = tracePoint.getParameters();
        if (objectArray == null) {
            return;
        }
        this.isGencon = true;
        threadState.localCollectionStarted = tracePoint;
        if (!this.hasAfStartTrace) {
            this.util.incrementSequenceNumber(threadState);
        }
        this.localWeakReferencesCleared += Math.max(0L, this.localWeakReferencesQueued - (Long)objectArray[2]);
        this.localWeakReferencesQueued = (Long)objectArray[2];
        this.localSoftReferencesQueued = Math.max(this.localSoftReferencesQueued, (Long)objectArray[3]);
        this.localPhantomReferencesQueued = Math.max(this.localPhantomReferencesQueued, (Long)objectArray[4]);
        this.localFinalReferencesQueued = Math.max(this.localFinalReferencesQueued, (Long)objectArray[5]);
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        long l = (Long)objectArray[0];
        this.util.addNumberDataPoint(threadState, GCLabels.GC_NUMBER_TUPLE, d, l);
    }

    void endLocalCollection(ThreadState threadState, TracePoint tracePoint, TraceMetaData traceMetaData) {
        this.checkSequenceNumber(threadState);
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        double d2 = 0.0;
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.util.getNativeTimeTwoDimensionalData(GCLabels.PAUSE_TIMES_WITHOUT_EXCLUSIVE_ACCESS);
        if (threadState.localCollectionStarted != null) {
            d2 = d - TraceAxisUtil.getTimestampMS(threadState.localCollectionStarted, traceMetaData);
            this.util.addNativeTimeDataPoint(threadState, GCLabels.PAUSE_TIMES_WITHOUT_EXCLUSIVE_ACCESS, d, d2);
            threadState.localCollectionStarted = null;
        } else {
            this.handleLostData(d, twoDimensionalDataBuilder);
        }
        Object[] objectArray = tracePoint.getParameters();
        if (objectArray == null) {
            return;
        }
        long l = (Long)objectArray[9];
        long l2 = (Long)objectArray[10];
        this.addAfterNurseryPoints(threadState, d, l, l2);
        long l3 = (Long)objectArray[11];
        long l4 = (Long)objectArray[12];
        this.util.addAfterTenuredInformation(threadState, d, l3, l4);
        this.util.addHeapDataPoint(threadState, GCLabels.FREE_FLAT_HEAP_AFTER_GC, d, l3 + l);
        this.util.addHeapDataPoint(threadState, GCLabels.FLAT_HEAP_SIZE, d, l4 + l2);
        this.addAfterLOAPoints(threadState, d, tracePoint, (Long)objectArray[13], (Long)objectArray[14]);
        long l5 = (Long)objectArray[7];
        double d3 = ((Long)objectArray[8]).longValue();
        this.util.addFlippedDataPoint(threadState, GCLabels.AMOUNT_FLIPPED, d, d3);
        this.util.addNumberDataPoint(threadState, GCLabels.OBJECTS_FLIPPED, d, l5);
        double d4 = ((Long)objectArray[15]).longValue();
        this.util.addAgeDataPoint(threadState, GCLabels.TENURE_AGE, d, d4);
        this.util.addScopeDataPoint(threadState, GCLabels.GC_TYPE_RECORD, d, GCType.NURSERY_INT);
        this.util.addReasonDataPoint(threadState, GCLabels.GC_REASON_RECORD, d, this.currentReason);
        GenconInternalObject genconInternalObject = new GenconInternalObject(l4 + l2, l3 + l, d2, (long)d);
        genconInternalObject.setReason(GCReasons.intToDisplayName(this.currentReason));
        genconInternalObject.setGCMode(GENCON);
        genconInternalObject.setType(GCType.intToDisplayName(GCType.NURSERY_INT));
        genconInternalObject.setFreeTenuredSize(l3);
        genconInternalObject.setTenuredSize(l4);
        genconInternalObject.setFreeNurserySize(l);
        genconInternalObject.setNurserySize(l3);
        genconInternalObject.setAmountFlipped((long)d3);
        genconInternalObject.setObjectsFlipped(l5);
        genconInternalObject.setTenureAge((long)d4);
        if (this.oldspaceHolding != null) {
            genconInternalObject.setFreeTenuredSizeBeforeGC(this.oldspaceHolding.oldspaceFree);
            genconInternalObject.setFreeNurserySizeBeforeGC(this.oldspaceHolding.newspaceFree);
            genconInternalObject.setFreeHeapBeforeGC(this.oldspaceHolding.oldspaceFree + this.oldspaceHolding.newspaceFree);
        }
        MarshallerImpl.getMarshaller().getGCEventHandler().addEvent(genconInternalObject);
    }

    void startMark(ThreadState threadState, TracePoint tracePoint) {
        threadState.flushStarts();
        threadState.markStarted = tracePoint;
    }

    void endMark(ThreadState threadState, TracePoint tracePoint, TraceMetaData traceMetaData) {
        this.checkSequenceNumber(threadState);
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.util.getNativeTimeTwoDimensionalData(GCLabels.MARK_TIMES);
        if (threadState.markStarted != null) {
            double d2 = d - TraceAxisUtil.getTimestampMS(threadState.markStarted, traceMetaData);
            this.util.addNativeTimeDataPoint(threadState, GCLabels.MARK_TIMES, d, d2);
            threadState.flushStarts();
        } else {
            this.handleLostData(d, twoDimensionalDataBuilder);
        }
    }

    void endSweep(ThreadState threadState, TracePoint tracePoint, TraceMetaData traceMetaData) {
        this.checkSequenceNumber(threadState);
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.util.getNativeTimeTwoDimensionalData(GCLabels.SWEEP_TIMES);
        if (threadState.sweepStarted != null) {
            double d2 = d - TraceAxisUtil.getTimestampMS(threadState.sweepStarted, traceMetaData);
            this.util.addNativeTimeDataPoint(threadState, GCLabels.SWEEP_TIMES, d, d2);
            threadState.flushStarts();
        } else {
            this.handleLostData(d, twoDimensionalDataBuilder);
        }
    }

    void startCompact(ThreadState threadState, TracePoint tracePoint) {
        threadState.flushStarts();
        threadState.compactStarted = tracePoint;
    }

    void endCompact(ThreadState threadState, TracePoint tracePoint, TraceMetaData traceMetaData) {
        this.checkSequenceNumber(threadState);
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.util.getNativeTimeTwoDimensionalData(GCLabels.COMPACT_TIMES);
        if (threadState.compactStarted != null) {
            double d2 = d - TraceAxisUtil.getTimestampMS(threadState.compactStarted, traceMetaData);
            this.util.addNativeTimeDataPoint(threadState, GCLabels.COMPACT_TIMES, d, d2);
            threadState.flushStarts();
        } else {
            this.handleLostData(d, twoDimensionalDataBuilder);
        }
    }

    void handleConcurrentKickoff(ThreadState threadState, TracePoint tracePoint, TraceMetaData traceMetaData) {
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        Object[] objectArray = tracePoint.getParameters();
        if (objectArray == null) {
            return;
        }
        this.util.addHeapDataPoint(threadState, GCLabels.INTENDED_KICKOFF, d, (Long)objectArray[1]);
    }

    private synchronized void handleLostData(double d, TwoDimensionalDataBuilder twoDimensionalDataBuilder) {
        DataPointBuilder dataPointBuilder = twoDimensionalDataBuilder.getAxisPair().createDataPointBuilder(0, d, 0.0, null);
        String string = dataPointBuilder.formatXWithUnits();
        String string2 = MessageFormat.format(Messages.getString("J9MMTraceParser.lost.data"), twoDimensionalDataBuilder.getLabel(), string);
        TRACE.fine(string2);
        String string3 = Messages.getString("J9MMTraceParser.lost.data.label");
        StringDataBuilder stringDataBuilder = factory.createStringData(string3);
        stringDataBuilder.addValue(string2);
        this.data.addData(stringDataBuilder);
    }

    void startSweep(ThreadState threadState, TracePoint tracePoint) {
        threadState.flushStarts();
        threadState.sweepStarted = tracePoint;
    }

    private double convertTwoLongsToDouble(Object[] objectArray, int n, int n2, int n3) {
        String string = objectArray[0].toString();
        String string2 = objectArray[1].toString();
        while (string2.length() < n3) {
            string2 = ZERO + string2;
        }
        Double d = new Double(string + DOT + string2);
        return d;
    }

    protected static int getDate(String string) {
        Matcher matcher = DATE_REG_EX_COMP.matcher(string);
        if (matcher.find()) {
            return new Integer(matcher.group(0));
        }
        return -1;
    }

    private void checkSequenceNumber(ThreadState threadState) {
        if (threadState.sequenceUID < 0) {
            this.util.incrementSequenceNumber(threadState);
        }
    }

    public void setEnabled(boolean bl) {
        if (this.util != null) {
            this.util.setEnabled(bl);
        }
    }

    public void handleSetAllocationThreshold(ThreadState threadState, TracePoint tracePoint) {
        Object[] objectArray = this.getTracepointParameters(tracePoint, 4);
        if (objectArray == null) {
            return;
        }
        Long l = (Long)objectArray[0];
        Long l2 = (Long)objectArray[1];
        this.util.addAllocationThresholdSettings(threadState, l, l2, true);
    }

    public void handleAllocationThreshold(ThreadState threadState, TracePoint tracePoint, TraceMetaData traceMetaData) {
        Object[] objectArray = this.getTracepointParameters(tracePoint, 3);
        if (objectArray == null) {
            return;
        }
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        Long l = (Long)objectArray[0];
        Long l2 = (Long)objectArray[1];
        Long l3 = (Long)objectArray[2];
        this.util.addLargeAllocationDataPoint(threadState, GCLabels.OBJECT_ALLOCATION_THRESHOLD, d, l, l2, l3);
        this.util.addAllocationThresholdSettings(threadState, l2, l3, false);
    }

    public void handleOutOfLineAllocation(ThreadState threadState, TracePoint tracePoint, TraceMetaData traceMetaData) {
        Object[] objectArray = this.getTracepointParameters(tracePoint, 3);
        if (objectArray == null) {
            return;
        }
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        Long l = (Long)objectArray[0];
        String string = (String)objectArray[1];
        Long l2 = (Long)objectArray[2];
        this.util.addOutOfLineAllocationDataPoint(threadState, d, l2, l, string);
    }

    void handlePGCStart(ThreadState threadState, TracePoint tracePoint, TraceMetaData traceMetaData) {
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        this.util.incrementSequenceNumber(threadState);
        threadState.pgcCollectionStarted = tracePoint;
        Object[] objectArray = tracePoint.getParameters();
        if (objectArray == null) {
            return;
        }
        long l = (Long)objectArray[0];
        this.util.addNumberDataPoint(threadState, GCLabels.GC_NUMBER_TUPLE, d, l);
        this.currentReason = GCReasons.BALANCE_INT;
    }

    void handlePGCEnd(ThreadState threadState, TracePoint tracePoint, TraceMetaData traceMetaData) {
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        Object[] objectArray = tracePoint.getParameters();
        if (objectArray == null) {
            return;
        }
        long l = (Long)objectArray[2];
        long l2 = (Long)objectArray[3];
        this.util.addHeapDataPoint(threadState, GCLabels.FREE_FLAT_HEAP_AFTER_ALL_GCS, d, l);
        this.util.addHeapDataPoint(threadState, GCLabels.FLAT_HEAP_SIZE, d, l2);
        long l3 = l2 - l;
        this.util.addHeapDataPoint(threadState, GCLabels.LIVE_FLAT_HEAP_AFTER_GC, d, l3);
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.util.getNativeTimeTwoDimensionalData(GCLabels.PAUSE_TIMES_WITHOUT_EXCLUSIVE_ACCESS);
        double d2 = 0.0;
        if (threadState.pgcCollectionStarted != null) {
            d2 = d - TraceAxisUtil.getTimestampMS(threadState.pgcCollectionStarted, traceMetaData);
            this.util.addNativeTimeDataPoint(threadState, GCLabels.PAUSE_TIMES_WITHOUT_EXCLUSIVE_ACCESS, d, d2);
            this.util.addNativeTimeDataPoint(threadState, GCLabels.PGC_CYCLE_TIME, d, d2);
            threadState.flushStarts();
            threadState.pgcCollectionStarted = null;
        } else {
            this.handleLostData(d, twoDimensionalDataBuilder);
        }
        this.util.addScopeDataPoint(threadState, GCLabels.GC_TYPE_RECORD, d, GCType.PGC_INT);
        this.util.addReasonDataPoint(threadState, GCLabels.GC_REASON_RECORD, d, this.currentReason);
        BalancedInternalObject balancedInternalObject = new BalancedInternalObject(l2, l, d2, (long)d);
        balancedInternalObject.setReason(GCReasons.intToDisplayName(this.currentReason));
        balancedInternalObject.setGCMode(BALANCED);
        balancedInternalObject.setType(GCType.intToDisplayName(GCType.PGC_INT));
        balancedInternalObject.setPgcCycleTime(d);
        if (this.oldspaceHolding != null) {
            balancedInternalObject.setFreeHeapBeforeGC(this.oldspaceHolding.oldspaceFree);
        }
        MarshallerImpl.getMarshaller().getGCEventHandler().addEvent(balancedInternalObject);
    }

    void handleGMPCycleStart(ThreadState threadState, TracePoint tracePoint) {
        threadState.gmpCycleStarted = tracePoint;
    }

    void handleGMPCycleEnd(ThreadState threadState, TracePoint tracePoint, TraceMetaData traceMetaData) {
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        if (threadState.gmpCycleStarted != null) {
            this.util.addNumberDataPoint(threadState, GCLabels.GMP_COLLECTIONS, d, this.gmpIncrementCount);
            this.gmpIncrementCount = 0L;
            threadState.gmpCycleStarted = null;
        }
    }

    void handleGMPIncrementStart(ThreadState threadState, TracePoint tracePoint, TraceMetaData traceMetaData) {
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        ++this.gmpIncrementCount;
        this.util.incrementSequenceNumber(threadState);
        threadState.gmpCollectionStarted = tracePoint;
        Object[] objectArray = tracePoint.getParameters();
        if (objectArray == null) {
            return;
        }
        long l = (Long)objectArray[0];
        this.util.addNumberDataPoint(threadState, GCLabels.GC_NUMBER_TUPLE, d, l);
        this.currentReason = GCReasons.BALANCE_INT;
    }

    void handleGMPIncrementEnd(ThreadState threadState, TracePoint tracePoint, TraceMetaData traceMetaData) {
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        Object[] objectArray = tracePoint.getParameters();
        if (objectArray == null) {
            return;
        }
        long l = (Long)objectArray[2];
        long l2 = (Long)objectArray[3];
        this.util.addHeapDataPoint(threadState, GCLabels.FREE_FLAT_HEAP_AFTER_ALL_GCS, d, l);
        this.util.addHeapDataPoint(threadState, GCLabels.FLAT_HEAP_SIZE, d, l2);
        long l3 = l2 - l;
        this.util.addHeapDataPoint(threadState, GCLabels.LIVE_FLAT_HEAP_AFTER_GC, d, l3);
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.util.getNativeTimeTwoDimensionalData(GCLabels.PAUSE_TIMES_WITHOUT_EXCLUSIVE_ACCESS);
        double d2 = 0.0;
        if (threadState.gmpCollectionStarted != null) {
            d2 = d - TraceAxisUtil.getTimestampMS(threadState.gmpCollectionStarted, traceMetaData);
            this.util.addNativeTimeDataPoint(threadState, GCLabels.PAUSE_TIMES_WITHOUT_EXCLUSIVE_ACCESS, d, d2);
            this.util.addNativeTimeDataPoint(threadState, GCLabels.GMP_INCREMENTAL_TIME, d, d2);
            threadState.flushStarts();
            threadState.gmpCollectionStarted = null;
        } else {
            this.handleLostData(d, twoDimensionalDataBuilder);
        }
        this.util.addScopeDataPoint(threadState, GCLabels.GC_TYPE_RECORD, d, GCType.GMP_INT);
        this.util.addReasonDataPoint(threadState, GCLabels.GC_REASON_RECORD, d, this.currentReason);
        BalancedInternalObject balancedInternalObject = new BalancedInternalObject(l2, l, d2, (long)d);
        balancedInternalObject.setReason(GCReasons.intToDisplayName(this.currentReason));
        balancedInternalObject.setGCMode(BALANCED);
        balancedInternalObject.setType(GCType.intToDisplayName(GCType.GMP_INT));
        if (this.oldspaceHolding != null) {
            balancedInternalObject.setFreeHeapBeforeGC(this.oldspaceHolding.oldspaceFree);
        }
        balancedInternalObject.setGmpIncrementalTime(d);
        MarshallerImpl.getMarshaller().getGCEventHandler().addEvent(balancedInternalObject);
    }

    private Object[] getTracepointParameters(TracePoint tracePoint, int n) {
        Object[] objectArray = tracePoint.getParameters();
        if (objectArray == null) {
            return null;
        }
        int n2 = objectArray.length;
        if (n2 != n) {
            TRACE.log(Level.WARNING, Messages.getString("J9MMTraceParser.check.parameters"), new Object[]{tracePoint.getID(), tracePoint.getComponent(), n2, n});
            return null;
        }
        return objectArray;
    }

    private class HeapValueHolding {
        double timestamp = 0.0;
        Long newspaceFree = null;
        Long newspaceTotal = null;
        Long oldspaceFree = null;

        HeapValueHolding(double d, Long l, Long l2, Long l3, Long l4) {
            this.timestamp = d;
            this.newspaceFree = l;
            this.newspaceTotal = l2;
            this.oldspaceFree = l3;
        }

        void process(ThreadState threadState, boolean bl) {
            if (bl) {
                if (this.newspaceTotal > 0L) {
                    J9MMTraceParser.this.util.addHeapDataPoint(threadState, GCLabels.FREE_NURSERY_HEAP_BEFORE_GC, this.timestamp, this.newspaceFree);
                }
                J9MMTraceParser.this.util.addHeapDataPoint(threadState, GCLabels.FREE_TENURED_HEAP_BEFORE_GC, this.timestamp, this.oldspaceFree);
                J9MMTraceParser.this.util.addHeapDataPoint(threadState, GCLabels.FREE_FLAT_HEAP_BEFORE_GC, this.timestamp, this.newspaceFree + this.oldspaceFree);
            } else {
                J9MMTraceParser.this.util.addHeapDataPoint(threadState, GCLabels.FREE_FLAT_HEAP_BEFORE_GC, this.timestamp, this.oldspaceFree);
            }
        }
    }
}

