/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.event.postprocessor;

import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.StructuredStringDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.SubsystemDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TableDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.NumberFormatter;
import com.ibm.java.diagnostics.common.datamodel.impl.data.StructuredStringDataImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.data.TableDataImpl;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.extensions.postprocessing.PostProcessor;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.JVMLabels;
import com.ibm.java.diagnostics.healthcenter.event.Messages;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.MarshallerImpl;
import com.ibm.java.diagnostics.healthcenter.postprocessor.PostProcessorBase;
import java.text.MessageFormat;
import java.util.logging.Logger;

public class EventsSummarisingPostProcessor
extends PostProcessorBase
implements PostProcessor {
    private static final Logger TRACE = LogFactory.getTrace(EventsSummarisingPostProcessor.class);
    private static final String CLASS_NAME = EventsSummarisingPostProcessor.class.getName();
    private static final String EMPTY_STRING = "";
    private static final String SPACE = " ";

    @Override
    public void postprocess(DataBuilder dataBuilder, OutputProperties outputProperties) {
        TRACE.entering(CLASS_NAME, "postprocess");
        if (MarshallerImpl.getMarshaller().isEventOnlyMode()) {
            return;
        }
        SubsystemDataBuilder subsystemDataBuilder = (SubsystemDataBuilder)dataBuilder.getTopLevelData(JVMLabels.EVENTS);
        if (subsystemDataBuilder != null) {
            subsystemDataBuilder.clearValue();
            subsystemDataBuilder.removeData("Recommendations");
            StructuredStringDataImpl structuredStringDataImpl = new StructuredStringDataImpl("Recommendations");
            TableDataImpl tableDataImpl = new TableDataImpl("HTTP Summary", new String[]{EMPTY_STRING, EMPTY_STRING});
            this.calculateEventProperties("http", dataBuilder, tableDataImpl, structuredStringDataImpl);
            if (tableDataImpl.size() > 0) {
                subsystemDataBuilder.addData(tableDataImpl);
            }
            TableDataImpl tableDataImpl2 = new TableDataImpl("MQLight Summary", new String[]{EMPTY_STRING, EMPTY_STRING});
            this.calculateEventProperties("mqlight", dataBuilder, tableDataImpl2, structuredStringDataImpl);
            if (tableDataImpl2.size() > 0) {
                subsystemDataBuilder.addData(tableDataImpl2);
            }
            TableDataImpl tableDataImpl3 = new TableDataImpl("MongoDB Summary", new String[]{EMPTY_STRING, EMPTY_STRING});
            this.calculateEventProperties("mongo", dataBuilder, tableDataImpl3, structuredStringDataImpl);
            if (tableDataImpl3.size() > 0) {
                subsystemDataBuilder.addData(tableDataImpl3);
            }
            TableDataImpl tableDataImpl4 = new TableDataImpl("MySQL Summary", new String[]{EMPTY_STRING, EMPTY_STRING});
            this.calculateEventProperties("mysql", dataBuilder, tableDataImpl4, structuredStringDataImpl);
            if (tableDataImpl4.size() > 0) {
                subsystemDataBuilder.addData(tableDataImpl4);
            }
            this.setHighLevelMessage(subsystemDataBuilder, structuredStringDataImpl);
            subsystemDataBuilder.addData(structuredStringDataImpl);
        }
        TRACE.exiting(CLASS_NAME, "postprocess");
    }

    private void calculateEventProperties(String string, Data data, TableDataBuilder tableDataBuilder, StructuredStringDataBuilder structuredStringDataBuilder) {
        TwoDimensionalDataBuilder twoDimensionalDataBuilder;
        Data data2 = data.getData(string);
        if (data2 instanceof TwoDimensionalDataBuilder && !(twoDimensionalDataBuilder = (TwoDimensionalDataBuilder)data2).isEmpty()) {
            String string2 = twoDimensionalDataBuilder.getYAxis().getUnits();
            String string3 = NumberFormatter.prettyString(twoDimensionalDataBuilder.getMaxY().getY()) + SPACE + string2;
            String string4 = NumberFormatter.prettyString(twoDimensionalDataBuilder.getMeanY()) + SPACE + string2;
            int n = twoDimensionalDataBuilder.getDataPoints().length;
            tableDataBuilder.addRow(new Object[]{Messages.getString("EventSummarisingPostProcessor.average.duration"), string4});
            tableDataBuilder.addRow(new Object[]{Messages.getString("EventSummarisingPostProcessor.maximum.duration"), string3});
            tableDataBuilder.addRow(new Object[]{Messages.getString("EventSummarisingPostProcessor.number.of.events"), n});
            String string5 = MessageFormat.format(Messages.getString("EventSummarisingPostProcessor.information.message"), string, string4, string3);
            String string6 = MessageFormat.format(Messages.getString("EventSummarisingPostProcessor.number.message"), n, string);
            structuredStringDataBuilder.addInformation(string5);
            structuredStringDataBuilder.addInformation(string6);
        }
    }
}

