/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.api.locking.impl;

import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.healthcenter.JVMLabels;
import com.ibm.java.diagnostics.healthcenter.api.impl.HealthCenterDataImpl;
import com.ibm.java.diagnostics.healthcenter.api.locking.LockingData;
import com.ibm.java.diagnostics.healthcenter.api.locking.LockingEventListener;
import com.ibm.java.diagnostics.healthcenter.api.locking.MonitorData;
import com.ibm.java.diagnostics.healthcenter.api.locking.impl.LockingInternalEventListener;
import com.ibm.java.diagnostics.healthcenter.api.locking.impl.MonitorDataImpl;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.MarshallerImpl;
import com.ibm.java.diagnostics.healthcenter.locking.LockingLabels;
import com.ibm.java.diagnostics.healthcenter.locking.LockingTableRow;
import com.ibm.java.diagnostics.healthcenter.locking.data.MonitorTableData;
import com.ibm.java.diagnostics.healthcenter.marshalling.data.events.LockingEventHandler;
import java.util.Date;
import java.util.List;
import javax.management.Notification;

public class LockingDataImpl
extends HealthCenterDataImpl
implements LockingData {
    private Notification javaMonitorNotify;
    private Notification systemMonitorNotify;
    private LockingInternalEventListener internalLocking = new LockingInternalEventListener();

    public LockingDataImpl(Data data) {
        super(data);
        LockingEventHandler lockingEventHandler = MarshallerImpl.getMarshaller().getLockingEventHandler();
        if (!lockingEventHandler.isAlive()) {
            lockingEventHandler.start();
        }
        lockingEventHandler.addLockingEventListener(this.internalLocking);
    }

    @Override
    protected String getRecommendationLabel() {
        return LockingLabels.RECOMMENDATION_LABEL;
    }

    @Override
    protected String getSubsystemLabel() {
        return JVMLabels.LOCKING;
    }

    @Override
    public MonitorData[] getInflatedJavaMonitors() {
        return this.getMonitors(LockingLabels.JAVA_MONITORS_LABEL);
    }

    @Override
    public MonitorData[] getInflatedSystemMonitors() {
        return this.getMonitors(LockingLabels.SYSTEM_MONITORS_LABEL);
    }

    private MonitorData[] getMonitors(String string) {
        MonitorTableData monitorTableData;
        MonitorData[] monitorDataArray = new MonitorData[]{};
        Data data = this.getJvmData().getTopLevelData(JVMLabels.LOCKING);
        if (data != null && (monitorTableData = (MonitorTableData)data.getData(string)) != null) {
            double d = monitorTableData.getXAxis().getX();
            LockingTableRow[] lockingTableRowArray = monitorTableData.getContents();
            monitorDataArray = new MonitorData[lockingTableRowArray.length];
            int n = 0;
            for (LockingTableRow lockingTableRow : lockingTableRowArray) {
                monitorDataArray[n] = new MonitorDataImpl(d, lockingTableRow.getPercentMissed(), lockingTableRow.getGetCount(), lockingTableRow.getSlowCount(), lockingTableRow.getNonRecursiveAttemptCount(), lockingTableRow.getPercentUtilisation(), (long)lockingTableRow.getAverageHoldTime(), lockingTableRow.getMonitorName());
                ++n;
            }
        }
        return monitorDataArray;
    }

    @Override
    public void startNotifying() {
        this.startNotifying(this.DEFAULT_NOTIFICATION);
    }

    @Override
    public void startNotifying(long l) {
        new Updater(l).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLockingListener(LockingEventListener lockingEventListener) {
        List<LockingEventListener> list = this.internalLocking.getListeners();
        synchronized (list) {
            this.internalLocking.getListeners().add(lockingEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLockingListener(LockingEventListener lockingEventListener) {
        List<LockingEventListener> list = this.internalLocking.getListeners();
        synchronized (list) {
            this.internalLocking.getListeners().remove(lockingEventListener);
        }
    }

    static /* synthetic */ long access$000(LockingDataImpl lockingDataImpl) {
        return lockingDataImpl.DEFAULT_NOTIFICATION;
    }

    private class Updater
    extends Thread {
        private Date javaMonitorTime;
        private Date systemMonitorTime;
        long count = 0L;
        long delay = LockingDataImpl.access$000(LockingDataImpl.this);

        public Updater(long l) {
            if (l >= LockingDataImpl.this.DEFAULT_NOTIFICATION) {
                this.delay = l;
            }
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.javaMonitorTime = new Date();
                        this.systemMonitorTime = new Date();
                        if (LockingDataImpl.this.getInflatedJavaMonitors() != null && LockingDataImpl.this.getInflatedJavaMonitors().length > 0 && LockingDataImpl.this.getInflatedJavaMonitors()[LockingDataImpl.this.getInflatedJavaMonitors().length - 1].getTime() != this.javaMonitorTime.getTime()) {
                            LockingDataImpl.this.javaMonitorNotify = new Notification(null, LockingDataImpl.this, this.count++);
                            LockingDataImpl.this.javaMonitorNotify.setUserData("com.ibm.java.diagnostics.healthcenter.api.threads.JavaMonitorData");
                            LockingDataImpl.this.sendNotification(LockingDataImpl.this.javaMonitorNotify);
                        }
                        if (LockingDataImpl.this.getInflatedSystemMonitors() != null && LockingDataImpl.this.getInflatedSystemMonitors().length > 0 && LockingDataImpl.this.getInflatedSystemMonitors()[LockingDataImpl.this.getInflatedSystemMonitors().length - 1].getTime() != this.systemMonitorTime.getTime()) {
                            LockingDataImpl.this.systemMonitorNotify = new Notification(null, LockingDataImpl.this, this.count++);
                            LockingDataImpl.this.systemMonitorNotify.setUserData("com.ibm.java.diagnostics.healthcenter.api.threads.SystemMonitorData");
                            LockingDataImpl.this.sendNotification(LockingDataImpl.this.systemMonitorNotify);
                        }
                        Thread.sleep(this.delay);
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread thread = Thread.currentThread();
                    thread.getUncaughtExceptionHandler().uncaughtException(thread, interruptedException);
                    continue;
                }
                break;
            }
        }
    }
}

