/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.common.util.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class EntryAndExitFormatter
extends Formatter {
    private static final String EXIT_ARROW = " < ";
    private static final String MS = " ms";
    private static final String ENTRY_ARROW = " > ";
    private static final String PLUS = " + ";
    private static final String SPACE = " ";
    private static final String TAB = "     ";
    private static final String CLOSE_BRACKET = "] ";
    private static final String OPEN_BRACKET = " [";
    private static final String FOUND_EXCEPTION = "Found exception: ";
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String EXIT = "RETURN";
    private static final String ENTRY = "ENTRY";
    private static final int deltaLength = 12;
    private final long[] timingStack = new long[100];
    private int timingIndex = 0;

    @Override
    public String format(LogRecord logRecord) {
        long l;
        StringBuffer stringBuffer = new StringBuffer();
        String string = logRecord.getMessage();
        if (ENTRY.equals(string)) {
            int n;
            this.timingIndex = (this.timingIndex + 1) % this.timingStack.length;
            this.timingStack[this.timingIndex] = l = logRecord.getMillis();
            this.appendDate(stringBuffer, l);
            for (n = 0; n < this.timingIndex; ++n) {
                stringBuffer.append(TAB);
            }
            for (n = 0; n < 12; ++n) {
                stringBuffer.append(SPACE);
            }
            stringBuffer.append(ENTRY_ARROW);
            this.appendMethod(logRecord, stringBuffer);
        } else if (EXIT.equals(string)) {
            l = logRecord.getMillis();
            this.appendDate(stringBuffer, l);
            for (int i = 0; i < this.timingIndex; ++i) {
                stringBuffer.append(TAB);
            }
            stringBuffer.append(PLUS);
            long l2 = l - this.timingStack[this.timingIndex];
            String string2 = new Double(l2).toString();
            stringBuffer.append(string2);
            stringBuffer.append(MS);
            for (int i = string2.length() + 6; i < 12; ++i) {
                stringBuffer.append(SPACE);
            }
            stringBuffer.append(EXIT_ARROW);
            this.appendMethod(logRecord, stringBuffer);
            this.timingIndex = (this.timingIndex - 1) % this.timingStack.length;
        } else {
            l = logRecord.getMillis();
            this.appendDate(stringBuffer, l);
            stringBuffer.append(TAB);
            stringBuffer.append(logRecord.getLevel());
            stringBuffer.append(TAB);
            stringBuffer.append(string);
        }
        for (Throwable throwable = logRecord.getThrown(); throwable != null; throwable = throwable.getCause()) {
            stringBuffer.append(FOUND_EXCEPTION);
            stringBuffer.append(throwable.getMessage());
            stringBuffer.append(NEWLINE);
            stringBuffer.append(this.getStackTraceAsString(throwable));
        }
        stringBuffer.append(NEWLINE);
        return stringBuffer.toString();
    }

    private void appendDate(StringBuffer stringBuffer, long l) {
        stringBuffer.append(OPEN_BRACKET);
        stringBuffer.append(new Date(l));
        stringBuffer.append(CLOSE_BRACKET);
    }

    private void appendMethod(LogRecord logRecord, StringBuffer stringBuffer) {
        stringBuffer.append(logRecord.getSourceClassName());
        stringBuffer.append(".");
        stringBuffer.append(logRecord.getSourceMethodName());
        stringBuffer.append("()");
    }

    private String getStackTraceAsString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter((Writer)stringWriter, true));
        return stringWriter.toString();
    }
}

