/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.common.datamodel.data;

import com.ibm.java.diagnostics.common.datamodel.data.Messages;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;

public class Status
implements Comparable<Status> {
    private static final String EMPTY_STRING = "";
    private static final String STATUS_STRING_TEMPLATE = Messages.getString("Status.tostring.template");
    private static final String ECLIPSE_PROBLEM_GIF = "platform:/plugin/org.eclipse.ui/icons/full/obj16/error_tsk.gif";
    private static final String ECLIPSE_WARN_GIF = "platform:/plugin/org.eclipse.ui/icons/full/obj16/warn_tsk.gif";
    private static final String ECLIPSE_GOOD_GIF = "platform:/plugin/com.ibm.java.diagnostics.healthcenter.coredisplayers/icons/checkedout.gif";
    private static final String BLANK_GIF = "platform:/plugin/com.ibm.java.diagnostics.healthcenter.coredisplayers/icons/blank.gif";
    private static final String ECLIPSE_INFO_GIF = "platform:/plugin/com.ibm.java.diagnostics.healthcenter.coredisplayers/icons/info_obj.gif";
    private static final String ECLIPSE_QUESTION_GIF = "platform:/plugin/org.eclipse.help.ui/icons/etool16/help.gif";
    public static final Status PROBLEM = new Status(Messages.getString("Status.problem"), "platform:/plugin/org.eclipse.ui/icons/full/obj16/error_tsk.gif", Messages.getString("Status.problem.help"), 5);
    public static final Status WARNING = new Status(Messages.getString("Status.warning"), "platform:/plugin/org.eclipse.ui/icons/full/obj16/warn_tsk.gif", Messages.getString("Status.warning.help"), 4);
    public static final Status INFORMATION = new Status(Messages.getString("Status.information"), "platform:/plugin/com.ibm.java.diagnostics.healthcenter.coredisplayers/icons/info_obj.gif", Messages.getString("Status.information.help"), 3);
    public static final Status HEALTHY = new Status(Messages.getString("Status.healthy"), "platform:/plugin/com.ibm.java.diagnostics.healthcenter.coredisplayers/icons/checkedout.gif", Messages.getString("Status.healthy.help"), 2);
    public static final Status UNKNOWN = new Status(Messages.getString("Status.unknown.help"), "platform:/plugin/org.eclipse.help.ui/icons/etool16/help.gif", Messages.getString("Status.unknown.help"), 1);
    public static final Status BLANK = new Status("", "platform:/plugin/com.ibm.java.diagnostics.healthcenter.coredisplayers/icons/blank.gif", "", 0);
    private final String label;
    private URL icon;
    private final String help;
    private final int intValue;

    private Status(String string, String string2, String string3, int n) {
        this.label = string;
        this.help = string3;
        this.intValue = n;
        if (string2 != null) {
            URL uRL = null;
            try {
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (uRL != null) {
                try {
                    this.icon = uRL;
                }
                catch (Throwable throwable) {
                    this.icon = null;
                }
            } else {
                this.icon = null;
            }
        } else {
            this.icon = null;
        }
    }

    public URL getIcon() {
        return this.icon;
    }

    public String getLabel() {
        return this.label;
    }

    public String getHelp() {
        return this.help;
    }

    public String toString() {
        return MessageFormat.format(STATUS_STRING_TEMPLATE, this.getLabel());
    }

    @Override
    public int compareTo(Status status) {
        if (this.intValue == status.intValue) {
            return 0;
        }
        if (this.intValue < status.intValue) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Status) {
            Status status = (Status)object;
            return this.intValue == status.intValue;
        }
        return false;
    }

    public int hashCode() {
        return this.intValue;
    }
}

