/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.plus.provider;

import com.ibm.crypto.plus.provider.DHParameters;
import com.ibm.crypto.plus.provider.IBMJCEPlusProvider;
import com.ibm.crypto.plus.provider.icc.DHKey;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyRep;
import java.security.PrivateKey;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.crypto.spec.DHParameterSpec;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;

final class DHPrivateKey
extends PrivateKeyInfo
implements PrivateKey,
Serializable,
javax.crypto.interfaces.DHPrivateKey,
Destroyable {
    private static final long serialVersionUID = -9137894705065174379L;
    private static final BigInteger PKCS8_VERSION;
    private IBMJCEPlusProvider provider = null;
    private BigInteger x = null;
    private DHParameters dhParams = null;
    private byte[] key = null;
    private byte[] encodedKey = null;
    private int[] DH_data = new int[]{1, 2, 840, 113549, 1, 3, 1};
    private transient boolean destroyed = false;
    private transient DHKey dhKey = null;
    private static final String[] z;

    public DHPrivateKey(IBMJCEPlusProvider iBMJCEPlusProvider, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) throws InvalidKeyException {
        this(iBMJCEPlusProvider, bigInteger, bigInteger2, bigInteger3, 0);
    }

    public DHPrivateKey(IBMJCEPlusProvider iBMJCEPlusProvider, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n2) throws InvalidKeyException {
        this.provider = iBMJCEPlusProvider;
        this.x = bigInteger;
        this.dhParams = new DHParameters(iBMJCEPlusProvider);
        try {
            this.dhParams.engineInit(new DHParameterSpec(bigInteger2, bigInteger3, n2));
            this.key = new DerValue(2, this.x.toByteArray()).toByteArray();
            this.encodedKey = this.getEncoded();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[11]);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidKeyException(z[12]);
        }
    }

    public DHPrivateKey(IBMJCEPlusProvider iBMJCEPlusProvider, BigInteger bigInteger, DHParameters dHParameters) throws InvalidKeyException {
        this.provider = iBMJCEPlusProvider;
        this.x = bigInteger;
        this.dhParams = dHParameters;
        try {
            this.key = new DerValue(2, this.x.toByteArray()).toByteArray();
            this.encodedKey = this.getEncoded();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[0]);
        }
    }

    public DHPrivateKey(IBMJCEPlusProvider iBMJCEPlusProvider, DHKey dHKey) {
        try {
            this.provider = iBMJCEPlusProvider;
            this.algid = new AlgorithmId(AlgorithmId.DH_oid, dHKey.getParameters());
            this.a(dHKey.getPrivateKeyBytes());
            this.dhKey = dHKey;
        }
        catch (Exception exception) {
            throw iBMJCEPlusProvider.a(z[14], (Throwable)exception);
        }
    }

    public DHPrivateKey(IBMJCEPlusProvider iBMJCEPlusProvider, byte[] byArray) throws InvalidKeyException {
        this.provider = iBMJCEPlusProvider;
        try {
            this.a(byArray);
            byte[] byArray2 = this.a();
            this.dhKey = DHKey.createPrivateKey(iBMJCEPlusProvider.a(), byArray);
        }
        catch (Exception exception) {
            throw new InvalidKeyException(z[13]);
        }
    }

    private byte[] a(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            DerValue derValue = new DerValue((InputStream)byteArrayInputStream);
            if (derValue.getTag() != 48) {
                throw new IOException(z[8]);
            }
            BigInteger bigInteger = derValue.getData().getInteger();
            if (!bigInteger.equals(PKCS8_VERSION)) {
                throw new IOException(z[3] + PKCS8_VERSION + z[4] + bigInteger);
            }
            DerValue derValue2 = derValue.getData().getDerValue();
            if (derValue2.getTag() != 48) {
                throw new IOException(z[2]);
            }
            DerInputStream derInputStream = derValue2.toDerInputStream();
            ObjectIdentifier objectIdentifier = derInputStream.getOID();
            if (derInputStream.available() == 0) {
                throw new IOException(z[5]);
            }
            DerValue derValue3 = derInputStream.getDerValue();
            if (derValue3.getTag() == 5) {
                throw new IOException(z[9]);
            }
            if (derValue3.getTag() != 48) {
                throw new IOException(z[6]);
            }
            derValue3.getData().reset();
            BigInteger bigInteger2 = derValue3.getData().getInteger();
            BigInteger bigInteger3 = derValue3.getData().getInteger();
            int n2 = -1;
            if (derValue3.getData().available() != 0) {
                n2 = derValue3.getData().getInteger().intValue();
            }
            if (derValue3.getData().available() != 0) {
                throw new IOException(z[10]);
            }
            DHParameters dHParameters = this.dhParams = new DHParameters(this.provider);
            DHParameterSpec dHParameterSpec = n2 == -1 ? new DHParameterSpec(bigInteger2, bigInteger3) : new DHParameterSpec(bigInteger2, bigInteger3, n2);
            dHParameters.engineInit(dHParameterSpec);
            this.key = derValue.getData().getOctetString();
            this.parseKeyBits();
            this.encodedKey = (byte[])byArray.clone();
            DerValue derValue4 = new DerValue(2, this.key);
            return derValue4.toByteArray();
        }
        catch (IOException | NumberFormatException exception) {
            throw new IOException(z[1], exception);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new IOException(z[7], invalidParameterSpecException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] a() throws IOException {
        BigInteger bigInteger = this.dhParams.b().modPow(this.x, this.dhParams.a());
        DerValue[] derValueArray = new DerValue[]{new DerValue(2, BigInteger.ZERO.toByteArray()), new DerValue(2, this.dhParams.a().toByteArray()), new DerValue(2, this.dhParams.b().toByteArray()), new DerValue(2, bigInteger.toByteArray()), new DerValue(2, this.x.toByteArray())};
        DerOutputStream derOutputStream = new DerOutputStream();
        try {
            derOutputStream.putSequence(derValueArray);
            byte[] byArray = derOutputStream.toByteArray();
            return byArray;
        }
        finally {
            this.a(derOutputStream);
        }
    }

    protected void parseKeyBits() throws IOException {
        DerInputStream derInputStream = new DerInputStream(this.key);
        try {
            this.x = derInputStream.getInteger();
        }
        catch (IOException iOException) {
            throw new IOException(z[15], iOException);
        }
    }

    @Override
    public String getAlgorithm() {
        this.b();
        return z[18];
    }

    @Override
    public String getFormat() {
        this.b();
        return super.getFormat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getEncoded() {
        DerOutputStream derOutputStream = null;
        DerOutputStream derOutputStream2 = null;
        this.b();
        if (this.encodedKey == null) {
            try {
                DerOutputStream derOutputStream3 = new DerOutputStream();
                derOutputStream3.putInteger(PKCS8_VERSION);
                DerOutputStream derOutputStream4 = new DerOutputStream();
                derOutputStream4.putOID(new ObjectIdentifier(this.DH_data));
                derOutputStream2 = new DerOutputStream();
                derOutputStream2.putInteger(this.dhParams.a());
                derOutputStream2.putInteger(this.dhParams.b());
                if (this.dhParams.c() != 0) {
                    derOutputStream2.putInteger(BigInteger.valueOf(this.dhParams.c()));
                }
                DerValue derValue = new DerValue(48, derOutputStream2.toByteArray());
                derOutputStream4.putDerValue(derValue);
                derOutputStream3.write((byte)48, derOutputStream4);
                derOutputStream3.putOctetString(this.key);
                derOutputStream = new DerOutputStream();
                derOutputStream.write((byte)48, derOutputStream3);
                this.encodedKey = derOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                byte[] byArray = null;
                return byArray;
            }
            finally {
                try {
                    derOutputStream.close();
                }
                catch (IOException iOException) {}
                try {
                    derOutputStream2.close();
                }
                catch (IOException iOException) {}
            }
        }
        return (byte[])this.encodedKey.clone();
    }

    @Override
    public DHParameterSpec getParams() {
        this.b();
        try {
            return this.dhParams.engineGetParameterSpec(DHParameterSpec.class);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw this.provider.a(z[16], (Throwable)invalidParameterSpecException);
        }
    }

    @Override
    public BigInteger getX() {
        this.b();
        return this.x;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void destroy() throws DestroyFailedException {
        if (!this.destroyed) {
            this.destroyed = true;
            if (this.key != null) {
                Arrays.fill(this.key, (byte)0);
            }
            this.dhKey = null;
            this.x = null;
            this.dhParams = null;
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    private void b() {
        if (this.destroyed) {
            throw new IllegalStateException(z[17]);
        }
    }

    private Object writeReplace() throws ObjectStreamException {
        this.b();
        return new KeyRep(KeyRep.Type.PRIVATE, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    DHKey c() {
        return this.dhKey;
    }

    private void a(DerOutputStream derOutputStream) {
        try {
            derOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.x, this.dhParams.a(), this.dhParams.b()};
        return Arrays.hashCode(objectArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof javax.crypto.interfaces.DHPrivateKey)) {
            return false;
        }
        javax.crypto.interfaces.DHPrivateKey dHPrivateKey = (javax.crypto.interfaces.DHPrivateKey)object;
        DHParameterSpec dHParameterSpec = dHPrivateKey.getParams();
        if (this.x.compareTo(dHPrivateKey.getX()) != 0) return false;
        if (this.dhParams.a().compareTo(dHParameterSpec.getP()) != 0) return false;
        if (this.dhParams.b().compareTo(dHParameterSpec.getG()) != 0) return false;
        if (object instanceof DHPrivateKey) {
            return true;
        }
        if (this.hashCode() != object.hashCode()) return false;
        return true;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[19];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "7\u0004\u0007um\u0000E\u0019im\u0010\u0010\n~\"56'53T\u0000\u0007xm\u0010\f\u0007|";
        int n3 = -1;
        block26: while (true) {
            char[] cArray;
            block30: {
                int n4;
                int n5;
                block29: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block29;
                    n5 = n5;
                    if (n5 <= n4) break block30;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 116;
                            break;
                        }
                        case 1: {
                            n6 = 101;
                            break;
                        }
                        case 2: {
                            n6 = 105;
                            break;
                        }
                        case 3: {
                            n6 = 27;
                            break;
                        }
                        default: {
                            n6 = 2;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "1\u0017\u001btpT\u0015\biq\u001d\u000b\u000e;i\u0011\u001cI~l\u0017\n\rrl\u0013";
                    n3 = 0;
                    continue block26;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "5\t\u000eRfT\f\u001a;l\u001b\u0011Iz\"' 8NG:&,";
                    n3 = 1;
                    continue block26;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\u0002\u0000\u001bhk\u001b\u000bIvk\u0007\b\boa\u001c_I3q\u0001\u0015\u0019tp\u0000\u0000\r!\"";
                    n3 = 2;
                    continue block26;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "XE\u0019zp\u0007\u0000\r!\"";
                    n3 = 3;
                    continue block26;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "$\u0004\u001bzo\u0011\u0011\fiqT\b\u0000hq\u001d\u000b\u000e";
                    n3 = 4;
                    continue block26;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "$\u0004\u001bzo\u0011\u0011\fiqT\u000b\u0006o\"\u0015E:^S! 'XG";
                    n3 = 5;
                    continue block26;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "1\u0017\u001btpT\u0006\u001b~c\u0000\f\u0007|\"0-9zp\u0015\b\fog\u0006\u0016";
                    n3 = 6;
                    continue block26;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "?\u0000\u0010;l\u001b\u0011Iz\"' 8NG:&,";
                    n3 = 7;
                    continue block26;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = ":\u0010\u0005w\"\u0004\u0004\u001bzo\u0011\u0011\fiq";
                    n3 = 8;
                    continue block26;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "1\u001d\u001dicT\u0015\bic\u0019\u0000\u001d~pT\u0001\boc";
                    n3 = 9;
                    continue block26;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "7\u0004\u0007um\u0000E\u0019im\u0010\u0010\n~\"56'53T\u0000\u0007xm\u0010\f\u0007|";
                    n3 = 10;
                    continue block26;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "7\u0004\u0007um\u0000E\u0000uk\u0000\f\bwk\u000e\u0000Ikc\u0006\u0004\u0004~v\u0011\u0017\u001a";
                    n3 = 11;
                    continue block26;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "2\u0004\u0000ww\u0006\u0000IrlT!!Kp\u001d\u0013\bog?\u0000\u0010";
                    n3 = 12;
                    continue block26;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "2\u0004\u0000ww\u0006\u0000IrlT!!Kp\u001d\u0013\bog?\u0000\u0010";
                    n3 = 13;
                    continue block26;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "=\u000b\u001fzn\u001d\u0001I_JT\u0015\u001brt\u0015\u0011\f;i\u0011\u001c";
                    n3 = 14;
                    continue block26;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "2\u0004\u0000ww\u0006\u0000IrlT!!Kp\u001d\u0013\bog?\u0000\u0010";
                    n3 = 15;
                    continue block26;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = " \r\u0000h\"\u001f\u0000\u0010;k\u0007E\u0007t\"\u0018\n\u0007|g\u0006E\u001fzn\u001d\u0001";
                    n3 = 16;
                    continue block26;
                }
                case 16: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 18;
                    string2 = "0-";
                    n3 = 17;
                    continue block26;
                }
                case 17: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        PKCS8_VERSION = BigInteger.valueOf(0L);
    }
}

