/*
 * Decompiled with CFR 0.152.
 */
package sun.util.resources;

import java.security.AccessController;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import sun.security.action.GetPropertyAction;
import sun.util.ResourceBundleEnumeration;

public abstract class OpenListResourceBundle
extends ResourceBundle {
    private volatile Map<String, Object> lookup = null;
    private volatile Set<String> keyset;

    protected OpenListResourceBundle() {
    }

    @Override
    protected Object handleGetObject(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.loadLookupTablesIfNecessary();
        return this.lookup.get(string);
    }

    @Override
    public Enumeration<String> getKeys() {
        ResourceBundle resourceBundle = this.parent;
        return new ResourceBundleEnumeration(this.handleKeySet(), resourceBundle != null ? resourceBundle.getKeys() : null);
    }

    @Override
    protected Set<String> handleKeySet() {
        this.loadLookupTablesIfNecessary();
        return this.lookup.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> keySet() {
        if (this.keyset != null) {
            return this.keyset;
        }
        Set<String> set = this.createSet();
        set.addAll(this.handleKeySet());
        if (this.parent != null) {
            set.addAll(this.parent.keySet());
        }
        OpenListResourceBundle openListResourceBundle = this;
        synchronized (openListResourceBundle) {
            if (this.keyset == null) {
                this.keyset = set;
            }
        }
        return this.keyset;
    }

    protected abstract Object[][] getContents();

    void loadLookupTablesIfNecessary() {
        if (this.lookup == null) {
            this.loadLookup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLookup() {
        Object[][] objectArray = this.getContents();
        Map<String, String[]> map = this.createMap(objectArray.length);
        Boolean bl = Boolean.parseBoolean(AccessController.doPrivileged(new GetPropertyAction("ibm.legacyTimezone")));
        for (int i = 0; i < objectArray.length; ++i) {
            String string = (String)objectArray[i][0];
            String[] stringArray = objectArray[i][1];
            if (string == null || stringArray == null) {
                throw new NullPointerException();
            }
            if (bl.booleanValue() && (string.equalsIgnoreCase("Europe/Istanbul") || string.equalsIgnoreCase("Asia/Istanbul") || string.equalsIgnoreCase("Turkey"))) {
                stringArray = new String[]{"Eastern European Time", "EET", "Eastern European Summer Time", "EEST", "Eastern European Time", "EET"};
            }
            map.put(string, stringArray);
        }
        OpenListResourceBundle openListResourceBundle = this;
        synchronized (openListResourceBundle) {
            if (this.lookup == null) {
                this.lookup = map;
            }
        }
    }

    protected <K, V> Map<K, V> createMap(int n) {
        return new HashMap(n);
    }

    protected <E> Set<E> createSet() {
        return new HashSet();
    }
}

