/*
 * Decompiled with CFR 0.152.
 */
package sun.security.timestamp;

import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Date;

public class TimestampToken {
    private int version;
    private ObjectIdentifier policy;
    private BigInteger serialNumber;
    private AlgorithmId hashAlgorithm;
    private byte[] hashedMessage;
    private Date genTime;
    private BigInteger nonce;

    public TimestampToken(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IOException("No timestamp token info");
        }
        this.parse(byArray);
    }

    public Date getDate() {
        return this.genTime;
    }

    public AlgorithmId getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public byte[] getHashedMessage() {
        return this.hashedMessage;
    }

    public BigInteger getNonce() {
        return this.nonce;
    }

    public String getPolicyID() {
        return this.policy.toString();
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    private void parse(byte[] byArray) throws IOException {
        DerValue derValue = new DerValue(byArray);
        if (derValue.getTag() != 48) {
            throw new IOException("Bad encoding for timestamp token info");
        }
        this.version = derValue.getData().getInteger().intValue();
        this.policy = derValue.getData().getOID();
        DerValue derValue2 = derValue.getData().getDerValue();
        this.hashAlgorithm = AlgorithmId.parse((DerValue)derValue2.getData().getDerValue());
        this.hashedMessage = derValue2.getData().getOctetString();
        this.serialNumber = derValue.getData().getBigInteger();
        this.genTime = derValue.getData().getGeneralizedTime();
        while (derValue.getData().available() > 0) {
            DerValue derValue3 = derValue.getData().getDerValue();
            if (derValue3.getTag() != 2) continue;
            this.nonce = derValue3.getBigInteger();
            break;
        }
    }
}

