/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketOption;
import java.net.SocketTimeoutException;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.IllegalBlockingModeException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import sun.nio.ch.ChannelInputStream;
import sun.nio.ch.ExtendedSocketOption;
import sun.nio.ch.Net;
import sun.nio.ch.RDMASocketChannelImpl;

class RDMASocketAdaptor
extends Socket {
    private final RDMASocketChannelImpl rsc;
    private volatile int timeout = 0;
    private InputStream socketInputStream = null;

    private RDMASocketAdaptor(RDMASocketChannelImpl rDMASocketChannelImpl) throws SocketException {
        super((SocketImpl)null);
        this.rsc = rDMASocketChannelImpl;
    }

    public static Socket create(RDMASocketChannelImpl rDMASocketChannelImpl) {
        try {
            return new RDMASocketAdaptor(rDMASocketChannelImpl);
        }
        catch (SocketException socketException) {
            throw new InternalError("Should not reach here");
        }
    }

    @Override
    public RDMASocketChannelImpl getChannel() {
        return this.rsc;
    }

    @Override
    public void connect(SocketAddress socketAddress) throws IOException {
        this.connect(socketAddress, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(SocketAddress socketAddress, int n) throws IOException {
        if (socketAddress == null) {
            throw new IllegalArgumentException("connect: The address can't be null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("connect: timeout can't be negative");
        }
        Object object = this.rsc.blockingLock();
        synchronized (object) {
            block19: {
                if (!this.rsc.isBlocking()) {
                    throw new IllegalBlockingModeException();
                }
                try {
                    if (n == 0) {
                        this.rsc.connect(socketAddress);
                        return;
                    }
                    this.rsc.configureBlocking(false);
                    try {
                        long l;
                        if (this.rsc.connect(socketAddress)) {
                            return;
                        }
                        long l2 = n;
                        do {
                            if (!this.rsc.isOpen()) {
                                throw new ClosedChannelException();
                            }
                            l = System.currentTimeMillis();
                            int n2 = this.rsc.poll(Net.POLLCONN, l2);
                            if (n2 <= 0 || !this.rsc.finishConnect()) continue;
                            break block19;
                        } while ((l2 -= System.currentTimeMillis() - l) > 0L);
                        try {
                            this.rsc.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        throw new SocketTimeoutException();
                    }
                    finally {
                        if (this.rsc.isOpen()) {
                            this.rsc.configureBlocking(true);
                        }
                    }
                }
                catch (Exception exception) {
                    Net.translateException(exception, true);
                }
            }
        }
    }

    @Override
    public void bind(SocketAddress socketAddress) throws IOException {
        try {
            this.rsc.bind(socketAddress);
        }
        catch (Exception exception) {
            Net.translateException(exception);
        }
    }

    @Override
    public InetAddress getInetAddress() {
        SocketAddress socketAddress = this.rsc.remoteAddress();
        if (socketAddress == null) {
            return null;
        }
        return ((InetSocketAddress)socketAddress).getAddress();
    }

    @Override
    public InetAddress getLocalAddress() {
        InetSocketAddress inetSocketAddress;
        if (this.rsc.isOpen() && (inetSocketAddress = this.rsc.localAddress()) != null) {
            return Net.getRevealedLocalAddress(inetSocketAddress).getAddress();
        }
        return new InetSocketAddress(0).getAddress();
    }

    @Override
    public int getPort() {
        SocketAddress socketAddress = this.rsc.remoteAddress();
        if (socketAddress == null) {
            return 0;
        }
        return ((InetSocketAddress)socketAddress).getPort();
    }

    @Override
    public int getLocalPort() {
        InetSocketAddress inetSocketAddress = this.rsc.localAddress();
        if (inetSocketAddress == null) {
            return -1;
        }
        return inetSocketAddress.getPort();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (!this.rsc.isOpen()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.rsc.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (!this.rsc.isInputOpen()) {
            throw new SocketException("Socket input is shutdown");
        }
        if (this.socketInputStream == null) {
            try {
                this.socketInputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                    @Override
                    public InputStream run() throws IOException {
                        return new SocketInputStreamLocal();
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (IOException)privilegedActionException.getException();
            }
        }
        return this.socketInputStream;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (!this.rsc.isOpen()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.rsc.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (!this.rsc.isOutputOpen()) {
            throw new SocketException("Socket output is shutdown");
        }
        OutputStream outputStream = null;
        try {
            outputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<OutputStream>(){

                @Override
                public OutputStream run() throws IOException {
                    return Channels.newOutputStream(RDMASocketAdaptor.this.rsc);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
        return outputStream;
    }

    private void setBooleanOption(SocketOption<Boolean> socketOption, boolean bl) throws SocketException {
        try {
            this.rsc.setOption((SocketOption)socketOption, (Object)bl);
        }
        catch (IOException iOException) {
            Net.translateToSocketException(iOException);
        }
    }

    private void setIntOption(SocketOption<Integer> socketOption, int n) throws SocketException {
        try {
            this.rsc.setOption((SocketOption)socketOption, (Object)n);
        }
        catch (IOException iOException) {
            Net.translateToSocketException(iOException);
        }
    }

    private boolean getBooleanOption(SocketOption<Boolean> socketOption) throws SocketException {
        try {
            return this.rsc.getOption(socketOption);
        }
        catch (IOException iOException) {
            Net.translateToSocketException(iOException);
            return false;
        }
    }

    private int getIntOption(SocketOption<Integer> socketOption) throws SocketException {
        try {
            return this.rsc.getOption(socketOption);
        }
        catch (IOException iOException) {
            Net.translateToSocketException(iOException);
            return -1;
        }
    }

    @Override
    public void setTcpNoDelay(boolean bl) throws SocketException {
        this.setBooleanOption(StandardSocketOptions.TCP_NODELAY, bl);
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return this.getBooleanOption(StandardSocketOptions.TCP_NODELAY);
    }

    @Override
    public void setSoLinger(boolean bl, int n) throws SocketException {
        if (!bl) {
            n = -1;
        }
        this.setIntOption(StandardSocketOptions.SO_LINGER, n);
    }

    @Override
    public int getSoLinger() throws SocketException {
        return this.getIntOption(StandardSocketOptions.SO_LINGER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendUrgentData(int n) throws IOException {
        Object object = this.rsc.blockingLock();
        synchronized (object) {
            if (!this.rsc.isBlocking()) {
                throw new IllegalBlockingModeException();
            }
            int n2 = this.rsc.sendOutOfBandData((byte)n);
            assert (n2 == 1);
        }
    }

    @Override
    public void setOOBInline(boolean bl) throws SocketException {
        this.setBooleanOption(ExtendedSocketOption.SO_OOBINLINE, bl);
    }

    @Override
    public boolean getOOBInline() throws SocketException {
        return this.getBooleanOption(ExtendedSocketOption.SO_OOBINLINE);
    }

    @Override
    public void setSoTimeout(int n) throws SocketException {
        if (n < 0) {
            throw new IllegalArgumentException("timeout can't be negative");
        }
        this.timeout = n;
    }

    @Override
    public int getSoTimeout() throws SocketException {
        return this.timeout;
    }

    @Override
    public void setSendBufferSize(int n) throws SocketException {
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid send size");
        }
        this.setIntOption(StandardSocketOptions.SO_SNDBUF, n);
    }

    @Override
    public int getSendBufferSize() throws SocketException {
        return this.getIntOption(StandardSocketOptions.SO_SNDBUF);
    }

    @Override
    public void setReceiveBufferSize(int n) throws SocketException {
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid receive size");
        }
        this.setIntOption(StandardSocketOptions.SO_RCVBUF, n);
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        return this.getIntOption(StandardSocketOptions.SO_RCVBUF);
    }

    @Override
    public void setKeepAlive(boolean bl) throws SocketException {
        this.setBooleanOption(StandardSocketOptions.SO_KEEPALIVE, bl);
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        return this.getBooleanOption(StandardSocketOptions.SO_KEEPALIVE);
    }

    @Override
    public void setTrafficClass(int n) throws SocketException {
        this.setIntOption(StandardSocketOptions.IP_TOS, n);
    }

    @Override
    public int getTrafficClass() throws SocketException {
        return this.getIntOption(StandardSocketOptions.IP_TOS);
    }

    @Override
    public void setReuseAddress(boolean bl) throws SocketException {
        this.setBooleanOption(StandardSocketOptions.SO_REUSEADDR, bl);
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this.getBooleanOption(StandardSocketOptions.SO_REUSEADDR);
    }

    @Override
    public void close() throws IOException {
        this.rsc.close();
    }

    @Override
    public void shutdownInput() throws IOException {
        try {
            this.rsc.shutdownInput();
        }
        catch (Exception exception) {
            Net.translateException(exception);
        }
    }

    @Override
    public void shutdownOutput() throws IOException {
        try {
            this.rsc.shutdownOutput();
        }
        catch (Exception exception) {
            Net.translateException(exception);
        }
    }

    @Override
    public String toString() {
        if (this.rsc.isConnected()) {
            return "RDMASocket[addr=" + this.getInetAddress() + ",port=" + this.getPort() + ",localport=" + this.getLocalPort() + "]";
        }
        return "RDMASocket[unconnected]";
    }

    @Override
    public boolean isConnected() {
        return this.rsc.isConnected();
    }

    @Override
    public boolean isBound() {
        return this.rsc.localAddress() != null;
    }

    @Override
    public boolean isClosed() {
        return !this.rsc.isOpen();
    }

    @Override
    public boolean isInputShutdown() {
        return !this.rsc.isInputOpen();
    }

    @Override
    public boolean isOutputShutdown() {
        return !this.rsc.isOutputOpen();
    }

    private class SocketInputStreamLocal
    extends ChannelInputStream {
        private SocketInputStreamLocal() {
            super(RDMASocketAdaptor.this.rsc);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected int read(ByteBuffer byteBuffer) throws IOException {
            Object object = RDMASocketAdaptor.this.rsc.blockingLock();
            synchronized (object) {
                if (!RDMASocketAdaptor.this.rsc.isBlocking()) {
                    throw new IllegalBlockingModeException();
                }
                if (RDMASocketAdaptor.this.timeout == 0) {
                    return RDMASocketAdaptor.this.rsc.read(byteBuffer);
                }
                RDMASocketAdaptor.this.rsc.configureBlocking(false);
                try {
                    long l;
                    int n = RDMASocketAdaptor.this.rsc.read(byteBuffer);
                    if (n != 0) {
                        int n2 = n;
                        return n2;
                    }
                    long l2 = RDMASocketAdaptor.this.timeout;
                    do {
                        if (!RDMASocketAdaptor.this.rsc.isOpen()) {
                            throw new ClosedChannelException();
                        }
                        l = System.currentTimeMillis();
                        int n3 = RDMASocketAdaptor.this.rsc.poll(Net.POLLIN, l2);
                        if (n3 <= 0 || (n = RDMASocketAdaptor.this.rsc.read(byteBuffer)) == 0) continue;
                        int n4 = n;
                        return n4;
                    } while ((l2 -= System.currentTimeMillis() - l) > 0L);
                    throw new SocketTimeoutException();
                }
                finally {
                    if (RDMASocketAdaptor.this.rsc.isOpen()) {
                        RDMASocketAdaptor.this.rsc.configureBlocking(true);
                    }
                }
            }
        }
    }
}

