/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.HashMap;
import java.util.Iterator;
import sun.nio.ch.FileDispatcherImpl;
import sun.nio.ch.IOUtil;
import sun.nio.ch.PollsetArrayWrapper;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.SelectorImpl;

class PollsetSelectorImpl
extends SelectorImpl {
    protected int fd0;
    protected int fd1;
    PollsetArrayWrapper pollWrapper;
    private HashMap fdToKey;
    private boolean closed = false;
    private Object interruptLock = new Object();
    private boolean interruptTriggered = false;

    PollsetSelectorImpl(SelectorProvider selectorProvider) {
        super(selectorProvider);
        long l = IOUtil.makePipe(false);
        this.fd0 = (int)(l >>> 32);
        this.fd1 = (int)l;
        this.pollWrapper = new PollsetArrayWrapper();
        this.pollWrapper.initInterrupt(this.fd0, this.fd1);
        this.fdToKey = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doSelect(long l) throws IOException {
        if (this.closed) {
            throw new ClosedSelectorException();
        }
        this.processDeregisterQueue();
        try {
            this.begin();
            this.pollWrapper.poll(l);
        }
        finally {
            this.end();
        }
        this.processDeregisterQueue();
        int n = this.updateSelectedKeys();
        if (this.pollWrapper.getReventOps(0) != 0) {
            Object object = this.interruptLock;
            synchronized (object) {
                IOUtil.drain(this.fd0);
                this.interruptTriggered = false;
            }
        }
        return n;
    }

    private int updateSelectedKeys() {
        int n = this.pollWrapper.updated;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = this.pollWrapper.getDescriptor(i);
            SelectionKeyImpl selectionKeyImpl = (SelectionKeyImpl)this.fdToKey.get(new Integer(n3));
            if (selectionKeyImpl == null) continue;
            int n4 = this.pollWrapper.getEventOps(i);
            if (this.selectedKeys.contains(selectionKeyImpl)) {
                if (!selectionKeyImpl.channel.translateAndSetReadyOps(n4, selectionKeyImpl)) continue;
                ++n2;
                continue;
            }
            selectionKeyImpl.channel.translateAndSetReadyOps(n4, selectionKeyImpl);
            if ((selectionKeyImpl.nioReadyOps() & selectionKeyImpl.nioInterestOps()) == 0) continue;
            this.selectedKeys.add(selectionKeyImpl);
            ++n2;
        }
        return n2;
    }

    @Override
    protected void implClose() throws IOException {
        if (!this.closed) {
            this.closed = true;
            FileDispatcherImpl.closeIntFD(this.fd0);
            FileDispatcherImpl.closeIntFD(this.fd1);
            if (this.pollWrapper != null) {
                this.pollWrapper.release(this.fd0);
                this.pollWrapper.closePollsetFD();
                this.pollWrapper = null;
                this.selectedKeys = null;
                Iterator iterator = this.keys.iterator();
                while (iterator.hasNext()) {
                    SelectionKeyImpl selectionKeyImpl = (SelectionKeyImpl)iterator.next();
                    this.deregister(selectionKeyImpl);
                    SelectableChannel selectableChannel = selectionKeyImpl.channel();
                    if (!selectableChannel.isOpen() && !selectableChannel.isRegistered()) {
                        ((SelChImpl)((Object)selectableChannel)).kill();
                    }
                    iterator.remove();
                }
            }
            this.fd0 = -1;
            this.fd1 = -1;
        }
    }

    @Override
    protected void implRegister(SelectionKeyImpl selectionKeyImpl) {
        int n = IOUtil.fdVal(selectionKeyImpl.channel.getFD());
        this.fdToKey.put(new Integer(n), selectionKeyImpl);
        this.pollWrapper.add(n);
        this.keys.add(selectionKeyImpl);
    }

    @Override
    protected void implDereg(SelectionKeyImpl selectionKeyImpl) throws IOException {
        assert (selectionKeyImpl.getIndex() >= 0);
        int n = selectionKeyImpl.channel.getFDVal();
        this.fdToKey.remove(new Integer(n));
        this.pollWrapper.release(n);
        selectionKeyImpl.setIndex(-1);
        this.keys.remove(selectionKeyImpl);
        this.selectedKeys.remove(selectionKeyImpl);
        this.deregister(selectionKeyImpl);
        SelectableChannel selectableChannel = selectionKeyImpl.channel();
        if (!selectableChannel.isOpen() && !selectableChannel.isRegistered()) {
            ((SelChImpl)((Object)selectableChannel)).kill();
        }
    }

    @Override
    public void putEventOps(SelectionKeyImpl selectionKeyImpl, int n) {
        int n2 = IOUtil.fdVal(selectionKeyImpl.channel.getFD());
        this.pollWrapper.setInterest(n2, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Selector wakeup() {
        Object object = this.interruptLock;
        synchronized (object) {
            if (!this.interruptTriggered) {
                this.pollWrapper.interrupt();
                this.interruptTriggered = true;
            }
        }
        return this;
    }

    static {
        IOUtil.load();
    }
}

