/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import sun.nio.ch.PollArrayWrapper;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.SelectorImpl;

abstract class AbstractPollSelectorImpl
extends SelectorImpl {
    PollArrayWrapper pollWrapper;
    protected final int INIT_CAP = 10;
    protected SelectionKeyImpl[] channelArray;
    protected int channelOffset = 0;
    protected int totalChannels;
    protected int interestingChannels;
    private boolean closed = false;
    private Object closeLock = new Object();
    private Map<SelectionKeyImpl, Integer> cacheMap = new HashMap<SelectionKeyImpl, Integer>();

    AbstractPollSelectorImpl(SelectorProvider selectorProvider, int n, int n2) {
        super(selectorProvider);
        this.totalChannels = n;
        this.interestingChannels = n;
        this.channelOffset = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInterest(SelectionKeyImpl selectionKeyImpl, int n) {
        Map<SelectionKeyImpl, Integer> map = this.cacheMap;
        synchronized (map) {
            this.cacheMap.put(selectionKeyImpl, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putEventOps(SelectionKeyImpl selectionKeyImpl, int n) {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                throw new ClosedSelectorException();
            }
            this.setInterest(selectionKeyImpl, n);
        }
    }

    @Override
    public Selector wakeup() {
        this.pollWrapper.interrupt();
        return this;
    }

    @Override
    protected abstract int doSelect(long var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implClose() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            for (int i = this.channelOffset; i < this.totalChannels; ++i) {
                SelectionKeyImpl selectionKeyImpl = this.channelArray[i];
                assert (selectionKeyImpl.getIndex() != -1);
                selectionKeyImpl.setIndex(-1);
                this.deregister(selectionKeyImpl);
                SelectableChannel selectableChannel = this.channelArray[i].channel();
                if (selectableChannel.isOpen() || selectableChannel.isRegistered()) continue;
                ((SelChImpl)((Object)selectableChannel)).kill();
            }
            this.implCloseInterrupt();
            this.pollWrapper.free();
            this.pollWrapper = null;
            this.selectedKeys = null;
            this.channelArray = null;
            this.totalChannels = 0;
            this.interestingChannels = 0;
        }
    }

    protected abstract void implCloseInterrupt() throws IOException;

    protected int updateSelectedKeys() {
        int n = 0;
        for (int i = this.channelOffset; i < this.interestingChannels; ++i) {
            int n2 = this.pollWrapper.getReventOps(i);
            if (n2 == 0) continue;
            SelectionKeyImpl selectionKeyImpl = this.channelArray[i];
            this.pollWrapper.putReventOps(i, 0);
            if (this.selectedKeys.contains(selectionKeyImpl)) {
                int n3 = selectionKeyImpl.nioReadyOps();
                selectionKeyImpl.channel.translateAndSetReadyOps(n2, selectionKeyImpl);
                if (selectionKeyImpl.nioReadyOps() == n3) continue;
                ++n;
                continue;
            }
            selectionKeyImpl.channel.translateAndSetReadyOps(n2, selectionKeyImpl);
            if ((selectionKeyImpl.nioReadyOps() & selectionKeyImpl.nioInterestOps()) == 0) continue;
            this.selectedKeys.add(selectionKeyImpl);
            ++n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void swapChannels(int n, int n2) {
        if (0 > n || n >= this.totalChannels || 0 > n2 || n2 >= this.totalChannels) {
            throw new RuntimeException("Internal Selector problem, cannot swap channels " + n + " and " + n2);
        }
        if (n == n2) {
            return;
        }
        SelectionKeyImpl selectionKeyImpl = this.channelArray[n];
        SelectionKeyImpl selectionKeyImpl2 = this.channelArray[n2];
        SelectionKeyImpl selectionKeyImpl3 = selectionKeyImpl;
        synchronized (selectionKeyImpl3) {
            SelectionKeyImpl selectionKeyImpl4 = selectionKeyImpl2;
            synchronized (selectionKeyImpl4) {
                this.channelArray[n] = selectionKeyImpl2;
                this.channelArray[n2] = selectionKeyImpl;
                selectionKeyImpl.setIndex(n2);
                selectionKeyImpl2.setIndex(n);
                PollArrayWrapper.swapEntry(this.pollWrapper, n, this.pollWrapper, n2);
            }
        }
    }

    private void adjustInteresting(SelectionKeyImpl selectionKeyImpl, int n) {
        if (this.totalChannels <= 1 || this.interestingChannels < 1) {
            throw new RuntimeException("Internal Selector problem, cannot adjust. totalChannels=" + this.totalChannels + ", interestingChannels=" + this.interestingChannels);
        }
        if (selectionKeyImpl.getIndex() < this.interestingChannels) {
            if (n == 0) {
                int n2 = this.interestingChannels - 1;
                this.swapChannels(selectionKeyImpl.getIndex(), n2);
                --this.interestingChannels;
            }
        } else if (n != 0) {
            int n3 = this.interestingChannels++;
            this.swapChannels(selectionKeyImpl.getIndex(), n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateRegistrations() {
        Map<SelectionKeyImpl, Integer> map = this.cacheMap;
        synchronized (map) {
            if (this.cacheMap.size() > 0) {
                Set<Map.Entry<SelectionKeyImpl, Integer>> set = this.cacheMap.entrySet();
                for (Map.Entry entry : set) {
                    int n = ((SelectionKeyImpl)entry.getKey()).getIndex();
                    if (n < 0) continue;
                    this.pollWrapper.putEventOps(n, (Integer)entry.getValue());
                    this.adjustInteresting((SelectionKeyImpl)entry.getKey(), (Integer)entry.getValue());
                }
                this.cacheMap.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implRegister(SelectionKeyImpl selectionKeyImpl) {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                throw new ClosedSelectorException();
            }
            if (this.channelArray.length == this.totalChannels) {
                int n = this.pollWrapper.totalChannels * 2;
                SelectionKeyImpl[] selectionKeyImplArray = new SelectionKeyImpl[n];
                for (int i = this.channelOffset; i < this.totalChannels; ++i) {
                    selectionKeyImplArray[i] = this.channelArray[i];
                }
                this.channelArray = selectionKeyImplArray;
                this.pollWrapper.grow(n);
            }
            this.channelArray[this.totalChannels] = selectionKeyImpl;
            selectionKeyImpl.setIndex(this.totalChannels);
            this.pollWrapper.addEntry(selectionKeyImpl.channel);
            ++this.totalChannels;
            this.keys.add(selectionKeyImpl);
            try {
                this.adjustInteresting(selectionKeyImpl, selectionKeyImpl.interestOps());
            }
            catch (CancelledKeyException cancelledKeyException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implDereg(SelectionKeyImpl selectionKeyImpl) throws IOException {
        SelectionKeyImpl selectionKeyImpl2 = selectionKeyImpl;
        synchronized (selectionKeyImpl2) {
            Object object;
            int n = selectionKeyImpl.getIndex();
            assert (n >= 0);
            if (this.channelArray[n] == selectionKeyImpl) {
                object = this.channelArray[this.totalChannels - 1];
                if (n != this.totalChannels - 1) {
                    Object object2 = object;
                    synchronized (object2) {
                        this.channelArray[n] = object;
                        ((SelectionKeyImpl)object).setIndex(n);
                        this.pollWrapper.release(n);
                        PollArrayWrapper.replaceEntry(this.pollWrapper, this.totalChannels - 1, this.pollWrapper, n);
                    }
                } else {
                    this.pollWrapper.release(n);
                }
                this.channelArray[this.totalChannels - 1] = null;
                --this.totalChannels;
                --this.pollWrapper.totalChannels;
                if (this.interestingChannels > this.totalChannels) {
                    this.interestingChannels = this.totalChannels;
                }
                try {
                    this.adjustInteresting((SelectionKeyImpl)object, ((SelectionKeyImpl)object).interestOps());
                }
                catch (CancelledKeyException cancelledKeyException) {
                    // empty catch block
                }
                selectionKeyImpl.setIndex(-1);
                this.keys.remove(selectionKeyImpl);
                this.selectedKeys.remove(selectionKeyImpl);
                this.deregister(selectionKeyImpl);
            }
            if (!((AbstractInterruptibleChannel)(object = selectionKeyImpl.channel())).isOpen() && !((SelectableChannel)object).isRegistered()) {
                ((SelChImpl)object).kill();
            }
        }
    }
}

