/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Color;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.SizeRequirements;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.View;
import javax.swing.text.html.CSSBorder;
import javax.swing.text.html.HTML;
import javax.swing.text.html.StyleSheet;

public class CSS
implements Serializable {
    private static final Hashtable<String, Attribute> attributeMap;
    private static final Hashtable<String, Value> valueMap;
    private static final Hashtable<HTML.Attribute, Attribute[]> htmlAttrToCssAttrMap;
    private static final Hashtable<Object, Attribute> styleConstantToCssMap;
    private static final Hashtable<String, Value> htmlValueToCssValueMap;
    private static final Hashtable<String, Value> cssValueToInternalValueMap;
    private transient Hashtable<Object, Object> valueConvertor;
    private int baseFontSize = baseFontSizeIndex + 1;
    private transient StyleSheet styleSheet = null;
    static int baseFontSizeIndex;

    public CSS() {
        this.valueConvertor = new Hashtable();
        this.valueConvertor.put(Attribute.FONT_SIZE, new FontSize());
        this.valueConvertor.put(Attribute.FONT_FAMILY, new FontFamily());
        this.valueConvertor.put(Attribute.FONT_WEIGHT, new FontWeight());
        BorderStyle borderStyle = new BorderStyle();
        this.valueConvertor.put(Attribute.BORDER_TOP_STYLE, borderStyle);
        this.valueConvertor.put(Attribute.BORDER_RIGHT_STYLE, borderStyle);
        this.valueConvertor.put(Attribute.BORDER_BOTTOM_STYLE, borderStyle);
        this.valueConvertor.put(Attribute.BORDER_LEFT_STYLE, borderStyle);
        ColorValue colorValue = new ColorValue();
        this.valueConvertor.put(Attribute.COLOR, colorValue);
        this.valueConvertor.put(Attribute.BACKGROUND_COLOR, colorValue);
        this.valueConvertor.put(Attribute.BORDER_TOP_COLOR, colorValue);
        this.valueConvertor.put(Attribute.BORDER_RIGHT_COLOR, colorValue);
        this.valueConvertor.put(Attribute.BORDER_BOTTOM_COLOR, colorValue);
        this.valueConvertor.put(Attribute.BORDER_LEFT_COLOR, colorValue);
        LengthValue lengthValue = new LengthValue();
        this.valueConvertor.put(Attribute.MARGIN_TOP, lengthValue);
        this.valueConvertor.put(Attribute.MARGIN_BOTTOM, lengthValue);
        this.valueConvertor.put(Attribute.MARGIN_LEFT, lengthValue);
        this.valueConvertor.put(Attribute.MARGIN_LEFT_LTR, lengthValue);
        this.valueConvertor.put(Attribute.MARGIN_LEFT_RTL, lengthValue);
        this.valueConvertor.put(Attribute.MARGIN_RIGHT, lengthValue);
        this.valueConvertor.put(Attribute.MARGIN_RIGHT_LTR, lengthValue);
        this.valueConvertor.put(Attribute.MARGIN_RIGHT_RTL, lengthValue);
        this.valueConvertor.put(Attribute.PADDING_TOP, lengthValue);
        this.valueConvertor.put(Attribute.PADDING_BOTTOM, lengthValue);
        this.valueConvertor.put(Attribute.PADDING_LEFT, lengthValue);
        this.valueConvertor.put(Attribute.PADDING_RIGHT, lengthValue);
        BorderWidthValue borderWidthValue = new BorderWidthValue(null, 0);
        this.valueConvertor.put(Attribute.BORDER_TOP_WIDTH, borderWidthValue);
        this.valueConvertor.put(Attribute.BORDER_BOTTOM_WIDTH, borderWidthValue);
        this.valueConvertor.put(Attribute.BORDER_LEFT_WIDTH, borderWidthValue);
        this.valueConvertor.put(Attribute.BORDER_RIGHT_WIDTH, borderWidthValue);
        LengthValue lengthValue2 = new LengthValue(true);
        this.valueConvertor.put(Attribute.TEXT_INDENT, lengthValue2);
        this.valueConvertor.put(Attribute.WIDTH, lengthValue);
        this.valueConvertor.put(Attribute.HEIGHT, lengthValue);
        this.valueConvertor.put(Attribute.BORDER_SPACING, lengthValue);
        StringValue stringValue = new StringValue();
        this.valueConvertor.put(Attribute.FONT_STYLE, stringValue);
        this.valueConvertor.put(Attribute.TEXT_DECORATION, stringValue);
        this.valueConvertor.put(Attribute.TEXT_ALIGN, stringValue);
        this.valueConvertor.put(Attribute.VERTICAL_ALIGN, stringValue);
        CssValueMapper cssValueMapper = new CssValueMapper();
        this.valueConvertor.put(Attribute.LIST_STYLE_TYPE, cssValueMapper);
        this.valueConvertor.put(Attribute.BACKGROUND_IMAGE, new BackgroundImage());
        this.valueConvertor.put(Attribute.BACKGROUND_POSITION, new BackgroundPosition());
        this.valueConvertor.put(Attribute.BACKGROUND_REPEAT, cssValueMapper);
        this.valueConvertor.put(Attribute.BACKGROUND_ATTACHMENT, cssValueMapper);
        CssValue cssValue = new CssValue();
        for (Attribute attribute : Attribute.allAttributes) {
            if (this.valueConvertor.get(attribute) != null) continue;
            this.valueConvertor.put(attribute, cssValue);
        }
    }

    void setBaseFontSize(int n) {
        this.baseFontSize = n < 1 ? 0 : (n > 7 ? 7 : n);
    }

    void setBaseFontSize(String string) {
        if (string != null) {
            if (string.startsWith("+")) {
                int n = Integer.valueOf(string.substring(1));
                this.setBaseFontSize(this.baseFontSize + n);
            } else if (string.startsWith("-")) {
                int n = -Integer.valueOf(string.substring(1)).intValue();
                this.setBaseFontSize(this.baseFontSize + n);
            } else {
                this.setBaseFontSize(Integer.valueOf(string));
            }
        }
    }

    int getBaseFontSize() {
        return this.baseFontSize;
    }

    void addInternalCSSValue(MutableAttributeSet mutableAttributeSet, Attribute attribute, String string) {
        if (attribute == Attribute.FONT) {
            ShorthandFontParser.parseShorthandFont(this, string, mutableAttributeSet);
        } else if (attribute == Attribute.BACKGROUND) {
            ShorthandBackgroundParser.parseShorthandBackground(this, string, mutableAttributeSet);
        } else if (attribute == Attribute.MARGIN) {
            ShorthandMarginParser.parseShorthandMargin(this, string, mutableAttributeSet, Attribute.ALL_MARGINS);
        } else if (attribute == Attribute.PADDING) {
            ShorthandMarginParser.parseShorthandMargin(this, string, mutableAttributeSet, Attribute.ALL_PADDING);
        } else if (attribute == Attribute.BORDER_WIDTH) {
            ShorthandMarginParser.parseShorthandMargin(this, string, mutableAttributeSet, Attribute.ALL_BORDER_WIDTHS);
        } else if (attribute == Attribute.BORDER_COLOR) {
            ShorthandMarginParser.parseShorthandMargin(this, string, mutableAttributeSet, Attribute.ALL_BORDER_COLORS);
        } else if (attribute == Attribute.BORDER_STYLE) {
            ShorthandMarginParser.parseShorthandMargin(this, string, mutableAttributeSet, Attribute.ALL_BORDER_STYLES);
        } else if (attribute == Attribute.BORDER || attribute == Attribute.BORDER_TOP || attribute == Attribute.BORDER_RIGHT || attribute == Attribute.BORDER_BOTTOM || attribute == Attribute.BORDER_LEFT) {
            ShorthandBorderParser.parseShorthandBorder(mutableAttributeSet, attribute, string);
        } else {
            Object object = this.getInternalCSSValue(attribute, string);
            if (object != null) {
                mutableAttributeSet.addAttribute(attribute, object);
            }
        }
    }

    Object getInternalCSSValue(Attribute attribute, String string) {
        CssValue cssValue = (CssValue)this.valueConvertor.get(attribute);
        Object object = cssValue.parseCssValue(string);
        return object != null ? object : cssValue.parseCssValue(attribute.getDefaultValue());
    }

    Attribute styleConstantsKeyToCSSKey(StyleConstants styleConstants) {
        return styleConstantToCssMap.get(styleConstants);
    }

    Object styleConstantsValueToCSSValue(StyleConstants styleConstants, Object object) {
        Attribute attribute = this.styleConstantsKeyToCSSKey(styleConstants);
        if (attribute != null) {
            CssValue cssValue = (CssValue)this.valueConvertor.get(attribute);
            return cssValue.fromStyleConstants(styleConstants, object);
        }
        return null;
    }

    Object cssValueToStyleConstantsValue(StyleConstants styleConstants, Object object) {
        if (object instanceof CssValue) {
            return ((CssValue)object).toStyleConstants(styleConstants, null);
        }
        return null;
    }

    Font getFont(StyleContext styleContext, AttributeSet attributeSet, int n, StyleSheet styleSheet) {
        Font font;
        Object object;
        Object object2;
        styleSheet = this.getStyleSheet(styleSheet);
        int n2 = CSS.getFontSize(attributeSet, n, styleSheet);
        StringValue stringValue = (StringValue)attributeSet.getAttribute(Attribute.VERTICAL_ALIGN);
        if (stringValue != null && (((String)(object2 = stringValue.toString())).indexOf("sup") >= 0 || ((String)object2).indexOf("sub") >= 0)) {
            n2 -= 2;
        }
        String string = (object2 = (FontFamily)attributeSet.getAttribute(Attribute.FONT_FAMILY)) != null ? ((FontFamily)object2).getValue() : "SansSerif";
        int n3 = 0;
        FontWeight fontWeight = (FontWeight)attributeSet.getAttribute(Attribute.FONT_WEIGHT);
        if (fontWeight != null && fontWeight.getValue() > 400) {
            n3 |= 1;
        }
        if ((object = attributeSet.getAttribute(Attribute.FONT_STYLE)) != null && object.toString().indexOf("italic") >= 0) {
            n3 |= 2;
        }
        if (string.equalsIgnoreCase("monospace")) {
            string = "Monospaced";
        }
        if ((font = styleContext.getFont(string, n3, n2)) == null || font.getFamily().equals("Dialog") && !string.equalsIgnoreCase("Dialog")) {
            string = "SansSerif";
            font = styleContext.getFont(string, n3, n2);
        }
        return font;
    }

    static int getFontSize(AttributeSet attributeSet, int n, StyleSheet styleSheet) {
        FontSize fontSize = (FontSize)attributeSet.getAttribute(Attribute.FONT_SIZE);
        return fontSize != null ? fontSize.getValue(attributeSet, styleSheet) : n;
    }

    Color getColor(AttributeSet attributeSet, Attribute attribute) {
        ColorValue colorValue = (ColorValue)attributeSet.getAttribute(attribute);
        if (colorValue != null) {
            return colorValue.getValue();
        }
        return null;
    }

    float getPointSize(String string, StyleSheet styleSheet) {
        styleSheet = this.getStyleSheet(styleSheet);
        if (string != null) {
            if (string.startsWith("+")) {
                int n = Integer.valueOf(string.substring(1));
                return this.getPointSize(this.baseFontSize + n, styleSheet);
            }
            if (string.startsWith("-")) {
                int n = -Integer.valueOf(string.substring(1)).intValue();
                return this.getPointSize(this.baseFontSize + n, styleSheet);
            }
            int n = Integer.valueOf(string);
            return this.getPointSize(n, styleSheet);
        }
        return 0.0f;
    }

    float getLength(AttributeSet attributeSet, Attribute attribute, StyleSheet styleSheet) {
        styleSheet = this.getStyleSheet(styleSheet);
        LengthValue lengthValue = (LengthValue)attributeSet.getAttribute(attribute);
        boolean bl = styleSheet == null ? false : styleSheet.isW3CLengthUnits();
        float f = lengthValue != null ? lengthValue.getValue(bl) : 0.0f;
        return f;
    }

    AttributeSet translateHTMLToCSS(AttributeSet attributeSet) {
        Object object;
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        Element element = (Element)((Object)attributeSet);
        HTML.Tag tag = this.getHTMLTag(attributeSet);
        if (tag == HTML.Tag.TD || tag == HTML.Tag.TH) {
            String string;
            object = element.getParentElement().getParentElement().getAttributes();
            int n = CSS.getTableBorder((AttributeSet)object);
            if (n > 0) {
                this.translateAttribute(HTML.Attribute.BORDER, "1", simpleAttributeSet);
            }
            if ((string = (String)object.getAttribute(HTML.Attribute.CELLPADDING)) != null) {
                LengthValue lengthValue = (LengthValue)this.getInternalCSSValue(Attribute.PADDING_TOP, string);
                lengthValue.span = lengthValue.span < 0.0f ? 0.0f : lengthValue.span;
                simpleAttributeSet.addAttribute(Attribute.PADDING_TOP, lengthValue);
                simpleAttributeSet.addAttribute(Attribute.PADDING_BOTTOM, lengthValue);
                simpleAttributeSet.addAttribute(Attribute.PADDING_LEFT, lengthValue);
                simpleAttributeSet.addAttribute(Attribute.PADDING_RIGHT, lengthValue);
            }
        }
        if (element.isLeaf()) {
            this.translateEmbeddedAttributes(attributeSet, simpleAttributeSet);
        } else {
            this.translateAttributes(tag, attributeSet, simpleAttributeSet);
        }
        if (tag == HTML.Tag.CAPTION) {
            object = attributeSet.getAttribute(HTML.Attribute.ALIGN);
            if (object != null && (object.equals("top") || object.equals("bottom"))) {
                simpleAttributeSet.addAttribute(Attribute.CAPTION_SIDE, object);
                simpleAttributeSet.removeAttribute(Attribute.TEXT_ALIGN);
            } else {
                object = attributeSet.getAttribute(HTML.Attribute.VALIGN);
                if (object != null) {
                    simpleAttributeSet.addAttribute(Attribute.CAPTION_SIDE, object);
                }
            }
        }
        return simpleAttributeSet;
    }

    private static int getTableBorder(AttributeSet attributeSet) {
        String string = (String)attributeSet.getAttribute(HTML.Attribute.BORDER);
        if (string == "#DEFAULT" || "".equals(string)) {
            return 1;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static Attribute[] getAllAttributeKeys() {
        Attribute[] attributeArray = new Attribute[Attribute.allAttributes.length];
        System.arraycopy(Attribute.allAttributes, 0, attributeArray, 0, Attribute.allAttributes.length);
        return attributeArray;
    }

    public static final Attribute getAttribute(String string) {
        return attributeMap.get(string);
    }

    static final Value getValue(String string) {
        return valueMap.get(string);
    }

    static URL getURL(URL uRL, String string) {
        URL uRL2;
        if (string == null) {
            return null;
        }
        if (string.startsWith("url(") && string.endsWith(")")) {
            string = string.substring(4, string.length() - 1);
        }
        try {
            uRL2 = new URL(string);
            if (uRL2 != null) {
                return uRL2;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (uRL != null) {
            try {
                uRL2 = new URL(uRL, string);
                return uRL2;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    static String colorToHex(Color color) {
        String string = "#";
        String string2 = Integer.toHexString(color.getRed());
        if (string2.length() > 2) {
            string2 = string2.substring(0, 2);
        } else {
            string = string2.length() < 2 ? string + "0" + string2 : string + string2;
        }
        string2 = Integer.toHexString(color.getGreen());
        if (string2.length() > 2) {
            string2 = string2.substring(0, 2);
        } else {
            string = string2.length() < 2 ? string + "0" + string2 : string + string2;
        }
        string2 = Integer.toHexString(color.getBlue());
        if (string2.length() > 2) {
            string2 = string2.substring(0, 2);
        } else {
            string = string2.length() < 2 ? string + "0" + string2 : string + string2;
        }
        return string;
    }

    static final Color hexToColor(String string) {
        Color color;
        int n = string.length();
        String string2 = string.startsWith("#") ? string.substring(1, Math.min(string.length(), 7)) : string;
        String string3 = "0x" + string2;
        try {
            color = Color.decode(string3);
        }
        catch (NumberFormatException numberFormatException) {
            color = null;
        }
        return color;
    }

    static Color stringToColor(String string) {
        if (string == null) {
            return null;
        }
        Color color = string.length() == 0 ? Color.black : (string.startsWith("rgb(") ? CSS.parseRGB(string) : (string.charAt(0) == '#' ? CSS.hexToColor(string) : (string.equalsIgnoreCase("Black") ? CSS.hexToColor("#000000") : (string.equalsIgnoreCase("Silver") ? CSS.hexToColor("#C0C0C0") : (string.equalsIgnoreCase("Gray") ? CSS.hexToColor("#808080") : (string.equalsIgnoreCase("White") ? CSS.hexToColor("#FFFFFF") : (string.equalsIgnoreCase("Maroon") ? CSS.hexToColor("#800000") : (string.equalsIgnoreCase("Red") ? CSS.hexToColor("#FF0000") : (string.equalsIgnoreCase("Purple") ? CSS.hexToColor("#800080") : (string.equalsIgnoreCase("Fuchsia") ? CSS.hexToColor("#FF00FF") : (string.equalsIgnoreCase("Green") ? CSS.hexToColor("#008000") : (string.equalsIgnoreCase("Lime") ? CSS.hexToColor("#00FF00") : (string.equalsIgnoreCase("Olive") ? CSS.hexToColor("#808000") : (string.equalsIgnoreCase("Yellow") ? CSS.hexToColor("#FFFF00") : (string.equalsIgnoreCase("Navy") ? CSS.hexToColor("#000080") : (string.equalsIgnoreCase("Blue") ? CSS.hexToColor("#0000FF") : (string.equalsIgnoreCase("Teal") ? CSS.hexToColor("#008080") : (string.equalsIgnoreCase("Aqua") ? CSS.hexToColor("#00FFFF") : (string.equalsIgnoreCase("Orange") ? CSS.hexToColor("#FF8000") : CSS.hexToColor(string))))))))))))))))))));
        return color;
    }

    private static Color parseRGB(String string) {
        int[] nArray = new int[]{4};
        int n = CSS.getColorComponent(string, nArray);
        int n2 = CSS.getColorComponent(string, nArray);
        int n3 = CSS.getColorComponent(string, nArray);
        return new Color(n, n2, n3);
    }

    private static int getColorComponent(String string, int[] nArray) {
        char c;
        int n = string.length();
        while (nArray[0] < n && (c = string.charAt(nArray[0])) != '-' && !Character.isDigit(c) && c != '.') {
            nArray[0] = nArray[0] + 1;
        }
        int n2 = nArray[0];
        if (n2 < n && string.charAt(nArray[0]) == '-') {
            nArray[0] = nArray[0] + 1;
        }
        while (nArray[0] < n && Character.isDigit(string.charAt(nArray[0]))) {
            nArray[0] = nArray[0] + 1;
        }
        if (nArray[0] < n && string.charAt(nArray[0]) == '.') {
            nArray[0] = nArray[0] + 1;
            while (nArray[0] < n && Character.isDigit(string.charAt(nArray[0]))) {
                nArray[0] = nArray[0] + 1;
            }
        }
        if (n2 != nArray[0]) {
            try {
                float f = Float.parseFloat(string.substring(n2, nArray[0]));
                if (nArray[0] < n && string.charAt(nArray[0]) == '%') {
                    nArray[0] = nArray[0] + 1;
                    f = f * 255.0f / 100.0f;
                }
                return Math.min(255, Math.max(0, (int)f));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    static int getIndexOfSize(float f, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (!(f <= (float)nArray[i])) continue;
            return i + 1;
        }
        return nArray.length;
    }

    static int getIndexOfSize(float f, StyleSheet styleSheet) {
        int[] nArray = styleSheet != null ? styleSheet.getSizeMap() : StyleSheet.sizeMapDefault;
        return CSS.getIndexOfSize(f, nArray);
    }

    static String[] parseStrings(String string) {
        int n = string == null ? 0 : string.length();
        Vector<String> vector = new Vector<String>(4);
        for (int i = 0; i < n; ++i) {
            while (i < n && Character.isWhitespace(string.charAt(i))) {
                ++i;
            }
            int n2 = i;
            while (i < n && !Character.isWhitespace(string.charAt(i))) {
                ++i;
            }
            if (n2 == i) continue;
            vector.addElement(string.substring(n2, i));
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    float getPointSize(int n, StyleSheet styleSheet) {
        int[] nArray;
        int[] nArray2 = nArray = (styleSheet = this.getStyleSheet(styleSheet)) != null ? styleSheet.getSizeMap() : StyleSheet.sizeMapDefault;
        if (--n < 0) {
            return nArray[0];
        }
        if (n > nArray.length - 1) {
            return nArray[nArray.length - 1];
        }
        return nArray[n];
    }

    private void translateEmbeddedAttributes(AttributeSet attributeSet, MutableAttributeSet mutableAttributeSet) {
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        if (attributeSet.getAttribute(StyleConstants.NameAttribute) == HTML.Tag.HR) {
            this.translateAttributes(HTML.Tag.HR, attributeSet, mutableAttributeSet);
        }
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            if (obj instanceof HTML.Tag) {
                HTML.Tag tag = (HTML.Tag)obj;
                Object object = attributeSet.getAttribute(tag);
                if (object == null || !(object instanceof AttributeSet)) continue;
                this.translateAttributes(tag, (AttributeSet)object, mutableAttributeSet);
                continue;
            }
            if (!(obj instanceof Attribute)) continue;
            mutableAttributeSet.addAttribute(obj, attributeSet.getAttribute(obj));
        }
    }

    private void translateAttributes(HTML.Tag tag, AttributeSet attributeSet, MutableAttributeSet mutableAttributeSet) {
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            if (obj instanceof HTML.Attribute) {
                HTML.Attribute attribute = (HTML.Attribute)obj;
                if (attribute == HTML.Attribute.ALIGN) {
                    Object object;
                    Attribute attribute2;
                    String string = (String)attributeSet.getAttribute(HTML.Attribute.ALIGN);
                    if (string == null || (attribute2 = this.getCssAlignAttribute(tag, attributeSet)) == null || (object = this.getCssValue(attribute2, string)) == null) continue;
                    mutableAttributeSet.addAttribute(attribute2, object);
                    continue;
                }
                if (attribute == HTML.Attribute.SIZE && !this.isHTMLFontTag(tag)) continue;
                if (tag == HTML.Tag.TABLE && attribute == HTML.Attribute.BORDER) {
                    int n = CSS.getTableBorder(attributeSet);
                    if (n <= 0) continue;
                    this.translateAttribute(HTML.Attribute.BORDER, Integer.toString(n), mutableAttributeSet);
                    continue;
                }
                this.translateAttribute(attribute, (String)attributeSet.getAttribute(attribute), mutableAttributeSet);
                continue;
            }
            if (!(obj instanceof Attribute)) continue;
            mutableAttributeSet.addAttribute(obj, attributeSet.getAttribute(obj));
        }
    }

    private void translateAttribute(HTML.Attribute attribute, String string, MutableAttributeSet mutableAttributeSet) {
        Attribute[] attributeArray = this.getCssAttribute(attribute);
        if (attributeArray == null || string == null) {
            return;
        }
        for (Attribute attribute2 : attributeArray) {
            Object object = this.getCssValue(attribute2, string);
            if (object == null) continue;
            mutableAttributeSet.addAttribute(attribute2, object);
        }
    }

    Object getCssValue(Attribute attribute, String string) {
        CssValue cssValue = (CssValue)this.valueConvertor.get(attribute);
        Object object = cssValue.parseHtmlValue(string);
        return object;
    }

    private Attribute[] getCssAttribute(HTML.Attribute attribute) {
        return htmlAttrToCssAttrMap.get(attribute);
    }

    private Attribute getCssAlignAttribute(HTML.Tag tag, AttributeSet attributeSet) {
        return Attribute.TEXT_ALIGN;
    }

    private HTML.Tag getHTMLTag(AttributeSet attributeSet) {
        Object object = attributeSet.getAttribute(StyleConstants.NameAttribute);
        if (object instanceof HTML.Tag) {
            HTML.Tag tag = (HTML.Tag)object;
            return tag;
        }
        return null;
    }

    private boolean isHTMLFontTag(HTML.Tag tag) {
        return tag != null && (tag == HTML.Tag.FONT || tag == HTML.Tag.BASEFONT);
    }

    private boolean isFloater(String string) {
        return string.equals("left") || string.equals("right");
    }

    private boolean validTextAlignValue(String string) {
        return this.isFloater(string) || string.equals("center");
    }

    static SizeRequirements calculateTiledRequirements(LayoutIterator layoutIterator, SizeRequirements sizeRequirements) {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        int n = 0;
        int n2 = 0;
        int n3 = layoutIterator.getCount();
        for (int i = 0; i < n3; ++i) {
            layoutIterator.setIndex(i);
            int n4 = n;
            int n5 = (int)layoutIterator.getLeadingCollapseSpan();
            n2 += Math.max(n4, n5);
            l3 += (long)((int)layoutIterator.getPreferredSpan(0.0f));
            l = (long)((float)l + layoutIterator.getMinimumSpan(0.0f));
            l2 = (long)((float)l2 + layoutIterator.getMaximumSpan(0.0f));
            n = (int)layoutIterator.getTrailingCollapseSpan();
        }
        n2 += n;
        n2 = (int)((float)n2 + 2.0f * layoutIterator.getBorderWidth());
        l += (long)n2;
        l3 += (long)n2;
        l2 += (long)n2;
        if (sizeRequirements == null) {
            sizeRequirements = new SizeRequirements();
        }
        sizeRequirements.minimum = l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
        sizeRequirements.preferred = l3 > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l3;
        sizeRequirements.maximum = l2 > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
        return sizeRequirements;
    }

    static void calculateTiledLayout(LayoutIterator layoutIterator, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        long l = 0L;
        int n7 = 0;
        int n8 = 0;
        int n9 = layoutIterator.getCount();
        int n10 = 3;
        long[] lArray = new long[n10];
        long[] lArray2 = new long[n10];
        for (n6 = 0; n6 < n10; ++n6) {
            lArray2[n6] = 0L;
            lArray[n6] = 0L;
        }
        for (n6 = 0; n6 < n9; ++n6) {
            layoutIterator.setIndex(n6);
            int n11 = n7;
            int n12 = (int)layoutIterator.getLeadingCollapseSpan();
            layoutIterator.setOffset(Math.max(n11, n12));
            n8 += layoutIterator.getOffset();
            long l2 = (long)layoutIterator.getPreferredSpan(n);
            layoutIterator.setSpan((int)l2);
            l += l2;
            int n13 = layoutIterator.getAdjustmentWeight();
            lArray[n13] = lArray[n13] + ((long)layoutIterator.getMaximumSpan(n) - l2);
            int n14 = layoutIterator.getAdjustmentWeight();
            lArray2[n14] = lArray2[n14] + (l2 - (long)layoutIterator.getMinimumSpan(n));
            n7 = (int)layoutIterator.getTrailingCollapseSpan();
        }
        n8 += n7;
        n8 = (int)((float)n8 + 2.0f * layoutIterator.getBorderWidth());
        for (n6 = 1; n6 < n10; ++n6) {
            int n15 = n6;
            lArray[n15] = lArray[n15] + lArray[n6 - 1];
            int n16 = n6;
            lArray2[n16] = lArray2[n16] + lArray2[n6 - 1];
        }
        n6 = n - n8;
        long l3 = (long)n6 - l;
        long[] lArray3 = l3 > 0L ? lArray : lArray2;
        l3 = Math.abs(l3);
        for (n5 = 0; n5 <= 2 && lArray3[n5] < l3; ++n5) {
        }
        float f = 0.0f;
        if (n5 <= 2 && (l3 -= n5 > 0 ? lArray3[n5 - 1] : 0L) != 0L) {
            float f2 = lArray3[n5] - (n5 > 0 ? lArray3[n5 - 1] : 0L);
            f = (float)l3 / f2;
        }
        int n17 = (int)layoutIterator.getBorderWidth();
        for (n4 = 0; n4 < n9; ++n4) {
            layoutIterator.setIndex(n4);
            layoutIterator.setOffset(layoutIterator.getOffset() + n17);
            if (layoutIterator.getAdjustmentWeight() < n5) {
                layoutIterator.setSpan((int)((long)n6 > l ? Math.floor(layoutIterator.getMaximumSpan(n)) : Math.ceil(layoutIterator.getMinimumSpan(n))));
            } else if (layoutIterator.getAdjustmentWeight() == n5) {
                n3 = (long)n6 > l ? (int)layoutIterator.getMaximumSpan(n) - layoutIterator.getSpan() : layoutIterator.getSpan() - (int)layoutIterator.getMinimumSpan(n);
                n2 = (int)Math.floor(f * (float)n3);
                layoutIterator.setSpan(layoutIterator.getSpan() + ((long)n6 > l ? n2 : -n2));
            }
            n17 = (int)Math.min((long)layoutIterator.getOffset() + (long)layoutIterator.getSpan(), Integer.MAX_VALUE);
        }
        n4 = n - n17 - (int)layoutIterator.getTrailingCollapseSpan() - (int)layoutIterator.getBorderWidth();
        n3 = n4 > 0 ? 1 : -1;
        n4 *= n3;
        n2 = 1;
        while (n4 > 0 && n2 != 0) {
            n2 = 0;
            int n18 = 0;
            for (int i = 0; i < n9; ++i) {
                int n19;
                layoutIterator.setIndex(i);
                layoutIterator.setOffset(layoutIterator.getOffset() + n18);
                int n20 = layoutIterator.getSpan();
                if (n4 <= 0) continue;
                int n21 = n19 = n3 > 0 ? (int)Math.floor(layoutIterator.getMaximumSpan(n)) - n20 : n20 - (int)Math.ceil(layoutIterator.getMinimumSpan(n));
                if (n19 < 1) continue;
                n2 = 1;
                layoutIterator.setSpan(n20 + n3);
                n18 += n3;
                --n4;
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Enumeration<Object> enumeration = this.valueConvertor.keys();
        objectOutputStream.writeInt(this.valueConvertor.size());
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Object object = enumeration.nextElement();
                Object object2 = this.valueConvertor.get(object);
                if (!(object instanceof Serializable) && (object = StyleContext.getStaticAttributeKey(object)) == null) {
                    object = null;
                    object2 = null;
                } else if (!(object2 instanceof Serializable) && (object2 = StyleContext.getStaticAttributeKey(object2)) == null) {
                    object = null;
                    object2 = null;
                }
                objectOutputStream.writeObject(object);
                objectOutputStream.writeObject(object2);
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        Hashtable hashtable = this.valueConvertor = n > 1 ? new Hashtable(Math.min(1024, n)) : new Hashtable(1);
        while (n-- > 0) {
            Object object;
            Object object2 = objectInputStream.readObject();
            Object object3 = objectInputStream.readObject();
            Object object4 = StyleContext.getStaticAttribute(object2);
            if (object4 != null) {
                object2 = object4;
            }
            if ((object = StyleContext.getStaticAttribute(object3)) != null) {
                object3 = object;
            }
            if (object2 == null || object3 == null) continue;
            this.valueConvertor.put(object2, object3);
        }
    }

    private StyleSheet getStyleSheet(StyleSheet styleSheet) {
        if (styleSheet != null) {
            this.styleSheet = styleSheet;
        }
        return this.styleSheet;
    }

    static {
        int n;
        attributeMap = new Hashtable();
        valueMap = new Hashtable();
        htmlAttrToCssAttrMap = new Hashtable(20);
        styleConstantToCssMap = new Hashtable(17);
        htmlValueToCssValueMap = new Hashtable(8);
        cssValueToInternalValueMap = new Hashtable(13);
        for (n = 0; n < Attribute.allAttributes.length; ++n) {
            attributeMap.put(Attribute.allAttributes[n].toString(), Attribute.allAttributes[n]);
        }
        for (n = 0; n < Value.allValues.length; ++n) {
            valueMap.put(Value.allValues[n].toString(), Value.allValues[n]);
        }
        htmlAttrToCssAttrMap.put(HTML.Attribute.COLOR, new Attribute[]{Attribute.COLOR});
        htmlAttrToCssAttrMap.put(HTML.Attribute.TEXT, new Attribute[]{Attribute.COLOR});
        htmlAttrToCssAttrMap.put(HTML.Attribute.CLEAR, new Attribute[]{Attribute.CLEAR});
        htmlAttrToCssAttrMap.put(HTML.Attribute.BACKGROUND, new Attribute[]{Attribute.BACKGROUND_IMAGE});
        htmlAttrToCssAttrMap.put(HTML.Attribute.BGCOLOR, new Attribute[]{Attribute.BACKGROUND_COLOR});
        htmlAttrToCssAttrMap.put(HTML.Attribute.WIDTH, new Attribute[]{Attribute.WIDTH});
        htmlAttrToCssAttrMap.put(HTML.Attribute.HEIGHT, new Attribute[]{Attribute.HEIGHT});
        htmlAttrToCssAttrMap.put(HTML.Attribute.BORDER, new Attribute[]{Attribute.BORDER_TOP_WIDTH, Attribute.BORDER_RIGHT_WIDTH, Attribute.BORDER_BOTTOM_WIDTH, Attribute.BORDER_LEFT_WIDTH});
        htmlAttrToCssAttrMap.put(HTML.Attribute.CELLPADDING, new Attribute[]{Attribute.PADDING});
        htmlAttrToCssAttrMap.put(HTML.Attribute.CELLSPACING, new Attribute[]{Attribute.BORDER_SPACING});
        htmlAttrToCssAttrMap.put(HTML.Attribute.MARGINWIDTH, new Attribute[]{Attribute.MARGIN_LEFT, Attribute.MARGIN_RIGHT});
        htmlAttrToCssAttrMap.put(HTML.Attribute.MARGINHEIGHT, new Attribute[]{Attribute.MARGIN_TOP, Attribute.MARGIN_BOTTOM});
        htmlAttrToCssAttrMap.put(HTML.Attribute.HSPACE, new Attribute[]{Attribute.PADDING_LEFT, Attribute.PADDING_RIGHT});
        htmlAttrToCssAttrMap.put(HTML.Attribute.VSPACE, new Attribute[]{Attribute.PADDING_BOTTOM, Attribute.PADDING_TOP});
        htmlAttrToCssAttrMap.put(HTML.Attribute.FACE, new Attribute[]{Attribute.FONT_FAMILY});
        htmlAttrToCssAttrMap.put(HTML.Attribute.SIZE, new Attribute[]{Attribute.FONT_SIZE});
        htmlAttrToCssAttrMap.put(HTML.Attribute.VALIGN, new Attribute[]{Attribute.VERTICAL_ALIGN});
        htmlAttrToCssAttrMap.put(HTML.Attribute.ALIGN, new Attribute[]{Attribute.VERTICAL_ALIGN, Attribute.TEXT_ALIGN, Attribute.FLOAT});
        htmlAttrToCssAttrMap.put(HTML.Attribute.TYPE, new Attribute[]{Attribute.LIST_STYLE_TYPE});
        htmlAttrToCssAttrMap.put(HTML.Attribute.NOWRAP, new Attribute[]{Attribute.WHITE_SPACE});
        styleConstantToCssMap.put(StyleConstants.FontFamily, Attribute.FONT_FAMILY);
        styleConstantToCssMap.put(StyleConstants.FontSize, Attribute.FONT_SIZE);
        styleConstantToCssMap.put(StyleConstants.Bold, Attribute.FONT_WEIGHT);
        styleConstantToCssMap.put(StyleConstants.Italic, Attribute.FONT_STYLE);
        styleConstantToCssMap.put(StyleConstants.Underline, Attribute.TEXT_DECORATION);
        styleConstantToCssMap.put(StyleConstants.StrikeThrough, Attribute.TEXT_DECORATION);
        styleConstantToCssMap.put(StyleConstants.Superscript, Attribute.VERTICAL_ALIGN);
        styleConstantToCssMap.put(StyleConstants.Subscript, Attribute.VERTICAL_ALIGN);
        styleConstantToCssMap.put(StyleConstants.Foreground, Attribute.COLOR);
        styleConstantToCssMap.put(StyleConstants.Background, Attribute.BACKGROUND_COLOR);
        styleConstantToCssMap.put(StyleConstants.FirstLineIndent, Attribute.TEXT_INDENT);
        styleConstantToCssMap.put(StyleConstants.LeftIndent, Attribute.MARGIN_LEFT);
        styleConstantToCssMap.put(StyleConstants.RightIndent, Attribute.MARGIN_RIGHT);
        styleConstantToCssMap.put(StyleConstants.SpaceAbove, Attribute.MARGIN_TOP);
        styleConstantToCssMap.put(StyleConstants.SpaceBelow, Attribute.MARGIN_BOTTOM);
        styleConstantToCssMap.put(StyleConstants.Alignment, Attribute.TEXT_ALIGN);
        htmlValueToCssValueMap.put("disc", Value.DISC);
        htmlValueToCssValueMap.put("square", Value.SQUARE);
        htmlValueToCssValueMap.put("circle", Value.CIRCLE);
        htmlValueToCssValueMap.put("1", Value.DECIMAL);
        htmlValueToCssValueMap.put("a", Value.LOWER_ALPHA);
        htmlValueToCssValueMap.put("A", Value.UPPER_ALPHA);
        htmlValueToCssValueMap.put("i", Value.LOWER_ROMAN);
        htmlValueToCssValueMap.put("I", Value.UPPER_ROMAN);
        cssValueToInternalValueMap.put("none", Value.NONE);
        cssValueToInternalValueMap.put("disc", Value.DISC);
        cssValueToInternalValueMap.put("square", Value.SQUARE);
        cssValueToInternalValueMap.put("circle", Value.CIRCLE);
        cssValueToInternalValueMap.put("decimal", Value.DECIMAL);
        cssValueToInternalValueMap.put("lower-roman", Value.LOWER_ROMAN);
        cssValueToInternalValueMap.put("upper-roman", Value.UPPER_ROMAN);
        cssValueToInternalValueMap.put("lower-alpha", Value.LOWER_ALPHA);
        cssValueToInternalValueMap.put("upper-alpha", Value.UPPER_ALPHA);
        cssValueToInternalValueMap.put("repeat", Value.BACKGROUND_REPEAT);
        cssValueToInternalValueMap.put("no-repeat", Value.BACKGROUND_NO_REPEAT);
        cssValueToInternalValueMap.put("repeat-x", Value.BACKGROUND_REPEAT_X);
        cssValueToInternalValueMap.put("repeat-y", Value.BACKGROUND_REPEAT_Y);
        cssValueToInternalValueMap.put("scroll", Value.BACKGROUND_SCROLL);
        cssValueToInternalValueMap.put("fixed", Value.BACKGROUND_FIXED);
        Object[] objectArray = Attribute.allAttributes;
        try {
            for (Object object : objectArray) {
                StyleContext.registerStaticAttributeKey(object);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        objectArray = Value.allValues;
        try {
            for (Object object : objectArray) {
                StyleContext.registerStaticAttributeKey(object);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        baseFontSizeIndex = 3;
    }

    static interface LayoutIterator {
        public static final int WorstAdjustmentWeight = 2;

        public void setOffset(int var1);

        public int getOffset();

        public void setSpan(int var1);

        public int getSpan();

        public int getCount();

        public void setIndex(int var1);

        public float getMinimumSpan(float var1);

        public float getPreferredSpan(float var1);

        public float getMaximumSpan(float var1);

        public int getAdjustmentWeight();

        public float getBorderWidth();

        public float getLeadingCollapseSpan();

        public float getTrailingCollapseSpan();
    }

    static class ShorthandBorderParser {
        static Attribute[] keys = new Attribute[]{Attribute.BORDER_TOP, Attribute.BORDER_RIGHT, Attribute.BORDER_BOTTOM, Attribute.BORDER_LEFT};

        ShorthandBorderParser() {
        }

        static void parseShorthandBorder(MutableAttributeSet mutableAttributeSet, Attribute attribute, String string) {
            int n;
            String[] stringArray;
            Object[] objectArray = new Object[CSSBorder.PARSERS.length];
            String[] stringArray2 = stringArray = CSS.parseStrings(string);
            int n2 = stringArray2.length;
            for (int i = 0; i < n2; ++i) {
                String string2 = stringArray2[i];
                boolean bl = false;
                for (int j = 0; j < objectArray.length; ++j) {
                    Object object = CSSBorder.PARSERS[j].parseCssValue(string2);
                    if (object == null) continue;
                    if (objectArray[j] != null) break;
                    objectArray[j] = object;
                    bl = true;
                    break;
                }
                if (bl) continue;
                return;
            }
            for (n = 0; n < objectArray.length; ++n) {
                if (objectArray[n] != null) continue;
                objectArray[n] = CSSBorder.DEFAULTS[n];
            }
            for (n = 0; n < keys.length; ++n) {
                if (attribute != Attribute.BORDER && attribute != keys[n]) continue;
                for (n2 = 0; n2 < objectArray.length; ++n2) {
                    mutableAttributeSet.addAttribute(CSSBorder.ATTRIBUTES[n2][n], objectArray[n2]);
                }
            }
        }
    }

    static class ShorthandMarginParser {
        ShorthandMarginParser() {
        }

        static void parseShorthandMargin(CSS cSS, String string, MutableAttributeSet mutableAttributeSet, Attribute[] attributeArray) {
            String[] stringArray = CSS.parseStrings(string);
            int n = stringArray.length;
            boolean bl = false;
            switch (n) {
                case 0: {
                    return;
                }
                case 1: {
                    for (int i = 0; i < 4; ++i) {
                        cSS.addInternalCSSValue(mutableAttributeSet, attributeArray[i], stringArray[0]);
                    }
                    break;
                }
                case 2: {
                    cSS.addInternalCSSValue(mutableAttributeSet, attributeArray[0], stringArray[0]);
                    cSS.addInternalCSSValue(mutableAttributeSet, attributeArray[2], stringArray[0]);
                    cSS.addInternalCSSValue(mutableAttributeSet, attributeArray[1], stringArray[1]);
                    cSS.addInternalCSSValue(mutableAttributeSet, attributeArray[3], stringArray[1]);
                    break;
                }
                case 3: {
                    cSS.addInternalCSSValue(mutableAttributeSet, attributeArray[0], stringArray[0]);
                    cSS.addInternalCSSValue(mutableAttributeSet, attributeArray[1], stringArray[1]);
                    cSS.addInternalCSSValue(mutableAttributeSet, attributeArray[2], stringArray[2]);
                    cSS.addInternalCSSValue(mutableAttributeSet, attributeArray[3], stringArray[1]);
                    break;
                }
                default: {
                    for (int i = 0; i < 4; ++i) {
                        cSS.addInternalCSSValue(mutableAttributeSet, attributeArray[i], stringArray[i]);
                    }
                }
            }
        }
    }

    static class ShorthandBackgroundParser {
        ShorthandBackgroundParser() {
        }

        static void parseShorthandBackground(CSS cSS, String string, MutableAttributeSet mutableAttributeSet) {
            String[] stringArray = CSS.parseStrings(string);
            int n = stringArray.length;
            int n2 = 0;
            int n3 = 0;
            while (n2 < n) {
                String string2 = stringArray[n2++];
                if ((n3 & 1) == 0 && ShorthandBackgroundParser.isImage(string2)) {
                    cSS.addInternalCSSValue(mutableAttributeSet, Attribute.BACKGROUND_IMAGE, string2);
                    n3 = (short)(n3 | 1);
                    continue;
                }
                if ((n3 & 2) == 0 && ShorthandBackgroundParser.isRepeat(string2)) {
                    cSS.addInternalCSSValue(mutableAttributeSet, Attribute.BACKGROUND_REPEAT, string2);
                    n3 = (short)(n3 | 2);
                    continue;
                }
                if ((n3 & 4) == 0 && ShorthandBackgroundParser.isAttachment(string2)) {
                    cSS.addInternalCSSValue(mutableAttributeSet, Attribute.BACKGROUND_ATTACHMENT, string2);
                    n3 = (short)(n3 | 4);
                    continue;
                }
                if ((n3 & 8) == 0 && ShorthandBackgroundParser.isPosition(string2)) {
                    if (n2 < n && ShorthandBackgroundParser.isPosition(stringArray[n2])) {
                        cSS.addInternalCSSValue(mutableAttributeSet, Attribute.BACKGROUND_POSITION, string2 + " " + stringArray[n2++]);
                    } else {
                        cSS.addInternalCSSValue(mutableAttributeSet, Attribute.BACKGROUND_POSITION, string2);
                    }
                    n3 = (short)(n3 | 8);
                    continue;
                }
                if ((n3 & 0x10) != 0 || !ShorthandBackgroundParser.isColor(string2)) continue;
                cSS.addInternalCSSValue(mutableAttributeSet, Attribute.BACKGROUND_COLOR, string2);
                n3 = (short)(n3 | 0x10);
            }
            if (!(n3 & true)) {
                cSS.addInternalCSSValue(mutableAttributeSet, Attribute.BACKGROUND_IMAGE, null);
            }
            if ((n3 & 2) == 0) {
                cSS.addInternalCSSValue(mutableAttributeSet, Attribute.BACKGROUND_REPEAT, "repeat");
            }
            if ((n3 & 4) == 0) {
                cSS.addInternalCSSValue(mutableAttributeSet, Attribute.BACKGROUND_ATTACHMENT, "scroll");
            }
            if ((n3 & 8) == 0) {
                cSS.addInternalCSSValue(mutableAttributeSet, Attribute.BACKGROUND_POSITION, null);
            }
        }

        static boolean isImage(String string) {
            return string.startsWith("url(") && string.endsWith(")");
        }

        static boolean isRepeat(String string) {
            return string.equals("repeat-x") || string.equals("repeat-y") || string.equals("repeat") || string.equals("no-repeat");
        }

        static boolean isAttachment(String string) {
            return string.equals("fixed") || string.equals("scroll");
        }

        static boolean isPosition(String string) {
            return string.equals("top") || string.equals("bottom") || string.equals("left") || string.equals("right") || string.equals("center") || string.length() > 0 && Character.isDigit(string.charAt(0));
        }

        static boolean isColor(String string) {
            return CSS.stringToColor(string) != null;
        }
    }

    static class ShorthandFontParser {
        ShorthandFontParser() {
        }

        static void parseShorthandFont(CSS cSS, String string, MutableAttributeSet mutableAttributeSet) {
            String string2;
            String[] stringArray = CSS.parseStrings(string);
            int n = stringArray.length;
            int n2 = 0;
            int n3 = 0;
            int n4 = Math.min(3, n);
            while (n2 < n4) {
                if (!(n3 & true) && ShorthandFontParser.isFontStyle(stringArray[n2])) {
                    cSS.addInternalCSSValue(mutableAttributeSet, Attribute.FONT_STYLE, stringArray[n2++]);
                    n3 = (short)(n3 | 1);
                    continue;
                }
                if ((n3 & 2) == 0 && ShorthandFontParser.isFontVariant(stringArray[n2])) {
                    cSS.addInternalCSSValue(mutableAttributeSet, Attribute.FONT_VARIANT, stringArray[n2++]);
                    n3 = (short)(n3 | 2);
                    continue;
                }
                if ((n3 & 4) == 0 && ShorthandFontParser.isFontWeight(stringArray[n2])) {
                    cSS.addInternalCSSValue(mutableAttributeSet, Attribute.FONT_WEIGHT, stringArray[n2++]);
                    n3 = (short)(n3 | 4);
                    continue;
                }
                if (!stringArray[n2].equals("normal")) break;
                ++n2;
            }
            if (!(n3 & true)) {
                cSS.addInternalCSSValue(mutableAttributeSet, Attribute.FONT_STYLE, "normal");
            }
            if ((n3 & 2) == 0) {
                cSS.addInternalCSSValue(mutableAttributeSet, Attribute.FONT_VARIANT, "normal");
            }
            if ((n3 & 4) == 0) {
                cSS.addInternalCSSValue(mutableAttributeSet, Attribute.FONT_WEIGHT, "normal");
            }
            if (n2 < n) {
                string2 = stringArray[n2];
                int n5 = string2.indexOf(47);
                if (n5 != -1) {
                    string2 = string2.substring(0, n5);
                    stringArray[n2] = stringArray[n2].substring(n5);
                } else {
                    ++n2;
                }
                cSS.addInternalCSSValue(mutableAttributeSet, Attribute.FONT_SIZE, string2);
            } else {
                cSS.addInternalCSSValue(mutableAttributeSet, Attribute.FONT_SIZE, "medium");
            }
            if (n2 < n && stringArray[n2].startsWith("/")) {
                string2 = null;
                if (stringArray[n2].equals("/")) {
                    if (++n2 < n) {
                        string2 = stringArray[n2++];
                    }
                } else {
                    string2 = stringArray[n2++].substring(1);
                }
                if (string2 != null) {
                    cSS.addInternalCSSValue(mutableAttributeSet, Attribute.LINE_HEIGHT, string2);
                } else {
                    cSS.addInternalCSSValue(mutableAttributeSet, Attribute.LINE_HEIGHT, "normal");
                }
            } else {
                cSS.addInternalCSSValue(mutableAttributeSet, Attribute.LINE_HEIGHT, "normal");
            }
            if (n2 < n) {
                string2 = stringArray[n2++];
                while (n2 < n) {
                    string2 = string2 + " " + stringArray[n2++];
                }
                cSS.addInternalCSSValue(mutableAttributeSet, Attribute.FONT_FAMILY, string2);
            } else {
                cSS.addInternalCSSValue(mutableAttributeSet, Attribute.FONT_FAMILY, "SansSerif");
            }
        }

        private static boolean isFontStyle(String string) {
            return string.equals("italic") || string.equals("oblique");
        }

        private static boolean isFontVariant(String string) {
            return string.equals("small-caps");
        }

        private static boolean isFontWeight(String string) {
            if (string.equals("bold") || string.equals("bolder") || string.equals("italic") || string.equals("lighter")) {
                return true;
            }
            return string.length() == 3 && string.charAt(0) >= '1' && string.charAt(0) <= '9' && string.charAt(1) == '0' && string.charAt(2) == '0';
        }
    }

    static class LengthUnit
    implements Serializable {
        static Hashtable<String, Float> lengthMapping = new Hashtable(6);
        static Hashtable<String, Float> w3cLengthMapping = new Hashtable(6);
        short type;
        float value;
        String units = null;
        static final short UNINITALIZED_LENGTH = 10;

        LengthUnit(String string, short s, float f) {
            this.parse(string, s, f);
        }

        void parse(String string, short s, float f) {
            this.type = s;
            this.value = f;
            int n = string.length();
            if (n > 0 && string.charAt(n - 1) == '%') {
                try {
                    this.value = Float.valueOf(string.substring(0, n - 1)).floatValue() / 100.0f;
                    this.type = 1;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (n >= 2) {
                this.units = string.substring(n - 2, n);
                Float f2 = lengthMapping.get(this.units);
                if (f2 != null) {
                    try {
                        this.value = Float.valueOf(string.substring(0, n - 2)).floatValue();
                        this.type = 0;
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (this.units.equals("em") || this.units.equals("ex")) {
                    try {
                        this.value = Float.valueOf(string.substring(0, n - 2)).floatValue();
                        this.type = (short)3;
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (string.equals("larger")) {
                    this.value = 2.0f;
                    this.type = (short)2;
                } else if (string.equals("smaller")) {
                    this.value = -2.0f;
                    this.type = (short)2;
                } else {
                    try {
                        this.value = Float.valueOf(string).floatValue();
                        this.type = 0;
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else if (n > 0) {
                try {
                    this.value = Float.valueOf(string).floatValue();
                    this.type = 0;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        float getValue(boolean bl) {
            Float f;
            Hashtable<String, Float> hashtable = bl ? w3cLengthMapping : lengthMapping;
            float f2 = 1.0f;
            if (this.units != null && (f = hashtable.get(this.units)) != null) {
                f2 = f.floatValue();
            }
            return this.value * f2;
        }

        static float getValue(float f, String string, Boolean bl) {
            Float f2;
            Hashtable<String, Float> hashtable = bl != false ? w3cLengthMapping : lengthMapping;
            float f3 = 1.0f;
            if (string != null && (f2 = hashtable.get(string)) != null) {
                f3 = f2.floatValue();
            }
            return f * f3;
        }

        public String toString() {
            return this.type + " " + this.value;
        }

        static {
            lengthMapping.put("pt", new Float(1.0f));
            lengthMapping.put("px", new Float(1.3f));
            lengthMapping.put("mm", new Float(2.83464f));
            lengthMapping.put("cm", new Float(28.3464f));
            lengthMapping.put("pc", new Float(12.0f));
            lengthMapping.put("in", new Float(72.0f));
            int n = 72;
            try {
                n = Toolkit.getDefaultToolkit().getScreenResolution();
            }
            catch (HeadlessException headlessException) {
                // empty catch block
            }
            w3cLengthMapping.put("pt", new Float((float)n / 72.0f));
            w3cLengthMapping.put("px", new Float(1.0f));
            w3cLengthMapping.put("mm", new Float((float)n / 25.4f));
            w3cLengthMapping.put("cm", new Float((float)n / 2.54f));
            w3cLengthMapping.put("pc", new Float((float)n / 6.0f));
            w3cLengthMapping.put("in", new Float(n));
        }
    }

    static class BackgroundImage
    extends CssValue {
        private boolean loadedImage;
        private ImageIcon image;

        BackgroundImage() {
        }

        @Override
        Object parseCssValue(String string) {
            BackgroundImage backgroundImage = new BackgroundImage();
            backgroundImage.svalue = string;
            return backgroundImage;
        }

        @Override
        Object parseHtmlValue(String string) {
            return this.parseCssValue(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ImageIcon getImage(URL uRL) {
            if (!this.loadedImage) {
                BackgroundImage backgroundImage = this;
                synchronized (backgroundImage) {
                    if (!this.loadedImage) {
                        URL uRL2 = CSS.getURL(uRL, this.svalue);
                        this.loadedImage = true;
                        if (uRL2 != null) {
                            this.image = new ImageIcon();
                            Image image = Toolkit.getDefaultToolkit().createImage(uRL2);
                            if (image != null) {
                                this.image.setImage(image);
                            }
                        }
                    }
                }
            }
            return this.image;
        }
    }

    static class BackgroundPosition
    extends CssValue {
        float horizontalPosition;
        float verticalPosition;
        short relative;

        BackgroundPosition() {
        }

        @Override
        Object parseCssValue(String string) {
            String[] stringArray = CSS.parseStrings(string);
            int n = stringArray.length;
            BackgroundPosition backgroundPosition = new BackgroundPosition();
            backgroundPosition.relative = (short)5;
            backgroundPosition.svalue = string;
            if (n > 0) {
                Object object;
                int n2 = 0;
                int n3 = 0;
                while (n3 < n) {
                    if (((String)(object = stringArray[n3++])).equals("center")) {
                        n2 = (short)(n2 | 4);
                        continue;
                    }
                    if ((n2 & 1) == 0) {
                        if (((String)object).equals("top")) {
                            n2 = (short)(n2 | 1);
                        } else if (((String)object).equals("bottom")) {
                            n2 = (short)(n2 | 1);
                            backgroundPosition.verticalPosition = 1.0f;
                            continue;
                        }
                    }
                    if ((n2 & 2) != 0) continue;
                    if (((String)object).equals("left")) {
                        n2 = (short)(n2 | 2);
                        backgroundPosition.horizontalPosition = 0.0f;
                        continue;
                    }
                    if (!((String)object).equals("right")) continue;
                    n2 = (short)(n2 | 2);
                    backgroundPosition.horizontalPosition = 1.0f;
                }
                if (n2 != 0) {
                    if (n2 & true) {
                        if ((n2 & 2) == 0) {
                            backgroundPosition.horizontalPosition = 0.5f;
                        }
                    } else if ((n2 & 2) == 2) {
                        backgroundPosition.verticalPosition = 0.5f;
                    } else {
                        backgroundPosition.verticalPosition = 0.5f;
                        backgroundPosition.horizontalPosition = 0.5f;
                    }
                } else {
                    object = new LengthUnit(stringArray[0], 0, 0.0f);
                    if (((LengthUnit)object).type == 0) {
                        backgroundPosition.horizontalPosition = ((LengthUnit)object).value;
                        backgroundPosition.relative = (short)(1 ^ backgroundPosition.relative);
                    } else if (((LengthUnit)object).type == 1) {
                        backgroundPosition.horizontalPosition = ((LengthUnit)object).value;
                    } else if (((LengthUnit)object).type == 3) {
                        backgroundPosition.horizontalPosition = ((LengthUnit)object).value;
                        backgroundPosition.relative = (short)(1 ^ backgroundPosition.relative | 2);
                    }
                    if (n > 1) {
                        object = new LengthUnit(stringArray[1], 0, 0.0f);
                        if (((LengthUnit)object).type == 0) {
                            backgroundPosition.verticalPosition = ((LengthUnit)object).value;
                            backgroundPosition.relative = (short)(4 ^ backgroundPosition.relative);
                        } else if (((LengthUnit)object).type == 1) {
                            backgroundPosition.verticalPosition = ((LengthUnit)object).value;
                        } else if (((LengthUnit)object).type == 3) {
                            backgroundPosition.verticalPosition = ((LengthUnit)object).value;
                            backgroundPosition.relative = (short)(4 ^ backgroundPosition.relative | 8);
                        }
                    } else {
                        backgroundPosition.verticalPosition = 0.5f;
                    }
                }
            }
            return backgroundPosition;
        }

        boolean isHorizontalPositionRelativeToSize() {
            return (this.relative & 1) == 1;
        }

        boolean isHorizontalPositionRelativeToFontSize() {
            return (this.relative & 2) == 2;
        }

        float getHorizontalPosition() {
            return this.horizontalPosition;
        }

        boolean isVerticalPositionRelativeToSize() {
            return (this.relative & 4) == 4;
        }

        boolean isVerticalPositionRelativeToFontSize() {
            return (this.relative & 8) == 8;
        }

        float getVerticalPosition() {
            return this.verticalPosition;
        }
    }

    static class CssValueMapper
    extends CssValue {
        CssValueMapper() {
        }

        @Override
        Object parseCssValue(String string) {
            Object v = cssValueToInternalValueMap.get(string);
            if (v == null) {
                v = cssValueToInternalValueMap.get(string.toLowerCase());
            }
            return v;
        }

        @Override
        Object parseHtmlValue(String string) {
            Object v = htmlValueToCssValueMap.get(string);
            if (v == null) {
                v = htmlValueToCssValueMap.get(string.toLowerCase());
            }
            return v;
        }
    }

    static class BorderWidthValue
    extends LengthValue {
        private static final float[] values = new float[]{1.0f, 2.0f, 4.0f};

        BorderWidthValue(String string, int n) {
            this.svalue = string;
            this.span = values[n];
            this.percentage = false;
        }

        @Override
        Object parseCssValue(String string) {
            if (string != null) {
                if (string.equals("thick")) {
                    return new BorderWidthValue(string, 2);
                }
                if (string.equals("medium")) {
                    return new BorderWidthValue(string, 1);
                }
                if (string.equals("thin")) {
                    return new BorderWidthValue(string, 0);
                }
            }
            return super.parseCssValue(string);
        }

        @Override
        Object parseHtmlValue(String string) {
            if (string == "#DEFAULT") {
                return this.parseCssValue("medium");
            }
            return this.parseCssValue(string);
        }
    }

    static class LengthValue
    extends CssValue {
        boolean mayBeNegative;
        boolean percentage;
        float span;
        String units = null;

        LengthValue() {
            this(false);
        }

        LengthValue(boolean bl) {
            this.mayBeNegative = bl;
        }

        float getValue() {
            return this.getValue(false);
        }

        float getValue(boolean bl) {
            return this.getValue(0.0f, bl);
        }

        float getValue(float f) {
            return this.getValue(f, false);
        }

        float getValue(float f, boolean bl) {
            if (this.percentage) {
                return this.span * f;
            }
            return LengthUnit.getValue(this.span, this.units, bl);
        }

        boolean isPercentage() {
            return this.percentage;
        }

        @Override
        Object parseCssValue(String string) {
            LengthValue lengthValue;
            try {
                float f = Float.valueOf(string).floatValue();
                lengthValue = new LengthValue();
                lengthValue.span = f;
            }
            catch (NumberFormatException numberFormatException) {
                LengthUnit lengthUnit = new LengthUnit(string, 10, 0.0f);
                switch (lengthUnit.type) {
                    case 0: {
                        lengthValue = new LengthValue();
                        lengthValue.span = this.mayBeNegative ? lengthUnit.value : Math.max(0.0f, lengthUnit.value);
                        lengthValue.units = lengthUnit.units;
                        break;
                    }
                    case 1: {
                        lengthValue = new LengthValue();
                        lengthValue.span = Math.max(0.0f, Math.min(1.0f, lengthUnit.value));
                        lengthValue.percentage = true;
                        break;
                    }
                    default: {
                        return null;
                    }
                }
            }
            lengthValue.svalue = string;
            return lengthValue;
        }

        @Override
        Object parseHtmlValue(String string) {
            if (string.equals("#DEFAULT")) {
                string = "1";
            }
            return this.parseCssValue(string);
        }

        @Override
        Object fromStyleConstants(StyleConstants styleConstants, Object object) {
            LengthValue lengthValue = new LengthValue();
            lengthValue.svalue = object.toString();
            lengthValue.span = ((Float)object).floatValue();
            return lengthValue;
        }

        @Override
        Object toStyleConstants(StyleConstants styleConstants, View view) {
            return new Float(this.getValue(false));
        }
    }

    static class BorderStyle
    extends CssValue {
        private transient Value style;

        BorderStyle() {
        }

        Value getValue() {
            return this.style;
        }

        @Override
        Object parseCssValue(String string) {
            Value value = CSS.getValue(string);
            if (value != null && (value == Value.INSET || value == Value.OUTSET || value == Value.NONE || value == Value.DOTTED || value == Value.DASHED || value == Value.SOLID || value == Value.DOUBLE || value == Value.GROOVE || value == Value.RIDGE)) {
                BorderStyle borderStyle = new BorderStyle();
                borderStyle.svalue = string;
                borderStyle.style = value;
                return borderStyle;
            }
            return null;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            if (this.style == null) {
                objectOutputStream.writeObject(null);
            } else {
                objectOutputStream.writeObject(this.style.toString());
            }
        }

        private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
            objectInputStream.defaultReadObject();
            Object object = objectInputStream.readObject();
            if (object != null) {
                this.style = CSS.getValue((String)object);
            }
        }
    }

    static class ColorValue
    extends CssValue {
        Color c;

        ColorValue() {
        }

        Color getValue() {
            return this.c;
        }

        @Override
        Object parseCssValue(String string) {
            Color color = CSS.stringToColor(string);
            if (color != null) {
                ColorValue colorValue = new ColorValue();
                colorValue.svalue = string;
                colorValue.c = color;
                return colorValue;
            }
            return null;
        }

        @Override
        Object parseHtmlValue(String string) {
            return this.parseCssValue(string);
        }

        @Override
        Object fromStyleConstants(StyleConstants styleConstants, Object object) {
            ColorValue colorValue = new ColorValue();
            colorValue.c = (Color)object;
            colorValue.svalue = CSS.colorToHex(colorValue.c);
            return colorValue;
        }

        @Override
        Object toStyleConstants(StyleConstants styleConstants, View view) {
            return this.c;
        }
    }

    static class FontWeight
    extends CssValue {
        int weight;

        FontWeight() {
        }

        int getValue() {
            return this.weight;
        }

        @Override
        Object parseCssValue(String string) {
            FontWeight fontWeight = new FontWeight();
            fontWeight.svalue = string;
            if (string.equals("bold")) {
                fontWeight.weight = 700;
            } else if (string.equals("normal")) {
                fontWeight.weight = 400;
            } else {
                try {
                    fontWeight.weight = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    fontWeight = null;
                }
            }
            return fontWeight;
        }

        @Override
        Object fromStyleConstants(StyleConstants styleConstants, Object object) {
            if (object.equals(Boolean.TRUE)) {
                return this.parseCssValue("bold");
            }
            return this.parseCssValue("normal");
        }

        @Override
        Object toStyleConstants(StyleConstants styleConstants, View view) {
            return this.weight > 500 ? Boolean.TRUE : Boolean.FALSE;
        }

        boolean isBold() {
            return this.weight > 500;
        }
    }

    static class FontFamily
    extends CssValue {
        String family;

        FontFamily() {
        }

        String getValue() {
            return this.family;
        }

        @Override
        Object parseCssValue(String string) {
            int n = string.indexOf(44);
            FontFamily fontFamily = new FontFamily();
            fontFamily.svalue = string;
            fontFamily.family = null;
            if (n == -1) {
                this.setFontName(fontFamily, string);
            } else {
                boolean bl = false;
                int n2 = string.length();
                n = 0;
                while (!bl) {
                    while (n < n2 && Character.isWhitespace(string.charAt(n))) {
                        ++n;
                    }
                    int n3 = n;
                    if ((n = string.indexOf(44, n)) == -1) {
                        n = n2;
                    }
                    if (n3 < n2) {
                        if (n3 != n) {
                            int n4 = n;
                            if (n > 0 && string.charAt(n - 1) == ' ') {
                                --n4;
                            }
                            this.setFontName(fontFamily, string.substring(n3, n4));
                            bl = fontFamily.family != null;
                        }
                        ++n;
                        continue;
                    }
                    bl = true;
                }
            }
            if (fontFamily.family == null) {
                fontFamily.family = "SansSerif";
            }
            return fontFamily;
        }

        private void setFontName(FontFamily fontFamily, String string) {
            fontFamily.family = string;
        }

        @Override
        Object parseHtmlValue(String string) {
            return this.parseCssValue(string);
        }

        @Override
        Object fromStyleConstants(StyleConstants styleConstants, Object object) {
            return this.parseCssValue(object.toString());
        }

        @Override
        Object toStyleConstants(StyleConstants styleConstants, View view) {
            return this.family;
        }
    }

    class FontSize
    extends CssValue {
        float value;
        boolean index;
        LengthUnit lu;

        FontSize() {
        }

        int getValue(AttributeSet attributeSet, StyleSheet styleSheet) {
            AttributeSet attributeSet2;
            styleSheet = CSS.this.getStyleSheet(styleSheet);
            if (this.index) {
                return Math.round(CSS.this.getPointSize((int)this.value, styleSheet));
            }
            if (this.lu == null) {
                return Math.round(this.value);
            }
            if (this.lu.type == 0) {
                boolean bl = styleSheet == null ? false : styleSheet.isW3CLengthUnits();
                return Math.round(this.lu.getValue(bl));
            }
            if (attributeSet != null && (attributeSet2 = attributeSet.getResolveParent()) != null) {
                int n = StyleConstants.getFontSize(attributeSet2);
                float f = this.lu.type == 1 || this.lu.type == 3 ? this.lu.value * (float)n : this.lu.value + (float)n;
                return Math.round(f);
            }
            return 12;
        }

        @Override
        Object parseCssValue(String string) {
            FontSize fontSize = new FontSize();
            fontSize.svalue = string;
            try {
                if (string.equals("xx-small")) {
                    fontSize.value = 1.0f;
                    fontSize.index = true;
                } else if (string.equals("x-small")) {
                    fontSize.value = 2.0f;
                    fontSize.index = true;
                } else if (string.equals("small")) {
                    fontSize.value = 3.0f;
                    fontSize.index = true;
                } else if (string.equals("medium")) {
                    fontSize.value = 4.0f;
                    fontSize.index = true;
                } else if (string.equals("large")) {
                    fontSize.value = 5.0f;
                    fontSize.index = true;
                } else if (string.equals("x-large")) {
                    fontSize.value = 6.0f;
                    fontSize.index = true;
                } else if (string.equals("xx-large")) {
                    fontSize.value = 7.0f;
                    fontSize.index = true;
                } else {
                    fontSize.lu = new LengthUnit(string, 1, 1.0f);
                }
            }
            catch (NumberFormatException numberFormatException) {
                fontSize = null;
            }
            return fontSize;
        }

        @Override
        Object parseHtmlValue(String string) {
            if (string == null || string.length() == 0) {
                return null;
            }
            FontSize fontSize = new FontSize();
            fontSize.svalue = string;
            try {
                int n = CSS.this.getBaseFontSize();
                if (string.charAt(0) == '+') {
                    int n2 = Integer.valueOf(string.substring(1));
                    fontSize.value = n + n2;
                    fontSize.index = true;
                } else if (string.charAt(0) == '-') {
                    int n3 = -Integer.valueOf(string.substring(1)).intValue();
                    fontSize.value = n + n3;
                    fontSize.index = true;
                } else {
                    fontSize.value = Integer.parseInt(string);
                    if (fontSize.value > 7.0f) {
                        fontSize.value = 7.0f;
                    } else if (fontSize.value < 0.0f) {
                        fontSize.value = 0.0f;
                    }
                    fontSize.index = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                fontSize = null;
            }
            return fontSize;
        }

        @Override
        Object fromStyleConstants(StyleConstants styleConstants, Object object) {
            if (object instanceof Number) {
                FontSize fontSize = new FontSize();
                fontSize.value = CSS.getIndexOfSize(((Number)object).floatValue(), StyleSheet.sizeMapDefault);
                fontSize.svalue = Integer.toString((int)fontSize.value);
                fontSize.index = true;
                return fontSize;
            }
            return this.parseCssValue(object.toString());
        }

        @Override
        Object toStyleConstants(StyleConstants styleConstants, View view) {
            if (view != null) {
                return this.getValue(view.getAttributes(), null);
            }
            return this.getValue(null, null);
        }
    }

    static class StringValue
    extends CssValue {
        StringValue() {
        }

        @Override
        Object parseCssValue(String string) {
            StringValue stringValue = new StringValue();
            stringValue.svalue = string;
            return stringValue;
        }

        @Override
        Object fromStyleConstants(StyleConstants styleConstants, Object object) {
            if (styleConstants == StyleConstants.Italic) {
                if (object.equals(Boolean.TRUE)) {
                    return this.parseCssValue("italic");
                }
                return this.parseCssValue("");
            }
            if (styleConstants == StyleConstants.Underline) {
                if (object.equals(Boolean.TRUE)) {
                    return this.parseCssValue("underline");
                }
                return this.parseCssValue("");
            }
            if (styleConstants == StyleConstants.Alignment) {
                String string;
                int n = (Integer)object;
                switch (n) {
                    case 0: {
                        string = "left";
                        break;
                    }
                    case 2: {
                        string = "right";
                        break;
                    }
                    case 1: {
                        string = "center";
                        break;
                    }
                    case 3: {
                        string = "justify";
                        break;
                    }
                    default: {
                        string = "left";
                    }
                }
                return this.parseCssValue(string);
            }
            if (styleConstants == StyleConstants.StrikeThrough) {
                if (object.equals(Boolean.TRUE)) {
                    return this.parseCssValue("line-through");
                }
                return this.parseCssValue("");
            }
            if (styleConstants == StyleConstants.Superscript) {
                if (object.equals(Boolean.TRUE)) {
                    return this.parseCssValue("super");
                }
                return this.parseCssValue("");
            }
            if (styleConstants == StyleConstants.Subscript) {
                if (object.equals(Boolean.TRUE)) {
                    return this.parseCssValue("sub");
                }
                return this.parseCssValue("");
            }
            return null;
        }

        @Override
        Object toStyleConstants(StyleConstants styleConstants, View view) {
            if (styleConstants == StyleConstants.Italic) {
                if (this.svalue.indexOf("italic") >= 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (styleConstants == StyleConstants.Underline) {
                if (this.svalue.indexOf("underline") >= 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (styleConstants == StyleConstants.Alignment) {
                if (this.svalue.equals("right")) {
                    return new Integer(2);
                }
                if (this.svalue.equals("center")) {
                    return new Integer(1);
                }
                if (this.svalue.equals("justify")) {
                    return new Integer(3);
                }
                return new Integer(0);
            }
            if (styleConstants == StyleConstants.StrikeThrough) {
                if (this.svalue.indexOf("line-through") >= 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (styleConstants == StyleConstants.Superscript) {
                if (this.svalue.indexOf("super") >= 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (styleConstants == StyleConstants.Subscript) {
                if (this.svalue.indexOf("sub") >= 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            return null;
        }

        boolean isItalic() {
            return this.svalue.indexOf("italic") != -1;
        }

        boolean isStrike() {
            return this.svalue.indexOf("line-through") != -1;
        }

        boolean isUnderline() {
            return this.svalue.indexOf("underline") != -1;
        }

        boolean isSub() {
            return this.svalue.indexOf("sub") != -1;
        }

        boolean isSup() {
            return this.svalue.indexOf("sup") != -1;
        }
    }

    static class CssValue
    implements Serializable {
        String svalue;

        CssValue() {
        }

        Object parseCssValue(String string) {
            return string;
        }

        Object parseHtmlValue(String string) {
            return this.parseCssValue(string);
        }

        Object fromStyleConstants(StyleConstants styleConstants, Object object) {
            return null;
        }

        Object toStyleConstants(StyleConstants styleConstants, View view) {
            return null;
        }

        public String toString() {
            return this.svalue;
        }
    }

    static final class Value {
        static final Value INHERITED = new Value("inherited");
        static final Value NONE = new Value("none");
        static final Value HIDDEN = new Value("hidden");
        static final Value DOTTED = new Value("dotted");
        static final Value DASHED = new Value("dashed");
        static final Value SOLID = new Value("solid");
        static final Value DOUBLE = new Value("double");
        static final Value GROOVE = new Value("groove");
        static final Value RIDGE = new Value("ridge");
        static final Value INSET = new Value("inset");
        static final Value OUTSET = new Value("outset");
        static final Value DISC = new Value("disc");
        static final Value CIRCLE = new Value("circle");
        static final Value SQUARE = new Value("square");
        static final Value DECIMAL = new Value("decimal");
        static final Value LOWER_ROMAN = new Value("lower-roman");
        static final Value UPPER_ROMAN = new Value("upper-roman");
        static final Value LOWER_ALPHA = new Value("lower-alpha");
        static final Value UPPER_ALPHA = new Value("upper-alpha");
        static final Value BACKGROUND_NO_REPEAT = new Value("no-repeat");
        static final Value BACKGROUND_REPEAT = new Value("repeat");
        static final Value BACKGROUND_REPEAT_X = new Value("repeat-x");
        static final Value BACKGROUND_REPEAT_Y = new Value("repeat-y");
        static final Value BACKGROUND_SCROLL = new Value("scroll");
        static final Value BACKGROUND_FIXED = new Value("fixed");
        private String name;
        static final Value[] allValues = new Value[]{INHERITED, NONE, DOTTED, DASHED, SOLID, DOUBLE, GROOVE, RIDGE, INSET, OUTSET, DISC, CIRCLE, SQUARE, DECIMAL, LOWER_ROMAN, UPPER_ROMAN, LOWER_ALPHA, UPPER_ALPHA, BACKGROUND_NO_REPEAT, BACKGROUND_REPEAT, BACKGROUND_REPEAT_X, BACKGROUND_REPEAT_Y, BACKGROUND_FIXED, BACKGROUND_FIXED};

        private Value(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }
    }

    public static final class Attribute {
        private String name;
        private String defaultValue;
        private boolean inherited;
        public static final Attribute BACKGROUND = new Attribute("background", null, false);
        public static final Attribute BACKGROUND_ATTACHMENT = new Attribute("background-attachment", "scroll", false);
        public static final Attribute BACKGROUND_COLOR = new Attribute("background-color", "transparent", false);
        public static final Attribute BACKGROUND_IMAGE = new Attribute("background-image", "none", false);
        public static final Attribute BACKGROUND_POSITION = new Attribute("background-position", null, false);
        public static final Attribute BACKGROUND_REPEAT = new Attribute("background-repeat", "repeat", false);
        public static final Attribute BORDER = new Attribute("border", null, false);
        public static final Attribute BORDER_BOTTOM = new Attribute("border-bottom", null, false);
        public static final Attribute BORDER_BOTTOM_COLOR = new Attribute("border-bottom-color", null, false);
        public static final Attribute BORDER_BOTTOM_STYLE = new Attribute("border-bottom-style", "none", false);
        public static final Attribute BORDER_BOTTOM_WIDTH = new Attribute("border-bottom-width", "medium", false);
        public static final Attribute BORDER_COLOR = new Attribute("border-color", null, false);
        public static final Attribute BORDER_LEFT = new Attribute("border-left", null, false);
        public static final Attribute BORDER_LEFT_COLOR = new Attribute("border-left-color", null, false);
        public static final Attribute BORDER_LEFT_STYLE = new Attribute("border-left-style", "none", false);
        public static final Attribute BORDER_LEFT_WIDTH = new Attribute("border-left-width", "medium", false);
        public static final Attribute BORDER_RIGHT = new Attribute("border-right", null, false);
        public static final Attribute BORDER_RIGHT_COLOR = new Attribute("border-right-color", null, false);
        public static final Attribute BORDER_RIGHT_STYLE = new Attribute("border-right-style", "none", false);
        public static final Attribute BORDER_RIGHT_WIDTH = new Attribute("border-right-width", "medium", false);
        public static final Attribute BORDER_STYLE = new Attribute("border-style", "none", false);
        public static final Attribute BORDER_TOP = new Attribute("border-top", null, false);
        public static final Attribute BORDER_TOP_COLOR = new Attribute("border-top-color", null, false);
        public static final Attribute BORDER_TOP_STYLE = new Attribute("border-top-style", "none", false);
        public static final Attribute BORDER_TOP_WIDTH = new Attribute("border-top-width", "medium", false);
        public static final Attribute BORDER_WIDTH = new Attribute("border-width", "medium", false);
        public static final Attribute CLEAR = new Attribute("clear", "none", false);
        public static final Attribute COLOR = new Attribute("color", "black", true);
        public static final Attribute DISPLAY = new Attribute("display", "block", false);
        public static final Attribute FLOAT = new Attribute("float", "none", false);
        public static final Attribute FONT = new Attribute("font", null, true);
        public static final Attribute FONT_FAMILY = new Attribute("font-family", null, true);
        public static final Attribute FONT_SIZE = new Attribute("font-size", "medium", true);
        public static final Attribute FONT_STYLE = new Attribute("font-style", "normal", true);
        public static final Attribute FONT_VARIANT = new Attribute("font-variant", "normal", true);
        public static final Attribute FONT_WEIGHT = new Attribute("font-weight", "normal", true);
        public static final Attribute HEIGHT = new Attribute("height", "auto", false);
        public static final Attribute LETTER_SPACING = new Attribute("letter-spacing", "normal", true);
        public static final Attribute LINE_HEIGHT = new Attribute("line-height", "normal", true);
        public static final Attribute LIST_STYLE = new Attribute("list-style", null, true);
        public static final Attribute LIST_STYLE_IMAGE = new Attribute("list-style-image", "none", true);
        public static final Attribute LIST_STYLE_POSITION = new Attribute("list-style-position", "outside", true);
        public static final Attribute LIST_STYLE_TYPE = new Attribute("list-style-type", "disc", true);
        public static final Attribute MARGIN = new Attribute("margin", null, false);
        public static final Attribute MARGIN_BOTTOM = new Attribute("margin-bottom", "0", false);
        public static final Attribute MARGIN_LEFT = new Attribute("margin-left", "0", false);
        public static final Attribute MARGIN_RIGHT = new Attribute("margin-right", "0", false);
        static final Attribute MARGIN_LEFT_LTR = new Attribute("margin-left-ltr", Integer.toString(Integer.MIN_VALUE), false);
        static final Attribute MARGIN_LEFT_RTL = new Attribute("margin-left-rtl", Integer.toString(Integer.MIN_VALUE), false);
        static final Attribute MARGIN_RIGHT_LTR = new Attribute("margin-right-ltr", Integer.toString(Integer.MIN_VALUE), false);
        static final Attribute MARGIN_RIGHT_RTL = new Attribute("margin-right-rtl", Integer.toString(Integer.MIN_VALUE), false);
        public static final Attribute MARGIN_TOP = new Attribute("margin-top", "0", false);
        public static final Attribute PADDING = new Attribute("padding", null, false);
        public static final Attribute PADDING_BOTTOM = new Attribute("padding-bottom", "0", false);
        public static final Attribute PADDING_LEFT = new Attribute("padding-left", "0", false);
        public static final Attribute PADDING_RIGHT = new Attribute("padding-right", "0", false);
        public static final Attribute PADDING_TOP = new Attribute("padding-top", "0", false);
        public static final Attribute TEXT_ALIGN = new Attribute("text-align", null, true);
        public static final Attribute TEXT_DECORATION = new Attribute("text-decoration", "none", true);
        public static final Attribute TEXT_INDENT = new Attribute("text-indent", "0", true);
        public static final Attribute TEXT_TRANSFORM = new Attribute("text-transform", "none", true);
        public static final Attribute VERTICAL_ALIGN = new Attribute("vertical-align", "baseline", false);
        public static final Attribute WORD_SPACING = new Attribute("word-spacing", "normal", true);
        public static final Attribute WHITE_SPACE = new Attribute("white-space", "normal", true);
        public static final Attribute WIDTH = new Attribute("width", "auto", false);
        static final Attribute BORDER_SPACING = new Attribute("border-spacing", "0", true);
        static final Attribute CAPTION_SIDE = new Attribute("caption-side", "left", true);
        static final Attribute[] allAttributes = new Attribute[]{BACKGROUND, BACKGROUND_ATTACHMENT, BACKGROUND_COLOR, BACKGROUND_IMAGE, BACKGROUND_POSITION, BACKGROUND_REPEAT, BORDER, BORDER_BOTTOM, BORDER_BOTTOM_WIDTH, BORDER_COLOR, BORDER_LEFT, BORDER_LEFT_WIDTH, BORDER_RIGHT, BORDER_RIGHT_WIDTH, BORDER_STYLE, BORDER_TOP, BORDER_TOP_WIDTH, BORDER_WIDTH, BORDER_TOP_STYLE, BORDER_RIGHT_STYLE, BORDER_BOTTOM_STYLE, BORDER_LEFT_STYLE, BORDER_TOP_COLOR, BORDER_RIGHT_COLOR, BORDER_BOTTOM_COLOR, BORDER_LEFT_COLOR, CLEAR, COLOR, DISPLAY, FLOAT, FONT, FONT_FAMILY, FONT_SIZE, FONT_STYLE, FONT_VARIANT, FONT_WEIGHT, HEIGHT, LETTER_SPACING, LINE_HEIGHT, LIST_STYLE, LIST_STYLE_IMAGE, LIST_STYLE_POSITION, LIST_STYLE_TYPE, MARGIN, MARGIN_BOTTOM, MARGIN_LEFT, MARGIN_RIGHT, MARGIN_TOP, PADDING, PADDING_BOTTOM, PADDING_LEFT, PADDING_RIGHT, PADDING_TOP, TEXT_ALIGN, TEXT_DECORATION, TEXT_INDENT, TEXT_TRANSFORM, VERTICAL_ALIGN, WORD_SPACING, WHITE_SPACE, WIDTH, BORDER_SPACING, CAPTION_SIDE, MARGIN_LEFT_LTR, MARGIN_LEFT_RTL, MARGIN_RIGHT_LTR, MARGIN_RIGHT_RTL};
        private static final Attribute[] ALL_MARGINS = new Attribute[]{MARGIN_TOP, MARGIN_RIGHT, MARGIN_BOTTOM, MARGIN_LEFT};
        private static final Attribute[] ALL_PADDING = new Attribute[]{PADDING_TOP, PADDING_RIGHT, PADDING_BOTTOM, PADDING_LEFT};
        private static final Attribute[] ALL_BORDER_WIDTHS = new Attribute[]{BORDER_TOP_WIDTH, BORDER_RIGHT_WIDTH, BORDER_BOTTOM_WIDTH, BORDER_LEFT_WIDTH};
        private static final Attribute[] ALL_BORDER_STYLES = new Attribute[]{BORDER_TOP_STYLE, BORDER_RIGHT_STYLE, BORDER_BOTTOM_STYLE, BORDER_LEFT_STYLE};
        private static final Attribute[] ALL_BORDER_COLORS = new Attribute[]{BORDER_TOP_COLOR, BORDER_RIGHT_COLOR, BORDER_BOTTOM_COLOR, BORDER_LEFT_COLOR};

        private Attribute(String string, String string2, boolean bl) {
            this.name = string;
            this.defaultValue = string2;
            this.inherited = bl;
        }

        public String toString() {
            return this.name;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public boolean isInherited() {
            return this.inherited;
        }
    }
}

