/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth;

import com.ibm.security.util.ResourcesMgr;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.DomainCombiner;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.Security;
import java.text.MessageFormat;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;
import javax.security.auth.AuthPermission;
import javax.security.auth.PrivateCredentialPermission;
import javax.security.auth.SubjectDomainCombiner;
import sun.security.action.GetPropertyAction;

public final class Subject
implements Serializable {
    private static final long serialVersionUID = -8308522755600156056L;
    Set<Principal> principals;
    transient Set<Object> pubCredentials;
    transient Set<Object> privCredentials;
    private volatile boolean readOnly = false;
    private static Constructor combiner_constructor;
    private static ClassLoader sysClassLoader;
    private static Method getSub;
    private static Method doAsPA;
    private static Method doAsPEA;
    private static Method doAsPPA;
    private static Method doAsPPEA;
    private static boolean overrideActive;
    private static final int PRINCIPAL_SET = 1;
    private static final int PUB_CREDENTIAL_SET = 2;
    private static final int PRIV_CREDENTIAL_SET = 3;
    private static final ProtectionDomain[] NULL_PD_ARRAY;

    public Subject() {
        this.principals = Collections.synchronizedSet(new SecureSet(this, 1));
        this.pubCredentials = Collections.synchronizedSet(new SecureSet(this, 2));
        this.privCredentials = Collections.synchronizedSet(new SecureSet(this, 3));
    }

    public Subject(boolean bl, Set<? extends Principal> set, Set<?> set2, Set<?> set3) {
        Subject.collectionNullClean(set);
        Subject.collectionNullClean(set2);
        Subject.collectionNullClean(set3);
        this.principals = Collections.synchronizedSet(new SecureSet<Principal>(this, 1, set));
        this.pubCredentials = Collections.synchronizedSet(new SecureSet(this, 2, set2));
        this.privCredentials = Collections.synchronizedSet(new SecureSet(this, 3, set3));
        this.readOnly = bl;
    }

    public void setReadOnly() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(AuthPermissionHolder.SET_READ_ONLY_PERMISSION);
        }
        this.readOnly = true;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public static Subject getSubject(final AccessControlContext accessControlContext) {
        if (overrideActive) {
            try {
                return (Subject)getSub.invoke(null, accessControlContext);
            }
            catch (Exception exception) {
                if (exception instanceof IllegalAccessException || exception instanceof IllegalArgumentException) {
                    overrideActive = false;
                    throw new InternalError("doAsPrivileged error (" + exception.getMessage() + "), override ended");
                }
                if (exception instanceof InvocationTargetException) {
                    throw (RuntimeException)((InvocationTargetException)exception).getTargetException();
                }
                throw (RuntimeException)exception;
            }
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(AuthPermissionHolder.GET_SUBJECT_PERMISSION);
        }
        Objects.requireNonNull(accessControlContext, ResourcesMgr.getString("invalid null AccessControlContext provided"));
        return AccessController.doPrivileged(new PrivilegedAction<Subject>(){

            @Override
            public Subject run() {
                DomainCombiner domainCombiner = accessControlContext.getDomainCombiner();
                if (!(domainCombiner instanceof SubjectDomainCombiner)) {
                    return null;
                }
                SubjectDomainCombiner subjectDomainCombiner = (SubjectDomainCombiner)domainCombiner;
                return subjectDomainCombiner.getSubject();
            }
        });
    }

    public static <T> T doAs(Subject subject, PrivilegedAction<T> privilegedAction) {
        if (overrideActive) {
            try {
                return (T)doAsPA.invoke(null, subject, privilegedAction);
            }
            catch (Exception exception) {
                if (exception instanceof IllegalAccessException || exception instanceof IllegalArgumentException) {
                    overrideActive = false;
                    throw new InternalError("doAsPrivileged error (" + exception.getMessage() + "), override ended");
                }
                if (exception instanceof InvocationTargetException) {
                    throw (RuntimeException)((InvocationTargetException)exception).getTargetException();
                }
                throw (RuntimeException)exception;
            }
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(AuthPermissionHolder.DO_AS_PERMISSION);
        }
        Objects.requireNonNull(privilegedAction, ResourcesMgr.getString("invalid null action provided"));
        AccessControlContext accessControlContext = AccessController.getContext();
        return AccessController.doPrivileged(privilegedAction, Subject.createContext(subject, accessControlContext));
    }

    public static <T> T doAs(Subject subject, PrivilegedExceptionAction<T> privilegedExceptionAction) throws PrivilegedActionException {
        if (overrideActive) {
            try {
                return (T)doAsPEA.invoke(null, subject, privilegedExceptionAction);
            }
            catch (Exception exception) {
                if (exception instanceof IllegalAccessException || exception instanceof IllegalArgumentException) {
                    overrideActive = false;
                    throw new InternalError("doAsPrivileged error (" + exception.getMessage() + "), override ended");
                }
                if (exception instanceof InvocationTargetException) {
                    Throwable throwable = ((InvocationTargetException)exception).getTargetException();
                    if (throwable instanceof PrivilegedActionException) {
                        throw (PrivilegedActionException)throwable;
                    }
                    throw (RuntimeException)throwable;
                }
                throw (RuntimeException)exception;
            }
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(AuthPermissionHolder.DO_AS_PERMISSION);
        }
        Objects.requireNonNull(privilegedExceptionAction, ResourcesMgr.getString("invalid null action provided"));
        AccessControlContext accessControlContext = AccessController.getContext();
        return AccessController.doPrivileged(privilegedExceptionAction, Subject.createContext(subject, accessControlContext));
    }

    public static <T> T doAsPrivileged(Subject subject, PrivilegedAction<T> privilegedAction, AccessControlContext accessControlContext) {
        if (overrideActive) {
            try {
                return (T)doAsPPA.invoke(null, subject, privilegedAction, accessControlContext);
            }
            catch (Exception exception) {
                if (exception instanceof IllegalAccessException || exception instanceof IllegalArgumentException) {
                    overrideActive = false;
                    throw new InternalError("doAsPrivileged error (" + exception.getMessage() + "), override ended");
                }
                if (exception instanceof InvocationTargetException) {
                    throw (RuntimeException)((InvocationTargetException)exception).getTargetException();
                }
                throw (RuntimeException)exception;
            }
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(AuthPermissionHolder.DO_AS_PRIVILEGED_PERMISSION);
        }
        Objects.requireNonNull(privilegedAction, ResourcesMgr.getString("invalid null action provided"));
        AccessControlContext accessControlContext2 = accessControlContext == null ? new AccessControlContext(NULL_PD_ARRAY) : accessControlContext;
        return AccessController.doPrivileged(privilegedAction, Subject.createContext(subject, accessControlContext2));
    }

    public static <T> T doAsPrivileged(Subject subject, PrivilegedExceptionAction<T> privilegedExceptionAction, AccessControlContext accessControlContext) throws PrivilegedActionException {
        if (overrideActive) {
            try {
                return (T)doAsPPEA.invoke(null, subject, privilegedExceptionAction, accessControlContext);
            }
            catch (Exception exception) {
                if (exception instanceof IllegalAccessException || exception instanceof IllegalArgumentException) {
                    overrideActive = false;
                    throw new InternalError("doAsPrivileged error (" + exception.getMessage() + "), override ended");
                }
                if (exception instanceof InvocationTargetException) {
                    Throwable throwable = ((InvocationTargetException)exception).getTargetException();
                    if (throwable instanceof PrivilegedActionException) {
                        throw (PrivilegedActionException)throwable;
                    }
                    throw (RuntimeException)throwable;
                }
                throw (RuntimeException)exception;
            }
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(AuthPermissionHolder.DO_AS_PRIVILEGED_PERMISSION);
        }
        Objects.requireNonNull(privilegedExceptionAction, ResourcesMgr.getString("invalid null action provided"));
        AccessControlContext accessControlContext2 = accessControlContext == null ? new AccessControlContext(NULL_PD_ARRAY) : accessControlContext;
        return AccessController.doPrivileged(privilegedExceptionAction, Subject.createContext(subject, accessControlContext2));
    }

    private static AccessControlContext createContext(final Subject subject, final AccessControlContext accessControlContext) {
        return AccessController.doPrivileged(new PrivilegedAction<AccessControlContext>(){

            @Override
            public AccessControlContext run() {
                if (subject == null) {
                    return new AccessControlContext(accessControlContext, null);
                }
                try {
                    Object[] objectArray = new Object[]{subject};
                    DomainCombiner domainCombiner = (DomainCombiner)combiner_constructor.newInstance(objectArray);
                    return new AccessControlContext(accessControlContext, domainCombiner);
                }
                catch (Exception exception) {
                    throw new SecurityException(exception.toString());
                }
            }
        });
    }

    public Set<Principal> getPrincipals() {
        return this.principals;
    }

    public <T extends Principal> Set<T> getPrincipals(Class<T> clazz) {
        Objects.requireNonNull(clazz, ResourcesMgr.getString("invalid null Class provided"));
        return new ClassSet<T>(1, clazz);
    }

    public Set<Object> getPublicCredentials() {
        return this.pubCredentials;
    }

    public Set<Object> getPrivateCredentials() {
        return this.privCredentials;
    }

    public <T> Set<T> getPublicCredentials(Class<T> clazz) {
        Objects.requireNonNull(clazz, ResourcesMgr.getString("invalid null Class provided"));
        return new ClassSet<T>(2, clazz);
    }

    public <T> Set<T> getPrivateCredentials(Class<T> clazz) {
        Objects.requireNonNull(clazz, ResourcesMgr.getString("invalid null Class provided"));
        return new ClassSet<T>(3, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object instanceof Subject) {
            HashSet<Principal> hashSet;
            Subject subject = (Subject)object;
            Set<Principal> set = subject.principals;
            synchronized (set) {
                hashSet = new HashSet<Principal>(subject.principals);
            }
            if (!this.principals.equals(hashSet)) {
                return false;
            }
            Set<Object> set2 = subject.pubCredentials;
            synchronized (set2) {
                set = new HashSet<Object>(subject.pubCredentials);
            }
            if (!this.pubCredentials.equals(set)) {
                return false;
            }
            Set<Object> set3 = subject.privCredentials;
            synchronized (set3) {
                set2 = new HashSet<Object>(subject.privCredentials);
            }
            return this.privCredentials.equals(set2);
        }
        return false;
    }

    public String toString() {
        return this.toString(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String toString(boolean bl) {
        String string = ResourcesMgr.getString("Subject:\n");
        String string2 = "";
        Set<Object> set = this.principals;
        synchronized (set) {
            for (Principal object : this.principals) {
                string2 = string2 + ResourcesMgr.getString("\tPrincipal: ") + object.toString() + ResourcesMgr.getString("\n");
            }
        }
        set = this.pubCredentials;
        synchronized (set) {
            for (Object object : this.pubCredentials) {
                string2 = string2 + ResourcesMgr.getString("\tPublic Credential: ") + object.toString() + ResourcesMgr.getString("\n");
            }
        }
        if (bl) {
            set = this.privCredentials;
            synchronized (set) {
                Iterator<Object> iterator = this.privCredentials.iterator();
                while (iterator.hasNext()) {
                    try {
                        Object object = iterator.next();
                        string2 = string2 + ResourcesMgr.getString("\tPrivate Credential: ") + object.toString() + ResourcesMgr.getString("\n");
                    }
                    catch (SecurityException securityException) {
                        string2 = string2 + ResourcesMgr.getString("\tPrivate Credential inaccessible\n");
                        break;
                    }
                }
            }
        }
        return string + string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        int n = 0;
        Set<Object> set = this.principals;
        synchronized (set) {
            for (Principal principal : this.principals) {
                n ^= principal.hashCode();
            }
        }
        set = this.pubCredentials;
        synchronized (set) {
            Iterator<Object> iterator = this.pubCredentials.iterator();
            while (iterator.hasNext()) {
                n ^= this.getCredHashCode(iterator.next());
            }
        }
        return n;
    }

    private int getCredHashCode(Object object) {
        try {
            return object.hashCode();
        }
        catch (IllegalStateException illegalStateException) {
            return object.getClass().toString().hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Set<Principal> set = this.principals;
        synchronized (set) {
            objectOutputStream.defaultWriteObject();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        this.readOnly = getField.get("readOnly", false);
        Set set = (Set)getField.get("principals", null);
        Objects.requireNonNull(set, ResourcesMgr.getString("invalid null input(s)"));
        try {
            this.principals = Collections.synchronizedSet(new SecureSet(this, 1, set));
        }
        catch (NullPointerException nullPointerException) {
            this.principals = Collections.synchronizedSet(new SecureSet(this, 1));
        }
        this.pubCredentials = Collections.synchronizedSet(new SecureSet(this, 2));
        this.privCredentials = Collections.synchronizedSet(new SecureSet(this, 3));
    }

    private static void collectionNullClean(Collection<?> collection) {
        block5: {
            boolean bl = false;
            Objects.requireNonNull(collection, ResourcesMgr.getString("invalid null input(s)"));
            try {
                bl = collection.contains(null);
            }
            catch (NullPointerException nullPointerException) {
                bl = false;
            }
            finally {
                if (!bl) break block5;
                throw new NullPointerException(ResourcesMgr.getString("invalid null input(s)"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        overrideActive = false;
        NULL_PD_ARRAY = new ProtectionDomain[0];
        Object object = AccessController.doPrivileged(new GetPropertyAction("com.ibm.SubjectOverrideClassName"));
        if (object != null) {
            AccessController.doPrivileged(new PrivilegedAction((String)object){
                final /* synthetic */ String val$overrideName;
                {
                    this.val$overrideName = string;
                }

                public Object run() {
                    try {
                        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                        Class<?> clazz = Class.forName(this.val$overrideName, true, classLoader);
                        Class<?> clazz2 = Class.forName("java.security.AccessControlContext", true, classLoader);
                        Class<?> clazz3 = Class.forName("java.security.PrivilegedAction", true, classLoader);
                        Class<?> clazz4 = Class.forName("java.security.PrivilegedExceptionAction", true, classLoader);
                        Class<?> clazz5 = Class.forName("javax.security.auth.Subject", true, classLoader);
                        getSub = clazz.getMethod("getSubject", clazz2);
                        doAsPA = clazz.getMethod("doAs", clazz5, clazz3);
                        doAsPEA = clazz.getMethod("doAs", clazz5, clazz4);
                        doAsPPA = clazz.getMethod("doAsPrivileged", clazz5, clazz3, clazz2);
                        doAsPPEA = clazz.getMethod("doAsPrivileged", clazz5, clazz4, clazz2);
                        return null;
                    }
                    catch (Throwable throwable) {
                        throw new InternalError("Could not initialize Subject overrides from " + this.val$overrideName + " because " + throwable.getMessage());
                    }
                }
            });
            overrideActive = true;
        }
        if (sysClassLoader != null) return;
        object = Subject.class;
        synchronized (Subject.class) {
            Object object2;
            if (sysClassLoader != null) return;
            sysClassLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return ClassLoader.getSystemClassLoader();
                }
            });
            Class[] classArray = new Class[]{Subject.class};
            String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return Security.getProperty("combiner.provider");
                }
            });
            if (string == null) {
                string = "javax.security.auth.SubjectDomainCombiner";
            } else {
                object2 = System.getSecurityManager();
                if (object2 != null) {
                    ((SecurityManager)object2).checkPermission(new AuthPermission("specifyDomainCombiner"));
                }
            }
            try {
                object2 = Class.forName(string, true, sysClassLoader);
                combiner_constructor = ((Class)object2).getConstructor(classArray);
            }
            catch (Exception exception) {
                throw new SecurityException(exception.toString());
            }
            return;
        }
    }

    static class AuthPermissionHolder {
        static final AuthPermission DO_AS_PERMISSION = new AuthPermission("doAs");
        static final AuthPermission DO_AS_PRIVILEGED_PERMISSION = new AuthPermission("doAsPrivileged");
        static final AuthPermission SET_READ_ONLY_PERMISSION = new AuthPermission("setReadOnly");
        static final AuthPermission GET_SUBJECT_PERMISSION = new AuthPermission("getSubject");
        static final AuthPermission MODIFY_PRINCIPALS_PERMISSION = new AuthPermission("modifyPrincipals");
        static final AuthPermission MODIFY_PUBLIC_CREDENTIALS_PERMISSION = new AuthPermission("modifyPublicCredentials");
        static final AuthPermission MODIFY_PRIVATE_CREDENTIALS_PERMISSION = new AuthPermission("modifyPrivateCredentials");

        AuthPermissionHolder() {
        }
    }

    private class ClassSet<T>
    extends AbstractSet<T> {
        private int which;
        private Class<T> c;
        private Set<T> set;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ClassSet(int n, Class<T> clazz) {
            this.which = n;
            this.c = clazz;
            this.set = new HashSet<T>();
            switch (n) {
                case 1: {
                    Set<Principal> set = Subject.this.principals;
                    synchronized (set) {
                        this.populateSet();
                        break;
                    }
                }
                case 2: {
                    Set<Object> set = Subject.this.pubCredentials;
                    synchronized (set) {
                        this.populateSet();
                        break;
                    }
                }
                default: {
                    Set<Object> set = Subject.this.privCredentials;
                    synchronized (set) {
                        this.populateSet();
                        break;
                    }
                }
            }
        }

        private void populateSet() {
            Iterator<Object> iterator;
            switch (this.which) {
                case 1: {
                    iterator = Subject.this.principals.iterator();
                    break;
                }
                case 2: {
                    iterator = Subject.this.pubCredentials.iterator();
                    break;
                }
                default: {
                    iterator = Subject.this.privCredentials.iterator();
                }
            }
            while (iterator.hasNext()) {
                Object object = this.which == 3 ? AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        return iterator.next();
                    }
                }) : iterator.next();
                if (object == null || !this.c.isAssignableFrom(object.getClass())) continue;
                if (this.which != 3) {
                    this.set.add(object);
                    continue;
                }
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    securityManager.checkPermission(new PrivateCredentialPermission(object.getClass().getName(), Subject.this.getPrincipals()));
                }
                this.set.add(object);
            }
        }

        @Override
        public int size() {
            return this.set.size();
        }

        @Override
        public Iterator<T> iterator() {
            return this.set.iterator();
        }

        @Override
        public boolean add(T t) {
            if (!t.getClass().isAssignableFrom(this.c)) {
                MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("attempting to add an object which is not an instance of class"));
                Object[] objectArray = new Object[]{this.c.toString()};
                throw new SecurityException(messageFormat.format(objectArray));
            }
            return this.set.add(t);
        }
    }

    private static class SecureSet<E>
    implements Set<E>,
    Serializable {
        private static final long serialVersionUID = 7911754171111800359L;
        private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("this$0", Subject.class), new ObjectStreamField("elements", LinkedList.class), new ObjectStreamField("which", Integer.TYPE)};
        Subject subject;
        LinkedList<E> elements;
        private int which;

        SecureSet(Subject subject, int n) {
            this.subject = subject;
            this.which = n;
            this.elements = new LinkedList();
        }

        SecureSet(Subject subject, int n, Set<? extends E> set) {
            this.subject = subject;
            this.which = n;
            this.elements = new LinkedList<E>(set);
        }

        @Override
        public int size() {
            return this.elements.size();
        }

        @Override
        public Iterator<E> iterator() {
            final LinkedList<E> linkedList = this.elements;
            return new Iterator<E>(){
                ListIterator<E> i;
                {
                    this.i = linkedList.listIterator(0);
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public E next() {
                    if (which != 3) {
                        return this.i.next();
                    }
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) {
                        try {
                            securityManager.checkPermission(new PrivateCredentialPermission(linkedList.get(this.i.nextIndex()).getClass().getName(), subject.getPrincipals()));
                        }
                        catch (SecurityException securityException) {
                            this.i.next();
                            throw securityException;
                        }
                    }
                    return this.i.next();
                }

                @Override
                public void remove() {
                    if (subject.isReadOnly()) {
                        throw new IllegalStateException(ResourcesMgr.getString("Subject is read-only"));
                    }
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) {
                        switch (which) {
                            case 1: {
                                securityManager.checkPermission(AuthPermissionHolder.MODIFY_PRINCIPALS_PERMISSION);
                                break;
                            }
                            case 2: {
                                securityManager.checkPermission(AuthPermissionHolder.MODIFY_PUBLIC_CREDENTIALS_PERMISSION);
                                break;
                            }
                            default: {
                                securityManager.checkPermission(AuthPermissionHolder.MODIFY_PRIVATE_CREDENTIALS_PERMISSION);
                            }
                        }
                    }
                    this.i.remove();
                }
            };
        }

        @Override
        public boolean add(E e) {
            Objects.requireNonNull(e, ResourcesMgr.getString("invalid null input(s)"));
            if (this.subject.isReadOnly()) {
                throw new IllegalStateException(ResourcesMgr.getString("Subject is read-only"));
            }
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                switch (this.which) {
                    case 1: {
                        securityManager.checkPermission(AuthPermissionHolder.MODIFY_PRINCIPALS_PERMISSION);
                        break;
                    }
                    case 2: {
                        securityManager.checkPermission(AuthPermissionHolder.MODIFY_PUBLIC_CREDENTIALS_PERMISSION);
                        break;
                    }
                    default: {
                        securityManager.checkPermission(AuthPermissionHolder.MODIFY_PRIVATE_CREDENTIALS_PERMISSION);
                    }
                }
            }
            switch (this.which) {
                case 1: {
                    if (e instanceof Principal) break;
                    throw new SecurityException(ResourcesMgr.getString("attempting to add an object which is not an instance of java.security.Principal to a Subject's Principal Set"));
                }
            }
            if (!this.elements.contains(e)) {
                return this.elements.add(e);
            }
            return false;
        }

        @Override
        public boolean remove(Object object) {
            Objects.requireNonNull(object, ResourcesMgr.getString("invalid null input(s)"));
            final Iterator<E> iterator = this.iterator();
            while (iterator.hasNext()) {
                Object object2 = this.which != 3 ? iterator.next() : AccessController.doPrivileged(new PrivilegedAction<E>(){

                    @Override
                    public E run() {
                        return iterator.next();
                    }
                });
                if (!object2.equals(object)) continue;
                iterator.remove();
                return true;
            }
            return false;
        }

        @Override
        public boolean contains(Object object) {
            Objects.requireNonNull(object, ResourcesMgr.getString("invalid null input(s)"));
            final Iterator<E> iterator = this.iterator();
            while (iterator.hasNext()) {
                Object object2;
                if (this.which != 3) {
                    object2 = iterator.next();
                } else {
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) {
                        securityManager.checkPermission(new PrivateCredentialPermission(object.getClass().getName(), this.subject.getPrincipals()));
                    }
                    object2 = AccessController.doPrivileged(new PrivilegedAction<E>(){

                        @Override
                        public E run() {
                            return iterator.next();
                        }
                    });
                }
                if (!object2.equals(object)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            boolean bl = false;
            Subject.collectionNullClean(collection);
            for (E e : collection) {
                bl |= this.add(e);
            }
            return bl;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            Subject.collectionNullClean(collection);
            boolean bl = false;
            final Iterator<E> iterator = this.iterator();
            block0: while (iterator.hasNext()) {
                Object object = this.which != 3 ? iterator.next() : AccessController.doPrivileged(new PrivilegedAction<E>(){

                    @Override
                    public E run() {
                        return iterator.next();
                    }
                });
                Iterator<?> iterator2 = collection.iterator();
                while (iterator2.hasNext()) {
                    if (!object.equals(iterator2.next())) continue;
                    iterator.remove();
                    bl = true;
                    continue block0;
                }
            }
            return bl;
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            Subject.collectionNullClean(collection);
            for (Object obj : collection) {
                if (this.contains(obj)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            Subject.collectionNullClean(collection);
            boolean bl = false;
            final Iterator<E> iterator = this.iterator();
            while (iterator.hasNext()) {
                Object object = this.which != 3 ? iterator.next() : AccessController.doPrivileged(new PrivilegedAction<E>(){

                    @Override
                    public E run() {
                        return iterator.next();
                    }
                });
                if (collection.contains(object)) continue;
                iterator.remove();
                bl = true;
            }
            return bl;
        }

        @Override
        public void clear() {
            final Iterator<E> iterator = this.iterator();
            while (iterator.hasNext()) {
                Object object = this.which != 3 ? iterator.next() : AccessController.doPrivileged(new PrivilegedAction<E>(){

                    @Override
                    public E run() {
                        return iterator.next();
                    }
                });
                iterator.remove();
            }
        }

        @Override
        public boolean isEmpty() {
            return this.elements.isEmpty();
        }

        @Override
        public Object[] toArray() {
            Iterator<E> iterator = this.iterator();
            while (iterator.hasNext()) {
                iterator.next();
            }
            return this.elements.toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            Iterator<E> iterator = this.iterator();
            while (iterator.hasNext()) {
                iterator.next();
            }
            return this.elements.toArray(TArray);
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Set)) {
                return false;
            }
            Collection collection = (Collection)object;
            if (collection.size() != this.size()) {
                return false;
            }
            try {
                return this.containsAll(collection);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            int n = 0;
            for (E e : this) {
                if (e == null) continue;
                n += e.hashCode();
            }
            return n;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            Object object;
            if (this.which == 3) {
                object = this.iterator();
                while (object.hasNext()) {
                    object.next();
                }
            }
            object = objectOutputStream.putFields();
            ((ObjectOutputStream.PutField)object).put("this$0", this.subject);
            ((ObjectOutputStream.PutField)object).put("elements", this.elements);
            ((ObjectOutputStream.PutField)object).put("which", this.which);
            objectOutputStream.writeFields();
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            ObjectInputStream.GetField getField = objectInputStream.readFields();
            this.subject = (Subject)getField.get("this$0", null);
            this.which = getField.get("which", 0);
            LinkedList linkedList = (LinkedList)getField.get("elements", null);
            Subject.collectionNullClean(linkedList);
            this.elements = linkedList.getClass() != LinkedList.class ? new LinkedList(linkedList) : linkedList;
        }
    }
}

