/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import com.ibm.security.util.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.regex.Pattern;

public final class PKCS12Attribute
implements KeyStore.Entry.Attribute {
    private static final Pattern COLON_SEPARATED_HEX_PAIRS = Pattern.compile("^[0-9a-fA-F]{2}(:[0-9a-fA-F]{2})+$");
    private String name;
    private String value;
    private byte[] encoded;
    private int hashValue = -1;

    public PKCS12Attribute(String string, String string2) {
        ObjectIdentifier objectIdentifier;
        if (string == null || string2 == null) {
            throw new NullPointerException();
        }
        try {
            objectIdentifier = new ObjectIdentifier(string);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Incorrect format: name", iOException);
        }
        this.name = string;
        int n = string2.length();
        String[] stringArray = string2.charAt(0) == '[' && string2.charAt(n - 1) == ']' ? string2.substring(1, n - 1).split(", ") : new String[]{string2};
        this.value = string2;
        try {
            this.encoded = this.encode(objectIdentifier, stringArray);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Incorrect format: value", iOException);
        }
    }

    public PKCS12Attribute(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        this.encoded = (byte[])byArray.clone();
        try {
            this.parse(byArray);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Incorrect format: encoded", iOException);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public byte[] getEncoded() {
        return (byte[])this.encoded.clone();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PKCS12Attribute)) {
            return false;
        }
        return Arrays.equals(this.encoded, ((PKCS12Attribute)object).getEncoded());
    }

    public int hashCode() {
        if (this.hashValue == -1) {
            Arrays.hashCode(this.encoded);
        }
        return this.hashValue;
    }

    public String toString() {
        return this.name + "=" + this.value;
    }

    private byte[] encode(ObjectIdentifier objectIdentifier, String[] derOutputStream) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOID(objectIdentifier);
        DerOutputStream derOutputStream3 = new DerOutputStream();
        for (String string : derOutputStream) {
            if (COLON_SEPARATED_HEX_PAIRS.matcher(string).matches()) {
                byte[] byArray = new BigInteger(string.replace(":", ""), 16).toByteArray();
                if (byArray[0] == 0) {
                    byArray = Arrays.copyOfRange(byArray, 1, byArray.length);
                }
                derOutputStream3.putOctetString(byArray);
                continue;
            }
            derOutputStream3.putUTF8String(string);
        }
        derOutputStream2.write((byte)49, derOutputStream3);
        DerOutputStream derOutputStream4 = new DerOutputStream();
        derOutputStream4.write((byte)48, derOutputStream2);
        return derOutputStream4.toByteArray();
    }

    private void parse(byte[] byArray) throws IOException {
        DerInputStream derInputStream = new DerInputStream(byArray);
        DerValue[] derValueArray = derInputStream.getSequence(2);
        if (derValueArray.length != 2) {
            throw new IOException("Invalid length for PKCS12Attribute");
        }
        ObjectIdentifier objectIdentifier = derValueArray[0].getOID();
        DerInputStream derInputStream2 = new DerInputStream(derValueArray[1].toByteArray());
        DerValue[] derValueArray2 = derInputStream2.getSet(1);
        Object[] objectArray = new String[derValueArray2.length];
        for (int i = 0; i < derValueArray2.length; ++i) {
            String string;
            byte by = derValueArray2[i].getTag();
            objectArray[i] = by == 4 ? Debug.toString(derValueArray2[i].getOctetString()) : ((string = derValueArray2[i].getAsString()) != null ? string : (by == 6 ? derValueArray2[i].getOID().toString() : (by == 24 ? derValueArray2[i].getGeneralizedTime().toString() : (by == 23 ? derValueArray2[i].getUTCTime().toString() : (by == 2 ? derValueArray2[i].getBigInteger().toString() : (by == 1 ? String.valueOf(derValueArray2[i].getBoolean()) : Debug.toString(derValueArray2[i].getDataBytes())))))));
        }
        this.name = objectIdentifier.toString();
        this.value = objectArray.length == 1 ? objectArray[0] : Arrays.toString(objectArray);
    }
}

