/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.RDMASocketImpl;
import java.net.SocketException;
import java.net.SocketOutputStream;
import sun.net.ConnectionResetException;

class RDMASocketOutputStream
extends SocketOutputStream {
    private RDMASocketImpl impl = null;
    private byte[] temp = new byte[1];

    private static native void init();

    private native void socketWrite0(long var1, byte[] var3, int var4, int var5) throws IOException;

    private native void socketWrite0Direct(long var1, byte[] var3, int var4, int var5) throws IOException;

    RDMASocketOutputStream(RDMASocketImpl rDMASocketImpl) throws IOException {
        super(rDMASocketImpl);
        this.impl = rDMASocketImpl;
    }

    private void socketWrite(byte[] byArray, int n, int n2) throws IOException {
        if (n2 <= 0 || n < 0 || n + n2 > byArray.length) {
            if (n2 == 0) {
                return;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        try {
            if (this.impl.isZeroCopy() && n2 >= this.impl.getZeroCopyThreshold() * 1024) {
                this.socketWrite0Direct(this.impl.getSocketDataPtr(), byArray, n, n2);
            } else {
                this.socketWrite0(this.impl.getSocketDataPtr(), byArray, n, n2);
            }
        }
        catch (SocketException socketException) {
            SocketException socketException2;
            if (socketException instanceof ConnectionResetException) {
                this.impl.setConnectionResetPending();
                socketException2 = new SocketException("RDMA Connection reset");
            }
            if (this.impl.isClosedOrPending()) {
                throw new SocketException("RDMA Socket closed");
            }
            throw socketException2;
        }
    }

    @Override
    public void write(int n) throws IOException {
        this.temp[0] = (byte)n;
        this.socketWrite(this.temp, 0, 1);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.socketWrite(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.socketWrite(byArray, n, n2);
    }

    static {
        RDMASocketOutputStream.init();
    }
}

