/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.NetworkSelector;
import java.net.PlainSocketImpl;
import java.net.RDMASocketInputStream;
import java.net.RDMASocketOutputStream;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketTimeoutException;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;

class RDMASocketImpl
extends PlainSocketImpl {
    private RDMASocketInputStream socketInputStream = null;
    private RDMASocketOutputStream socketOutputStream = null;
    private long socketDataPtr = 0L;
    private final SocketImpl oldImpl;
    private boolean created = false;
    private final boolean zCopy;
    private final int zCopyThreshold;
    private static final boolean tcpFallback;
    private static final int DFLT_TCP_FALLBACK_WAIT_TIME = 100;
    private static final int MIN_TCP_FALLBACK_WAIT_TIME = 20;
    private static final int MAX_TCP_FALLBACK_WAIT_TIME = 10000;
    private static final int tcpFallbackWaitTime;
    private boolean tcpFallbackInPlace = false;
    private static final String connTimedOutStr = "Connection timed out";
    private static final String acceptTimedOutStr = "Accept timed out";
    private static final boolean nativeForkCompatibility;

    static native void initProtoRDMA();

    native long socketCreateRDMA(FileDescriptor var1) throws IOException;

    native void socketConnectRDMA(InetAddress var1, int var2, long var3, int var5) throws IOException;

    native void socketBindRDMA(InetAddress var1, int var2, long var3) throws IOException;

    native void socketListenRDMA(int var1, long var2) throws IOException;

    native long socketAcceptRDMA(SocketImpl var1, long var2, int var4) throws IOException;

    native void socketCloseRDMA(boolean var1, long var2) throws IOException;

    native void socketShutdownRDMA(int var1, long var2) throws IOException;

    native void socketSendUrgentDataRDMA(int var1, long var2) throws IOException;

    native void socketSetOptionRDMA(int var1, boolean var2, Object var3, long var4) throws SocketException;

    native int socketGetOptionRDMA(int var1, Object var2, long var3) throws SocketException;

    native int socketAvailableRDMA(long var1) throws IOException;

    private void socketCreatePrivate(FileDescriptor fileDescriptor) throws IOException {
        this.socketDataPtr = this.socketCreateRDMA(fileDescriptor);
        this.created = true;
        if (NetworkSelector.isDebugOn()) {
            System.out.printf("JSORI:NET:%X: RDMA socket created%n", this.hashCode());
        }
    }

    RDMASocketImpl(SocketImpl socketImpl, boolean bl, int n) {
        this.oldImpl = socketImpl;
        this.zCopy = bl;
        this.zCopyThreshold = n;
    }

    @Override
    protected void create(boolean bl) throws IOException {
        if (!bl) {
            throw new UnsupportedOperationException("Must be a stream socket for RDMA!");
        }
        super.create(bl);
    }

    @Override
    public boolean isClosedOrPending() {
        if (this.tcpFallbackInPlace) {
            return super.isClosedOrPending();
        }
        return this.socketDataPtr == 0L;
    }

    @Override
    protected synchronized InputStream getInputStream() throws IOException {
        if (this.tcpFallbackInPlace) {
            return super.getInputStream();
        }
        if (this.isClosedOrPending()) {
            throw new IOException("RDMA Socket Closed");
        }
        if (this.inputShut()) {
            throw new IOException("RDMA Socket input is shutdown");
        }
        if (this.socketInputStream == null) {
            this.socketInputStream = new RDMASocketInputStream(this);
            if (NetworkSelector.isDebugOn()) {
                System.out.printf("JSORI:NET:%X: RDMA socket input stream created%n", this.hashCode());
            }
        }
        return this.socketInputStream;
    }

    @Override
    protected synchronized OutputStream getOutputStream() throws IOException {
        if (this.tcpFallbackInPlace) {
            return super.getOutputStream();
        }
        if (this.isClosedOrPending()) {
            throw new IOException("RDMA Socket Closed");
        }
        if (this.outputShut()) {
            throw new IOException("RDMA Socket output is shutdown");
        }
        if (this.socketOutputStream == null) {
            this.socketOutputStream = new RDMASocketOutputStream(this);
            if (NetworkSelector.isDebugOn()) {
                System.out.printf("JSORI:NET:%X: RDMA socket output stream created%n", this.hashCode());
            }
        }
        return this.socketOutputStream;
    }

    @Override
    void processNRException(InetAddress inetAddress, int n, int n2) {
    }

    @Override
    void socketCreate(boolean bl) throws IOException {
        super.socketCreate(bl);
        this.socketCreatePrivate(null);
    }

    @Override
    void socketConnect(InetAddress inetAddress, int n, int n2) throws IOException {
        if (!this.created && this.oldImpl != null) {
            this.socketCreatePrivate(this.oldImpl.getFileDescriptor());
        }
        if (nativeForkCompatibility && !tcpFallback) {
            try {
                super.socketConnect(inetAddress, n, n2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            int n3 = 0;
            if (n2 < 0) {
                System.out.printf("JSORW:NET:%X: Invalid timeout parameter '%d' - defaulting to zero (infinite timeout)%n", this.hashCode(), n2);
                n3 = n2 = 0;
            } else {
                n3 = n2 > 0 ? n2 : 0;
            }
            this.socketConnectRDMA(inetAddress, n, this.socketDataPtr, n3);
            if (NetworkSelector.isDebugOn()) {
                System.out.printf("JSORI:NET:%X: RDMA connection established to %s:%d%n", this.hashCode(), inetAddress, n);
            }
        }
        catch (Exception exception) {
            this.socketCloseRDMA(false, this.socketDataPtr);
            this.socketDataPtr = 0L;
            if (exception instanceof SocketTimeoutException) {
                throw new SocketTimeoutException(exception.getMessage());
            }
            throw new IOException(exception.getMessage());
        }
    }

    @Override
    void socketBind(InetAddress inetAddress, int n) throws IOException {
        if (!this.created && this.oldImpl != null) {
            this.socketCreatePrivate(this.oldImpl.getFileDescriptor());
        }
        super.socketBind(inetAddress, n);
        this.socketBindRDMA(inetAddress, n, this.socketDataPtr);
        if (NetworkSelector.isDebugOn()) {
            System.out.printf("JSORI:NET:%X: RDMA socket bound to %s:%d%n", this.hashCode(), inetAddress, n);
        }
    }

    @Override
    void socketListen(int n) throws IOException {
        if (tcpFallback) {
            super.socketListen(n);
        }
        this.socketListenRDMA(n, this.socketDataPtr);
        if (NetworkSelector.isDebugOn()) {
            System.out.printf("JSORI:NET:%X: RDMA socket now in listening mode%n", this.hashCode());
        }
    }

    @Override
    void socketAccept(SocketImpl socketImpl) throws IOException {
        long l = 0L;
        if (!(socketImpl instanceof RDMASocketImpl)) {
            return;
        }
        try {
            int n = 0;
            int n2 = 0;
            n2 = this.getTimeout();
            if (n2 == 0 && this.oldImpl != null) {
                n2 = ((PlainSocketImpl)this.oldImpl).getTimeout();
            }
            n = tcpFallback ? tcpFallbackWaitTime : (n2 > 0 ? n2 : 0);
            l = this.socketAcceptRDMA(socketImpl, this.socketDataPtr, n);
            if (NetworkSelector.isDebugOn()) {
                System.out.printf("JSORI:NET:%X: Accepted RDMA connection request on %X%n", this.hashCode(), socketImpl.hashCode());
            }
        }
        catch (Exception exception) {
            if (exception instanceof SocketTimeoutException) {
                if (tcpFallback) {
                    super.socketAccept((PlainSocketImpl)socketImpl);
                    ((RDMASocketImpl)socketImpl).setTcpFallbackInPlace(true);
                    l = 0L;
                }
                throw new SocketTimeoutException(exception.getMessage());
            }
            throw new IOException(exception.getMessage());
        }
        ((RDMASocketImpl)socketImpl).setSocketDataPtr(l);
    }

    @Override
    void socketClose0(boolean bl) throws IOException {
        if (this.socketDataPtr != 0L) {
            this.socketCloseRDMA(bl, this.socketDataPtr);
            if (!bl) {
                this.socketDataPtr = 0L;
                if (NetworkSelector.isDebugOn()) {
                    System.out.printf("JSORI:NET:%X: RDMA socket closed%n", this.hashCode());
                }
            }
        }
        super.socketClose0(bl);
    }

    @Override
    void socketShutdown(int n) throws IOException {
        if (this.tcpFallbackInPlace) {
            super.socketShutdown(n);
        } else {
            this.socketShutdownRDMA(n, this.socketDataPtr);
            if (NetworkSelector.isDebugOn()) {
                System.out.printf("JSORI:NET:%X: RDMA socket closed for %s%n", this.hashCode(), n == 0 ? "read" : (n == 1 ? "write" : "read/write"));
            }
        }
    }

    @Override
    void socketSendUrgentData(int n) throws IOException {
        if (this.tcpFallbackInPlace) {
            super.socketSendUrgentData(n);
        } else {
            this.socketSendUrgentDataRDMA(n, this.socketDataPtr);
        }
    }

    @Override
    protected int getLocalPort() {
        if (this.tcpFallbackInPlace) {
            return super.getLocalPort();
        }
        if (NetworkSelector.isDebugOn()) {
            System.out.printf("JSORI:NET:%X: Retrieved RDMA socket local port %d%n", this.hashCode(), this.localport);
        }
        return this.localport;
    }

    @Override
    protected int getPort() {
        if (this.tcpFallbackInPlace) {
            return super.getPort();
        }
        if (NetworkSelector.isDebugOn()) {
            System.out.printf("JSORI:NET:%X: Retrieved RDMA socket remote port %d%n", this.hashCode(), this.port);
        }
        return this.port;
    }

    @Override
    protected InetAddress getInetAddress() {
        if (this.tcpFallbackInPlace) {
            return super.getInetAddress();
        }
        if (NetworkSelector.isDebugOn()) {
            System.out.printf("JSORI:NET:%X: Retrieved RDMA socket remote addr %s%n", this.hashCode(), this.address);
        }
        return this.address;
    }

    @Override
    protected void socketSetOption(int n, boolean bl, Object object) throws SocketException {
        if (this.tcpFallbackInPlace) {
            super.socketSetOption(n, bl, object);
        } else {
            switch (n) {
                case 1: 
                case 4: 
                case 8: 
                case 128: 
                case 4097: 
                case 4098: 
                case 4099: {
                    this.socketSetOptionRDMA(n, bl, object, this.socketDataPtr);
                    if (!NetworkSelector.isDebugOn()) break;
                    System.out.printf("JSORI:NET:%X: RDMA socket option 0x%x set to %s%n", this.hashCode(), n, bl);
                    break;
                }
            }
        }
    }

    @Override
    int socketGetOption(int n, Object object) throws SocketException {
        int n2 = -1;
        if (this.tcpFallbackInPlace) {
            n2 = super.socketGetOption(n, object);
        } else {
            switch (n) {
                case 1: 
                case 4: 
                case 8: 
                case 15: 
                case 128: 
                case 4097: 
                case 4098: 
                case 4099: {
                    n2 = this.socketGetOptionRDMA(n, object, this.socketDataPtr);
                    if (!NetworkSelector.isDebugOn()) break;
                    System.out.printf("JSORI:NET:%X: RDMA socket option 0x%x value %d%n", this.hashCode(), n, n2);
                    break;
                }
                default: {
                    n2 = -1;
                }
            }
        }
        return n2;
    }

    @Override
    int socketAvailable() throws IOException {
        if (this.tcpFallbackInPlace) {
            return super.socketAvailable();
        }
        return this.socketAvailableRDMA(this.socketDataPtr);
    }

    long getSocketDataPtr() {
        return this.socketDataPtr;
    }

    void setSocketDataPtr(long l) {
        this.socketDataPtr = l;
    }

    void setTcpFallbackInPlace(boolean bl) {
        this.tcpFallbackInPlace = bl;
        if (NetworkSelector.isDebugOn()) {
            System.out.printf("JSORI:NET:%X: TCP fallback mode in place for RDMA socket%n", this.hashCode());
        }
    }

    boolean isZeroCopy() {
        return this.zCopy;
    }

    int getZeroCopyThreshold() {
        return this.zCopyThreshold;
    }

    static {
        boolean bl = false;
        String string = null;
        String string2 = null;
        int n = 100;
        boolean bl2 = false;
        String string3 = null;
        RDMASocketImpl.initProtoRDMA();
        string = AccessController.doPrivileged(new GetPropertyAction("com.ibm.net.rdma.tcpFallback"));
        if (string != null) {
            bl = Boolean.parseBoolean(string);
        }
        tcpFallback = bl;
        string2 = AccessController.doPrivileged(new GetPropertyAction("com.ibm.net.rdma.tcpFallbackWaitTime"));
        if (string2 != null) {
            try {
                n = Integer.parseInt(string2);
                if (n < 20) {
                    System.out.printf("JSORW:NET: Invalid tcp fallback wait time '%d' - defaulting to %d milliseconds%n", n, 20);
                    n = 20;
                } else if (n > 10000) {
                    System.out.printf("JSORW:NET: Invalid tcp fallback wait time '%d' - defaulting to %d milliseconds%n", n, 10000);
                    n = 10000;
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("JSORW:NET: Invalid \"com.ibm.net.rdma.tcpFallbackWaitTime\" property value (" + numberFormatException.getMessage() + "): defaulting to " + 100 + " milliseconds");
                n = 100;
            }
        }
        tcpFallbackWaitTime = n;
        string3 = AccessController.doPrivileged(new GetPropertyAction("com.ibm.net.rdma.nativeForkCompatibility"));
        if (string3 != null) {
            bl2 = Boolean.parseBoolean(string3);
        }
        nativeForkCompatibility = bl2;
    }
}

