/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public class DataOutputStream
extends FilterOutputStream
implements DataOutput {
    protected int written;
    private byte[] bytearr = null;
    private byte[] writeBuffer = new byte[8];

    public DataOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    private void incCount(int n) {
        int n2 = this.written + n;
        if (n2 < 0) {
            n2 = Integer.MAX_VALUE;
        }
        this.written = n2;
    }

    @Override
    public synchronized void write(int n) throws IOException {
        this.out.write(n);
        this.incCount(1);
    }

    @Override
    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
        this.incCount(n2);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public final void writeBoolean(boolean bl) throws IOException {
        this.out.write(bl ? 1 : 0);
        this.incCount(1);
    }

    @Override
    public final void writeByte(int n) throws IOException {
        this.out.write(n);
        this.incCount(1);
    }

    @Override
    public final void writeShort(int n) throws IOException {
        this.out.write(n >>> 8 & 0xFF);
        this.out.write(n >>> 0 & 0xFF);
        this.incCount(2);
    }

    @Override
    public final void writeChar(int n) throws IOException {
        this.out.write(n >>> 8 & 0xFF);
        this.out.write(n >>> 0 & 0xFF);
        this.incCount(2);
    }

    @Override
    public final void writeInt(int n) throws IOException {
        this.writeBuffer[0] = (byte)(n >>> 24);
        this.writeBuffer[1] = (byte)(n >>> 16);
        this.writeBuffer[2] = (byte)(n >>> 8);
        this.writeBuffer[3] = (byte)(n >>> 0);
        this.out.write(this.writeBuffer, 0, 4);
        this.incCount(4);
    }

    @Override
    public final void writeLong(long l) throws IOException {
        this.writeBuffer[0] = (byte)(l >>> 56);
        this.writeBuffer[1] = (byte)(l >>> 48);
        this.writeBuffer[2] = (byte)(l >>> 40);
        this.writeBuffer[3] = (byte)(l >>> 32);
        this.writeBuffer[4] = (byte)(l >>> 24);
        this.writeBuffer[5] = (byte)(l >>> 16);
        this.writeBuffer[6] = (byte)(l >>> 8);
        this.writeBuffer[7] = (byte)(l >>> 0);
        this.out.write(this.writeBuffer, 0, 8);
        this.incCount(8);
    }

    @Override
    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    @Override
    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    @Override
    public final void writeBytes(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.out.write((byte)string.charAt(i));
        }
        this.incCount(n);
    }

    @Override
    public final void writeChars(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            this.out.write(c >>> 8 & 0xFF);
            this.out.write(c >>> 0 & 0xFF);
        }
        this.incCount(n * 2);
    }

    @Override
    public final void writeUTF(String string) throws IOException {
        DataOutputStream.writeUTF(string, this);
    }

    static int writeUTF(String string, DataOutput dataOutput) throws IOException {
        char c;
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            c = string.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++n2;
                continue;
            }
            if (c > '\u07ff') {
                n2 += 3;
                continue;
            }
            n2 += 2;
        }
        if (n2 > 65535) {
            throw new UTFDataFormatException("encoded string too long: " + n2 + " bytes");
        }
        byte[] byArray = null;
        if (dataOutput instanceof DataOutputStream) {
            DataOutputStream dataOutputStream = (DataOutputStream)dataOutput;
            if (dataOutputStream.bytearr == null || dataOutputStream.bytearr.length < n2 + 2) {
                dataOutputStream.bytearr = new byte[n2 * 2 + 2];
            }
            byArray = dataOutputStream.bytearr;
        } else {
            byArray = new byte[n2 + 2];
        }
        byArray[n3++] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n3++] = (byte)(n2 >>> 0 & 0xFF);
        int n4 = 0;
        for (n4 = 0; n4 < n && (c = string.charAt(n4)) >= '\u0001' && c <= '\u007f'; ++n4) {
            byArray[n3++] = (byte)c;
        }
        while (n4 < n) {
            c = string.charAt(n4);
            if (c >= '\u0001' && c <= '\u007f') {
                byArray[n3++] = (byte)c;
            } else if (c > '\u07ff') {
                byArray[n3++] = (byte)(0xE0 | c >> 12 & 0xF);
                byArray[n3++] = (byte)(0x80 | c >> 6 & 0x3F);
                byArray[n3++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                byArray[n3++] = (byte)(0xC0 | c >> 6 & 0x1F);
                byArray[n3++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            ++n4;
        }
        dataOutput.write(byArray, 0, n2 + 2);
        return n2 + 2;
    }

    public final int size() {
        return this.written;
    }
}

