/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.util;

import com.ibm.jvm.MemorySafetyService;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import sun.misc.SharedSecrets;

public class HashMapRT<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    transient Entry[] table;
    transient int size;
    int threshold;
    final float loadFactor;
    volatile transient int modCount;
    private transient int contentionFlag = 0;
    private transient Set<Map.Entry<K, V>> entrySet = null;
    volatile transient Set<K> keySet = null;
    volatile transient Collection<V> values = null;
    private static final long serialVersionUID = 362498820763181265L;

    private synchronized void onEntry() {
        switch (this.contentionFlag) {
            case 0: {
                this.contentionFlag = 1;
                break;
            }
            case 1: {
                this.contentionFlag = 2;
            }
            case 2: {
                throw new ConcurrentModificationException("concurrent access to HashMap attempted by " + Thread.currentThread());
            }
            default: {
                throw new RuntimeException("Unexpected contentionFlag " + this.contentionFlag);
            }
        }
    }

    private synchronized void onExit() {
        int n = this.contentionFlag;
        this.contentionFlag = 0;
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                throw new ConcurrentModificationException("concurrent access to HashMap attempted by " + Thread.currentThread());
            }
            default: {
                throw new RuntimeException("Unexpected contentionFlag " + n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMapRT(int n, float f) {
        int n2;
        if (n < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + n);
        }
        if (n > 0x40000000) {
            n = 0x40000000;
        }
        if (f <= 0.0f || Float.isNaN(f)) {
            throw new IllegalArgumentException("Illegal load factor: " + f);
        }
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        this.loadFactor = f;
        this.threshold = (int)((float)n2 * f);
        long l = -1L;
        try {
            l = MemorySafetyService.enterObjectsMemoryArea((Object)this);
            this.table = new Entry[n2];
        }
        finally {
            MemorySafetyService.exitLastMemoryArea((long)l);
        }
        this.init();
    }

    public HashMapRT(int n) {
        this(n, 0.75f);
    }

    public HashMapRT() {
        this.loadFactor = 0.75f;
        this.threshold = 12;
        long l = -1L;
        try {
            l = MemorySafetyService.enterObjectsMemoryArea((Object)this);
            this.table = new Entry[16];
        }
        finally {
            MemorySafetyService.exitLastMemoryArea((long)l);
        }
        this.init();
    }

    public HashMapRT(Map<? extends K, ? extends V> map) {
        this(Math.max((int)((float)map.size() / 0.75f) + 1, 16), 0.75f);
        this.putAllForCreate(map);
    }

    void init() {
    }

    static int hash(Object object) {
        int n = object == null ? 0 : object.hashCode();
        return n;
    }

    static boolean eq(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    static int indexFor(int n, int n2) {
        return n & n2 - 1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public V get(Object object) {
        int n = HashMapRT.hash(object);
        int n2 = HashMapRT.indexFor(n, this.table.length);
        Entry entry = this.table[n2];
        while (!(entry == null || entry.hash == n && HashMapRT.eq(object, entry.key))) {
            entry = entry.next;
        }
        if (entry == null) {
            return null;
        }
        return entry.value;
    }

    @Override
    public boolean containsKey(Object object) {
        int n = HashMapRT.hash(object);
        int n2 = HashMapRT.indexFor(n, this.table.length);
        Entry entry = this.table[n2];
        while (entry != null) {
            if (entry.hash == n && HashMapRT.eq(object, entry.key)) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    Entry<K, V> getEntry(Object object) {
        int n = HashMapRT.hash(object);
        int n2 = HashMapRT.indexFor(n, this.table.length);
        Entry entry = this.table[n2];
        while (!(entry == null || entry.hash == n && HashMapRT.eq(object, entry.key))) {
            entry = entry.next;
        }
        return entry;
    }

    @Override
    public V put(K k, V v) {
        int n = HashMapRT.hash(k);
        int n2 = HashMapRT.indexFor(n, this.table.length);
        Entry entry = this.table[n2];
        while (entry != null) {
            if (entry.hash == n && HashMapRT.eq(k, entry.key)) {
                Object v2 = entry.value;
                entry.value = v;
                entry.recordAccess(this);
                return v2;
            }
            entry = entry.next;
        }
        ++this.modCount;
        this.addEntry(n, k, v, n2);
        return null;
    }

    private void putForCreate(K k, V v) {
        int n = HashMapRT.hash(k);
        int n2 = HashMapRT.indexFor(n, this.table.length);
        Entry entry = this.table[n2];
        while (entry != null) {
            if (entry.hash == n && HashMapRT.eq(k, entry.key)) {
                entry.value = v;
                return;
            }
            entry = entry.next;
        }
        this.createEntry(n, k, v, n2);
    }

    void putAllForCreate(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.putForCreate(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resize(int n) {
        Entry[] entryArray = this.table;
        int n2 = entryArray.length;
        if (n2 == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] entryArray2 = null;
        long l = -1L;
        try {
            l = MemorySafetyService.enterObjectsMemoryArea((Object)this);
            entryArray2 = new Entry[n];
        }
        finally {
            MemorySafetyService.exitLastMemoryArea((long)l);
        }
        this.transfer(entryArray2);
        this.table = entryArray2;
        this.threshold = (int)((float)n * this.loadFactor);
    }

    void transfer(Entry[] entryArray) {
        this.onEntry();
        try {
            this.transfer0(entryArray);
        }
        finally {
            this.onExit();
        }
    }

    private void transfer0(Entry[] entryArray) {
        Entry[] entryArray2 = this.table;
        int n = entryArray.length;
        for (int i = 0; i < entryArray2.length; ++i) {
            Entry entry;
            Entry entry2 = entryArray2[i];
            if (entry2 == null) continue;
            entryArray2[i] = null;
            do {
                entry = entry2.next;
                int n2 = HashMapRT.indexFor(entry2.hash, n);
                entry2.next = entryArray[n2];
                entryArray[n2] = entry2;
            } while ((entry2 = entry) != null);
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        int n = map.size();
        if (n == 0) {
            return;
        }
        if (n > this.threshold) {
            int n2;
            int n3 = (int)((float)n / this.loadFactor + 1.0f);
            if (n3 > 0x40000000) {
                n3 = 0x40000000;
            }
            for (n2 = this.table.length; n2 < n3; n2 <<= 1) {
            }
            if (n2 > this.table.length) {
                this.resize(n2);
            }
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object object) {
        Entry<K, V> entry = this.removeEntryForKey(object);
        return entry == null ? null : (V)entry.value;
    }

    Entry<K, V> removeEntryForKey(Object object) {
        Entry entry;
        int n = HashMapRT.hash(object);
        int n2 = HashMapRT.indexFor(n, this.table.length);
        Entry entry2 = entry = this.table[n2];
        while (entry2 != null) {
            Entry entry3 = entry2.next;
            if (entry2.hash == n && HashMapRT.eq(object, entry2.key)) {
                ++this.modCount;
                --this.size;
                if (entry == entry2) {
                    this.table[n2] = entry3;
                } else {
                    entry.next = entry3;
                }
                entry2.recordRemoval(this);
                return entry2;
            }
            entry = entry2;
            entry2 = entry3;
        }
        return entry2;
    }

    Entry<K, V> removeMapping(Object object) {
        Entry entry;
        if (!(object instanceof Map.Entry)) {
            return null;
        }
        Map.Entry entry2 = (Map.Entry)object;
        Object k = entry2.getKey();
        int n = HashMapRT.hash(k);
        int n2 = HashMapRT.indexFor(n, this.table.length);
        Entry entry3 = entry = this.table[n2];
        while (entry3 != null) {
            Entry entry4 = entry3.next;
            if (entry3.hash == n && entry3.equals(entry2)) {
                ++this.modCount;
                --this.size;
                if (entry == entry3) {
                    this.table[n2] = entry4;
                } else {
                    entry.next = entry4;
                }
                entry3.recordRemoval(this);
                return entry3;
            }
            entry = entry3;
            entry3 = entry4;
        }
        return entry3;
    }

    @Override
    public void clear() {
        ++this.modCount;
        Entry[] entryArray = this.table;
        for (int i = 0; i < entryArray.length; ++i) {
            entryArray[i] = null;
        }
        this.size = 0;
    }

    @Override
    public boolean containsValue(Object object) {
        if (object == null) {
            return this.containsNullValue();
        }
        Entry[] entryArray = this.table;
        for (int i = 0; i < entryArray.length; ++i) {
            Entry entry = entryArray[i];
            while (entry != null) {
                if (object.equals(entry.value)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    private boolean containsNullValue() {
        Entry[] entryArray = this.table;
        for (int i = 0; i < entryArray.length; ++i) {
            Entry entry = entryArray[i];
            while (entry != null) {
                if (entry.value == null) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object clone() {
        HashMapRT hashMapRT = null;
        try {
            hashMapRT = (HashMapRT)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        long l = -1L;
        try {
            l = MemorySafetyService.enterObjectsMemoryArea((Object)this);
            hashMapRT.table = new Entry[this.table.length];
        }
        finally {
            MemorySafetyService.exitLastMemoryArea((long)l);
        }
        hashMapRT.entrySet = null;
        hashMapRT.modCount = 0;
        hashMapRT.size = 0;
        hashMapRT.init();
        hashMapRT.putAllForCreate(this);
        return hashMapRT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEntry(int n, K k, V v, int n2) {
        Entry entry = this.table[n2];
        long l = -1L;
        try {
            l = MemorySafetyService.enterSafeMemoryArea();
            this.table[n2] = new Entry<K, V>(n, k, v, entry);
        }
        finally {
            MemorySafetyService.exitLastMemoryArea((long)l);
        }
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createEntry(int n, K k, V v, int n2) {
        Entry entry = this.table[n2];
        long l = -1L;
        try {
            l = MemorySafetyService.enterSafeMemoryArea();
            this.table[n2] = new Entry<K, V>(n, k, v, entry);
        }
        finally {
            MemorySafetyService.exitLastMemoryArea((long)l);
        }
        ++this.size;
    }

    Iterator<K> newKeyIterator() {
        return new KeyIterator();
    }

    Iterator<V> newValueIterator() {
        return new ValueIterator();
    }

    Iterator<Map.Entry<K, V>> newEntryIterator() {
        return new EntryIterator();
    }

    @Override
    public Set<K> keySet() {
        KeySet keySet = this.keySet;
        return keySet != null ? keySet : (this.keySet = new KeySet());
    }

    @Override
    public Collection<V> values() {
        Values values = this.values;
        return values != null ? values : (this.values = new Values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet entrySet = this.entrySet;
        return entrySet != null ? entrySet : (this.entrySet = new EntrySet());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Iterator<Map.Entry<K, V>> iterator = this.entrySet().iterator();
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.table.length);
        objectOutputStream.writeInt(this.size);
        while (iterator.hasNext()) {
            Map.Entry<K, V> entry = iterator.next();
            objectOutputStream.writeObject(entry.getKey());
            objectOutputStream.writeObject(entry.getValue());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        SharedSecrets.getJavaOISAccess().checkArray(objectInputStream, Map.Entry[].class, n);
        this.table = new Entry[n];
        this.init();
        int n2 = objectInputStream.readInt();
        for (int i = 0; i < n2; ++i) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.putForCreate(object, object2);
        }
    }

    int capacity() {
        return this.table.length;
    }

    float loadFactor() {
        return this.loadFactor;
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        @Override
        public Iterator iterator() {
            return HashMapRT.this.newEntryIterator();
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Entry entry2 = HashMapRT.this.getEntry(entry.getKey());
            return entry2 != null && entry2.equals(entry);
        }

        @Override
        public boolean remove(Object object) {
            return HashMapRT.this.removeMapping(object) != null;
        }

        @Override
        public int size() {
            return HashMapRT.this.size;
        }

        @Override
        public void clear() {
            HashMapRT.this.clear();
        }
    }

    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return HashMapRT.this.newValueIterator();
        }

        @Override
        public int size() {
            return HashMapRT.this.size;
        }

        @Override
        public boolean contains(Object object) {
            return HashMapRT.this.containsValue(object);
        }

        @Override
        public void clear() {
            HashMapRT.this.clear();
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return HashMapRT.this.newKeyIterator();
        }

        @Override
        public int size() {
            return HashMapRT.this.size;
        }

        @Override
        public boolean contains(Object object) {
            return HashMapRT.this.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            return HashMapRT.this.removeEntryForKey(object) != null;
        }

        @Override
        public void clear() {
            HashMapRT.this.clear();
        }
    }

    private class EntryIterator
    extends HashIterator<Map.Entry<K, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    private class KeyIterator
    extends HashIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    private class ValueIterator
    extends HashIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }

    private abstract class HashIterator<E>
    implements Iterator<E> {
        Entry<K, V> next;
        int expectedModCount;
        int index;
        Entry<K, V> current;

        HashIterator() {
            this.expectedModCount = HashMapRT.this.modCount;
            Entry[] entryArray = HashMapRT.this.table;
            int n = entryArray.length;
            Entry entry = null;
            if (HashMapRT.this.size != 0) {
                while (n > 0 && (entry = entryArray[--n]) == null) {
                }
            }
            this.next = entry;
            this.index = n;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        Entry<K, V> nextEntry() {
            if (HashMapRT.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry entry = this.next;
            if (entry == null) {
                throw new NoSuchElementException();
            }
            Entry entry2 = entry.next;
            Entry[] entryArray = HashMapRT.this.table;
            int n = this.index;
            while (entry2 == null && n > 0) {
                entry2 = entryArray[--n];
            }
            this.index = n;
            this.next = entry2;
            this.current = entry;
            return this.current;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            if (HashMapRT.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Object k = this.current.key;
            this.current = null;
            HashMapRT.this.removeEntryForKey(k);
            this.expectedModCount = HashMapRT.this.modCount;
        }
    }

    static class Entry<K, V>
    implements Map.Entry<K, V> {
        final K key;
        V value;
        final int hash;
        Entry<K, V> next;

        Entry(int n, K k, V v, Entry<K, V> entry) {
            this.value = v;
            this.next = entry;
            this.key = k;
            this.hash = n;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v) {
            V v2 = this.value;
            this.value = v;
            return v2;
        }

        @Override
        public boolean equals(Object object) {
            Object v;
            V v2;
            Object k;
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            K k2 = this.getKey();
            return (k2 == (k = entry.getKey()) || k2 != null && k2.equals(k)) && ((v2 = this.getValue()) == (v = entry.getValue()) || v2 != null && v2.equals(v));
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }

        void recordAccess(HashMapRT<K, V> hashMapRT) {
        }

        void recordRemoval(HashMapRT<K, V> hashMapRT) {
        }
    }
}

