/*
 * Decompiled with CFR 0.152.
 */
package openj9.lang.management.internal;

import com.ibm.java.lang.management.internal.ManagementPermissionHelper;
import com.ibm.jvm.Dump;
import com.ibm.jvm.DumpConfigurationUnavailableException;
import com.ibm.jvm.InvalidDumpOptionException;
import com.ibm.oti.util.Msg;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import openj9.lang.management.ConfigurationUnavailableException;
import openj9.lang.management.InvalidOptionException;
import openj9.lang.management.OpenJ9DiagnosticsMXBean;

public final class OpenJ9DiagnosticsMXBeanImpl
implements OpenJ9DiagnosticsMXBean {
    private static final OpenJ9DiagnosticsMXBean instance = OpenJ9DiagnosticsMXBeanImpl.createInstance();

    private static OpenJ9DiagnosticsMXBean createInstance() {
        return new OpenJ9DiagnosticsMXBeanImpl();
    }

    @Override
    public void resetDumpOptions() throws ConfigurationUnavailableException {
        OpenJ9DiagnosticsMXBeanImpl.checkManagementSecurityPermission();
        try {
            Dump.resetDumpOptions();
        }
        catch (Exception e) {
            this.handleDumpConfigurationUnavailableException(e);
            throw OpenJ9DiagnosticsMXBeanImpl.handleError(e);
        }
    }

    @Override
    public String[] queryDumpOptions() {
        OpenJ9DiagnosticsMXBeanImpl.checkManagementSecurityPermission();
        try {
            return Dump.queryDumpOptions();
        }
        catch (Exception e) {
            throw OpenJ9DiagnosticsMXBeanImpl.handleError(e);
        }
    }

    @Override
    public void setDumpOptions(String dumpOptions) throws InvalidOptionException, ConfigurationUnavailableException {
        OpenJ9DiagnosticsMXBeanImpl.checkManagementSecurityPermission();
        try {
            Dump.setDumpOptions(dumpOptions);
        }
        catch (Exception e) {
            this.handleInvalidDumpOptionException(e);
            this.handleDumpConfigurationUnavailableException(e);
            throw OpenJ9DiagnosticsMXBeanImpl.handleError(e);
        }
    }

    @Override
    public void triggerDump(String dumpAgent) throws IllegalArgumentException {
        OpenJ9DiagnosticsMXBeanImpl.checkManagementSecurityPermission();
        switch (dumpAgent) {
            case "java": {
                Dump.JavaDump();
                break;
            }
            case "heap": {
                Dump.HeapDump();
                break;
            }
            case "system": {
                Dump.SystemDump();
                break;
            }
            case "snap": {
                Dump.SnapDump();
                break;
            }
            default: {
                throw new IllegalArgumentException(Msg.getString("K0663"));
            }
        }
    }

    @Override
    public String triggerDumpToFile(String dumpAgent, String fileNamePattern) throws IllegalArgumentException, InvalidOptionException {
        String fileName = null;
        OpenJ9DiagnosticsMXBeanImpl.checkManagementSecurityPermission();
        switch (dumpAgent) {
            case "java": {
                try {
                    fileName = Dump.javaDumpToFile(fileNamePattern);
                    break;
                }
                catch (Exception e) {
                    this.handleInvalidDumpOptionException(e);
                    throw OpenJ9DiagnosticsMXBeanImpl.handleError(e);
                }
            }
            case "heap": {
                try {
                    fileName = Dump.heapDumpToFile(fileNamePattern);
                    break;
                }
                catch (Exception e) {
                    this.handleInvalidDumpOptionException(e);
                    throw OpenJ9DiagnosticsMXBeanImpl.handleError(e);
                }
            }
            case "system": {
                try {
                    fileName = Dump.systemDumpToFile(fileNamePattern);
                    break;
                }
                catch (Exception e) {
                    this.handleInvalidDumpOptionException(e);
                    throw OpenJ9DiagnosticsMXBeanImpl.handleError(e);
                }
            }
            case "snap": {
                try {
                    fileName = Dump.snapDumpToFile(fileNamePattern);
                    break;
                }
                catch (Exception e) {
                    this.handleInvalidDumpOptionException(e);
                    throw OpenJ9DiagnosticsMXBeanImpl.handleError(e);
                }
            }
            default: {
                throw new IllegalArgumentException(Msg.getString("K0663"));
            }
        }
        return fileName;
    }

    @Override
    public String triggerClassicHeapDump() throws InvalidOptionException {
        String dumpOptions = "heap:opts=CLASSIC";
        OpenJ9DiagnosticsMXBeanImpl.checkManagementSecurityPermission();
        try {
            String fileName = Dump.triggerDump(dumpOptions);
            return fileName;
        }
        catch (Exception e) {
            this.handleInvalidDumpOptionException(e);
            throw OpenJ9DiagnosticsMXBeanImpl.handleError(e);
        }
    }

    private static void checkManagementSecurityPermission() {
        SecurityManager manager = System.getSecurityManager();
        if (manager != null) {
            manager.checkPermission(ManagementPermissionHelper.MPCONTROL);
        }
    }

    public static OpenJ9DiagnosticsMXBean getInstance() {
        return instance;
    }

    private OpenJ9DiagnosticsMXBeanImpl() {
    }

    @Override
    public ObjectName getObjectName() {
        try {
            return ObjectName.getInstance("openj9.lang.management:type=OpenJ9Diagnostics");
        }
        catch (MalformedObjectNameException e) {
            throw new InternalError(e);
        }
    }

    private static InternalError handleError(Exception error) {
        throw new InternalError(error.toString(), error);
    }

    private void handleInvalidDumpOptionException(Exception cause) throws InvalidOptionException {
        if (cause instanceof InvalidDumpOptionException) {
            throw new InvalidOptionException("Error in dump options specified", cause);
        }
    }

    private void handleDumpConfigurationUnavailableException(Exception cause) throws ConfigurationUnavailableException {
        if (cause instanceof DumpConfigurationUnavailableException) {
            throw new ConfigurationUnavailableException("Dump configuration cannot be changed while a dump is in progress", cause);
        }
    }
}

