/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.jit.JITHelpers;
import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.J9UnmodifiableClass;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import sun.misc.Unsafe;
import sun.misc.VM;
import sun.reflect.misc.ReflectUtil;

@J9UnmodifiableClass
final class J9VMInternals {
    private static final int j9Version = 100926064;
    private static final long j9Config = 8314596480236151296L;
    static final JITHelpers jitHelpers = JITHelpers.getHelpers();
    private static Map exceptions;
    static boolean initialized;
    private static Unsafe unsafe;

    private J9VMInternals() {
    }

    static void threadCompleteInitialization() {
        Thread.currentThread().internalSetContextClassLoader(ClassLoader.getSystemClassLoader());
        VM.booted();
    }

    private static void completeInitialization() {
        initialized = true;
        exceptions = new WeakHashMap();
        ClassLoader.completeInitialization();
        J9VMInternals.threadCompleteInitialization();
    }

    static void initialize(Class<?> clazz) {
        if (null != clazz.initializationLock) {
            Unsafe localUnsafe = unsafe;
            if (null == localUnsafe) {
                localUnsafe = unsafe = Unsafe.getUnsafe();
            }
            localUnsafe.ensureClassInitialized(clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializationAlreadyFailed(Class clazz) {
        NoClassDefFoundError notFound = new NoClassDefFoundError(clazz.getName() + " (initialization failure)");
        if (exceptions != null) {
            Map map = exceptions;
            synchronized (map) {
                Throwable reason;
                SoftReference weakReason = (SoftReference)exceptions.get(clazz);
                if (weakReason != null && (reason = (Throwable)weakReason.get()) != null) {
                    reason = J9VMInternals.copyThrowable(reason);
                    notFound.initCause(reason);
                }
            }
        }
        throw notFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void recordInitializationFailure(Class clazz, Throwable err) {
        if (initialized) {
            if (exceptions == null) {
                exceptions = new WeakHashMap();
            }
            Map map = exceptions;
            synchronized (map) {
                Throwable cause = err;
                if (err instanceof ExceptionInInitializerError && (cause = ((ExceptionInInitializerError)err).getException()) == null) {
                    cause = err;
                }
                exceptions.put(clazz, new SoftReference<Throwable>(J9VMInternals.copyThrowable(cause)));
            }
        }
        J9VMInternals.ensureError(err);
    }

    private static void ensureError(Throwable err) {
        if (err instanceof Error) {
            throw (Error)err;
        }
        throw new ExceptionInInitializerError(err);
    }

    private static native Throwable newInstance(Class var0, Class var1);

    private static Throwable cloneThrowable(final Throwable throwable, final HashMap hashMapThrowable) {
        return (Throwable)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Throwable clone;
                try {
                    Class cls = throwable.getClass();
                    clone = J9VMInternals.newInstance(cls, Object.class);
                    while (cls != null) {
                        Field[] fields = cls.getDeclaredFields();
                        for (int i = 0; i < fields.length; ++i) {
                            Object value;
                            if (Modifier.isStatic(fields[i].getModifiers()) || cls == Throwable.class && fields[i].getName().equals("walkback")) continue;
                            fields[i].setAccessible(true);
                            if (cls == Throwable.class && fields[i].getName().equals("cause")) {
                                value = clone;
                            } else {
                                value = fields[i].get(throwable);
                                if (value instanceof Throwable) {
                                    value = J9VMInternals.copyThrowable((Throwable)value, hashMapThrowable);
                                }
                            }
                            fields[i].set(clone, value);
                        }
                        cls = J9VMInternals.getSuperclass(cls);
                    }
                }
                catch (Throwable e) {
                    clone = new Throwable(Msg.getString("K05c3", e, throwable.toString()));
                }
                return clone;
            }
        });
    }

    private static Throwable copyThrowable(Throwable throwable) {
        HashMap hashMapThrowable = new HashMap();
        return J9VMInternals.copyThrowable(throwable, hashMapThrowable);
    }

    private static Throwable copyThrowable(Throwable throwable, HashMap hashMapThrowable) {
        if (hashMapThrowable.get(throwable) != null) {
            return throwable;
        }
        hashMapThrowable.put(throwable, throwable);
        Throwable root = J9VMInternals.cloneThrowable(throwable, hashMapThrowable);
        root.setStackTrace(throwable.getStackTrace());
        Throwable parent = root;
        for (Throwable cause = throwable.getCause(); cause != null && hashMapThrowable.get(cause) == null; cause = cause.getCause()) {
            hashMapThrowable.put(cause, cause);
            Throwable child = J9VMInternals.cloneThrowable(cause, hashMapThrowable);
            child.setStackTrace(cause.getStackTrace());
            parent.setCause(child);
            parent = child;
        }
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void threadCleanup(Thread thread) {
        try {
            thread.group.remove(thread);
        }
        finally {
            thread.exit();
            Thread thread2 = thread;
            synchronized (thread2) {
                thread.notifyAll();
            }
        }
    }

    private static void checkPackageAccess(final Class clazz, ProtectionDomain pd) {
        final SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            ProtectionDomain[] protectionDomainArray;
            if (pd == null) {
                protectionDomainArray = new ProtectionDomain[]{};
            } else {
                ProtectionDomain[] protectionDomainArray2 = new ProtectionDomain[1];
                protectionDomainArray = protectionDomainArray2;
                protectionDomainArray2[0] = pd;
            }
            ProtectionDomain[] pdArray = protectionDomainArray;
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    String packageName = clazz.getPackageName();
                    if (packageName != null) {
                        sm.checkPackageAccess(packageName);
                    }
                    if (Proxy.isProxyClass(clazz)) {
                        ClassLoader cl = clazz.getClassLoaderImpl();
                        ReflectUtil.checkProxyPackageAccess(cl, clazz.getInterfaces());
                    }
                    return null;
                }
            }, new AccessControlContext(pdArray));
        }
    }

    private static void runFinalize(Object obj) {
        try {
            obj.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static native StackTraceElement[] getStackTrace(Throwable var0, boolean var1);

    private static native void prepareClassImpl(Class var0);

    static void prepare(Class clazz) {
        if (clazz.initializationLock == null) {
            return;
        }
        J9VMInternals.prepareClassImpl(clazz);
    }

    static native Class getSuperclass(Class var0);

    static native Class[] getInterfaces(Class var0);

    static native Object newInstanceImpl(Class var0) throws IllegalAccessException, InstantiationException;

    static int fastIdentityHashCode(Object anObject) {
        JITHelpers h = jitHelpers;
        if (null == h) {
            return J9VMInternals.identityHashCode(anObject);
        }
        if (h.is32Bit()) {
            int ptr = h.getIntFromObject(anObject, 0L);
            if ((ptr & com.ibm.oti.vm.VM.OBJECT_HEADER_HAS_BEEN_MOVED_IN_CLASS) != 0 && !h.isArray(anObject)) {
                int j9class = ptr & com.ibm.oti.vm.VM.J9_JAVA_CLASS_MASK;
                return h.getIntFromObject(anObject, h.getBackfillOffsetFromJ9Class32(j9class));
            }
        } else {
            long ptr;
            long l = ptr = com.ibm.oti.vm.VM.FJ9OBJECT_SIZE == 4 ? Integer.toUnsignedLong(h.getIntFromObject(anObject, 0L)) : h.getLongFromObject(anObject, 0L);
            if ((ptr & (long)com.ibm.oti.vm.VM.OBJECT_HEADER_HAS_BEEN_MOVED_IN_CLASS) != 0L && !h.isArray(anObject)) {
                long j9class = ptr & (long)com.ibm.oti.vm.VM.J9_JAVA_CLASS_MASK;
                return h.getIntFromObject(anObject, h.getBackfillOffsetFromJ9Class64(j9class));
            }
        }
        return J9VMInternals.identityHashCode(anObject);
    }

    static native int identityHashCode(Object var0);

    static native Object primitiveClone(Object var0) throws CloneNotSupportedException;

    public static native void dumpString(String var0);

    private static String[] getClassInfoStrings(final Class<?> clazz, String classPath) {
        ClassLoader classLoader;
        String classLoaderStr = "<Bootstrap Loader>";
        String cpResult = "<Unknown>";
        if (classPath == null && (classLoader = clazz.getClassLoader()) != null) {
            classLoaderStr = classLoader.toString();
            classPath = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    String path = null;
                    try {
                        URL loc;
                        CodeSource cs;
                        ProtectionDomain pd = clazz.getProtectionDomain();
                        if (pd != null && (cs = pd.getCodeSource()) != null && (loc = cs.getLocation()) != null) {
                            path = loc.toString();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return path;
                }
            });
        }
        if (classPath != null) {
            cpResult = classPath;
        }
        String[] strings = new String[]{cpResult, classLoaderStr};
        return strings;
    }

    public static String formatNoSuchMethod(String methodSig, Class<?> clazz1, String classPath1, Class<?> clazz2, String classPath2) {
        String[] callingClassInfo = null;
        String[] calledClassInfo = null;
        try {
            callingClassInfo = J9VMInternals.getClassInfoStrings(clazz1, classPath1);
            calledClassInfo = J9VMInternals.getClassInfoStrings(clazz2, classPath2);
            Object[] args = new String[]{methodSig, callingClassInfo[0], callingClassInfo[1], clazz2.toString(), calledClassInfo[0], calledClassInfo[1]};
            return Msg.getString("K0613", "{0} (loaded from {1} by {2}) called from {3} (loaded from {4} by {5}).", args);
        }
        catch (Exception | VirtualMachineError e) {
            if (null == callingClassInfo || null == calledClassInfo) {
                return methodSig;
            }
            try {
                return methodSig + "(loaded from " + callingClassInfo[0] + " by " + callingClassInfo[1] + ") called from " + clazz2.toString() + " (loaded from " + calledClassInfo[0] + " by " + calledClassInfo[1] + ")";
            }
            catch (Exception | VirtualMachineError e2) {
                return methodSig;
            }
        }
    }

    static final class ClassInitializationLock {
        Class theClass;

        ClassInitializationLock() {
        }
    }
}

