/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.enc.dom;

import java.security.Key;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.enc.EncryptionMethod;
import javax.xml.crypto.enc.XMLDecryptContext;
import org.w3c.dom.Element;

public class DOMDecryptContext
extends DOMCryptoContext
implements XMLDecryptContext {
    private Element encData;
    private EncryptionMethod encMethod;

    public DOMDecryptContext(Key key, Element encData) {
        if (key == null) {
            throw new NullPointerException("key must not be null");
        }
        if (encData == null) {
            throw new NullPointerException("encData must not be null");
        }
        super.setKeySelector(KeySelector.singletonKeySelector(key));
        this.encData = encData;
    }

    public DOMDecryptContext(KeySelector ks, Element encData) {
        if (ks == null) {
            throw new NullPointerException("ks must not be null");
        }
        if (encData == null) {
            throw new NullPointerException("encData must not be null");
        }
        super.setKeySelector(ks);
        this.encData = encData;
    }

    @Override
    public EncryptionMethod getEncryptionMethod() {
        return this.encMethod;
    }

    @Override
    public void setEncryptionMethod(EncryptionMethod encMethod) {
        this.encMethod = encMethod;
    }

    public Element getEncryptedData() {
        return this.encData;
    }
}

