/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.enc;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.util.List;
import java.util.Map;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.NoSuchMechanismException;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.enc.CipherReference;
import javax.xml.crypto.enc.DataReference;
import javax.xml.crypto.enc.EncryptedData;
import javax.xml.crypto.enc.EncryptedType;
import javax.xml.crypto.enc.EncryptionMethod;
import javax.xml.crypto.enc.EncryptionProperties;
import javax.xml.crypto.enc.EncryptionProperty;
import javax.xml.crypto.enc.KeyReference;
import javax.xml.crypto.enc.ToBeEncrypted;
import javax.xml.crypto.enc.ToBeEncryptedKey;
import javax.xml.crypto.enc.XMLDecryptContext;
import javax.xml.crypto.enc.keyinfo.AgreementMethod;
import javax.xml.crypto.enc.keyinfo.DHKeyValue;
import javax.xml.crypto.enc.keyinfo.EncryptedKey;
import javax.xml.crypto.enc.spec.AgreementMethodParameterSpec;
import javax.xml.crypto.enc.spec.EncryptionMethodParameterSpec;

public abstract class XMLEncryptionFactory {
    private String mechanismType;
    private Provider provider;
    private static Class cl;
    private static final Class[] getImplParams;
    private static Method getImplMethod;

    protected XMLEncryptionFactory() {
    }

    public static XMLEncryptionFactory getInstance(String mechanismType) throws NoSuchMechanismException {
        if (mechanismType == null) {
            throw new NullPointerException("mechanismType cannot be null");
        }
        return XMLEncryptionFactory.findInstance(mechanismType, null);
    }

    private static XMLEncryptionFactory findInstance(String mechanismType, Provider provider) {
        if (getImplMethod == null) {
            throw new NoSuchMechanismException("Cannot find " + mechanismType + " mechanism type");
        }
        Object[] objs = null;
        try {
            objs = (Object[])getImplMethod.invoke(null, mechanismType, "XMLEncryptionFactory", provider);
        }
        catch (IllegalAccessException iae) {
            throw new NoSuchMechanismException("Cannot find " + mechanismType + " mechanism type", iae);
        }
        catch (InvocationTargetException ite) {
            throw new NoSuchMechanismException("Cannot find " + mechanismType + " mechanism type", ite);
        }
        XMLEncryptionFactory factory = (XMLEncryptionFactory)objs[0];
        factory.mechanismType = mechanismType;
        factory.provider = (Provider)objs[1];
        return factory;
    }

    public static XMLEncryptionFactory getInstance(String mechanismType, Provider provider) throws NoSuchMechanismException {
        if (mechanismType == null) {
            throw new NullPointerException("mechanismType cannot be null");
        }
        if (provider == null) {
            throw new NullPointerException("provider cannot be null");
        }
        return XMLEncryptionFactory.findInstance(mechanismType, provider);
    }

    public static XMLEncryptionFactory getInstance(String mechanismType, String provider) throws NoSuchProviderException, NoSuchMechanismException {
        if (mechanismType == null) {
            throw new NullPointerException("mechanismType cannot be null");
        }
        if (provider == null) {
            throw new NullPointerException("provider cannot be null");
        }
        Provider prov = Security.getProvider(provider);
        if (prov == null) {
            throw new NoSuchProviderException("cannot find provider named " + provider);
        }
        return XMLEncryptionFactory.findInstance(mechanismType, prov);
    }

    public static XMLEncryptionFactory getInstance() throws NoSuchMechanismException {
        return XMLEncryptionFactory.getInstance("DOM");
    }

    public final String getMechanismType() {
        return this.mechanismType;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public abstract EncryptedData newEncryptedData(ToBeEncrypted var1, EncryptionMethod var2, KeyInfo var3, EncryptionProperties var4, String var5);

    public abstract EncryptedData newEncryptedData(ToBeEncrypted var1, EncryptionMethod var2, KeyInfo var3, EncryptionProperties var4, String var5, CipherReference var6);

    public abstract DataReference newDataReference(String var1, List var2);

    public abstract KeyReference newKeyReference(String var1, List var2);

    public abstract EncryptionProperty newEncryptionProperty(List var1, String var2, String var3, Map var4);

    public abstract EncryptionProperties newEncryptionProperties(List var1, String var2);

    public abstract EncryptionMethod newEncryptionMethod(String var1, Integer var2, EncryptionMethodParameterSpec var3) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException;

    public abstract CipherReference newCipherReference(String var1, List var2);

    public abstract CanonicalizationMethod newCanonicalizationMethod(String var1, C14NMethodParameterSpec var2) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException;

    public abstract EncryptedType unmarshalEncryptedType(XMLDecryptContext var1) throws MarshalException;

    public abstract boolean isFeatureSupported(String var1);

    public abstract AgreementMethod newAgreementMethod(String var1, byte[] var2, KeyInfo var3, KeyInfo var4, AgreementMethodParameterSpec var5) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException;

    public abstract EncryptedKey newEncryptedKey(ToBeEncryptedKey var1, EncryptionMethod var2, KeyInfo var3, EncryptionProperties var4, List var5, String var6, String var7, String var8);

    public abstract EncryptedKey newEncryptedKey(ToBeEncryptedKey var1, EncryptionMethod var2, KeyInfo var3, EncryptionProperties var4, List var5, String var6, String var7, String var8, CipherReference var9);

    public abstract KeyInfo newOriginatorKeyInfo(List var1, String var2);

    public abstract KeyInfo newRecipientKeyInfo(List var1, String var2);

    public abstract DHKeyValue newDHKeyValue(PublicKey var1) throws KeyException;

    static {
        getImplParams = new Class[]{String.class, String.class, Provider.class};
        try {
            cl = Class.forName("javax.xml.crypto.enc.XMLEncSecurity");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        getImplMethod = (Method)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Method m = null;
                try {
                    m = cl.getDeclaredMethod("getImpl", getImplParams);
                    if (m != null) {
                        m.setAccessible(true);
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                return m;
            }
        });
    }
}

