/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.VM;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.DomainCombiner;
import java.security.Permission;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import sun.security.util.SecurityConstants;

public final class AccessControlContext {
    static final int STATE_NOT_AUTHORIZED = 0;
    static final int STATE_AUTHORIZED = 1;
    static final int STATE_UNKNOWN = 2;
    private static int debugSetting = -1;
    private static ArrayList<String> debugPermClassArray;
    private static ArrayList<String> debugPermNameArray;
    private static ArrayList<String> debugPermActionsArray;
    static ArrayList<URL> debugCodeBaseArray;
    private static final int DEBUG_UNINITIALIZED_HASCODEBASE = 0;
    private static final int DEBUG_NO_CODEBASE = 1;
    private static final int DEBUG_HAS_CODEBASE = 2;
    static final int DEBUG_DISABLED = 0;
    static final int DEBUG_ACCESS_DENIED = 1;
    static final int DEBUG_ENABLED = 2;
    DomainCombiner domainCombiner;
    ProtectionDomain[] context;
    int authorizeState = 2;
    private boolean containPrivilegedContext = false;
    private ProtectionDomain callerPD;
    AccessControlContext doPrivilegedAcc;
    boolean isLimitedContext = false;
    Permission[] limitedPerms;
    AccessControlContext nextStackAcc;
    private int debugHasCodebase;
    static final int DEBUG_ACCESS = 1;
    static final int DEBUG_ACCESS_STACK = 2;
    static final int DEBUG_ACCESS_DOMAIN = 4;
    static final int DEBUG_ACCESS_FAILURE = 8;
    static final int DEBUG_ACCESS_THREAD = 16;
    static final int DEBUG_ALL = 255;

    static int debugSetting() {
        if (debugSetting != -1) {
            return debugSetting;
        }
        debugSetting = 0;
        String value = VM.getVMLangAccess().internalGetProperties().getProperty("java.security.debug");
        if (value == null) {
            return debugSetting;
        }
        StreamTokenizer tokenizer = new StreamTokenizer(new StringReader(value));
        tokenizer.resetSyntax();
        tokenizer.wordChars(0, 0x10FFFF);
        tokenizer.quoteChar(34);
        tokenizer.whitespaceChars(44, 44);
        try {
            while (tokenizer.nextToken() != -1) {
                String keyword = tokenizer.sval;
                if (keyword.equals("all")) {
                    debugSetting = 255;
                    return debugSetting;
                }
                if (keyword.startsWith("access:")) {
                    debugSetting |= 1;
                    keyword = keyword.substring(7);
                }
                if (keyword.equals("access")) {
                    debugSetting |= 1;
                    continue;
                }
                if (keyword.equals("stack")) {
                    debugSetting |= 2;
                    continue;
                }
                if (keyword.equals("domain")) {
                    debugSetting |= 4;
                    continue;
                }
                if (keyword.equals("failure")) {
                    debugSetting |= 8;
                    continue;
                }
                if (keyword.equals("thread")) {
                    debugSetting |= 0x10;
                    continue;
                }
                if (keyword.startsWith("permission=")) {
                    String debugPermClass = keyword.substring(11);
                    if (debugPermClass.isEmpty() && tokenizer.nextToken() != -1) {
                        debugPermClass = tokenizer.sval;
                    }
                    if (null == debugPermClassArray) {
                        debugPermClassArray = new ArrayList();
                    }
                    debugPermClassArray.add(debugPermClass);
                    continue;
                }
                if (keyword.startsWith("codebase=")) {
                    String codebase = keyword.substring(9);
                    if (codebase.isEmpty() && tokenizer.nextToken() != -1) {
                        codebase = tokenizer.sval;
                    }
                    URL debugCodeBase = null;
                    try {
                        debugCodeBase = new URL(codebase);
                    }
                    catch (MalformedURLException e) {
                        System.err.println("Error setting -Djava.security.debug=access:codebase - " + e);
                    }
                    if (null == debugCodeBase) continue;
                    if (null == debugCodeBaseArray) {
                        debugCodeBaseArray = new ArrayList();
                    }
                    debugCodeBaseArray.add(debugCodeBase);
                    continue;
                }
                if (keyword.startsWith("permname=")) {
                    String debugPermName = keyword.substring(9);
                    if (debugPermName.isEmpty() && tokenizer.nextToken() != -1) {
                        debugPermName = tokenizer.sval;
                    }
                    if (null == debugPermNameArray) {
                        debugPermNameArray = new ArrayList();
                    }
                    debugPermNameArray.add(debugPermName);
                    continue;
                }
                if (!keyword.startsWith("permactions=")) continue;
                String debugPermActions = keyword.substring(12);
                if (debugPermActions.isEmpty() && tokenizer.nextToken() != -1) {
                    debugPermActions = tokenizer.sval;
                }
                if (null == debugPermActionsArray) {
                    debugPermActionsArray = new ArrayList();
                }
                debugPermActionsArray.add(debugPermActions);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (0 == (debugSetting & 1)) {
            debugSetting = 0;
        }
        return debugSetting;
    }

    static boolean debugPermission(Permission perm) {
        boolean result = true;
        if (debugPermClassArray != null) {
            result = false;
            String permClassName = perm.getClass().getName();
            for (String debugPermClass : debugPermClassArray) {
                if (!debugPermClass.equals(permClassName)) continue;
                return true;
            }
        }
        if (debugPermNameArray != null) {
            result = false;
            String permName = perm.getName();
            for (String debugPermName : debugPermNameArray) {
                if (!debugPermName.equals(permName)) continue;
                return true;
            }
        }
        if (debugPermActionsArray != null) {
            result = false;
            String permActions = perm.getActions();
            for (String debugPermActions : debugPermActionsArray) {
                if (!debugPermActions.equals(permActions)) continue;
                return true;
            }
        }
        return result;
    }

    boolean hasDebugCodeBase() {
        if (this.debugHasCodebase != 0) {
            return this.debugHasCodebase == 2;
        }
        ProtectionDomain[] pds = this.context;
        if (pds != null) {
            for (int i = 0; i < pds.length; ++i) {
                CodeSource cs;
                ProtectionDomain pd = this.context[i];
                CodeSource codeSource = cs = null == pd ? null : pd.getCodeSource();
                if (cs == null || !AccessControlContext.debugCodeBase(cs.getLocation())) continue;
                this.debugHasCodebase = 2;
                return true;
            }
            if (this.doPrivilegedAcc != null && this.doPrivilegedAcc.hasDebugCodeBase()) {
                this.debugHasCodebase = 2;
                return true;
            }
            if (this.nextStackAcc != null && this.nextStackAcc.hasDebugCodeBase()) {
                this.debugHasCodebase = 2;
                return true;
            }
        }
        this.debugHasCodebase = 1;
        return false;
    }

    static boolean debugCodeBase(URL location) {
        if (location != null) {
            for (URL debugCodeBase : debugCodeBaseArray) {
                if (!debugCodeBase.equals(location)) continue;
                return true;
            }
        }
        return false;
    }

    static void debugPrintAccess() {
        System.err.print("access: ");
        if ((AccessControlContext.debugSetting() & 0x10) == 16) {
            System.err.print("(" + Thread.currentThread() + ")");
        }
    }

    public AccessControlContext(ProtectionDomain[] fromContext) {
        int length = fromContext.length;
        if (length == 0) {
            this.context = null;
        } else {
            int domainIndex = 0;
            this.context = new ProtectionDomain[length];
            block0: for (int i = 0; i < length; ++i) {
                ProtectionDomain current = fromContext[i];
                if (current == null) continue;
                for (int j = 0; j < i; ++j) {
                    if (current == this.context[j]) continue block0;
                }
                this.context[domainIndex++] = current;
            }
            if (domainIndex == 0) {
                this.context = null;
            } else if (domainIndex != length) {
                ProtectionDomain[] copy = new ProtectionDomain[domainIndex];
                System.arraycopy((Object)this.context, 0, (Object)copy, 0, domainIndex);
                this.context = copy;
            }
        }
    }

    AccessControlContext(ProtectionDomain[] context, int authorizeState) {
        switch (authorizeState) {
            default: {
                throw new IllegalArgumentException();
            }
            case 0: 
            case 1: 
        }
        this.context = context;
        this.authorizeState = authorizeState;
        this.containPrivilegedContext = true;
    }

    AccessControlContext(AccessControlContext acc, ProtectionDomain[] context, int authorizeState) {
        switch (authorizeState) {
            default: {
                throw new IllegalArgumentException();
            }
            case 1: {
                if (null == acc) break;
                this.domainCombiner = acc.domainCombiner;
            }
            case 0: 
        }
        this.doPrivilegedAcc = acc;
        this.context = context;
        this.authorizeState = authorizeState;
        this.containPrivilegedContext = true;
    }

    public AccessControlContext(AccessControlContext acc, DomainCombiner combiner) {
        this(acc, combiner, false);
    }

    AccessControlContext(AccessControlContext acc, DomainCombiner combiner, boolean preauthorized) {
        SecurityManager security;
        if (!preauthorized && null != (security = System.getSecurityManager())) {
            security.checkPermission(SecurityConstants.CREATE_ACC_PERMISSION);
        }
        this.authorizeState = 1;
        this.context = acc.context;
        this.domainCombiner = combiner;
        this.containPrivilegedContext = acc.containPrivilegedContext;
        this.isLimitedContext = acc.isLimitedContext;
        this.limitedPerms = acc.limitedPerms;
        this.nextStackAcc = acc.nextStackAcc;
        this.doPrivilegedAcc = acc.doPrivilegedAcc;
    }

    private static Object[] combineObjs(boolean objPDs, Object[] checked, Object[] toBeCombined, int start, int len, boolean justCombine) {
        if (null == toBeCombined) {
            return checked;
        }
        int lenToBeCombined = Math.min(len, toBeCombined.length - start);
        if (0 == lenToBeCombined) {
            return checked;
        }
        int lenChecked = null == checked ? 0 : checked.length;
        Object[] answer = objPDs ? new ProtectionDomain[lenChecked + lenToBeCombined] : new Permission[lenChecked + lenToBeCombined];
        if (0 != lenChecked) {
            System.arraycopy((Object)checked, 0, (Object)answer, 0, lenChecked);
        }
        if (justCombine) {
            System.arraycopy((Object)toBeCombined, start, (Object)answer, lenChecked, lenToBeCombined);
        } else {
            int answerLength = lenChecked;
            block0: for (int i = 0; i < lenToBeCombined; ++i) {
                Object object = toBeCombined[start + i];
                if (null == object) continue;
                int j = answerLength;
                do {
                    if (--j >= 0) continue;
                    answer[answerLength] = object;
                    ++answerLength;
                    continue block0;
                } while (object != answer[j]);
            }
            if (answerLength < answer.length) {
                Object[] result = objPDs ? new ProtectionDomain[answerLength] : new Permission[answerLength];
                System.arraycopy((Object)answer, 0, (Object)result, 0, answerLength);
                answer = result;
            }
        }
        return answer;
    }

    static ProtectionDomain[] combinePDObjs(ProtectionDomain[] checked, Object[] toBeCombined) {
        return (ProtectionDomain[])AccessControlContext.combineObjs(true, checked, toBeCombined, 0, null != toBeCombined ? toBeCombined.length : 0, false);
    }

    static Permission[] combinePermObjs(Permission[] checked, Permission[] toBeCombined, int start, int len, boolean justCombine) {
        return (Permission[])AccessControlContext.combineObjs(false, checked, toBeCombined, start, len, justCombine);
    }

    static int checkPermWithCachedPDsImplied(Permission perm, Object[] toCheck, AccessCache cacheChecked) {
        if (null == toCheck) {
            return -1;
        }
        ProtectionDomain[] pdsImplied = null == cacheChecked ? null : cacheChecked.pdsImplied;
        int i = toCheck.length;
        block0: while (i > 0) {
            Object domain;
            if (null == (domain = toCheck[--i])) continue;
            if (null != pdsImplied) {
                for (int j = 0; j < pdsImplied.length; ++j) {
                    if (domain == pdsImplied[j]) continue block0;
                }
            }
            if (((ProtectionDomain)domain).implies(perm)) continue;
            return i;
        }
        if (null != cacheChecked) {
            cacheChecked.pdsImplied = AccessControlContext.combinePDObjs(pdsImplied, toCheck);
        }
        return -1;
    }

    static boolean checkPermWithCachedPermImplied(Permission perm, Permission[] permsLimited, AccessCache cacheChecked) {
        if (null == permsLimited) {
            return false;
        }
        Permission[] permsImplied = null;
        Permission[] permsNotImplied = null;
        if (null != cacheChecked) {
            permsImplied = cacheChecked.permsImplied;
            permsNotImplied = cacheChecked.permsNotImplied;
        }
        boolean success = false;
        int lenNotImplied = permsLimited.length;
        for (int j = 0; j < permsLimited.length; ++j) {
            if (null == permsLimited[j]) continue;
            if (null != permsImplied) {
                for (int k = 0; k < permsImplied.length; ++k) {
                    if (permsLimited[j] != permsImplied[k]) continue;
                    success = true;
                    break;
                }
                if (success) {
                    lenNotImplied = j;
                    break;
                }
            }
            boolean notImplied = false;
            if (null != permsNotImplied) {
                for (int k = 0; k < permsNotImplied.length; ++k) {
                    if (permsLimited[j] != permsNotImplied[k]) continue;
                    notImplied = true;
                    lenNotImplied = j;
                    break;
                }
            }
            if (notImplied || !permsLimited[j].implies(perm)) continue;
            success = true;
            if (null != cacheChecked) {
                cacheChecked.permsImplied = AccessControlContext.combinePermObjs(permsImplied, permsLimited, j, 1, true);
            }
            lenNotImplied = j;
            break;
        }
        if (0 < lenNotImplied && null != cacheChecked) {
            cacheChecked.permsNotImplied = AccessControlContext.combinePermObjs(permsNotImplied, permsLimited, 0, lenNotImplied, false);
        }
        return success;
    }

    static boolean checkPermissionWithCache(Permission perm, DomainCombiner activeDC, Object[] pdsContext, int debug, AccessControlContext accCurrent, boolean isLimited, Permission[] permsLimited, AccessControlContext accNext, AccessCache cacheChecked) throws AccessControlException {
        int i;
        if ((debug & 2) != 0 && (AccessControlContext.debugSetting() & 4) != 0) {
            AccessControlContext.debugPrintAccess();
            if (pdsContext == null || pdsContext.length == 0) {
                System.err.println("domain (context is null)");
            } else {
                for (i = 0; i < pdsContext.length; ++i) {
                    System.err.println("domain " + i + " " + pdsContext[i]);
                }
            }
        }
        if (null != pdsContext && 0 <= (i = AccessControlContext.checkPermWithCachedPDsImplied(perm, pdsContext, cacheChecked))) {
            if ((debug & 1) != 0) {
                if ((AccessControlContext.debugSetting() & 1) != 0) {
                    AccessControlContext.debugPrintAccess();
                    System.err.println("access denied " + perm);
                }
                if ((AccessControlContext.debugSetting() & 8) != 0) {
                    new Exception("Stack trace").printStackTrace();
                    System.err.println("domain that failed " + pdsContext[i]);
                }
            }
            throw new AccessControlException(Msg.getString("K002c", perm), perm);
        }
        if (null != accCurrent && (null != accCurrent.context || null != accCurrent.doPrivilegedAcc || null != accCurrent.limitedPerms || null != accCurrent.nextStackAcc)) {
            Object[] pdCombined = activeDC == null ? accCurrent.context : activeDC.combine((ProtectionDomain[])pdsContext, accCurrent.context);
            AccessControlContext.checkPermissionWithCache(perm, activeDC, pdCombined, debug, accCurrent.doPrivilegedAcc, accCurrent.isLimitedContext, accCurrent.limitedPerms, accCurrent.nextStackAcc, cacheChecked);
        }
        if (isLimited && null != permsLimited) {
            if (AccessControlContext.checkPermWithCachedPermImplied(perm, permsLimited, cacheChecked)) {
                return true;
            }
            if (null != accNext) {
                Object[] pdCombined = activeDC == null ? accNext.context : activeDC.combine((ProtectionDomain[])pdsContext, accNext.context);
                AccessControlContext.checkPermissionWithCache(perm, activeDC, pdCombined, debug, accNext.doPrivilegedAcc, accNext.isLimitedContext, accNext.limitedPerms, accNext.nextStackAcc, cacheChecked);
            }
            return false;
        }
        if ((debug & 2) != 0) {
            AccessControlContext.debugPrintAccess();
            System.err.println("access allowed " + perm);
        }
        return true;
    }

    private boolean debugHelper(Permission perm) {
        boolean debug = true;
        if (debugCodeBaseArray != null) {
            debug = this.hasDebugCodeBase();
        }
        if (debug) {
            debug = AccessControlContext.debugPermission(perm);
        }
        if (debug && (AccessControlContext.debugSetting() & 2) != 0) {
            new Exception("Stack trace for " + perm).printStackTrace();
        }
        return debug;
    }

    public void checkPermission(Permission perm) throws AccessControlException {
        boolean debug;
        if (perm == null) {
            throw new NullPointerException();
        }
        if (null != this.context && 1 != this.authorizeState && this.containPrivilegedContext && null != System.getSecurityManager()) {
            if (2 == this.authorizeState) {
                this.authorizeState = null == this.callerPD || this.callerPD.implies(SecurityConstants.CREATE_ACC_PERMISSION) ? 1 : 0;
                this.callerPD = null;
            }
            if (0 == this.authorizeState) {
                throw new AccessControlException(Msg.getString("K002d", perm, SecurityConstants.CREATE_ACC_PERMISSION), perm);
            }
        }
        boolean bl = debug = (AccessControlContext.debugSetting() & 1) != 0;
        if (debug) {
            debug = this.debugHelper(perm);
        }
        AccessControlContext.checkPermissionWithCache(perm, null, this.context, debug ? 3 : 0, this.doPrivilegedAcc, this.isLimitedContext, this.limitedPerms, this.nextStackAcc, new AccessCache());
    }

    private static boolean equalSets(Object[] s1, Object[] s2) {
        int length;
        if (s1 == null || (length = s1.length) == 0) {
            return s2 == null || s2.length == 0;
        }
        if (s2 == null || length != s2.length) {
            return false;
        }
        block0: for (int i = 0; i < length; ++i) {
            int j;
            Object object = s1[i];
            if (object == null) {
                for (j = 0; j < length; ++j) {
                    if (s2[j] == null) continue block0;
                }
            } else {
                for (j = 0; j < length; ++j) {
                    if (object.equals(s2[j])) continue block0;
                }
            }
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessControlContext otherContext = (AccessControlContext)o;
        if (null != this.domainCombiner ? !this.domainCombiner.equals(otherContext.domainCombiner) : null != otherContext.domainCombiner) {
            return false;
        }
        if (this.isLimitedContext != otherContext.isLimitedContext) {
            return false;
        }
        if (!AccessControlContext.equalSets(this.context, otherContext.context)) {
            return false;
        }
        if (null != this.doPrivilegedAcc && !this.doPrivilegedAcc.equals(otherContext.doPrivilegedAcc)) {
            return false;
        }
        if (this.isLimitedContext) {
            if (!AccessControlContext.equalSets(this.limitedPerms, otherContext.limitedPerms)) {
                return false;
            }
            if (null != this.nextStackAcc) {
                return this.nextStackAcc.equals(otherContext.nextStackAcc);
            }
        }
        return true;
    }

    public int hashCode() {
        int i;
        int result = 0;
        int n = i = this.context == null ? 0 : this.context.length;
        while (--i >= 0 && this.context[i] != null) {
            result ^= this.context[i].hashCode();
        }
        if (null != this.doPrivilegedAcc) {
            result ^= this.doPrivilegedAcc.hashCode();
        }
        if (this.isLimitedContext) {
            int n2 = i = this.limitedPerms == null ? 0 : this.limitedPerms.length;
            while (--i >= 0) {
                if (null == this.limitedPerms[i]) continue;
                result ^= this.limitedPerms[i].hashCode();
            }
            if (null != this.nextStackAcc) {
                result ^= this.nextStackAcc.hashCode();
            }
        }
        return result;
    }

    public DomainCombiner getDomainCombiner() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(SecurityConstants.GET_COMBINER_PERMISSION);
        }
        return this.domainCombiner;
    }

    DomainCombiner getCombiner() {
        return this.domainCombiner;
    }

    ProtectionDomain[] getContext() {
        return this.context;
    }

    AccessControlContext(ProtectionDomain[] domains, AccessControlContext acc) {
        this.context = AccessController.toArrayOfProtectionDomains(domains, acc, 0);
        this.authorizeState = 1;
        this.containPrivilegedContext = true;
        if (null != acc && 1 == acc.authorizeState) {
            this.domainCombiner = acc.domainCombiner;
        }
    }

    AccessControlContext optimize() {
        return this;
    }

    static final class AccessCache {
        ProtectionDomain[] pdsImplied;
        Permission[] permsImplied;
        Permission[] permsNotImplied;

        AccessCache() {
        }
    }
}

