/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.VM;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.invoke.InvokeExactHandle;
import java.lang.invoke.MethodTypeHelper;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public final class MethodType
implements Serializable {
    static final Class<?>[] EMTPY_PARAMS = new Class[0];
    private static Map<MethodType, WeakReference<MethodType>> internTable = Collections.synchronizedMap(new WeakHashMap());
    private static InternTableAddLock internTableAddLock = new InternTableAddLock();
    final Class<?> rtype;
    final Class<?>[] ptypes;
    int argSlots;
    int[] stackDescriptionBits;
    private String methodDescriptor;
    private int hashcode = 0;
    private InvokeExactHandle invoker;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];
    private static final long serialVersionUID = 292L;
    private DeserializedFieldsHolder deserializedFields;

    private MethodType(Class<?> rtype, Class<?>[] ptypes, boolean copyArguments) {
        this.rtype = rtype;
        if (copyArguments) {
            this.ptypes = new Class[ptypes.length];
            System.arraycopy(ptypes, 0, this.ptypes, 0, ptypes.length);
        } else {
            this.ptypes = ptypes;
        }
    }

    private final int[] stackDescriptionBits(Class<?>[] args, int stackSlots) {
        int neededInts = (stackSlots + 1 + 31) / 32;
        int[] ints = new int[neededInts];
        int index = 0;
        int argBit = 1;
        int curr = 0;
        curr |= argBit;
        argBit <<= 1;
        for (Class<?> c : args) {
            if (c.isPrimitive()) {
                if ((c.equals(Double.TYPE) || c.equals(Long.TYPE)) && (argBit <<= 1) == 0) {
                    argBit = 1;
                    ints[index] = curr;
                    ++index;
                    curr = 0;
                }
            } else {
                curr |= argBit;
            }
            if ((argBit <<= 1) != 0) continue;
            argBit = 1;
            ints[index] = curr;
            ++index;
            curr = 0;
        }
        if (index < ints.length) {
            ints[index] = curr;
        }
        return ints;
    }

    public MethodType changeParameterType(int position, Class<?> type) {
        Class[] newParameters = (Class[])this.ptypes.clone();
        newParameters[position] = type;
        return MethodType.methodType(this.rtype, newParameters, false);
    }

    public MethodType changeReturnType(Class<?> type) {
        return MethodType.methodType(type, this.ptypes, false);
    }

    public MethodType dropParameterTypes(int startPosition, int endPosition) throws IndexOutOfBoundsException {
        if (startPosition >= 0 && endPosition >= 0 && startPosition <= endPosition && endPosition <= this.ptypes.length) {
            int delta = endPosition - startPosition;
            Class[] newParameters = new Class[this.ptypes.length - delta];
            System.arraycopy(this.ptypes, 0, (Object)newParameters, 0, startPosition);
            System.arraycopy(this.ptypes, endPosition, (Object)newParameters, startPosition, this.ptypes.length - endPosition);
            return MethodType.methodType(this.rtype, newParameters, false);
        }
        throw new IndexOutOfBoundsException("'" + this + "' startPosition=" + startPosition + " endPosition=" + endPosition);
    }

    MethodType dropFirstParameterType() throws IndexOutOfBoundsException {
        if (this.ptypes.length == 0) {
            throw new IndexOutOfBoundsException();
        }
        return MethodType.methodType(this.rtype, Arrays.copyOfRange(this.ptypes, 1, this.ptypes.length), false);
    }

    public boolean equals(Object x) {
        if (this == x) {
            return true;
        }
        if (!(x instanceof MethodType)) {
            return false;
        }
        MethodType that = (MethodType)x;
        if (this.ptypes.length != that.ptypes.length || this.rtype != that.rtype) {
            return false;
        }
        return Arrays.equals(this.ptypes, that.ptypes);
    }

    public MethodType erase() {
        Class[] newParameters = (Class[])this.ptypes.clone();
        for (int i = 0; i < newParameters.length; ++i) {
            if (newParameters[i].isPrimitive()) continue;
            newParameters[i] = Object.class;
        }
        return MethodType.methodType(this.rtype.isPrimitive() ? this.rtype : Object.class, newParameters, false);
    }

    public static MethodType fromMethodDescriptorString(String methodDescriptor, ClassLoader loader) {
        Map<String, MethodType> classLoaderMethodTypeCache;
        MethodType mt;
        ClassLoader classLoader = loader;
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        MethodType methodType = mt = (classLoaderMethodTypeCache = VM.getVMLangAccess().getMethodTypeCache(classLoader)) != null ? classLoaderMethodTypeCache.get(methodDescriptor) : null;
        if (null == mt) {
            if (methodDescriptor.indexOf(46) != -1) {
                throw new IllegalArgumentException(methodDescriptor);
            }
            ArrayList<Class<?>> classes = MethodType.parseIntoClasses(methodDescriptor, classLoader);
            if (classes.size() == 0) {
                throw new IllegalArgumentException(methodDescriptor);
            }
            Class<?> returnType = classes.remove(classes.size() - 1);
            mt = MethodType.methodType(returnType, classes);
            if (classLoaderMethodTypeCache != null) {
                classLoaderMethodTypeCache.put(mt.methodDescriptor, mt);
            }
        }
        return mt;
    }

    private static final MethodType fromMethodDescriptorStringAppendArg(String methodDescriptor, ClassLoader loader, Class<?> appendArgumentType) {
        ArrayList<Class<?>> types = MethodType.parseIntoClasses(methodDescriptor, loader);
        Class returnType = (Class)types.remove(types.size() - 1);
        types.add(appendArgumentType);
        return MethodType.methodType(returnType, types);
    }

    private static final Throwable throwNoClassDefFoundError(TypeNotPresentException e) {
        Throwable cause = e.getCause();
        if (cause instanceof ClassNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(cause.getMessage());
            noClassDefFoundError.initCause(cause);
            throw noClassDefFoundError;
        }
        throw e;
    }

    private static final ArrayList<Class<?>> parseIntoClasses(String methodDescriptor, ClassLoader classLoader) {
        int length = methodDescriptor.length();
        if (length == 0) {
            throw new IllegalArgumentException(Msg.getString("K05d3", methodDescriptor));
        }
        char[] signature = new char[length];
        methodDescriptor.getChars(0, length, signature, 0);
        int index = 0;
        boolean closeBracket = false;
        if (signature[index] != '(') {
            throw new IllegalArgumentException(Msg.getString("K05d4", methodDescriptor));
        }
        ++index;
        ArrayList args = new ArrayList();
        while (index < length) {
            if (signature[index] == ')') {
                if (closeBracket) {
                    throw new IllegalArgumentException(Msg.getString("K05d5", methodDescriptor));
                }
                closeBracket = true;
                ++index;
                continue;
            }
            index = MethodTypeHelper.parseIntoClass(signature, index, args, classLoader, methodDescriptor);
            ++index;
        }
        return args;
    }

    public MethodType generic() {
        return MethodType.genericMethodType(this.ptypes.length);
    }

    public int hashCode() {
        if (this.hashcode == 0) {
            int hash = 31 + this.rtype.hashCode();
            for (Class<?> c : this.ptypes) {
                hash = 31 * hash + c.hashCode();
            }
            this.hashcode = hash;
        }
        return this.hashcode;
    }

    public boolean hasPrimitives() {
        if (this.rtype.isPrimitive()) {
            return true;
        }
        for (Class<?> c : this.ptypes) {
            if (!c.isPrimitive()) continue;
            return true;
        }
        return false;
    }

    public boolean hasWrappers() {
        if (MethodTypeHelper.WRAPPER_SET.contains(this.rtype) || this.rtype == Void.class) {
            return true;
        }
        for (Class<?> c : this.ptypes) {
            if (!MethodTypeHelper.WRAPPER_SET.contains(c)) continue;
            return true;
        }
        return false;
    }

    public MethodType insertParameterTypes(int position, Class<?> ... types) throws IndexOutOfBoundsException {
        if (position < 0 || position > this.ptypes.length) {
            throw new IndexOutOfBoundsException();
        }
        int typesLength = types.length;
        if (typesLength == 0) {
            return this;
        }
        Class[] params = new Class[this.ptypes.length + typesLength];
        System.arraycopy(this.ptypes, 0, (Object)params, 0, position);
        System.arraycopy(types, 0, (Object)params, position, typesLength);
        System.arraycopy(this.ptypes, position, (Object)params, position + typesLength, this.ptypes.length - position);
        return MethodType.methodType(this.rtype, params, false);
    }

    public MethodType insertParameterTypes(int position, List<Class<?>> types) {
        return this.insertParameterTypes(position, types.toArray(new Class[types.size()]));
    }

    public static MethodType methodType(Class<?> type) {
        return MethodType.methodType(type, EMTPY_PARAMS, false);
    }

    public static MethodType methodType(Class<?> type, Class<?> parameter0) {
        return MethodType.methodType(type, new Class[]{parameter0}, false);
    }

    public static MethodType methodType(Class<?> returnType, Class<?>[] parameters) {
        return MethodType.methodType(returnType, parameters, true);
    }

    private static MethodType methodType(Class<?> returnType, Class<?>[] parameters, boolean copyArguments) {
        returnType.getClass();
        MethodType type = new MethodType(returnType, parameters, copyArguments);
        return type.intern();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MethodType intern() {
        MethodType type = this.probeTable();
        if (type != null) {
            return type;
        }
        InternTableAddLock internTableAddLock = MethodType.internTableAddLock;
        synchronized (internTableAddLock) {
            type = this.probeTable();
            if (type != null) {
                return type;
            }
            int stackSlots = this.ptypes.length;
            for (Class<?> c : this.ptypes) {
                c.getClass();
                if (c == Double.TYPE || c == Long.TYPE) {
                    ++stackSlots;
                    continue;
                }
                if (c != Void.TYPE) continue;
                throw new IllegalArgumentException(Msg.getString("K05d9", Void.TYPE));
            }
            if (stackSlots > 255) {
                throw new IllegalArgumentException(Msg.getString("K05d8", stackSlots));
            }
            this.argSlots = stackSlots;
            this.stackDescriptionBits = this.stackDescriptionBits(this.ptypes, this.argSlots);
            this.methodDescriptor = this.createMethodDescriptorString();
            MethodType tenured = MethodType.makeTenured(this);
            internTable.put(tenured, new WeakReference<MethodType>(tenured));
            return tenured;
        }
    }

    private MethodType probeTable() {
        Reference reference = internTable.get(this);
        if (reference != null) {
            return (MethodType)reference.get();
        }
        return null;
    }

    private static native MethodType makeTenured(MethodType var0);

    public static MethodType methodType(Class<?> type, Class<?> parameter0, Class<?> ... parameters) {
        Class[] params = new Class[parameters.length + 1];
        params[0] = parameter0;
        System.arraycopy(parameters, 0, (Object)params, 1, parameters.length);
        return MethodType.methodType(type, params, false);
    }

    public static MethodType methodType(Class<?> type, List<Class<?>> parameters) {
        return MethodType.methodType(type, parameters.toArray(new Class[parameters.size()]), false);
    }

    public static MethodType methodType(Class<?> returnType, MethodType methodType) {
        return MethodType.methodType(returnType, methodType.ptypes, false);
    }

    public static MethodType genericMethodType(int numParameters) throws IllegalArgumentException {
        return MethodType.genericMethodType(numParameters, false);
    }

    public static MethodType genericMethodType(int numParameters, boolean isVarargs) throws IllegalArgumentException {
        if (numParameters < 0 || numParameters > (isVarargs ? 254 : 255)) {
            throw new IllegalArgumentException();
        }
        int count = numParameters;
        if (isVarargs) {
            ++count;
        }
        Object[] params = new Class[count];
        Arrays.fill(params, Object.class);
        if (isVarargs) {
            params[numParameters] = Object[].class;
        }
        return MethodType.methodType(Object.class, params, false);
    }

    public Class<?>[] parameterArray() {
        return (Class[])this.ptypes.clone();
    }

    public int parameterCount() {
        return this.ptypes.length;
    }

    Class<?>[] ptypes() {
        return this.ptypes;
    }

    public List<Class<?>> parameterList() {
        List<Object> list = Arrays.asList((Object[])this.ptypes.clone());
        return Collections.unmodifiableList(list);
    }

    public Class<?> parameterType(int position) throws IndexOutOfBoundsException {
        return this.ptypes[position];
    }

    public Class<?> returnType() {
        return this.rtype;
    }

    Class<?> lastParameterType() {
        Class<Void> result = Void.TYPE;
        if (this.ptypes.length > 0) {
            result = this.ptypes[this.ptypes.length - 1];
        }
        return result;
    }

    public String toMethodDescriptorString() {
        return this.methodDescriptor;
    }

    private String createMethodDescriptorString() {
        StringBuilder sb = new StringBuilder("(");
        for (Class<?> c : this.ptypes) {
            sb.append(MethodTypeHelper.getBytecodeStringName(c));
        }
        sb.append(")");
        sb.append(MethodTypeHelper.getBytecodeStringName(this.rtype));
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("(");
        for (int i = 0; i < this.ptypes.length; ++i) {
            sb.append(this.ptypes[i].getSimpleName());
            if (i >= this.ptypes.length - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        sb.append(this.rtype.getSimpleName());
        return sb.toString();
    }

    public MethodType unwrap() {
        Class[] args = (Class[])this.ptypes.clone();
        for (int i = 0; i < args.length; ++i) {
            args[i] = MethodTypeHelper.unwrapPrimitive(args[i]);
        }
        Class<Object> unwrappedReturnType = MethodTypeHelper.unwrapPrimitive(this.rtype);
        if (MethodTypeHelper.unwrapPrimitive(this.rtype) == Void.class) {
            unwrappedReturnType = Void.TYPE;
        }
        return MethodType.methodType(unwrappedReturnType, args, false);
    }

    public MethodType wrap() {
        Class[] args = (Class[])this.ptypes.clone();
        for (int i = 0; i < args.length; ++i) {
            args[i] = MethodTypeHelper.wrapPrimitive(args[i]);
        }
        return MethodType.methodType(MethodTypeHelper.wrapPrimitive(this.rtype), args, false);
    }

    public MethodType appendParameterTypes(Class<?> ... classes) throws IllegalArgumentException, NullPointerException {
        if (classes == null) {
            throw new NullPointerException();
        }
        return this.appendParameterTypes(Arrays.asList(classes));
    }

    public MethodType appendParameterTypes(List<Class<?>> classes) throws IllegalArgumentException, NullPointerException {
        if (classes == null) {
            throw new NullPointerException();
        }
        ArrayList combinedParameters = new ArrayList(Arrays.asList(this.ptypes));
        combinedParameters.addAll(classes);
        return MethodType.methodType(this.rtype, combinedParameters);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.returnType());
        out.writeObject(this.parameterArray());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            final Field fReturnType = this.getClass().getDeclaredField("rtype");
            final Field fArguments = this.getClass().getDeclaredField("ptypes");
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    fReturnType.setAccessible(true);
                    fArguments.setAccessible(true);
                    return null;
                }
            });
            fReturnType.set(this, Void.TYPE);
            fArguments.set(this, EMTPY_PARAMS);
            this.methodDescriptor = "()V";
            this.stackDescriptionBits = this.stackDescriptionBits(EMTPY_PARAMS, 0);
            Class serialReturnType = (Class)in.readObject();
            Class[] serialArguments = (Class[])in.readObject();
            this.deserializedFields = new DeserializedFieldsHolder(serialReturnType, serialArguments);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    private Object readResolve() throws ObjectStreamException {
        Class<Void> ret = Void.TYPE;
        Class<?>[] args = EMTPY_PARAMS;
        DeserializedFieldsHolder localArgs = this.deserializedFields;
        if (localArgs != null) {
            ret = this.deserializedFields.returnType;
            args = this.deserializedFields.arguments;
        }
        return MethodType.methodType(ret, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InvokeExactHandle getInvokeExactHandle() {
        if (null == this.invoker) {
            MethodType methodType = this;
            synchronized (methodType) {
                if (null == this.invoker) {
                    this.invoker = new InvokeExactHandle(this);
                }
            }
        }
        return this.invoker;
    }

    private static class DeserializedFieldsHolder {
        Class<?> returnType;
        Class<?>[] arguments;

        DeserializedFieldsHolder(Class<?> rtype, Class<?>[] args) {
            this.returnType = rtype == null ? Void.TYPE : rtype;
            this.arguments = args == null ? EMTPY_PARAMS : args;
        }
    }

    static final class InternTableAddLock {
        InternTableAddLock() {
        }
    }
}

