/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.virtualization.management.internal;

import com.ibm.oti.util.Msg;
import com.ibm.virtualization.management.HypervisorInfoRetrievalException;
import com.ibm.virtualization.management.HypervisorMXBean;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public final class HypervisorMXBeanImpl
implements HypervisorMXBean {
    private static final int HYPERVISOR_NOT_SUPPORTED = -100001;
    private static final int RUNNING_ON_HYPERVISOR = 1;
    private static final int NOT_RUNNING_ON_HYPERVISOR = 0;
    private static final HypervisorMXBeanImpl instance = new HypervisorMXBeanImpl();
    private int isVirtual = this.isEnvironmentVirtualImpl();
    private String hypervisorName = this.getVendorImpl();

    public static HypervisorMXBeanImpl getInstance() {
        return instance;
    }

    private HypervisorMXBeanImpl() {
    }

    @Override
    public String getVendor() {
        return this.hypervisorName;
    }

    @Override
    public boolean isEnvironmentVirtual() throws UnsupportedOperationException, HypervisorInfoRetrievalException {
        if (this.isVirtual == -100001) {
            throw new UnsupportedOperationException(Msg.getString("K0565"));
        }
        if (this.isVirtual < 0) {
            throw new HypervisorInfoRetrievalException(Msg.getString("K0566", this.isVirtual));
        }
        if (this.isVirtual == 1) {
            return true;
        }
        if (this.isVirtual == 0) {
            return false;
        }
        return false;
    }

    @Override
    public ObjectName getObjectName() {
        try {
            ObjectName name = new ObjectName("com.ibm.virtualization.management:type=Hypervisor");
            return name;
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
    }

    private native int isEnvironmentVirtualImpl();

    private native String getVendorImpl();
}

