/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.shared;

import com.ibm.oti.shared.SharedClassPermission;
import java.security.AccessControlException;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class SharedAbstractHelperFactory {
    private static final AtomicInteger idCount = new AtomicInteger(1);

    static boolean checkPermission(ClassLoader loader, String type) {
        boolean result = true;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(new SharedClassPermission(loader, type));
            }
            catch (AccessControlException e) {
                result = false;
            }
        }
        return result;
    }

    static boolean canFind(ClassLoader loader) {
        return SharedAbstractHelperFactory.checkPermission(loader, "read");
    }

    static boolean canStore(ClassLoader loader) {
        return SharedAbstractHelperFactory.checkPermission(loader, "write");
    }

    static int getNewID() {
        return idCount.getAndIncrement();
    }
}

