/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management.internal;

import com.ibm.java.lang.management.internal.ManagementUtils;
import com.ibm.java.lang.management.internal.OperatingSystemMXBeanImpl;
import com.ibm.java.lang.management.internal.RuntimeMXBeanImpl;
import com.ibm.lang.management.MemoryUsage;
import com.ibm.lang.management.MemoryUsageRetrievalException;
import com.ibm.lang.management.OperatingSystemMXBean;
import com.ibm.lang.management.ProcessorUsage;
import com.ibm.lang.management.ProcessorUsageRetrievalException;
import com.ibm.lang.management.internal.OperatingSystemNotificationThread;
import com.ibm.lang.management.internal.UnixExtendedOperatingSystem;
import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.VM;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Objects;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import openj9.internal.tools.attach.target.IPC;

public class ExtendedOperatingSystemMXBeanImpl
extends OperatingSystemMXBeanImpl
implements OperatingSystemMXBean {
    private static final ExtendedOperatingSystemMXBeanImpl instance = new ExtendedOperatingSystemMXBeanImpl();
    private static long oldTime = -1L;
    private static long oldCpuTime = -1L;
    private static long interimTime = -1L;
    private static long interimCpuTime = -1L;
    private static long latestTime = -1L;
    private static long latestCpuTime = -1L;
    private HwEmulResult isHwEmulated = HwEmulResult.UNKNOWN;

    public static ExtendedOperatingSystemMXBeanImpl getInstance() {
        if (ManagementUtils.isRunningOnUnix()) {
            return UnixExtendedOperatingSystem.getInstance();
        }
        return instance;
    }

    private static boolean isZosHardwareEmulated(String hwModel) {
        if (hwModel.equalsIgnoreCase("1090") || hwModel.equalsIgnoreCase("1091")) {
            return true;
        }
        String emuHwProperty = VM.getVMLangAccess().internalGetProperties().getProperty("com.ibm.lang.management.OperatingSystemMXBean.zos.emulatedHardwareModels");
        if (null != emuHwProperty) {
            for (String emuHw : emuHwProperty.split("[;,]")) {
                if (!hwModel.equalsIgnoreCase(emuHw)) continue;
                return true;
            }
        }
        return false;
    }

    ExtendedOperatingSystemMXBeanImpl() {
        if (this.isDLPAREnabled()) {
            PrivilegedAction<Thread> createThread = () -> {
                Thread thread = VM.getVMLangAccess().createThread(new OperatingSystemNotificationThread(this), "OperatingSystemMXBean notification dispatcher", true, false, true, ClassLoader.getSystemClassLoader());
                thread.setPriority(6);
                return thread;
            };
            Thread thread = AccessController.doPrivileged(createThread);
            thread.start();
        }
    }

    private native boolean isDLPAREnabled();

    private double calculateProcessCpuLoad(long endTs, long endCpuTime, long startTs, long startCpuTime) {
        double timestampDelta = endTs - startTs;
        double processTimeDelta = endCpuTime - startCpuTime;
        if (timestampDelta <= 0.0 || processTimeDelta < 0.0) {
            return -1.0;
        }
        return Math.min(processTimeDelta / ((double)this.getOnlineProcessorsImpl() * timestampDelta), 1.0);
    }

    @Override
    public final long getFreePhysicalMemorySize() {
        return this.getFreePhysicalMemorySizeImpl();
    }

    private native long getFreePhysicalMemorySizeImpl();

    @Override
    public final long getFreeSwapSpaceSize() {
        try {
            MemoryUsage usage = this.retrieveMemoryUsage(new MemoryUsage());
            return usage.getSwapFree();
        }
        catch (MemoryUsageRetrievalException e) {
            return -1L;
        }
    }

    @Override
    public final String getHardwareModel() throws UnsupportedOperationException {
        return this.getHardwareModelImpl();
    }

    private native String getHardwareModelImpl() throws UnsupportedOperationException;

    private native MemoryUsage getMemoryUsageImpl(MemoryUsage var1);

    private native int getOnlineProcessorsImpl();

    @Override
    public final synchronized double getProcessCpuLoad() {
        double processCpuLoad = -1.0;
        latestTime = System.nanoTime();
        long cpuTime = this.getProcessCpuTime();
        if (CpuTimePrecisionHolder.precision == 1) {
            cpuTime *= 100L;
        }
        latestCpuTime = cpuTime;
        if (-1L == oldTime) {
            oldTime = interimTime = latestTime;
            oldCpuTime = interimCpuTime = latestCpuTime;
            return -1.0;
        }
        if (latestTime - interimTime >= 10000000L) {
            processCpuLoad = this.calculateProcessCpuLoad(latestTime, latestCpuTime, interimTime, interimCpuTime);
            if (processCpuLoad >= 0.0) {
                oldTime = interimTime;
                oldCpuTime = interimCpuTime;
                interimTime = latestTime;
                interimCpuTime = latestCpuTime;
                return processCpuLoad;
            }
            interimTime = latestTime;
            interimCpuTime = latestCpuTime;
        }
        if (latestTime - oldTime >= 10000000L && (processCpuLoad = this.calculateProcessCpuLoad(latestTime, latestCpuTime, oldTime, oldCpuTime)) < 0.0) {
            oldTime = latestTime;
            oldCpuTime = latestCpuTime;
        }
        return processCpuLoad;
    }

    @Override
    public final long getProcessCpuTime() {
        return this.getProcessCpuTimeImpl() * (long)CpuTimePrecisionHolder.precision;
    }

    @Override
    @Deprecated
    public final long getProcessCpuTimeByNS() {
        long cpuTimeNS = this.getProcessCpuTime();
        if (CpuTimePrecisionHolder.precision == 1) {
            cpuTimeNS *= 100L;
        }
        return cpuTimeNS;
    }

    private native long getProcessCpuTimeImpl();

    @Override
    public final int getProcessingCapacity() {
        return this.getProcessingCapacityImpl();
    }

    private native int getProcessingCapacityImpl();

    private native ProcessorUsage[] getProcessorUsageImpl(ProcessorUsage[] var1);

    @Override
    public final long getProcessPhysicalMemorySize() {
        return this.getProcessPhysicalMemorySizeImpl();
    }

    private native long getProcessPhysicalMemorySizeImpl();

    @Override
    public final long getProcessPrivateMemorySize() {
        return this.getProcessPrivateMemorySizeImpl();
    }

    private native long getProcessPrivateMemorySizeImpl();

    @Override
    public long getCommittedVirtualMemorySize() {
        return this.getProcessVirtualMemorySizeImpl();
    }

    @Override
    @Deprecated
    public final long getProcessVirtualMemorySize() {
        return this.getProcessVirtualMemorySizeImpl();
    }

    private native long getProcessVirtualMemorySizeImpl();

    @Override
    public final double getSystemCpuLoad() {
        return this.getSystemCpuLoadImpl();
    }

    private native double getSystemCpuLoadImpl();

    @Override
    public long getTotalPhysicalMemorySize() {
        return this.getTotalPhysicalMemoryImpl();
    }

    @Override
    @Deprecated
    public final long getTotalPhysicalMemory() {
        return this.getTotalPhysicalMemoryImpl();
    }

    private native long getTotalPhysicalMemoryImpl();

    private native ProcessorUsage getTotalProcessorUsageImpl(ProcessorUsage var1);

    @Override
    public final long getTotalSwapSpaceSize() {
        try {
            MemoryUsage usage = this.retrieveMemoryUsage(new MemoryUsage());
            return usage.getSwapTotal();
        }
        catch (MemoryUsageRetrievalException e) {
            return -1L;
        }
    }

    @Override
    public final boolean isHardwareEmulated() throws UnsupportedOperationException {
        if (HwEmulResult.UNKNOWN == this.isHwEmulated) {
            String osName = VM.getVMLangAccess().internalGetProperties().getProperty("os.name");
            String hwModel = this.getHardwareModel();
            if (null != osName && null != hwModel) {
                boolean isEmuTmp = false;
                if (osName.equalsIgnoreCase("z/OS")) {
                    isEmuTmp = ExtendedOperatingSystemMXBeanImpl.isZosHardwareEmulated(hwModel);
                }
                this.isHwEmulated = isEmuTmp ? HwEmulResult.YES : HwEmulResult.NO;
            } else {
                if (null == hwModel) {
                    String strErr = Msg.getString("K05db");
                    throw new UnsupportedOperationException(strErr);
                }
                throw new UnsupportedOperationException();
            }
        }
        return HwEmulResult.YES == this.isHwEmulated;
    }

    @Override
    public final MemoryUsage retrieveMemoryUsage() throws MemoryUsageRetrievalException {
        return this.getMemoryUsageImpl(new MemoryUsage());
    }

    @Override
    public final MemoryUsage retrieveMemoryUsage(MemoryUsage memoryUsageObj) throws NullPointerException, MemoryUsageRetrievalException {
        return this.getMemoryUsageImpl(Objects.requireNonNull(memoryUsageObj));
    }

    @Override
    public final ProcessorUsage[] retrieveProcessorUsage() throws ProcessorUsageRetrievalException {
        return this.getProcessorUsageImpl(null);
    }

    @Override
    public final ProcessorUsage[] retrieveProcessorUsage(ProcessorUsage[] procUsageArr) throws NullPointerException, ProcessorUsageRetrievalException, IllegalArgumentException {
        if (null == procUsageArr) {
            throw new NullPointerException(Msg.getString("K056B"));
        }
        for (ProcessorUsage p : procUsageArr) {
            if (null != p) continue;
            throw new NullPointerException(Msg.getString("K056C"));
        }
        return this.getProcessorUsageImpl(procUsageArr);
    }

    @Override
    public final ProcessorUsage retrieveTotalProcessorUsage() throws ProcessorUsageRetrievalException {
        return this.getTotalProcessorUsageImpl(new ProcessorUsage());
    }

    @Override
    public final ProcessorUsage retrieveTotalProcessorUsage(ProcessorUsage procUsageObj) throws NullPointerException, ProcessorUsageRetrievalException {
        return this.getTotalProcessorUsageImpl(Objects.requireNonNull(procUsageObj));
    }

    @Override
    public final MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{ExtendedOperatingSystemMXBeanImpl.makeNotificationInfo("com.ibm.management.processing.capacity.change", "Processing Capacity Notification"), ExtendedOperatingSystemMXBeanImpl.makeNotificationInfo("com.ibm.management.total.physical.memory.change", "Total Physical Memory Notification"), ExtendedOperatingSystemMXBeanImpl.makeNotificationInfo("com.ibm.management.available.processors.change", "Available Processors Notification")};
    }

    private static MBeanNotificationInfo makeNotificationInfo(String type, String description) {
        return new MBeanNotificationInfo(new String[]{type}, Notification.class.getName(), description);
    }

    @Override
    public boolean isProcessRunning(long pid) {
        RuntimeMXBeanImpl.checkMonitorPermission();
        return IPC.processExists(pid);
    }

    private static final class CpuTimePrecisionHolder {
        static final int precision = CpuTimePrecisionHolder.getPrecision();
        static final int NS_SCALE_FACTOR = 100;
        static final int NO_SCALE_FACTOR = 1;

        private CpuTimePrecisionHolder() {
        }

        private static int getPrecision() {
            boolean is100ns = Boolean.getBoolean("com.ibm.lang.management.OperatingSystemMXBean.isCpuTime100ns");
            int precisionVaue = is100ns ? 1 : 100;
            return precisionVaue;
        }
    }

    private static enum HwEmulResult {
        NO,
        UNKNOWN,
        YES;

    }
}

