/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.channel.framework;

import com.ibm.nws.ejs.ras.Tr;
import com.ibm.nws.ejs.ras.TraceComponent;
import com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.exception.ChannelFrameworkException;
import java.lang.reflect.Method;

public class ChannelFrameworkFactory {
    private static final TraceComponent tc = Tr.register(ChannelFrameworkFactory.class, "ChannelFramework", "com.ibm.ws.channel.resources.channelframeworkservice");
    private static ChannelFramework framework;

    public static synchronized ChannelFramework getChannelFramework() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getChannelFramework");
        }
        if (framework == null) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Attempt to load the ChannelFrameworkProvider");
                }
                Class<?> clazz = Class.forName("com.ibm.wsspi.channel.ChannelFrameworkProvider", true, Thread.currentThread().getContextClassLoader());
                Method method = clazz.getMethod("getChannelFramework", null);
                framework = (ChannelFramework)method.invoke(null, null);
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unable to reflectively create instance from ChannelFrameworkProvider");
                }
                framework = new ChannelFrameworkImpl();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getChannelFramework");
        }
        return framework;
    }

    public static synchronized void setChannelFramework(ChannelFramework channelFramework) throws ChannelFrameworkException {
        throw new ChannelFrameworkException("Channel Framework Already Exists");
    }
}

