/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nws.ffdc;

import com.ibm.nws.ffdc.IncidentStream;
import com.ibm.nws.ffdc.IncidentStreamImpl;
import com.ibm.nws.ffdc.IncidentStreamPool;

public class IncidentStreamManager {
    private static final ThreadLocal svIncidentStreams = new ThreadLocal();
    private static final IncidentStreamPool svStreamPool = new IncidentStreamPool(30);

    private IncidentStreamManager() {
    }

    public static final IncidentStream getIncidentStream() {
        IncidentStreamImpl incidentStreamImpl = (IncidentStreamImpl)svIncidentStreams.get();
        if (incidentStreamImpl == null) {
            incidentStreamImpl = (IncidentStreamImpl)svStreamPool.remove();
            incidentStreamImpl.initialize();
            svIncidentStreams.set(incidentStreamImpl);
        }
        return incidentStreamImpl;
    }

    public static final void openIncidentStream() {
        IncidentStreamImpl incidentStreamImpl = (IncidentStreamImpl)svIncidentStreams.get();
        incidentStreamImpl.open();
    }

    public static final void clearIncidentStream(Object object) {
        IncidentStreamImpl incidentStreamImpl = (IncidentStreamImpl)svIncidentStreams.get();
        if (incidentStreamImpl != null) {
            incidentStreamImpl.resetIncidentStream();
            svStreamPool.add(incidentStreamImpl);
            svIncidentStreams.set(null);
        }
    }

    public static final void closeIncidentStream(Object object) {
        IncidentStreamImpl incidentStreamImpl = (IncidentStreamImpl)svIncidentStreams.get();
        if (incidentStreamImpl != null) {
            incidentStreamImpl.resetIncidentStream();
        }
    }
}

