/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.xcommands;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaHeap;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaReference;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.helpers.ClassOutput;
import com.ibm.jvm.dtfjview.commands.helpers.Exceptions;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import com.ibm.jvm.dtfjview.commands.xcommands.XCommand;
import java.io.PrintStream;
import java.util.Iterator;

@DTFJPlugin(version="1.*", runtime=false)
public class XJCommand
extends XCommand {
    public XJCommand() {
        this.addCommand("x/j", "<object address> | <class name>", "displays information about a particular object or all objects of a class");
    }

    @Override
    public boolean recognises(String command, IContext context) {
        if (super.recognises(command, context)) {
            return command.toLowerCase().endsWith("j");
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void doCommand(String[] args) {
        String objName;
        boolean supers = false;
        String param = args[0];
        Long objAddress = Utils.longFromStringWithPrefix(param);
        if (null == objAddress) {
            objName = param;
            if (args.length >= 2) {
                String option = args[1];
                if (option.equals("super")) {
                    supers = true;
                } else {
                    if (!option.equals("nosuper")) {
                        this.out.println("second parameter for \"x/j\" must be \"super\" or \"nosuper\"");
                        return;
                    }
                    supers = false;
                }
            }
        } else {
            objName = null;
        }
        this.printHeapObjects(objAddress, objName, this.out, supers);
    }

    private void printHeapObjects(Long objAddress, String objName, PrintStream out, boolean supers) {
        JavaRuntime jr = this.ctx.getRuntime();
        Iterator itHeap = jr.getHeaps();
        int count = 1;
        while (itHeap.hasNext()) {
            Object obj = itHeap.next();
            if (obj instanceof JavaHeap) {
                JavaHeap jh = (JavaHeap)obj;
                out.print("\t heap #" + count + " - name: ");
                out.print(jh.getName());
                out.print("\n\n");
                this.printObjects(jh, objAddress, objName, out, supers, jr);
                ++count;
                continue;
            }
            out.println("\t\tWarning : skipping corrupt heap");
        }
    }

    private void printObjects(JavaHeap jh, Long objAddress, String objName, PrintStream out, boolean supers, JavaRuntime jr) {
        if (objName != null) {
            this.printObjectsFromName(jh, objName, out, supers, jr);
        } else {
            this.printObjectsFromAddress(jh, objAddress, out, jr);
        }
    }

    private void printObjectsFromName(JavaHeap jh, String objName, PrintStream out, boolean supers, JavaRuntime jr) {
        if (objName != null) {
            JavaClass[] classes = Utils.getClassGivenName(objName, jr, out);
            if (classes == null || classes.length == 0) {
                out.print("\t  could not find class with name \"" + objName + "\"\n\n");
                return;
            }
            for (int i = 0; i < classes.length; ++i) {
                boolean foundInstance = false;
                JavaClass objClass = classes[i];
                if (classes.length > 1) {
                    ClassOutput.printRuntimeClassAndLoader(objClass, out);
                }
                ClassOutput.printStaticFields(objClass, out);
                Iterator itObject = jh.getObjects();
                int corruptObjectCount = 0;
                while (itObject.hasNext()) {
                    JavaClass jc;
                    Object obj = itObject.next();
                    if (obj instanceof CorruptData) {
                        ++corruptObjectCount;
                        continue;
                    }
                    JavaObject jo = (JavaObject)obj;
                    String hierarchy = "";
                    try {
                        jc = jo.getJavaClass();
                    }
                    catch (CorruptDataException e) {
                        out.print("\t  <error getting class while traversing objects: ");
                        out.print(Exceptions.getCorruptDataExceptionString());
                        out.print(">\n");
                        jc = null;
                    }
                    boolean foundSuperclass = false;
                    while (jc != null && !foundSuperclass) {
                        String className;
                        try {
                            className = jc.getName();
                        }
                        catch (CorruptDataException e) {
                            out.print("\t  <error getting class name while traversing objects: ");
                            out.print(Exceptions.getCorruptDataExceptionString());
                            out.print(">\n");
                            jc = null;
                            continue;
                        }
                        hierarchy = hierarchy.equals("") ? className : className + " => " + hierarchy;
                        if (jc.equals((Object)objClass)) {
                            foundInstance = true;
                            foundSuperclass = true;
                            out.print("\t  ");
                            out.print(hierarchy);
                            out.print(" @ ");
                            out.print(Utils.toHex(jo.getID().getAddress()));
                            out.print("\n");
                            ClassOutput.printFields(jo, jc, jr, out);
                            XJCommand.printReferences(jo, out);
                            continue;
                        }
                        if (supers) {
                            try {
                                jc = jc.getSuperclass();
                            }
                            catch (CorruptDataException e) {
                                out.print("\t  <error getting superclass while traversing objects: ");
                                out.print(Exceptions.getCorruptDataExceptionString());
                                out.print(">\n");
                                jc = null;
                            }
                            continue;
                        }
                        jc = null;
                    }
                }
                if (!foundInstance) {
                    out.print("\t  <no object of class \"");
                    out.print(objName);
                    out.print("\" exists>\n\n");
                }
                if (corruptObjectCount == 0) continue;
                out.println("\t Warning : " + corruptObjectCount + " corrupt objects were skipped\n");
            }
        }
    }

    private void printObjectsFromAddress(JavaHeap jh, Long objAddress, PrintStream out, JavaRuntime jr) {
        Iterator itObject = jh.getObjects();
        boolean found = false;
        boolean done = false;
        int corruptObjectCount = 0;
        while (itObject.hasNext() && !done) {
            JavaClass jc;
            Object obj = itObject.next();
            if (obj instanceof CorruptData) {
                ++corruptObjectCount;
                continue;
            }
            JavaObject jo = (JavaObject)obj;
            if (jo.getID().getAddress() != objAddress.longValue()) continue;
            found = true;
            out.print("\t  ");
            try {
                jc = jo.getJavaClass();
            }
            catch (CorruptDataException e) {
                out.print("\t  <error getting class while traversing objects: ");
                out.print(Exceptions.getCorruptDataExceptionString());
                out.print(">");
                jc = null;
            }
            if (null == jc) continue;
            try {
                out.print(jc.getName());
            }
            catch (CorruptDataException e) {
                out.print("\t  <error getting class name while traversing objects: ");
                out.print(Exceptions.getCorruptDataExceptionString());
                out.print(">");
            }
            out.print(" @ ");
            out.print(Utils.toHex(objAddress));
            out.print("\n");
            ClassOutput.printFields(jo, jc, jr, out);
            XJCommand.printReferences(jo, out);
            done = true;
        }
        if (!found) {
            out.print("\t  <no object found at address ");
            out.print(Utils.toHex(objAddress));
            out.print(">\n\n");
        }
        if (corruptObjectCount != 0) {
            out.println("\t Warning : " + corruptObjectCount + " corrupt objects were skipped\n");
        }
    }

    @Override
    public void printDetailedHelp(PrintStream out) {
        super.printDetailedHelp(out);
        out.println("displays information about a particular object or all objects of a class\n\nparameters: 0x<object_addr> | <class_name> [super | nosuper]\n\nIf given class name, all static fields with their values will be printed, followed by all objects of that class with their fields and values for each class of that name (if multiple classloaders have loaded classes with that name).\n\nIf \"super\" is specifed with \"x/j < class_name>\" it is interpreted as a superclass name, and all instances of any subclasses will be printed.\n\nIf given an object address (in hex), static fields for that object's class will not be printed; the other fields and values of that object will be printed along with its address.\n\nNote: this command ignores the number of items and unit size passed to it by the \"x/\" command.\n\n");
    }

    public static void printReferences(JavaObject jo, PrintStream out) {
        Iterator references = jo.getReferences();
        if (references.hasNext()) {
            references.next();
        }
        if (!references.hasNext()) {
            out.print("\t    references: <none>\n ");
            out.print("\t     ");
        } else {
            out.print("\t    references:\n ");
            out.print("\t     ");
            while (references.hasNext()) {
                Object potential_reference = references.next();
                if (!(potential_reference instanceof JavaReference)) continue;
                JavaReference reference = (JavaReference)potential_reference;
                try {
                    Object target = reference.getTarget();
                    if (target instanceof JavaObject) {
                        out.print(" 0x" + Long.toHexString(((JavaObject)target).getID().getAddress()));
                        continue;
                    }
                    if (!(target instanceof JavaClass)) continue;
                    out.print(" 0x" + Long.toHexString(((JavaClass)target).getID().getAddress()));
                }
                catch (DataUnavailable target) {
                }
                catch (CorruptDataException e) {
                    out.print(Exceptions.getCorruptDataExceptionString());
                }
            }
        }
        out.print("\n\n");
    }
}

