/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore.entry;

import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.keystore.entry.DisplayItemFactory$ExtensionItem;
import com.ibm.gsk.ikeyman.keystore.entry.DisplayItemFactory$ExtensionOIDItem;
import com.ibm.gsk.ikeyman.keystore.ext.KeymanTree;
import com.ibm.gsk.ikeyman.keystore.ext.KeymanTree$KeymanTreeNode;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AuthorityKeyIdentifierExtension;
import com.ibm.security.x509.CertificateExtensions;
import com.ibm.security.x509.ExtKeyUsageExtension;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.KeyUsageExtension;
import com.ibm.security.x509.SubjectKeyIdentifierExtension;
import com.ibm.security.x509.X509CertInfo;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class DisplayItemFactory$ExtensionItemImpl
implements DisplayItemFactory$ExtensionItem {
    private final DisplayItemFactory$ExtensionOIDItem oid;
    private final boolean critical;
    private final String value;
    private final Extension extension;

    public DisplayItemFactory$ExtensionItemImpl(Extension extension) {
        this.oid = new DisplayItemFactory$ExtensionOIDItem(extension.getExtensionId());
        this.critical = extension.isCritical();
        this.value = extension.toString();
        this.extension = extension;
    }

    public static List extractExtensions(X509Certificate x509Certificate) throws KeyManagerException {
        ArrayList<DisplayItemFactory$ExtensionItemImpl> arrayList = new ArrayList<DisplayItemFactory$ExtensionItemImpl>();
        try {
            CertificateExtensions certificateExtensions = DisplayItemFactory$ExtensionItemImpl.extractCertificateExtensions(x509Certificate);
            if (certificateExtensions != null) {
                Collection collection = certificateExtensions.getAllExtensions();
                for (Extension extension : collection) {
                    arrayList.add(new DisplayItemFactory$ExtensionItemImpl(extension));
                }
            }
            return arrayList;
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.CERTIFICATE_ENCODING_ERROR, (Throwable)certificateEncodingException);
        }
        catch (IOException iOException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.DER_ENCODING_ERROR, (Throwable)iOException);
        }
        catch (CertificateParsingException certificateParsingException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.CERTIFICATE_PARSING_ERROR, (Throwable)certificateParsingException);
        }
        catch (CertificateException certificateException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.CERTIFICATE_ERROR, (Throwable)certificateException);
        }
    }

    public static ExtKeyUsageExtension extractExtendedkeyUsageExtensions(X509Certificate x509Certificate) throws KeyManagerException {
        ExtKeyUsageExtension extKeyUsageExtension = null;
        try {
            CertificateExtensions certificateExtensions = DisplayItemFactory$ExtensionItemImpl.extractCertificateExtensions(x509Certificate);
            if (certificateExtensions != null) {
                extKeyUsageExtension = (ExtKeyUsageExtension)certificateExtensions.get("ExtKeyUsage");
            }
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.CERTIFICATE_ENCODING_ERROR, (Throwable)certificateEncodingException);
        }
        catch (IOException iOException) {
        }
        catch (CertificateParsingException certificateParsingException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.CERTIFICATE_PARSING_ERROR, (Throwable)certificateParsingException);
        }
        catch (CertificateException certificateException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.CERTIFICATE_ERROR, (Throwable)certificateException);
        }
        return extKeyUsageExtension;
    }

    private static CertificateExtensions extractCertificateExtensions(X509Certificate x509Certificate) throws IOException, CertificateEncodingException, CertificateParsingException, CertificateException {
        DerValue derValue = new DerValue(x509Certificate.getEncoded()).getData().getDerValue();
        X509CertInfo x509CertInfo = new X509CertInfo(derValue);
        CertificateExtensions certificateExtensions = (CertificateExtensions)x509CertInfo.get("extensions");
        return certificateExtensions;
    }

    public Extension getExtension() {
        return this.extension;
    }

    public KeymanTree$KeymanTreeNode getTreeNode() {
        KeymanTree$KeymanTreeNode keymanTree$KeymanTreeNode = KeymanTree.newNode(this.oid.getName());
        keymanTree$KeymanTreeNode.addChild(KeymanTree.newNode(Messages.getString("Label.ExtensionIdentifier"), this.oid.getOid()));
        keymanTree$KeymanTreeNode.addChild(KeymanTree.newNode(Messages.getString("Label.CriticalFlag"), "" + this.critical));
        keymanTree$KeymanTreeNode.addChild(KeymanTree.newNode(Messages.getString("Label.Value"), this.value));
        return keymanTree$KeymanTreeNode;
    }

    public List getTreeNodes() {
        ArrayList<KeymanTree$KeymanTreeNode> arrayList = new ArrayList<KeymanTree$KeymanTreeNode>();
        arrayList.add(this.getTreeNode());
        return arrayList;
    }

    public static KeyUsageExtension extractkeyUsageExtensions(X509Certificate x509Certificate) throws KeyManagerException {
        KeyUsageExtension keyUsageExtension = null;
        try {
            CertificateExtensions certificateExtensions = DisplayItemFactory$ExtensionItemImpl.extractCertificateExtensions(x509Certificate);
            if (certificateExtensions != null) {
                keyUsageExtension = (KeyUsageExtension)certificateExtensions.get("KeyUsage");
            }
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.CERTIFICATE_ENCODING_ERROR, (Throwable)certificateEncodingException);
        }
        catch (IOException iOException) {
        }
        catch (CertificateParsingException certificateParsingException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.CERTIFICATE_PARSING_ERROR, (Throwable)certificateParsingException);
        }
        catch (CertificateException certificateException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.CERTIFICATE_ERROR, (Throwable)certificateException);
        }
        return keyUsageExtension;
    }

    public static SubjectKeyIdentifierExtension extractSubjectKeyIdentifierExtension(X509Certificate x509Certificate) throws KeyManagerException {
        SubjectKeyIdentifierExtension subjectKeyIdentifierExtension = null;
        try {
            CertificateExtensions certificateExtensions = DisplayItemFactory$ExtensionItemImpl.extractCertificateExtensions(x509Certificate);
            if (certificateExtensions != null) {
                subjectKeyIdentifierExtension = (SubjectKeyIdentifierExtension)certificateExtensions.get("SubjectKeyIdentifier");
            }
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.CERTIFICATE_ENCODING_ERROR, (Throwable)certificateEncodingException);
        }
        catch (IOException iOException) {
        }
        catch (CertificateParsingException certificateParsingException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.CERTIFICATE_PARSING_ERROR, (Throwable)certificateParsingException);
        }
        catch (CertificateException certificateException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.CERTIFICATE_ERROR, (Throwable)certificateException);
        }
        return subjectKeyIdentifierExtension;
    }

    public static AuthorityKeyIdentifierExtension extractAuthorityKeyIdentifierExtension(X509Certificate x509Certificate) throws KeyManagerException {
        AuthorityKeyIdentifierExtension authorityKeyIdentifierExtension = null;
        try {
            CertificateExtensions certificateExtensions = DisplayItemFactory$ExtensionItemImpl.extractCertificateExtensions(x509Certificate);
            if (certificateExtensions != null) {
                authorityKeyIdentifierExtension = (AuthorityKeyIdentifierExtension)certificateExtensions.get("AuthorityKeyIdentifier");
            }
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.CERTIFICATE_ENCODING_ERROR, (Throwable)certificateEncodingException);
        }
        catch (IOException iOException) {
        }
        catch (CertificateParsingException certificateParsingException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.CERTIFICATE_PARSING_ERROR, (Throwable)certificateParsingException);
        }
        catch (CertificateException certificateException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.CERTIFICATE_ERROR, (Throwable)certificateException);
        }
        return authorityKeyIdentifierExtension;
    }
}

