/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore.entry;

import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateRequestItemImpl;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateRequestKeyItem;
import com.ibm.gsk.ikeyman.util.KeymanUtil;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.X509CertImpl;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

class CertificateRequestKeyItemImpl
extends CertificateRequestItemImpl
implements CertificateRequestKeyItem {
    private PrivateKey privateKey;

    protected CertificateRequestKeyItemImpl(String string, CertificationRequest certificationRequest, PrivateKey privateKey) throws KeyManagerException {
        super(string, certificationRequest);
        this.privateKey = privateKey;
    }

    public X509Certificate toCertificate(Extension extension, String string) throws KeyManagerException {
        String string2 = this.getSignatureAlgorithm().getOID();
        AlgorithmId algorithmId = KeymanUtil.getSignatureAlgorithm(string2);
        X509CertImpl x509CertImpl = (X509CertImpl)this.createCertificate(this.getSubjectDN().getX500Name(), 1, null, algorithmId, extension, string);
        try {
            x509CertImpl.sign(this.getPrivateKey(), string2, string);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_KEY_FOR_SIGNING, invalidKeyException, new String[]{this.getLabel()});
        }
        catch (CertificateException certificateException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.CERTIFICATE_ENCODING_ERROR, (Throwable)certificateException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_SUCH_ALGORITHM, noSuchAlgorithmException, new String[]{noSuchAlgorithmException.getMessage()});
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_SUCH_PROVIDER, noSuchProviderException, new String[]{string});
        }
        catch (SignatureException signatureException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.SIGNATURE_ERROR, signatureException, new String[]{this.getLabel()});
        }
        return x509CertImpl;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }
}

