/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore;

import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.gsk.ikeyman.error.CancelledException;
import com.ibm.gsk.ikeyman.error.InternalKeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.keystore.KeyStoreProxyCreatorFactory$FileLessKeyStoreProxy;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory$DatabaseDescriptor;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory$PKCS11ImplDatabaseDescriptorConfig;
import java.io.IOException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.cert.CertificateException;

class KeyStoreProxyCreatorFactory$PKCS11ImplKeyStoreProxy
extends KeyStoreProxyCreatorFactory$FileLessKeyStoreProxy {
    private final boolean tempProv;

    public KeyStoreProxyCreatorFactory$PKCS11ImplKeyStoreProxy(KeyStore keyStore, DatabaseDescriptorFactory$PKCS11ImplDatabaseDescriptorConfig databaseDescriptorFactory$PKCS11ImplDatabaseDescriptorConfig, boolean bl, boolean bl2) throws KeyManagerException, CancelledException {
        super(keyStore, databaseDescriptorFactory$PKCS11ImplDatabaseDescriptorConfig, bl);
        this.tempProv = bl2;
    }

    protected void load() throws KeyManagerException, CancelledException {
        if (this.create) {
            throw new InternalKeyManagerException(KeyManagerException$ExceptionReason.INVALID_ARGUMENT, new String[]{"loadKeyStore:create"});
        }
        try {
            this.keyStore.load(null, ((DatabaseDescriptorFactory$PKCS11ImplDatabaseDescriptorConfig)this.descriptor).getPassword(true, this.create).toCharArray());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_SUCH_ALGORITHM, noSuchAlgorithmException, new String[]{noSuchAlgorithmException.getMessage()});
        }
        catch (CertificateException certificateException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.CERTIFICATE_LOAD_ERROR, (Throwable)certificateException);
        }
        catch (IOException iOException) {
            if (iOException.getMessage() != null && iOException.getMessage().toLowerCase().contains("pin is incorrect")) {
                throw new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_PIN, (Throwable)iOException);
            }
            throw new KeyManagerException(KeyManagerException$ExceptionReason.IO_ERROR, (Throwable)iOException);
        }
    }

    public KeyStore reload() throws KeyManagerException, CancelledException {
        this.close();
        return super.reload();
    }

    public void save(DatabaseDescriptorFactory$PKCS11ImplDatabaseDescriptorConfig databaseDescriptorFactory$PKCS11ImplDatabaseDescriptorConfig) throws KeyManagerException {
    }

    public void close() throws KeyManagerException {
        try {
            IBMPKCS11Impl iBMPKCS11Impl = (IBMPKCS11Impl)Security.getProvider(((DatabaseDescriptorFactory$PKCS11ImplDatabaseDescriptorConfig)this.descriptor).getProvider());
            if (iBMPKCS11Impl != null) {
                iBMPKCS11Impl.logout();
                if (this.tempProv) {
                    Security.removeProvider(iBMPKCS11Impl.getName());
                }
            }
        }
        catch (Exception exception) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.KEYSTORE_CLOSE_ERROR, (Throwable)exception);
        }
    }

    public void delete() throws KeyManagerException {
        throw new InternalKeyManagerException(KeyManagerException$ExceptionReason.INVALID_OPERATION, new String[]{"PKCS11ImplKeyStoreProxy.delete"});
    }

    public void save(DatabaseDescriptorFactory$DatabaseDescriptor databaseDescriptorFactory$DatabaseDescriptor) throws KeyManagerException {
        this.save((DatabaseDescriptorFactory$PKCS11ImplDatabaseDescriptorConfig)databaseDescriptorFactory$DatabaseDescriptor);
    }
}

