/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore;

import com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11KeyParameterSpec;
import com.ibm.crypto.pkcs11impl.provider.PKCS11DSAKeyPairParameterSpec;
import com.ibm.crypto.pkcs11impl.provider.PKCS11RSAKeyPairParameterSpec;
import com.ibm.gsk.ikeyman.command.CommandParameters;
import com.ibm.gsk.ikeyman.command.Constants$Parameter;
import com.ibm.gsk.ikeyman.error.InternalKeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.keystore.KeyCreatorFactory$AbstractKeyCreator;
import com.ibm.gsk.ikeyman.keystore.KeyCreatorFactory$SecretKeyTypes;
import com.ibm.gsk.ikeyman.util.AliasRange;
import com.ibm.gsk.ikeyman.util.AliasRange$ValidationMode;
import com.ibm.gsk.ikeyman.util.KeymanUtil;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

class KeyCreatorFactory$PKCS11KeyCreator
extends KeyCreatorFactory$AbstractKeyCreator {
    private static final int BITS_PER_BYTE = 8;
    private static final boolean TOKEN = true;
    private static final boolean SENSITIVE = true;
    private static final boolean SIGNING = true;
    private static final boolean ENCRYPTION = true;
    private static final boolean WRAPPING = true;
    private static final boolean EXTRACTABLE_PRIVATE = false;
    private static final boolean EXTRACTABLE_SECRET = true;
    private static final Map keySizes = new HashMap();

    public KeyCreatorFactory$PKCS11KeyCreator(String string) {
        super(string);
    }

    protected KeyGenerator getKeyGenerator(String string, String string2, int n, SecureRandom secureRandom) throws KeyManagerException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        KeyGenerator keyGenerator = null;
        keyGenerator = KeymanUtil.isIBMJCE() ? KeyGenerator.getInstance(string, this.getProvider()) : KeyGenerator.getInstance(string);
        GeneralPKCS11KeyParameterSpec generalPKCS11KeyParameterSpec = new GeneralPKCS11KeyParameterSpec(string2, string2, Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), n / 8, string);
        keyGenerator.init((AlgorithmParameterSpec)generalPKCS11KeyParameterSpec, secureRandom);
        return keyGenerator;
    }

    protected KeyPairGenerator getKeyPairGenerator(String string, String string2, int n, SecureRandom secureRandom) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, KeyManagerException, NoSuchProviderException {
        String string3 = KeymanUtil.getKeyType(string);
        KeyPairGenerator keyPairGenerator = null;
        keyPairGenerator = KeymanUtil.isIBMJCE() ? KeyPairGenerator.getInstance(string3, this.getProvider()) : KeyPairGenerator.getInstance(string3);
        Object object = string3.equals("DSA") ? new PKCS11DSAKeyPairParameterSpec(n, string2, null, string2, Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), null) : new PKCS11RSAKeyPairParameterSpec(n, string2, null, string2, Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        keyPairGenerator.initialize((AlgorithmParameterSpec)object, secureRandom);
        return keyPairGenerator;
    }

    public KeyPair generateKeyPair(CommandParameters commandParameters) throws KeyManagerException {
        try {
            KeyPair keyPair;
            PublicKey publicKey;
            int n;
            SecureRandom secureRandom = null;
            secureRandom = KeymanUtil.isIBMJCE() ? SecureRandom.getInstance("IBMSecureRandom", this.getProvider()) : SecureRandom.getInstance("SHA1PRNG");
            secureRandom.setSeed((long)Math.random());
            String string = KeymanUtil.getKeyType(commandParameters.getSigAlg().toString());
            int n2 = commandParameters.getSize();
            KeyPairGenerator keyPairGenerator = this.getKeyPairGenerator(string, commandParameters.getLabel(), n2, secureRandom);
            int n3 = string.equals("RSA") || string.equals("DSA") ? 5 : 0;
            while ((n = KeymanUtil.computeKeySize(publicKey = (keyPair = keyPairGenerator.generateKeyPair()).getPublic())) < n2 && n3-- > 0) {
            }
            if (n < n2 && string.equals("RSA")) {
                throw new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_KEY_SIZE, new Exception(), new String[]{n + "", string});
            }
            return keyPair;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_SUCH_ALGORITHM, noSuchAlgorithmException, new String[]{noSuchAlgorithmException.getMessage()});
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new InternalKeyManagerException(KeyManagerException$ExceptionReason.NO_SUCH_PROVIDER, noSuchProviderException, new String[]{this.getProvider()});
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_ALGORITHM_PARAMETERS, (Throwable)invalidAlgorithmParameterException);
        }
        catch (InvalidParameterException invalidParameterException) {
            if (invalidParameterException.getMessage() != null && invalidParameterException.getMessage().startsWith("Modulus size")) {
                throw new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_KEY_SIZE_FOR_ALGORITHM, invalidParameterException, new String[]{commandParameters.getSize() + "", KeymanUtil.getKeyType()});
            }
            throw new KeyManagerException(KeyManagerException$ExceptionReason.RESTRICTED_POLICY_FILES, (Throwable)invalidParameterException);
        }
    }

    public Map generateSecretKeys(CommandParameters commandParameters) throws KeyManagerException {
        try {
            HashMap<String, SecretKey> hashMap = new HashMap<String, SecretKey>();
            SecureRandom secureRandom = null;
            secureRandom = KeymanUtil.isIBMJCE() ? SecureRandom.getInstance("IBMSecureRandom", this.getProvider()) : SecureRandom.getInstance("SHA1PRNG");
            secureRandom.setSeed((long)Math.random());
            if (commandParameters.isParameterPresent(Constants$Parameter.Label)) {
                KeyGenerator keyGenerator = this.getKeyGenerator(commandParameters.getKeyAlgorithm(), commandParameters.getLabel(), commandParameters.getKeySize(), secureRandom);
                SecretKey secretKey = keyGenerator.generateKey();
                hashMap.put(commandParameters.getLabel(), secretKey);
            } else {
                AliasRange aliasRange = new AliasRange(commandParameters.getLabelRange());
                aliasRange.validate(AliasRange$ValidationMode.NORMAL);
                Enumeration enumeration = aliasRange.getAliasEnumerator();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    KeyGenerator keyGenerator = this.getKeyGenerator(commandParameters.getKeyAlgorithm(), string, commandParameters.getKeySize(), secureRandom);
                    SecretKey secretKey = keyGenerator.generateKey();
                    hashMap.put(string, secretKey);
                }
            }
            return hashMap;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_SUCH_ALGORITHM, noSuchAlgorithmException, new String[]{noSuchAlgorithmException.getMessage()});
        }
        catch (InvalidParameterException invalidParameterException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_ALGORITHM_PARAMETER, invalidParameterException, new String[]{invalidParameterException.getMessage()});
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_SUCH_PROVIDER, noSuchProviderException, new String[]{this.getProvider()});
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_ALGORITHM_PARAMETER, (Throwable)invalidAlgorithmParameterException);
        }
    }

    public Integer[] getKeySizes(KeyCreatorFactory$SecretKeyTypes keyCreatorFactory$SecretKeyTypes) {
        return (Integer[])keySizes.get((Object)keyCreatorFactory$SecretKeyTypes);
    }

    static {
        keySizes.put(KeyCreatorFactory$SecretKeyTypes.AES, new Integer[]{128, 192, 256});
        keySizes.put(KeyCreatorFactory$SecretKeyTypes.DES, new Integer[]{64});
        keySizes.put(KeyCreatorFactory$SecretKeyTypes.DESede, new Integer[]{192});
    }
}

