/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore;

import com.ibm.gsk.ikeyman.error.InternalKeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.keystore.EntryMakerFactory$1;
import com.ibm.gsk.ikeyman.keystore.EntryMakerFactory$EntryMaker;
import com.ibm.gsk.ikeyman.keystore.entry.CMSKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.Entry;
import com.ibm.gsk.ikeyman.keystore.entry.EntryFactory;
import com.ibm.gsk.ikeyman.keystore.entry.UnloadableCertificateItemImpl;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.List;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
class EntryMakerFactory$CMSKeyMaker
implements EntryMakerFactory$EntryMaker {
    private static final List supportedTypes = new ArrayList();

    private EntryMakerFactory$CMSKeyMaker() {
    }

    public List getSupportedTypes() {
        return supportedTypes;
    }

    public CMSKeyItem makeEntry(String string, KeyStore.Entry entry) throws KeyManagerException {
        if (entry == null) {
            return new UnloadableCertificateItemImpl(string, null);
        }
        if (entry instanceof KeyStore.PrivateKeyEntry) {
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)entry;
            return EntryFactory.newCMSKey(string, privateKeyEntry.getPrivateKey(), privateKeyEntry.getCertificateChain());
        }
        throw new InternalKeyManagerException(KeyManagerException$ExceptionReason.INVALID_ENTRY_TYPE, new String[]{string, entry.getClass().toString()});
    }

    public CMSKeyItem makeEntry(String string, Certificate certificate) throws KeyManagerException {
        return new UnloadableCertificateItemImpl(string, certificate);
    }

    public Entry makeEntry(String string, Certificate certificate) throws KeyManagerException {
        return this.makeEntry(string, certificate);
    }

    public Entry makeEntry(String string, KeyStore.Entry entry) throws KeyManagerException {
        return this.makeEntry(string, entry);
    }

    EntryMakerFactory$CMSKeyMaker(EntryMakerFactory$1 entryMakerFactory$1) {
        this();
    }

    static {
        supportedTypes.add(CMSKeyItem.class);
        supportedTypes.add(CertificateKeyItem.class);
    }
}

