/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.io;

import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.util.KeymanUtil;
import com.ibm.security.pkcs12.PFX;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CRLImpl;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.cert.CRL;
import java.util.Calendar;
import java.util.Date;

public class BlankPKCS12File {
    private static final String ENCRYPTION_ALGORITHM = KeymanUtil.isIBMJCE() ? "3KeyTripleDES" : "DESede";
    private PFX pfx;

    public BlankPKCS12File() throws KeyManagerException {
        try {
            this.pfx = new PFX();
            long l = new Date().getTime();
            X509CRLImpl x509CRLImpl = new X509CRLImpl(new X500Name("cn=dummyCRL"), Calendar.getInstance().getTime(), Calendar.getInstance().getTime());
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(1024);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            PrivateKey privateKey = keyPair.getPrivate();
            if (KeymanUtil.isIBMJCE()) {
                x509CRLImpl.sign(privateKey, "RSA");
            } else {
                x509CRLImpl.sign(privateKey, "SHA1withRSA");
            }
            x509CRLImpl.getEncoded();
            this.pfx.addCRL((CRL)x509CRLImpl, "test", String.valueOf(l).getBytes());
        }
        catch (Exception exception) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.BLANK_PKCS12_CREATION_ERROR, exception, new String[]{exception.getMessage() != null ? exception.getMessage() : exception.toString()});
        }
    }

    public void store(char[] cArray, String string) throws KeyManagerException {
        try {
            this.pfx.protect(ENCRYPTION_ALGORITHM, cArray);
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            this.pfx.encode((OutputStream)fileOutputStream);
            ((OutputStream)fileOutputStream).close();
        }
        catch (PKCSException pKCSException) {
            if (pKCSException.getMessage() != null && pKCSException.getMessage().toLowerCase().contains("illegal key size")) {
                throw new KeyManagerException(KeyManagerException$ExceptionReason.RESTRICTED_POLICY_FILES, (Throwable)pKCSException);
            }
        }
        catch (Exception exception) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.BLANK_PKCS12_STORE_ERROR, exception, new String[]{exception.getMessage() != null ? exception.getMessage() : exception.toString()});
        }
    }
}

