/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.certclient.beans;

import com.ibm.crypto.provider.PBMParameterSpec;
import com.ibm.security.certclient.PkEeFactory;
import com.ibm.security.certclient.base.PkAttrs;
import com.ibm.security.certclient.base.PkConfRepEvent;
import com.ibm.security.certclient.base.PkConfReqEvent;
import com.ibm.security.certclient.base.PkConstants;
import com.ibm.security.certclient.base.PkException;
import com.ibm.security.certclient.base.PkInitRepEvent;
import com.ibm.security.certclient.base.PkInitReqEvent;
import com.ibm.security.certclient.base.PkNLSConstants;
import com.ibm.security.certclient.base.PkPipe;
import com.ibm.security.certclient.base.PkRejectionException;
import com.ibm.security.certclient.base.PkRevoRepEvent;
import com.ibm.security.certclient.base.PkRevoReqEvent;
import com.ibm.security.certclient.base.PkSecnRepEvent;
import com.ibm.security.certclient.base.PkSecnReqEvent;
import com.ibm.security.certclient.util.PkNormalize;
import com.ibm.security.cmp.InfoTypeAndValue;
import com.ibm.security.cmp.PKIHeader;
import com.ibm.security.cmp.PKIMessage;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.GeneralName;
import com.ibm.security.x509.GeneralNameInterface;
import com.ibm.security.x509.KeyIdentifier;
import com.ibm.security.x509.X500Name;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Date;

public class PkEeXMgr
extends PkPipe
implements PkConstants {
    private static final String sccsid = "@(#) 84 1.11.1.1    com/tivoli/pki/beans/PkEeXMgr.java, PkBeans, javapki2, 09172003 9/17/03 10:27:51";
    private static BigInteger BIG_ONE = BigInteger.valueOf(1L);

    @Override
    public PkInitRepEvent doInitReq(PkInitReqEvent pkInitReqEvent) throws PkException {
        boolean bl = false;
        Object var3_3 = null;
        PkInitRepEvent pkInitRepEvent = null;
        Object object = pkInitReqEvent.getAttrs().getValue("x509.info.subject", null);
        String string = null;
        try {
            string = new PkNormalize().normalize(pkInitReqEvent.getAttrs().getValue("x509.info.subject").toString());
        }
        catch (Exception exception) {
            string = pkInitReqEvent.getAttrs().getValue("x509.info.subject").toString();
        }
        pkInitRepEvent = this.propagate(pkInitReqEvent);
        BigInteger bigInteger = pkInitRepEvent.getSerialNumber();
        return pkInitRepEvent;
    }

    @Override
    public PkSecnRepEvent doSecnReq(PkSecnReqEvent pkSecnReqEvent) throws PkException {
        PkSecnRepEvent pkSecnRepEvent = null;
        try {
            pkSecnRepEvent = this.propagate(pkSecnReqEvent);
        }
        catch (Exception exception) {
            if (exception instanceof PkException) {
                throw (PkException)exception;
            }
            throw new PkException(exception);
        }
        return pkSecnRepEvent;
    }

    @Override
    public PkConfRepEvent doConfReq(PkConfReqEvent pkConfReqEvent) throws PkException {
        PkConfRepEvent pkConfRepEvent = null;
        InfoTypeAndValue[] infoTypeAndValueArray = null;
        infoTypeAndValueArray = (InfoTypeAndValue[])pkConfReqEvent.getAttrs().getValue("cert.oper.certRevocationPassphrase", null);
        PKIHeader pKIHeader = (PKIHeader)pkConfReqEvent.getAttrs().getValue("TMP_MSG_HDR");
        if (pKIHeader == null) {
            throw new PkException(PkNLSConstants.MISSING_MESSAGE_HEADER);
        }
        try {
            PrivateKey privateKey = (PrivateKey)pkConfReqEvent.getAttrs().getValue("cert.oper.messageProtectionKey", null);
            if (privateKey == null) {
                String string = (String)pkConfReqEvent.getAttrs().getValue("x509.info.init_pwd", null);
                PkAttrs pkAttrs = pkConfReqEvent.getAttrs();
                KeyIdentifier keyIdentifier = (KeyIdentifier)pkConfReqEvent.getAttrs().getValue("cert.oper.SenderKeyIdentifier");
                PKIMessage pKIMessage = this.getConfMessage(pKIHeader, keyIdentifier, string, infoTypeAndValueArray);
                PkConfReqEvent pkConfReqEvent2 = new PkConfReqEvent(pkConfReqEvent.getSource(), pKIMessage, pkAttrs);
                pkConfRepEvent = (PkConfRepEvent)this.propagate(pkConfReqEvent2);
            } else {
                PKIMessage pKIMessage = this.getConfMessageForCr(pKIHeader, pkConfReqEvent.getAttrs());
                PkConfReqEvent pkConfReqEvent3 = new PkConfReqEvent(pkConfReqEvent.getSource(), pKIMessage, pkConfReqEvent.getAttrs());
                pkConfRepEvent = (PkConfRepEvent)this.propagate(pkConfReqEvent3);
            }
        }
        catch (Exception exception) {
            if (exception instanceof PkException) {
                throw (PkException)exception;
            }
            throw new PkException(exception);
        }
        return pkConfRepEvent;
    }

    @Override
    public PkRevoRepEvent doRevoReq(PkRevoReqEvent pkRevoReqEvent) throws PkException {
        Object var2_2 = null;
        PKIHeader pKIHeader = null;
        try {
            pKIHeader = this.createHeader(pkRevoReqEvent.getAttrs());
            pkRevoReqEvent.getAttrs().add("TMP_MSG_HDR", 2, pKIHeader);
        }
        catch (Exception exception) {
            if (exception instanceof PkException) {
                throw (PkException)exception;
            }
            throw new PkException(exception);
        }
        return this.propagate(new PkRevoReqEvent(this, null, pkRevoReqEvent.getAttrs()));
    }

    private PKIHeader createHeader(PkAttrs pkAttrs) throws Exception {
        boolean bl = false;
        if (pkAttrs.getValue("x509.info.certrevopublickey", null) != null) {
            bl = true;
        }
        GeneralName generalName = null;
        GeneralName generalName2 = null;
        KeyIdentifier keyIdentifier = null;
        KeyIdentifier keyIdentifier2 = null;
        if (!bl) {
            generalName = new GeneralName((GeneralNameInterface)((X500Name)pkAttrs.getValue("x509.info.subject")));
            generalName2 = (GeneralName)pkAttrs.getValue("cert.oper.RECIPIENT_DN");
            keyIdentifier = (KeyIdentifier)pkAttrs.getValue("cert.oper.SenderKeyIdentifier", null);
            keyIdentifier2 = null;
        } else {
            generalName = new GeneralName((GeneralNameInterface)new X500Name("o=JavaPki,c=US"));
            generalName2 = new GeneralName((GeneralNameInterface)new X500Name("o=JavaPki,c=US"));
            keyIdentifier = new KeyIdentifier(new String("JavaPki").getBytes());
            keyIdentifier2 = new KeyIdentifier(new String("JavaPki").getBytes());
        }
        byte[] byArray = new Date().toString().getBytes();
        byte[] byArray2 = null;
        byte[] byArray3 = new Long(new Date().getTime()).toString().getBytes();
        byte[] byArray4 = "this is a salt".getBytes();
        AlgorithmId algorithmId = new AlgorithmId(AlgorithmId.SHA_oid);
        int n = 1001;
        AlgorithmId algorithmId2 = new AlgorithmId(AlgorithmId.HmacSHA1_oid);
        PBMParameterSpec pBMParameterSpec = new PBMParameterSpec(byArray4, algorithmId, n, algorithmId2);
        AlgorithmParameters algorithmParameters = null;
        InfoTypeAndValue[] infoTypeAndValueArray = (InfoTypeAndValue[])pkAttrs.getValue("cert.oper.certRevocationPassphrase", null);
        try {
            algorithmParameters = AlgorithmParameters.getInstance("PasswordBasedMac", PkEeFactory.getProvider());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw noSuchAlgorithmException;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw noSuchProviderException;
        }
        algorithmParameters.init((AlgorithmParameterSpec)pBMParameterSpec);
        AlgorithmId algorithmId3 = null;
        algorithmId3 = new AlgorithmId(AlgorithmId.PasswordBasedMac_oid, algorithmParameters.getEncoded());
        PKIHeader pKIHeader = new PKIHeader(BIG_ONE, generalName, generalName2, new Date(), algorithmId3, keyIdentifier, keyIdentifier2, byArray3, byArray, byArray2, null, infoTypeAndValueArray);
        return pKIHeader;
    }

    private PKIHeader createHeader1(PkAttrs pkAttrs) throws Exception {
        GeneralName generalName = new GeneralName((GeneralNameInterface)((X500Name)pkAttrs.getValue("x509.info.subject")));
        GeneralName generalName2 = (GeneralName)pkAttrs.getValue("cert.oper.RECIPIENT_DN", null);
        KeyIdentifier keyIdentifier = (KeyIdentifier)pkAttrs.getValue("cert.oper.SenderKeyIdentifier");
        Object var5_5 = null;
        byte[] byArray = new Date().toString().getBytes();
        InfoTypeAndValue[] infoTypeAndValueArray = (InfoTypeAndValue[])pkAttrs.getValue("cert.oper.certRevocationPassphrase", null);
        PKIHeader pKIHeader = new PKIHeader(BIG_ONE, generalName, generalName2, null, null, keyIdentifier, null, null, byArray, null, null, infoTypeAndValueArray);
        return pKIHeader;
    }

    private PKIMessage getConfMessage(PKIHeader pKIHeader, KeyIdentifier keyIdentifier, String string, InfoTypeAndValue[] infoTypeAndValueArray) throws Exception {
        GeneralName generalName = pKIHeader.getRecipient();
        GeneralName generalName2 = pKIHeader.getSender();
        KeyIdentifier keyIdentifier2 = null;
        byte[] byArray = pKIHeader.getRecipNonce();
        byte[] byArray2 = pKIHeader.getSenderNonce();
        byte[] byArray3 = pKIHeader.getTransactionID();
        byte[] byArray4 = "this is a salt".getBytes();
        AlgorithmId algorithmId = new AlgorithmId(AlgorithmId.SHA_oid);
        int n = 1001;
        AlgorithmId algorithmId2 = new AlgorithmId(AlgorithmId.HmacSHA1_oid);
        PBMParameterSpec pBMParameterSpec = new PBMParameterSpec(byArray4, algorithmId, n, algorithmId2);
        AlgorithmParameters algorithmParameters = null;
        try {
            algorithmParameters = AlgorithmParameters.getInstance("PasswordBasedMac", PkEeFactory.getProvider());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw noSuchAlgorithmException;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw noSuchProviderException;
        }
        algorithmParameters.init((AlgorithmParameterSpec)pBMParameterSpec);
        AlgorithmId algorithmId3 = null;
        algorithmId3 = new AlgorithmId(AlgorithmId.PasswordBasedMac_oid, algorithmParameters.getEncoded());
        PKIHeader pKIHeader2 = new PKIHeader(BIG_ONE, generalName, generalName2, new Date(), algorithmId3, keyIdentifier, keyIdentifier2, byArray3, byArray, byArray2, null, infoTypeAndValueArray);
        PKIMessage pKIMessage = new PKIMessage(pKIHeader2, 19, null, null, null);
        PKIMessage pKIMessage2 = null;
        try {
            if (string == null) {
                throw new PkRejectionException(PkNLSConstants.MSG_CANNOT_BE_PROTECTED);
            }
            pKIMessage2 = pKIMessage.protect(string.getBytes());
        }
        catch (Exception exception) {
            if (exception instanceof PkException) {
                throw (PkException)exception;
            }
            throw new PkException(exception);
        }
        return pKIMessage2;
    }

    private PKIMessage getConfMessageForCr(PKIHeader pKIHeader, PkAttrs pkAttrs) throws Exception {
        String string;
        GeneralName generalName = pKIHeader.getRecipient();
        GeneralName generalName2 = pKIHeader.getSender();
        KeyIdentifier keyIdentifier = (KeyIdentifier)pkAttrs.getValue("cert.oper.SenderKeyIdentifier");
        KeyIdentifier keyIdentifier2 = null;
        byte[] byArray = pKIHeader.getRecipNonce();
        byte[] byArray2 = pKIHeader.getSenderNonce();
        byte[] byArray3 = pKIHeader.getTransactionID();
        boolean bl = true;
        AlgorithmId algorithmId = (AlgorithmId)pkAttrs.getValue("x509.info.algorithmID");
        Object var12_12 = null;
        InfoTypeAndValue[] infoTypeAndValueArray = null;
        infoTypeAndValueArray = (InfoTypeAndValue[])pkAttrs.getValue("cert.oper.certRevocationPassphrase", null);
        PKIHeader pKIHeader2 = new PKIHeader(BIG_ONE, generalName, generalName2, new Date(), algorithmId, keyIdentifier, keyIdentifier2, byArray3, byArray, byArray2, null, infoTypeAndValueArray);
        DerOutputStream derOutputStream = new DerOutputStream();
        pKIHeader2.encode((OutputStream)derOutputStream);
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        byte[] byArray4 = derOutputStream2.toByteArray();
        byte[] byArray5 = null;
        try {
            String string2 = (String)pkAttrs.getValue("cert.oper.PROVIDER");
            PrivateKey privateKey = (PrivateKey)pkAttrs.getValue("cert.oper.messageProtectionKey");
            string = (String)pkAttrs.getValue("x509.info.algorithmName");
            Signature signature = Signature.getInstance(string, string2);
            signature.initSign(privateKey);
            signature.update(byArray4);
            byArray5 = signature.sign();
        }
        catch (Exception exception) {
            if (exception instanceof PkException) {
                throw (PkException)exception;
            }
            throw new PkException(exception);
        }
        string = new PKIMessage(pKIHeader2, 19, null, byArray5, null);
        return string;
    }
}

