/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.Arrays;
import sun.nio.cs.ext.ArabicDecoder;
import sun.nio.cs.ext.ArabicEncoder;
import sun.nio.cs.ext.ExtendedCharsets;

public class SingleByteArabic {
    private static final byte[] IBM420_ArabicDeshaping = new byte[]{-28, -62, -62, -61, -61, -59, -59, -57, -57};
    private static final byte[] IBM864_ArabicDeshaping = new byte[]{-28, -62, -62, -61, -61, -57, -57, -57, -57};
    private static final byte[] asciiSubBytes = new byte[]{63};
    private static final byte[] ebcdicSubBytes = new byte[]{111};

    public static CharsetDecoder newArabicDecoder(String string, Charset charset, char[] cArray) {
        switch (string) {
            case "IBM420S": {
                if (ExtendedCharsets.isSwapLF()) {
                    char[] cArray2 = Arrays.copyOf(cArray, cArray.length);
                    cArray2[149] = 133;
                    return new Decoder(charset, cArray2, 0);
                }
                return new Decoder(charset, cArray, 0);
            }
            case "IBM420": 
            case "IBM918": 
            case "IBM1097": {
                if (ExtendedCharsets.isSwapLF()) {
                    char[] cArray3 = Arrays.copyOf(cArray, cArray.length);
                    cArray3[149] = 133;
                    return new Decoder(charset, cArray3, 1);
                }
                return new Decoder(charset, cArray, 1);
            }
            case "IBM864": 
            case "IBM868": 
            case "IBM1006": 
            case "IBM1046": 
            case "IBM1098": 
            case "ISO_8859_6": 
            case "MS1256": {
                return new Decoder(charset, cArray, 1);
            }
        }
        return null;
    }

    public static CharsetEncoder newArabicEncoder(String string, Charset charset, char[] cArray, char[] cArray2) {
        short[] sArray = new short[cArray2.length];
        for (int i = 0; i < cArray2.length; ++i) {
            sArray[i] = (short)cArray2[i];
        }
        switch (string) {
            case "IBM420": 
            case "IBM420S": {
                if (ExtendedCharsets.isSwapLF() && '\ufffd' != cArray2[0]) {
                    char[] cArray3 = Arrays.copyOf(cArray, cArray.length);
                    cArray3[cArray2[0] + 10] = 37;
                    return new Encoder(charset, sArray, cArray3, IBM420_ArabicDeshaping, ebcdicSubBytes);
                }
                return new Encoder(charset, sArray, cArray, IBM420_ArabicDeshaping, ebcdicSubBytes);
            }
            case "IBM864": {
                return new Encoder(charset, sArray, cArray, IBM864_ArabicDeshaping, asciiSubBytes);
            }
            case "IBM918": 
            case "IBM1097": {
                if (ExtendedCharsets.isSwapLF() && '\ufffd' != cArray2[0]) {
                    char[] cArray4 = Arrays.copyOf(cArray, cArray.length);
                    cArray4[cArray2[0] + 10] = 37;
                    return new Encoder(charset, sArray, cArray4, null, ebcdicSubBytes);
                }
                return new Encoder(charset, sArray, cArray, null, ebcdicSubBytes);
            }
            case "IBM1006": 
            case "IBM1046": 
            case "IBM1098": 
            case "IBM868": 
            case "ISO_8859_6": 
            case "MS1256": {
                return new Encoder(charset, sArray, cArray, null, asciiSubBytes);
            }
        }
        return null;
    }

    public static final class Encoder
    extends ArabicEncoder {
        public Encoder(Charset charset, short[] sArray, char[] cArray, byte[] byArray, byte[] byArray2) {
            super(charset, sArray, new String(cArray), 8, byArray, byArray2);
        }
    }

    public static final class Decoder
    extends ArabicDecoder {
        public Decoder(Charset charset, char[] cArray, byte by) {
            super(charset, new String(cArray), by);
        }
    }
}

