/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.Arrays;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.ext.DoubleByte;
import sun.nio.cs.ext.ExtendedCharsets;
import sun.nio.cs.ext.IBM949;

public class IBM949C
extends Charset
implements HistoricallyNamedCharset {
    static final char[] b2cSB;
    static final char[] c2b;
    static final char[] c2bIndex;

    public IBM949C() {
        super("x-IBM949C", ExtendedCharsets.aliasesFor("x-IBM949C"));
    }

    @Override
    public String historicalName() {
        return "Cp949C";
    }

    @Override
    public boolean contains(Charset charset) {
        return charset.name().equals("US-ASCII") || charset instanceof IBM949C;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new DoubleByte.Decoder_DBCS_ASCII(this, IBM949.b2c, b2cSB, 161, 254);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new DoubleByte.Encoder_DBCS_ASCII((Charset)this, c2b, c2bIndex);
    }

    static {
        int n;
        IBM949.initb2c();
        b2cSB = new char[256];
        for (n = 0; n < 128; ++n) {
            IBM949C.b2cSB[n] = (char)n;
        }
        for (n = 128; n < 256; ++n) {
            IBM949C.b2cSB[n] = IBM949.b2cSB[n];
        }
        IBM949.initc2b();
        c2b = Arrays.copyOf(IBM949.c2b, IBM949.c2b.length);
        c2bIndex = Arrays.copyOf(IBM949.c2bIndex, IBM949.c2bIndex.length);
        for (n = 0; n < 128; n = (int)((char)(n + 1))) {
            char c = c2bIndex[n >> 8];
            IBM949C.c2b[c + (n & 0xFF)] = n;
        }
    }
}

