/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.util.list;

public final class DoubleLinkedList {
    Item head = null;
    Item tail = null;

    public void addFirst(Item item) {
        if (this.head == null) {
            this.head = this.tail = item;
        } else {
            this.head.setPrevious(item);
            item.setNext(this.head);
            this.head = item;
        }
    }

    public void addLast(Item item) {
        if (this.tail == null) {
            this.head = this.tail = item;
        } else {
            this.tail.setNext(item);
            item.setPrevious(this.tail);
            this.tail = item;
        }
    }

    public Item getFirst() {
        return this.head;
    }

    public Item getLast() {
        return this.tail;
    }

    public Item removeFirst() {
        Item item = this.head;
        if (this.head != null) {
            this.head = this.head.getNext();
            if (this.head == null) {
                this.tail = null;
            } else {
                this.head.setPrevious(null);
            }
            item.setNext(null);
        }
        return item;
    }

    public Item removeLast() {
        Item item = this.tail;
        if (this.tail != null) {
            this.tail = this.tail.getPrevious();
            if (this.tail == null) {
                this.head = null;
            } else {
                this.tail.setNext(null);
            }
            item.setPrevious(null);
        }
        return item;
    }

    public void remove(Item item) {
        if (item != null) {
            if (item == this.head) {
                this.removeFirst();
            } else if (item == this.tail) {
                this.removeLast();
            } else {
                Item item2 = item.getNext();
                Item item3 = item.getPrevious();
                item2.setPrevious(item3);
                item3.setNext(item2);
                item.setNext(null);
                item.setPrevious(null);
            }
        }
    }

    public boolean isEmpty() {
        return this.head == null;
    }

    public void clear() {
        while (this.head != null) {
            this.removeFirst();
        }
    }

    public void clearAfterItem(Item item) {
        while (this.tail != item) {
            this.removeLast();
            if (this.tail != null) continue;
            break;
        }
    }

    public void clearBeforeItem(Item item) {
        while (this.head != item) {
            this.removeFirst();
            if (this.head != null) continue;
            break;
        }
    }

    public static abstract class Item {
        private Item next = null;
        private Item previous = null;

        public final Item getNext() {
            return this.next;
        }

        final void setNext(Item item) {
            this.next = item;
        }

        public final Item getPrevious() {
            return this.previous;
        }

        final void setPrevious(Item item) {
            this.previous = item;
        }
    }
}

